#include <jenga/include/smoothie/LexicalScoping.h>
#include <jenga/include/smoothie/SmoothieException.h>
#include <jenga/include/smoothie/Variable.h>
#include <jenga/include/smoothie/Procedure.h>


CScope::CScope( int level, int addr, SCOPE_TYPE TypeOfStatement ){
	this->level = level;
	this->StartAddress = addr;
	this->TypeOfStatement = TypeOfStatement;

	pBreakSchedule = (DWORD *)malloc( 1 );
	nBreakSchedule = 0;
}
CScope::~CScope(){
	free( pBreakSchedule );
}

int CScope::GetStartAddress(){
	return StartAddress;
}
SCOPE_TYPE CScope::GetTypeOfStatement(){
	return TypeOfStatement;
}




CScope *CLexicalScopes::SearchScope( SCOPE_TYPE TypeOfStatement ){
	for( int i = level; i>=0; i-- ){
		if( ppScopes[i]->GetTypeOfStatement() == TypeOfStatement ){
			return ppScopes[i];
		}
	}
	return NULL;
}

CLexicalScopes::CLexicalScopes(){
	ppScopes = (CScope **)malloc( 1 );
	level=0;
}
CLexicalScopes::~CLexicalScopes(){
	free( ppScopes );
}
void CLexicalScopes::Init(int addr){
	// TODO: G[`FbN

	level = -1;
	Start( addr, SCOPE_TYPE_BASE );
}
void CLexicalScopes::Start( int addr, SCOPE_TYPE TypeOfStatement ){
	level++;
	ppScopes = (CScope **)realloc( ppScopes, ( level + 1 ) * sizeof( CScope * ) );
	ppScopes[level] = CreateScope( level, addr, TypeOfStatement );
}
void CLexicalScopes::End(){
	if( level <= 0 ){
		SmoothieException::Throw();
		return;
	}

	//fXgN^Ă
	CallDestructorsOfScopeEnd();

	Variables &vars = UserProc::IsGlobalAreaCompiling()?
		globalVars :
		UserProc::CompilingUserProc().localVars;

	//gpς݃[Jϐ̐`FbNO
	BOOST_FOREACH( Variable *pVar, vars ){
		if(pVar->bLiving&&pVar->ScopeLevel==level){
			pVar->bLiving=0;
			extern int obp;
			pVar->ScopeEndAddress=obp;
		}
	}


	//XR[voXPW[
	ppScopes[level]->RunScheduleOfBreak();


	//XR[vx
	delete ppScopes[level];
	level--;
}

int CLexicalScopes::GetNowLevel(){
	return level;
}
void CLexicalScopes::SetNowLevel( int level ){
	this->level = level;
}
int CLexicalScopes::GetStartAddress(){
	return ppScopes[level]->GetStartAddress();
}
