#pragma once

#include <jenga/include/smoothie/Class.h>

class ClassImpl: public CClass
{
public:
	ClassImpl( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const string &name )
		: CClass( namespaceScopes, importedNamespaces, name )
	{
	}

	//p
	virtual bool Inherits( const char *inheritNames, int nowLine );
	virtual bool InheritsClass( const CClass &inheritsClass, int nowLine );
	virtual bool InheritsInterface( const CClass &inheritsClass, int nowLine );

	//oA\bh̒ǉ
	CMember *CreateMember( Prototype::Accessibility accessibility, bool isConst, bool isRef, char *buffer, int nowLine );
	virtual void AddMember( Prototype::Accessibility accessibility, bool idConst, bool isRef, char *buffer, int nowLine );
	virtual void AddStaticMember( Prototype::Accessibility accessibility, bool isConst, bool isRef, char *buffer, int nowLine );

	virtual void AddMethod(CClass *pobj_c, Prototype::Accessibility accessibility, BOOL bStatic, bool isConst, bool isAbstract,
		bool isVirtual, bool isOverride, char *buffer, int nowLine);

	virtual LONG_PTR GetVtblGlobalOffset(void) const;
	virtual void ActionVtblSchedule(LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection);
};

class ClassesImpl : public Classes
{
public:
	virtual CClass *Create( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const char *name);
	virtual void CollectClassesForNameOnly( const BasicSource &source );

	virtual void InitStaticMember();

private:
	bool MemberVar_LoopRefCheck(const CClass &objClass);
public:
	virtual void GetClass_recur(const char *lpszInheritsClass);
	virtual void GetAllClassInfo();
	virtual void Compile_System_InitializeUserTypes();

};
