#include <LexicalScopingImpl.h>

#include "../common.h"

#ifdef _AMD64_
#include "../../BasicCompiler64/opcode.h"
#else
#include "../../BasicCompiler32/opcode.h"
#endif


void ScopeImpl::Break(){
	//̃[JIuWFNg
	GetLexicalScopes().CallDestructorsOfReturn( level );

	//jmp ...(Next addr)
	OpBuffer[obp++]=(char)0xE9;

	pBreakSchedule=(DWORD *)realloc( pBreakSchedule, ( nBreakSchedule + 1 ) * sizeof(DWORD) );
	pBreakSchedule[nBreakSchedule]=obp;
	nBreakSchedule++;

	obp+=sizeof(long);
}
void ScopeImpl::RunScheduleOfBreak(){
	for(int i=0;i<nBreakSchedule;i++){
		*((long *)(OpBuffer+pBreakSchedule[i]))=obp-(pBreakSchedule[i]+sizeof(long));
	}
}

// XR[vĨfXgN^Ăяo
void LexicalScopesImpl::CallDestructorsOfScopeEnd(){

	Variables &vars = UserProc::IsGlobalAreaCompiling()?
		globalVars :
		UserProc::CompilingUserProc().localVars;


	int i3;
	int indexSystemGC=-1;
	for( i3 = (int)vars.size() - 1; i3 >= 0; i3-- ){		//mۂ̂Ƌtŉ邽߁AobNT[`ɂ

		Variable *pVar = vars[i3];

		if( UserProc::IsGlobalAreaCompiling() && GetNowLevel() == 0 ){
			if( pVar->GetName() == "_System_GC" ){
				indexSystemGC=i3;
				continue;
			}
		}

		//ꃌx̃LVJXR[v݂̂m
		if(!pVar->bLiving) continue;
		if( pVar->ScopeLevel != GetNowLevel() ) continue;

		if( pVar->IsStruct() && pVar->IsParameter() ){
			//\̃p[^Ƃ

			//

#ifdef _AMD64_
			//x64rbgR[h

			//mov rcx,qword ptr[rsp+offset]
			op_mov_RM(sizeof(_int64),REG_RCX,REG_RSP,
				-pVar->offset,
				MOD_BASE_DISP32);
			obp-=sizeof(long);
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
#else
			//x86R[h

			//mov ecx,dword ptr[ebp+offset]
			op_mov_RM(sizeof(long),REG_ECX,REG_EBP,-pVar->offset,MOD_BASE_DISP32);
			obp-=sizeof(long);
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//push ecx
			op_push(REG_ECX);
#endif

			//call free
			extern UserProc *pSub_free;
			op_call(pSub_free);


			if( UserProc::IsGlobalAreaCompiling() ){
				//ɂ͗ȂnY
				SetError(300,NULL,cp);
			}
		}
	}

	if(indexSystemGC!=-1){
		//_System_GCIuWFNg̃fXgN^̌Ăяo
		const CMethod *method = vars[indexSystemGC]->GetClass().GetDestructorMethod();
		if( method ){
			Opcode_CallProc("",method->pUserProc,0,vars[indexSystemGC]->GetName().c_str(),DEF_OBJECT);
		}
	}
}

// ReturnXe[ggŔsfXgN^𐶐
void LexicalScopesImpl::CallDestructorsOfReturn( int BaseLevel ){
	//݂̃XR[vxޔ
	int backupScopeLevel = GetNowLevel();

	for( int i = GetNowLevel(); i >= BaseLevel; i-- ){
		SetNowLevel( i );

		CallDestructorsOfScopeEnd();
	}

	//݂̃XR[vx𕜌
	SetNowLevel( backupScopeLevel );
}

LexicalScopesImpl &GetLexicalScopes()
{
	static LexicalScopesImpl *pTemp = NULL;
	if( !pTemp )
	{
		pTemp = (LexicalScopesImpl *)Smoothie::Temp::pLexicalScopes;
	}
	return *pTemp;
}
