#include <jenga/include/smoothie/Smoothie.h>
#include <jenga/include/smoothie/LexicalAnalysis.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void SetVariableFromRax(int VarType,int CalcType,RELATIVE_VAR *pRelativeVar){
	/////////////////////////////////////////////////
	// rax̓eϐɃRs[R[h𒊏o
	/////////////////////////////////////////////////

	if(VarType==DEF_BOOLEAN){
		//bool
		SetBooleanVariable(CalcType,pRelativeVar);
	}
	else if( IsRealNumberType( VarType ) ){
		// Double/Single^ϐփWX^̒l
		SetRealVariable(VarType, CalcType, pRelativeVar);
	}
	else if( IsWholeNumberType( VarType ) || VarType == DEF_OBJECT ){
		int typeSize = GetTypeSize( VarType, -1 );

		//ϐrax̒li[
		SetWholeVariable( typeSize, CalcType, pRelativeVar );
	}
	else{
		SetError(300,NULL,cp);
	}
}
void OpcodeCalc(const char *Command){
	int i,i2,i3;
	char variable[VN_SIZE];



	//////////////////////////////////////
	// CNgEfNg
	//////////////////////////////////////

	for(i=0;;i++){
		if(Command[i]=='\"'){
			//_uNH[g͕sȂ̂ŃG[
			variable[i]=0;
			SetError(3,variable,cp);
			return;
		}

		if(Command[i]=='('){
			i2=GetStringInPare(variable+i,Command+i);
			i+=i2-1;
			continue;
		}
		if(Command[i]=='['){
			i2=GetStringInBracket(variable+i,Command+i);
			i+=i2-1;
			continue;
		}
		if(Command[i]=='\0'){

			///////////////////////////////////
			// CNgEfNg
			///////////////////////////////////

			if(i>2){
				if(Command[i-2]=='+'&&Command[i-1]=='+'){
					//CNg
					variable[i-2]=0;
					IncDec(CALC_ADDITION,variable,"1");
					return;
				}
				else if(Command[i-2]=='-'&&Command[i-1]=='-'){
					//fNg
					variable[i-2]=0;
					IncDec(CALC_SUBTRACTION,variable,"1");
					return;
				}
			}


			//[̎ʎqG[L[[hɂ
			for(i=0;;i++){
				if(!IsVariableChar(Command[i])){
					variable[i]=0;
					break;
				}
				variable[i]=Command[i];
			}

			if(GetVarType(variable,Type(),0)){
				//ϐXgɊYƂ
				SetError(1,NULL,cp);
			}
			else{
				if(GetConstHash(variable)){
					//萔XgɊYƂ
					SetError(1,NULL,cp);
				}
				else{
					//ϐXgA萔XgɊYȂƂ
					SetError(3,variable,cp);
				}
			}
			return;
		}

		i2=GetCalcId(Command+i,&i3);
		if(i2){
			variable[i]=0;

			if(Command[i]=='=') break;

			if(Command[i+1+i3]=='='){
				IncDec(i2,variable,Command+i+1+i3+1);
				return;
			}
		}

		variable[i]=Command[i];
	}

	if(Command[i+1]=='\0'){
		SetError(1,NULL,cp);
		return;
	}



	///////////////////////////////////////////////////////////////
	// CfNTsetANZTi[]=Zq̃I[o[[hɑΉj
	///////////////////////////////////////////////////////////////

	char ObjName[VN_SIZE],array_element[VN_SIZE];
	GetArrayElement(variable,ObjName,array_element);
	if(array_element[0]){
		Type varType;
		if( GetVarType(ObjName,varType,0) && varType.IsObject() ){
			char temporary[VN_SIZE];
			sprintf(temporary,"%s.%c%c%c",ObjName,1,ESC_OPERATOR,CALC_ARRAY_SET);

			char temp2[VN_SIZE];
			sprintf(temp2,"%s,%s",array_element,Command+i+1);

			int idProc;
			void *pProc;
			idProc=GetProc(temporary,(void **)&pProc);
			if(idProc){
				CallProc(idProc,pProc,temporary,temp2,Type());
				return;
			}
		}
	}


	if( lstrcmpi( variable, "This" ) == 0 ){
		SetError(133,NULL,cp);
		return;
	}


	////////////////////////////////////////
	// ϐ̃^Cv^ʂāAZs
	////////////////////////////////////////

	Type varType;

	//^
	if( !GetVarType(variable,varType,false) ){

		// vpeBp̃\bhĂяo
		if(!CallPropertyMethod( variable, Command+i+1, Type() )){
			//G[\
			GetVarType(variable,varType,true);
		}

		return;
	}

	extern LONG_PTR ProcPtr_BaseIndex;
	if(varType.IsProcPtr()) ProcPtr_BaseIndex=varType.GetIndex();
	else ProcPtr_BaseIndex=-1;

	//NumOpe...iraxA܂xmm0ɓi[j
	int reg=REG_RAX;
	BOOL bCalcUseHeap;
	Type calcType;
	if( !NumOpe(&reg,Command+i+1,varType,calcType,&bCalcUseHeap) ){
		return;
	}

	if(reg!=REG_RAX&&calcType.IsWhole()||
		varType.IsNull()||calcType.IsNull()){
		SetError(300,NULL,cp);
	}

	//ʂi[Ă郌WX^ubLO
	pobj_BlockReg->lock(reg);

	//ϐAhX擾
	RELATIVE_VAR VarRelativeVar;
	if(!GetVarOffsetReadWrite(
		variable,
		&VarRelativeVar,
		varType)) return;

	//WX^̃ubLO
	pobj_BlockReg->clear();

	if(varType.GetBasicType()&FLAG_PTR){
		SetError(14,variable,cp);
		return;
	}

	if( varType.IsStruct() ){
		//\̃CX^Xւ̑
		SetStructVariableFromRax(varType,calcType,&VarRelativeVar,bCalcUseHeap);
		return;
	}

	if( calcType.IsObject() && !calcType.Equals( varType ) ){
		bool isUpCast = false;
		if( varType.IsObject() ){
			if( varType.GetClass().IsEqualsOrSubClass( &calcType.GetClass() ) ){
				isUpCast = true;
			}
		}
		if( !isUpCast ){
			//LXgZq̃I[o[[hɑΉ
			CallCastOperatorProc(REG_RAX,calcType,bCalcUseHeap,varType);
		}
	}

	if( varType.IsObject() && Smoothie::GetMeta().blittableTypes.IsExist( calcType ) ){
		// Blittable^IuWFNgƂĈ
		vector<UserProc *> userProcs;
		Smoothie::GetMeta().blittableTypes.GetClass( calcType ).GetStaticMethods().Enum( "_Create", userProcs );
		if( userProcs.size() != 1 ){
			SetError();
			return;
		}
		UserProc *pUserProc = userProcs[0];

		// mov rcx, rax
		op_mov_RR( REG_RCX, REG_RAX );

		// call System.[TypeClass]._Create
		op_call( pUserProc );

		calcType = pUserProc->ReturnType();
	}

	/////////////////////////////////
	// EӁAӂ̌^`FbNs
	/////////////////////////////////

	CheckDifferentType(varType,calcType,0,0);


	/////////////////////////////////////////////////
	// raxixmm0j̓eϐɃRs[
	/////////////////////////////////////////////////
	SetVariableFromRax(varType.GetBasicType(),calcType.GetBasicType(),&VarRelativeVar);
}
