#include "common.h"
#include OPCODE_H_PATH	//opcode.h


//VOgIuWFNg
CDBConst CDBConst::obj;


bool ConstBase::IsEqualSymbol( const NamespaceScopes &namespaceScopes, const string &name ) const
{
	if( GetName() != name ){
		return false;
	}
	return NamespaceScopes::IsSameArea( this->namespaceScopes, namespaceScopes );
}
bool ConstBase::IsEqualSymbol( const string &fullName ) const
{
	char AreaName[VN_SIZE] = "";		//IuWFNgϐ
	char NestName[VN_SIZE] = "";		//qo
	bool isNest = CClass::SplitName( fullName.c_str(), AreaName, NestName );

	return IsEqualSymbol( NamespaceScopes( AreaName ), NestName );
}




CConst::CConst( const NamespaceScopes &namespaceScopes, const string &name, const Type &type, _int64 i64data)
	: ConstBase( namespaceScopes, name )
	, type( type )
	, i64data( i64data )
	, pNext( NULL )
{
}
CConst::CConst( const NamespaceScopes &namespaceScopes, const string &name, int value)
	: ConstBase( namespaceScopes, name )
	, type( Type(DEF_LONG) )
	, i64data( value )
	, pNext( NULL )
{
}
CConst::~CConst(){
	//ÃIuWFNgj
	if(pNext){
		delete pNext;
		pNext = 0;
	}
}

Type CConst::GetType(){
	return type;
}
_int64 CConst::GetWholeData(){
	return i64data;
}
double CConst::GetDoubleData(){
	double dbl;
	memcpy(&dbl,&i64data,sizeof(_int64));
	return dbl;
}



CConstMacro::CConstMacro( const NamespaceScopes &namespaceScopes, const string &name, char *Expression)
	: ConstBase( namespaceScopes, name )
{
}
CConstMacro::~CConstMacro(){
}





CDBConst::CDBConst(){
	memset(this,0,sizeof(CDBConst));

	ppHash = (CConst **)calloc(MAX_HASH*sizeof(CConst *),1);
	Init();
}
CDBConst::~CDBConst(){
	Free();

	free(ppHash);
}

//
void CDBConst::Free(){
	int i;
	for(i=0; i<MAX_HASH; i++){
		if(ppHash[i]){
			delete ppHash[i];
			ppHash[i] = 0;
		}
	}
}

//
void CDBConst::Init(){
	Free();
}

void AddConstData(char *Command);
void CDBConst::Add( const NamespaceScopes &namespaceScopes, char *buffer ){
	int i;

	//O擾
	char Name[VN_SIZE];
	for(i=0;;i++){
		if(buffer[i]=='\0'){
			SetError(10,"Const",cp);
			return;
		}
		if(buffer[i]=='='||buffer[i]=='('){
			Name[i]=0;
			break;
		}
		Name[i]=buffer[i];
	}

	//d`FbN
	if(GetBasicType(Name)){
		SetError(15,Name,cp);
		return;
	}

	if(buffer[i] == '('){
		//萔}N

		//
		AddConstData(buffer);
	}
	else{
		//ʂ̒萔
		char *Expression = buffer + i + 1;

		AddConst( namespaceScopes, Name,Expression);
	}
}

void CDBConst::AddConst( const string &name, CConst *newconst){
	int key = hash_default(name.c_str());

	//nbVXgɒǉ
	if(ppHash[key]){
		CConst *pConst = ppHash[key];
		while(pConst->pNext){
			pConst = pConst->pNext;
		}

		pConst->pNext = newconst;
	}
	else{
		ppHash[key] = newconst;
	}
}
void CDBConst::AddConst( const NamespaceScopes &namespaceScopes, const string &name , char *Expression){
	_int64 i64data;
	Type resultType;
	if( !StaticCalculation(false, Expression, 0, &i64data, resultType) ){
		//ϐ̏ꍇ
		//Ȃis̈RpCdim錾ƂĈj
		return;
	}

	//el̏ꍇ
	//o^s

	CConst *newconst = new CConst(namespaceScopes, name, resultType, i64data);

	AddConst( name, newconst);
}
void CDBConst::AddConst(const NamespaceScopes &namespaceScopes, const string &name, int value){
	CConst *newconst = new CConst( namespaceScopes, name, value);

	AddConst(name, newconst);
}

CConst *CDBConst::GetObjectPtr( const string &name ){
	char ObjName[VN_SIZE];		//IuWFNgϐ
	char NestMember[VN_SIZE];	//qo
	bool isObjectMember = CClass::SplitName( name.c_str(), ObjName, NestMember );

	//nbVl擾
	int key;
	key=hash_default( NestMember );

	//i[ʒu擾
	CConst *pConst;
	pConst=ppHash[key];
	while(pConst){
		if( pConst->IsEqualSymbol( name ) ) break;

		pConst=pConst->pNext;
	}

	return pConst;
}


int CDBConst::GetBasicType(char *Name){
	CConst *pConst = GetObjectPtr(Name);

	if(!pConst) return 0;

	return pConst->GetType().GetBasicType();
}
_int64 CDBConst::GetWholeData(char *Name){
	CConst *pConst = GetObjectPtr(Name);

	if(!pConst) return 0;

	return pConst->GetWholeData();
}
double CDBConst::GetDoubleData(char *Name){
	CConst *pConst = GetObjectPtr(Name);

	if(!pConst) return 0;

	return pConst->GetDoubleData();
}
bool CDBConst::IsStringPtr( char *Name ){
	CConst *pConst = GetObjectPtr(Name);

	if(!pConst) return false;

	const Type &type = pConst->GetType();

	return ( type.GetBasicType() == typeOfPtrChar && type.GetIndex() == LITERAL_STRING );
}
