#pragma once

#include <string>
#include <vector>

#include "Type.h"
#include "Class.h"
#include "Source.h"

using namespace std;

class CClass;

class CMember : public MemberPrototype
{
	string name;
	Type type;
	bool isConst;

	string initializeExpression;
	string constructParameter;
public:
	int SubScripts[MAX_ARRAYDIM];

	int source_code_address;

	const string &GetName() const
	{
		return name;
	}
	void SetName( const string &name )
	{
		this->name = name;
	}

	Type GetType() const
	{
		return type;
	}

	bool IsConst()
	{
		return isConst;
	}

	const string &GetInitializeExpression() const
	{
		return initializeExpression;
	}
	const string &GetConstructParameter() const
	{
		return constructParameter;
	}

	CMember( Prototype::Accessibility accessibility, const string &name, const Type &type, bool isConst, const string &initializeExpression, const string &constructParameter )
		: MemberPrototype( accessibility )
		, name( name )
		, type( type )
		, isConst( isConst )
		, initializeExpression( initializeExpression )
		, constructParameter( constructParameter )
	{
	}
	CMember::CMember(CMember &member)
		: MemberPrototype( member.GetAccessibility() )
		, name( member.GetName() )
		, type( member.GetType() )
		, isConst( member.IsConst() )
	{
		//SubScripts
		memcpy(SubScripts,member.SubScripts,MAX_ARRAYDIM*sizeof(int));

		//\[XR[ḧʒu
		source_code_address=member.source_code_address;
	}
	~CMember()
	{
	}
};
typedef std::vector<CMember *> Members;
