#pragma once

#include <string>
#include <vector>

class SmoothieException
{
	int errorCode;
	std::string keyword;
	int nowLine;
public:
	SmoothieException( int errorCode, const std::string &keyword, int nowLine )
		: errorCode( errorCode )
		, keyword( keyword )
		, nowLine( nowLine )
	{
	}
	SmoothieException( int errorCode, const std::string &keyword )
		: errorCode( errorCode )
		, keyword( keyword )
		, nowLine( -1 )
	{
	}
	SmoothieException( int errorCode )
		: errorCode( errorCode )
		, keyword( "" )
		, nowLine( -1 )
	{
	}
	SmoothieException()
		: errorCode( 300 )
		, keyword( "" )
		, nowLine( -1 )
	{
	}

	int GetErrorCode() const
	{
		return errorCode;
	}
	const std::string &GetKeyword() const
	{
		return keyword;
	}
	int GetNowLine() const
	{
		return nowLine;
	}
};
