#pragma once

#include <string>
#include <vector>

#include "Type.h"
#include "BasicFixed.h"

class Parameter : public Type
{
	std::string varName;
	bool isRef;
	bool isArray;
	int subScripts[MAX_ARRAYDIM];

	const std::string initValue;

public:
	Parameter( const std::string &varName, const Type &type, bool isRef = false, const std::string initValue = "" ):
		Type( type ),
		varName( varName ),
		isRef( isRef ),
		isArray( false ),
		initValue( initValue )
	{
		subScripts[0] = -1;
	}
	Parameter( const Parameter &param ):
		Type( param ),
		varName( param.varName ),
		isRef( param.isRef ),
		isArray( false ),
		initValue( param.initValue )
	{
		subScripts[0] = -1;
		if( param.isArray ){
			SetArray( param.subScripts );
		}
	}
	~Parameter(){}

	void SetArray( const int *pSubScripts ){
		isArray = true;
		memcpy( this->subScripts, pSubScripts, sizeof(int) * MAX_ARRAYDIM );
	}

	const std::string &GetVarName() const
	{
		return varName;
	}

	bool IsRef() const
	{
		return isRef;
	}
	bool IsArray(){
		return isArray;
	}
	int *GetSubScriptsPtr(){
		return subScripts;
	}

	const std::string &GetInitValue() const
	{
		return initValue;
	}

	bool Equals( const Parameter &param ) const
	{
		if( Type::Equals( param ) ){
			return true;
		}
		else{

			if( this->isRef && this->GetBasicType() == DEF_ANY &&
				param.isRef == false && param.IsPointer()
				||
				this->isRef == false && this->IsPointer() &&
				param.isRef && param.GetBasicType() == DEF_ANY ){
					/* ByRef var As Any
							
						var As VoidPtr
						͓
					*/
					return true;
			}
		}

		return false;
	}
};

class Parameters : public std::vector<Parameter *>
{
public:

	bool Equals( const Parameters &params ) const
	{
		if( this->size() != params.size() ){
			return false;
		}

		int max = (int)this->size();
		for( int i=0; i<max; i++ ){
			if( !(*this)[i]->Equals( *params[i] ) ){
				return false;
			}
		}

		return true;
	}

	int GetMemorySize() const
	{
		return (int)this->size() * PTR_SIZE;
	}
};
