#include "../common.h"
#include <Method.h>


Methods::Methods()
{
}
Methods::~Methods()
{
	Methods &methods = *this;
	BOOST_FOREACH( CMethod *pMethod, methods ){
		delete pMethod;
	}
}

void Methods::Add( UserProc *pUserProc,Prototype::Accessibility accessibility, bool isConst, bool isAbstract, bool isVirtual ){
	CMethod *pMethod = new DynamicMethod( pUserProc, accessibility, isAbstract, isVirtual, isConst );
	this->push_back( pMethod );
	pUserProc->SetMethod( pMethod );
}
void Methods::AddStatic(UserProc *pUserProc, Prototype::Accessibility accessibility ){
	CMethod *pMethod = new StaticMethod( pUserProc, accessibility );
	this->push_back( pMethod );
	pUserProc->SetMethod( pMethod );
}

const CMethod *Methods::GetMethodPtr( UserProc *pUserProc ) const
{
	const Methods &methods = *this;
	for( int i=(int)methods.size()-1; i>=0; i-- ){
		if( pUserProc == methods[i]->pUserProc ){
			return methods[i];
		}
	}
	return NULL;
}
bool Methods::IsExist( const char *name ) const
{
	const Methods &methods = *this;
	foreach( const CMethod *pMethod, methods ){
		if( pMethod->pUserProc->GetName() == name ) return true;
	}
	return false;
}
void Methods::Enum( const char *methodName, vector<UserProc *> &subs ) const
{
	//IuWFNg̃o֐̏ꍇ
	//I[o[Chꂽ֐ɃT[`Kv邽߁AobNT[`s
	const Methods &methods = *this;
	for( int i=(int)methods.size()-1; i>=0; i-- ){
		if( methods[i]->pUserProc->GetName() == methodName ){
			subs.push_back( methods[i]->pUserProc );
		}
	}
}
void Methods::Enum( const BYTE idOperatorCalc, vector<UserProc *> &subs ) const
{
	//IuWFNg̃o֐̏ꍇ
	//I[o[Chꂽ֐ɃT[`Kv邽߁AobNT[`s
	const Methods &methods = *this;
	for( int i=(int)methods.size()-1; i>=0; i-- ){
		UserProc *pUserProc = methods[i]->pUserProc;
		const char *temp = pUserProc->GetName().c_str();
		if(temp[0]==1&&temp[1]==ESC_OPERATOR){
			if((BYTE)temp[2]==idOperatorCalc){
				subs.push_back( pUserProc );
			}
		}
	}
}
