#include "common.h"

//R[hϊpNXCu
CNkf nkf;

CNkf::CNkf(){
	char temporary[MAX_PATH];
	sprintf(temporary,"%sSubOperation\\nkf32.dll",pj_editor_Dir);

	hLib=LoadLibrary(temporary);

	pGetNkfVersion=(GetNkfVersion)GetProcAddress(hLib,"GetNkfVersion");
	pSetNkfOption=(SetNkfOption)GetProcAddress(hLib,"SetNkfOption");
	pNkfConvert=(NkfConvert)GetProcAddress(hLib,"NkfConvert");
	pNkfGetKanjiCode=(NkfGetKanjiCode)GetProcAddress(hLib,"NkfGetKanjiCode");
}

CNkf::~CNkf(){
	FreeLibrary(hLib);
}


char *CNkf::RestoreBuffer(char *buffer,int iCharCode){
	/////////////////////
	// R[h𕜌
	// \Shift-JIS
	/////////////////////
	extern HANDLE hHeap;
	char *pBuf;

	pBuf=(char *)HeapAlloc(hHeap,0,lstrlen(buffer)*2+1);

	switch(iCharCode){
		case NKF_SHIFT_JIS:
			lstrcpy(pBuf,buffer);
			break;
		case NKF_EUC:
			pSetNkfOption("-ex");
			pNkfConvert(pBuf,buffer);
			break;
		case NKF_ISO_2022_JP:
			pSetNkfOption("-jx");
			pNkfConvert(pBuf,buffer);
			break;
		case NKF_UTF_8:
			pSetNkfOption("-wx");
			pNkfConvert(pBuf,buffer);
			break;
	}

	return pBuf;
}

void CNkf::GetCharCodeName(int iCharCode,char *name){
	switch(iCharCode){
		case NKF_SHIFT_JIS:
			lstrcpy(name,"Shift-JIS");
			break;
		case NKF_EUC:
			lstrcpy(name,"EUC");
			break;
		case NKF_ISO_2022_JP:
			lstrcpy(name,"JIS");
			break;
		case NKF_UTF_8:
			lstrcpy(name,"UTF-8");
			break;
	}
}

char *CNkf::ToCRLF(int iLfCode,char *buffer){
	extern HANDLE hHeap;
	int i,i2;

	char *temp;
	temp=(char *)HeapAlloc(hHeap,0,lstrlen(buffer)*2+1);

	for(i=0,i2=0;;i++,i2++){
		if(buffer[i]=='\0'){
			temp[i2]=0;
			break;
		}
		if(iLfCode==LFCODE_LF){
			if(buffer[i]=='\n'){
				temp[i2++]='\r';
				temp[i2]='\n';
				continue;
			}
		}
		else if(iLfCode==LFCODE_CR){
			if(buffer[i]=='\r'){
				temp[i2++]='\r';
				temp[i2]='\n';
				continue;
			}
		}

		temp[i2]=buffer[i];
	}

	return temp;
}
void CNkf::ToLF(char *buffer){
	extern HANDLE hHeap;
	int i,i2;

	for(i=0,i2=0;;i++,i2++){
		if(buffer[i]=='\r'&&buffer[i+1]=='\n'){
			buffer[i2]='\n';
			i++;
			continue;
		}

		buffer[i2]=buffer[i];
		if(buffer[i]=='\0') break;
	}
}
void CNkf::ToCR(char *buffer){
	extern HANDLE hHeap;
	int i,i2;

	for(i=0,i2=0;;i++,i2++){
		if(buffer[i]=='\r'&&buffer[i+1]=='\n'){
			buffer[i2]='\r';
			i++;
			continue;
		}

		buffer[i2]=buffer[i];
		if(buffer[i]=='\0') break;
	}
}

void CNkf::GetLfCodeName(int iLfCode,char *name){
	switch(iLfCode){
		case LFCODE_CRLF:
			lstrcpy(name,"CRLF");
			break;
		case LFCODE_LF:
			lstrcpy(name,"LF");
			break;
		case LFCODE_CR:
			lstrcpy(name,"CR");
			break;
	}
}



BOOL CALLBACK nkfDlgCodeSave(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	static int WndNum;
	HWND hList;

	switch(message){
		case WM_INITDIALOG:
			SetPosCenter(hwnd);

			WndNum=GetWndNum(GetWindow(hClient,GW_CHILD));
			if(WndNum==-1){
				//EBhE̎擾Ɏs
				EndDialog(hwnd,0);
				break;
			}
			if(!IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
				//eLXghLgłȂƂ
				EndDialog(hwnd,0);
				break;
			}

			hList=GetDlgItem(hwnd,IDC_LIST_CHARCODE);
			SendMessage(hList,LB_ADDSTRING,0,(long)"Shift-JIS");
			SendMessage(hList,LB_ADDSTRING,0,(long)"EUC");
			SendMessage(hList,LB_ADDSTRING,0,(long)"JIS");
			SendMessage(hList,LB_ADDSTRING,0,(long)"UTF-8");
			SendMessage(hList,LB_SETCURSEL,MdiInfo[WndNum].pMdiTextEdit->iCharCode,0);

			hList=GetDlgItem(hwnd,IDC_LIST_LFCODE);
			SendMessage(hList,LB_ADDSTRING,0,(long)"CRLF(Windows)");
			SendMessage(hList,LB_ADDSTRING,0,(long)"LF(Unix)");
			SendMessage(hList,LB_ADDSTRING,0,(long)"CR(Macintosh)");
			SendMessage(hList,LB_SETCURSEL,MdiInfo[WndNum].pMdiTextEdit->iLfCode,0);
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					//R[h擾
					MdiInfo[WndNum].pMdiTextEdit->iCharCode=
						(int)SendDlgItemMessage(hwnd,IDC_LIST_CHARCODE,LB_GETCURSEL,0,0);

					//sR[h擾
					MdiInfo[WndNum].pMdiTextEdit->iLfCode=
						(int)SendDlgItemMessage(hwnd,IDC_LIST_LFCODE,LB_GETCURSEL,0,0);

					//ۑ
					if(!SaveDocument(GetWindow(hClient,GW_CHILD),NULL)) return 0;

					EndDialog(hwnd,1);
					break;
				case IDCANCEL:
					EndDialog(hwnd,0);
					break;
			}
			break;
	}
	return 0;
}
