#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void NewStringObject(int reg, const char *str){
	///////////////////////////////////////////////////////
	// lpszTextStringIuWFNg𐶐A
	// IuWFNg|C^regɊi[
	///////////////////////////////////////////////////////


	//////////////////////////////////////////////////////
	/////    WX^̃obNAbv
	{	BACKUP_REGISTER_RESOURCE
	//////////////////////////////////////////////////////

		char *parameter = (char *)malloc( lstrlen( str ) + 32 );
		sprintf( parameter, "\"%s\"%c%c*Char", str, 1, ESC_AS );
		SetStringQuotes( parameter );

		Operator_New( *pobj_DBClass->GetStringClassPtr(), "", parameter, Type( DEF_OBJECT, *pobj_DBClass->GetStringClassPtr() ) );

		free( parameter );

		//mov reg,rax
		op_mov_RR( reg, REG_RAX );

	/////////////////////////////////////////////
	//////   WX^𕜌
		RESTORE_REGISTER_RESOURCE
	}////////////////////////////////////////////
}

void SetUseRegFromRax(int type,int UseReg,int XmmReg){
	if(IsRealNumberType(type)){
		//^
		if(XmmReg==REG_XMM4){
			if(type==DEF_DOUBLE){
				//movsd qword ptr[rsp+offset],xmm0	X^bNt[𗘗p
				pobj_sf->push(REG_XMM0,sizeof(double));
			}
			if(type==DEF_SINGLE){
				//movss dword ptr[rsp+offset],xmm0	X^bNt[𗘗p
				pobj_sf->push(REG_XMM0,sizeof(float));
			}
		}
		else{
			if(type==DEF_DOUBLE){
				//movsd xmm_reg,xmm0
				op_movsd_RR(XmmReg,REG_XMM0);
			}
			else if(type==DEF_SINGLE){
				//movss xmm_reg,xmm0
				op_movss_RR(XmmReg,REG_XMM0);
			}
		}
	}
	else{
		//^
		if(UseReg==REG_R14){
			//mov qword ptr[rsp+offset],rax     X^bNt[𗘗p
			pobj_sf->push(REG_RAX);
		}
		else{
			//mov reg,rax
			op_mov_RR(UseReg,REG_RAX);
		}
	}
}

void ExtendRegToBigType( int reg, int bigBasicType, int baseBasicType ){
	switch( Type::GetBasicSize( bigBasicType ) ){
		case sizeof(_int64):
			ExtendTypeTo64(baseBasicType,reg);
			break;
		case sizeof(long):
			ExtendTypeTo32(baseBasicType,reg);
			break;
		case sizeof(short):
			ExtendTypeTo16(baseBasicType,reg);
			break;
	}
}


bool VarToReg( RELATIVE_VAR &relativeVar, const Type &baseType, Type &resultType ){
	int UseReg=pobj_reg->GetNextReg();
	int XmmReg=pobj_reg->GetNextXmmReg();

	//傫Ȍ^ւ̈Öق̕ϊ
	int bigType = AutoBigCast(baseType.GetBasicType(),resultType.GetBasicType());

	if(resultType.GetBasicType()&FLAG_PTR){
		//z|C^
		resultType.SetBasicType( GetPtrType(resultType.GetBasicType()^FLAG_PTR) );

		SetVarPtrToReg(UseReg,&relativeVar);
	}
	else if(resultType.IsReal()){
		//^
		if( resultType.IsDouble() )
			SetXmmReg_DoubleVariable(&relativeVar,XmmReg);
		if( resultType.IsSingle() )
			SetXmmReg_SingleVariable(&relativeVar,XmmReg);
	}
	else if( resultType.IsWhole() || resultType.IsObject()){
		//^
		SetReg_WholeVariable(resultType.GetBasicType(),&relativeVar,UseReg);
	}
	else if( resultType.IsStruct() ){
		//\̃|C^UseReg֊i[i\̂͒l^j
		SetVarPtrToReg(UseReg,&relativeVar);
	}
	else{
		return false;
	}

	if( resultType.GetBasicType() != bigType ){
		// 傫Ȍ^֕ϊꂽꍇ
		// WX^̒lLXg
		ExtendRegToBigType( UseReg, bigType, resultType.GetBasicType() );

		resultType.SetBasicType( bigType );
	}

	return true;
}
bool TermMemberOpe( const CClass &objClass, const Type &baseType, Type &resultType, const char *termFull, const char *termLeft, const char *member ){

	int UseReg=pobj_reg->GetNextReg();
	int XmmReg=pobj_reg->GetNextXmmReg();


	if( GetMemberType( objClass, member, resultType, 0, false ) ){
		// oƂ

		//IuWFNg|C^r11ɃRs[
		op_mov_RR( REG_R11, UseReg );

		RELATIVE_VAR relativeVar;
		relativeVar.dwKind=VAR_DIRECTMEM;

		if( !_member_offset(
			true,	//G[\
			false,	//ǂݍݐp
			objClass,
			member,&relativeVar,resultType,0)){
				return false;
		}

		if( !VarToReg( relativeVar, baseType, resultType ) ){
			SetError(11,termFull,cp);
		}

		return true;
	}


	///////////////////////////////////////////////////////////////////
	// I\bh
	///////////////////////////////////////////////////////////////////
	vector<UserProc *> userProcs;

	char methodName[VN_SIZE], lpPtrOffset[VN_SIZE], parameter[VN_SIZE], dummy[1];
	CClass::RefType refType;
	lstrcpy( methodName, member );
	GetVarFormatString(methodName,parameter,lpPtrOffset,dummy,refType);

	objClass.GetMethods().Enum( methodName, userProcs );
	UserProc *pUserProc;
	if(userProcs.size()){
		//I[o[[h
		pUserProc=OverloadSolutionWithStrParam(termFull,userProcs,parameter,termLeft);

		if( pUserProc ){

			resultType = pUserProc->ReturnType();


			//////////////////////////////////////////////////////
			/////    WX^̃obNAbv
			{	BACKUP_REGISTER_RESOURCE
			//////////////////////////////////////////////////////

				//IuWFNg|C^X^bNɓĂ
				//mov qword ptr[rsp+offset],reg     X^bNt[𗘗p
				pobj_sf->push( UseReg );

				if( !Opcode_CallProc(parameter,pUserProc,PROCFLAG_NEW,termLeft,0 ) ){
					//WX^𕜌
					RESTORE_REGISTER_RESOURCE

					return false;
				}

				pobj_sf->pop();

				/////////////////////
				// ߂l̏
				/////////////////////

				//傫Ȍ^ւ̈Öق̕ϊ
				int bigType = AutoBigCast(baseType.GetBasicType(), resultType.GetBasicType() );

				if( resultType.GetBasicType() != bigType ){
					// 傫Ȍ^֕ϊꂽꍇ
					// WX^̒lLXg
					ExtendRegToBigType( REG_RAX, bigType, resultType.GetBasicType() );

					resultType.SetBasicType( bigType );
				}

				SetUseRegFromRax(resultType.GetBasicType(),UseReg,XmmReg);


			/////////////////////////////////////////////
			//////   WX^𕜌
				RESTORE_REGISTER_RESOURCE
			}////////////////////////////////////////////
			
			return true;
		}
	}

	return false;
}
bool TermOpe( const char *term, const Type &baseType, Type &resultType, bool &isLiteral, BOOL *pbUseHeap, bool isWantObject, bool *pIsClassName, bool isProcedureCallOnly ){
	char parameter[VN_SIZE];

	// With
	char termFull[VN_SIZE];
	if(term[0]=='.'){
		GetWithName(termFull);
		lstrcat(termFull,term);
	}
	else lstrcpy(termFull,term);

	char termLeft[VN_SIZE];
	lstrcpy(termLeft,termFull);

	// p[X
	char member[VN_SIZE];
	CClass::RefType refType;
	if( SplitMemberName( termFull, termLeft, member, refType ) ){
		///////////////////////////////////////////////////////////////////
		// IuWFNgƃoɕłƂ
		// termLeft.member
		///////////////////////////////////////////////////////////////////

		isLiteral = false;

		// IuWFNǧ^擾
		bool isClassName = false;
		Type leftType;
		if( GetTermType( termLeft, leftType, isLiteral, &isClassName ) ){
			if( isClassName == false && Smoothie::meta.blittableTypes.IsExist( leftType ) ){
				// ̃IuWFNgBlittable^̂Ƃ

				char temporary[VN_SIZE];
				lstrcpy( temporary, termLeft );
				sprintf( termLeft, "%s(%s)",
					Smoothie::meta.blittableTypes.Find( leftType ).GetCreateStaticMethodFullName().c_str(),
					temporary );
			}
		}

		if( !TermOpe( termLeft, baseType, leftType, isLiteral, pbUseHeap, true, &isClassName ) ){
			goto globalArea;
		}

		if( isClassName ){
			// ÓIo/\bh̏ꍇ
			goto globalArea;
		}

		if( !leftType.HasMember() ){
			// oȂ^̏ꍇ
			return false;
		}

		return TermMemberOpe( leftType.GetClass(), baseType, resultType, termFull, termLeft, member );
	}
globalArea:

	//////////////////////////////////////////////
	// NXǂ`FbNiÓIopj
	//////////////////////////////////////////////

	if( pIsClassName ){
		if( pobj_DBClass->Find( termFull ) ){
			*pIsClassName = true;
			return true;
		}
	}


	/////////////////////////////////////////////////////////////////
	// O[oGA
	/////////////////////////////////////////////////////////////////

	int UseReg=pobj_reg->GetNextReg();
	int XmmReg=pobj_reg->GetNextXmmReg();


	if(lstrcmpi(termFull,"This")==0 && isProcedureCallOnly == false ){
		//ThisIuWFNg
		resultType.SetType( DEF_OBJECT, pobj_CompilingClass );

		SetThisPtrToReg( UseReg );

		isLiteral = false;

		return true;
	}


	//////////////////////////////////////
	// ֐iDLLA[U[`Agݍ݁j
	//////////////////////////////////////
	char procName[VN_SIZE];
	char temporary[8192];

	int i2=GetCallProcName(termFull,procName);
	if(termFull[i2]=='('){
		int i4=GetStringInPare_RemovePare(parameter,termFull+i2+1);

		void *pInfo;
		int idProc=GetProc(procName,(void **)&pInfo);

		if(idProc){
			//JbR")"ɑNULLłȂƂ
			if(termFull[i2+1+i4+1]!='\0'){
				SetError(42,NULL,cp);
			}


			//////////////////////////////////////////////////////
			/////    WX^̃obNAbv
			{	BACKUP_REGISTER_RESOURCE
			//////////////////////////////////////////////////////


				////////////////
				// Ăяo
				////////////////

				CallProc(idProc,pInfo,procName,parameter,resultType);


				/////////////////////
				// ߂l̏
				/////////////////////

				//傫Ȍ^ւ̈Öق̕ϊ
				int bigType = AutoBigCast(baseType.GetBasicType(), resultType.GetBasicType() );

				if( resultType.GetBasicType() != bigType ){
					// 傫Ȍ^֕ϊꂽꍇ
					// WX^̒lLXg
					ExtendRegToBigType( REG_RAX, bigType, resultType.GetBasicType() );

					resultType.SetBasicType( bigType );
				}

				SetUseRegFromRax(resultType.GetBasicType(),UseReg,XmmReg);

			/////////////////////////////////////////////
			//////   WX^𕜌
				RESTORE_REGISTER_RESOURCE
			}////////////////////////////////////////////

			if(resultType.IsStruct()){
				//\̂߂Ƃ̓q[v̈ɃCX^Xi[Ă
				//freeKv
				// TODO: GCɔC
				*pbUseHeap = 1;
			}

			isLiteral = false;

			return true;
		}
		else if(GetConstCalcBuffer(procName,parameter,temporary)){
			/////////////////////////
			// }N֐
			/////////////////////////

			//JbR")"ɑNULLłȂƂ̓G[ɂ
			if(termFull[i2+1+i4+1]!='\0') SetError(42,NULL,cp);

			//}N֐̏ꍇ
			NumOpe(&UseReg,temporary,Type(),resultType);

			if(!IS_LITERAL(resultType.GetIndex())){
				//elł͂ȂƂ
				isLiteral = false;
			}

			return true;
		}
	}
	else if( isProcedureCallOnly ){
		// ֐ĂяoȊO͎󂯕tȂ
		return false;
	}


	////////////////////////////////
	// CfNTigetANZTj
	////////////////////////////////

	char VarName[VN_SIZE],ArrayElements[VN_SIZE];
	GetArrayElement(termFull,VarName,ArrayElements);
	if(ArrayElements[0]){
		GetVarType(VarName,resultType,false);
		if( resultType.IsObject() ){
			CallIndexerGetterProc(UseReg,&resultType.GetClass(),VarName,ArrayElements,resultType);

			isLiteral = false;

			return true;
		}
	}


	////////////////////////////////
	// ϐ
	////////////////////////////////

	RELATIVE_VAR relativeVar;
	if(GetVarOffset(
		false,	//G[\Ȃ
		false,	//ǂݍݐp
		termFull,
		&relativeVar,resultType)){
		//////////
		// ϐ
		//////////

		if( !VarToReg( relativeVar, baseType, resultType ) ){
			SetError(11,termFull,cp);
		}

		isLiteral = false;

		return true;
	}

/*
	////////////////////////////////
	// ^
	////////////////////////////////

	if( Type::StringToType( termFull, resultType ) ){
		resultType.SetBasicType( resultType.GetBasicType() | FLAG_CAST );
		return true;
	}*/


	/////////////////////////////////
	// vpeBp̃\bh
	/////////////////////////////////

	//zvfr
	GetArrayElement(termFull,VarName,ArrayElements);

	if(GetSubHash(VarName,0)){

		//////////////////////////////////////////////////////
		/////    WX^̃obNAbv
		{	BACKUP_REGISTER_RESOURCE
		//////////////////////////////////////////////////////

			CallPropertyMethod(termFull,NULL,resultType);

			//傫Ȍ^ւ̈Öق̕ϊ
			int bigType = AutoBigCast(baseType.GetBasicType(), resultType.GetBasicType() );

			if( resultType.GetBasicType() != bigType ){
				// 傫Ȍ^֕ϊꂽꍇ
				// WX^̒lLXg
				ExtendRegToBigType( REG_RAX, bigType, resultType.GetBasicType() );

				resultType.SetBasicType( bigType );
			}

			SetUseRegFromRax(resultType.GetBasicType(),UseReg,XmmReg);

		/////////////////////////////////////////////
		//////   WX^𕜌
			RESTORE_REGISTER_RESOURCE
		}////////////////////////////////////////////

		if(resultType.IsStruct()){
			//\̂߂Ƃ̓q[v̈ɃCX^Xi[Ă
			//freeKv
			// TODO: GCɔC
			*pbUseHeap = 1;
		}

		isLiteral = false;

		return true;
	}


	return false;
}

bool NumOpe( int *pReg,
			const char *expression,
			const Type &baseType,
			Type &resultType,
			BOOL *pbUseHeap ){

	int i,i2,i3;
	char temporary[1024],temp2[1024];

	if(expression[0]=='\0'){
		SetError(1,NULL,cp);
		return false;
	}

	if(expression[0]==1&& expression[1]==ESC_NEW ){
		//NewZqiIuWFNgj

		if( pobj_BlockReg->check(REG_RAX) ){
			SetError();
		}

		//////////////////////////////////////////////////////
		/////    WX^̃obNAbv
		{	BACKUP_REGISTER_RESOURCE
		//////////////////////////////////////////////////////

			if( !Operator_New( expression+2, baseType, resultType ) ){
				return false;
			}

		/////////////////////////////////////////////
		//////   WX^𕜌
			RESTORE_REGISTER_RESOURCE
		}////////////////////////////////////////////

		//mov reg,rax
		op_mov_RR( *pReg, REG_RAX );

		return true;
	}

	if( !baseType.IsNull() && expression[0] == '[' ){
		// ez̏ꍇ

		if( !baseType.IsPointer() ){
			SetError(1,NULL,cp);
			return false;
		}
		Type tempBaseType( baseType );
		tempBaseType.PtrLevelDown();

		char *buffer = (char *)malloc( lstrlen( expression ) + 1 );
		lstrcpy( buffer, expression );
		RemoveStringBracket( buffer );

		void *binary = malloc( 1 );
		int num = 0;

		i = 0;
		while( buffer[i] ){
			i = GetOneParameter( buffer, i, temporary );
			if( buffer[i] == ',' ){
				i++;
			}

			Type resultType;
			_int64 i64data;
			if( !StaticCalculation( true, temporary, tempBaseType.GetBasicType(), &i64data, resultType ) ){
				return false;
			}
			if( !resultType.IsWhole() ){
				// TODO: ɖΉ
				SetError();
				return false;
			}

			binary = realloc( binary, ( num + 1 ) * tempBaseType.GetSize() );
			memcpy( (char *)binary + (num * tempBaseType.GetSize()), &i64data, tempBaseType.GetSize() );
			num++;
		}

		i2 = dataTable.AddBinary( binary, num * tempBaseType.GetSize() );

		//mov reg,i2
		op_mov_RV(sizeof(_int64),*pReg,i2);
		obp-=sizeof(long);
		pobj_DataTableSchedule->add();
		obp+=sizeof(long);

		free( buffer );

		resultType = baseType;

		return true;
	}


	/////////////////////////////////
	// vft|[hŎ擾
	/////////////////////////////////

	char *values[255];
	long calc[255];
	long stack[255];
	int pnum;
	if(!GetNumOpeElements(expression,&pnum,values,calc,stack)){
		for(i=0;i<pnum;i++){
			if(values[i]) HeapDefaultFree(values[i]);
		}
		return 0;
	}


	BOOL bInitRegSwitch=0;
	if(!pobj_reg){
		bInitRegSwitch=1;

		//ƗpWX^擾
		pobj_reg=new CRegister(*pReg);
	}

	//G[̕p
	CRegister objReg_Backup;
	objReg_Backup=*pobj_reg;



	////////////////////////////////
	// Z̃R[hJn
	////////////////////////////////

	BOOL bError;
	bError=0;

	//el݂̂̌vZǂ𔻕ʂ邽߂̃tO
	BOOL bLiteralCalculation=1;

	//eZ̏ꍇlZÕobt@ʒu
	int BeforeObp;
	BeforeObp=obp;

	//eZ̏ꍇlZÕvV[WXPW[ʒu
	//64rbg̊|ZAZȂǂœ֐Ă΂邽
	int Before_ProcAddrScheduleNum;
	Before_ProcAddrScheduleNum=pobj_SubAddrSchedule->num;

	//eZ̏ꍇlZÕf[^e[uXPW[ʒu
	int Before_DataTableScheduleNum;
	Before_DataTableScheduleNum=pobj_DataTableSchedule->num;

	//eZ̏ꍇlZO̍ĔzuXPW[
	CReloc *pobj_BackReloc;
	pobj_BackReloc=new CReloc();
	pobj_BackReloc->copy(pobj_Reloc);

	//eZ̏ꍇlZÕX^bNt[XPW[ʒu
	int Before_StackFrameScheduleNum;
	Before_StackFrameScheduleNum=pobj_sf->num;

	double dbl;
	int sp;
	int type_stack[255];
	LONG_PTR index_stack[255];
	bool isNothing_stack[255];
	BOOL bUseHeap[255];
	_int64 i64data;
	int UseReg,XmmReg;
	BOOL bXmm;
	for(i=0,sp=0;i<pnum;i++){
		int idCalc;
		idCalc=calc[i]%100;

		if(idCalc){
			if(type_stack[sp-2]==DEF_OBJECT){
				if( idCalc == CALC_AS
					&& type_stack[sp-1] == ( DEF_OBJECT | FLAG_CAST )
					&& index_stack[sp-1] == index_stack[sp-2]
					|| isNothing_stack[sp-2] ){
						// ̌^A܂Nothingɑ΂AsAsZqĂяoȂ
				}
				else if( idCalc == CALC_AS
					&& type_stack[sp-1] == ( DEF_OBJECT | FLAG_CAST )
					&& ( ((CClass *)index_stack[sp-1])->IsEqualsOrSubClass( (CClass *)index_stack[sp-2] ) || ((CClass *)index_stack[sp-2])->IsEqualsOrSubClass( (CClass *)index_stack[sp-1] )
					)){
						// _ELXg
				}
				else if( idCalc == CALC_AS
					&& type_stack[sp-1] == ( DEF_OBJECT | FLAG_CAST ) && ((CClass *)index_stack[sp-1])->IsInterface()
					){
						// C^[tFCXւ̃LXg
						// TODO: 
						CastToInterface( pobj_reg->GetLockingReg(), REG_R15, *(CClass *)index_stack[sp-2], *(CClass *)index_stack[sp-1] );
				}
				else{
					//I[o[[hꂽIy[^Ăяo
					i2=CallOperatorProc(idCalc,baseType,type_stack,index_stack,bUseHeap,sp);
					if(i2==0){
						if(idCalc==CALC_EQUAL) lstrcpy(temp2,"==");
						else GetCalcName(idCalc,temp2);
						sprintf(temporary,"Operator %s",temp2);
						SetError(27,temporary,cp);
						goto error;
					}
					else if(i2==-1) goto error;

					continue;
				}
			}

			if(!CheckCalcType(idCalc,type_stack,sp)) goto error;
		}

		switch(idCalc){
			//l
			case 0:
				index_stack[sp]=-1;
				isNothing_stack[sp] = false;
				bUseHeap[sp]=0;

				UseReg=pobj_reg->GetNextReg();
				XmmReg=pobj_reg->GetNextXmmReg();

				bXmm=0;

				char *term;
				term=values[i];

				if( calc[i+1]%100 == CALC_AS ){
					// AsZq̉EӒl
					//^
					if( Type::StringToType( term, resultType ) ){
						resultType.SetBasicType( resultType.GetBasicType() | FLAG_CAST );
					}
					else{
						SetError(3, term, cp );
						goto error;
					}

					type_stack[sp] = resultType.GetBasicType();
					index_stack[sp] = resultType.GetIndex();
					sp++;

					break;
				}

				if(term[0]=='\"'){
					//e
					if(!RemoveStringQuotes(term)){
						SetError(43,NULL,cp);
						goto error;
					}
					i3=lstrlen(term);
StrLiteral:

					if( baseType.IsObject() || baseType.IsNull() ){
						//v^CvIuWFNgA܂͖̂Ƃ

						//String^IuWFNg𐶐
						NewStringObject(UseReg,term);

						type_stack[sp]=DEF_OBJECT;
						index_stack[sp]=(LONG_PTR)pobj_DBClass->GetStringClassPtr();
						bLiteralCalculation=0;

						if(bXmm) pobj_reg->LockXmmReg();
						else pobj_reg->LockReg();

						sp++;
						break;
					}

					type_stack[sp]=typeOfPtrChar;
					bLiteralCalculation=0;

					i2 = dataTable.AddString( term, i3 );

					//mov reg,i2
					op_mov_RV(sizeof(_int64),UseReg,i2);
					obp-=sizeof(long);
					pobj_DataTableSchedule->add();
					obp+=sizeof(long);

					if(UseReg==REG_R14){
						//mov qword ptr[rsp+offset],r14     X^bNt[𗘗p
						pobj_sf->push(REG_R14);
					}
				}
				else if((term[0]=='e'||term[0]=='E')&&
					(term[1]=='x'||term[1]=='X')&&
					term[2]=='\"'){
					//gŃeiGXP[vV[PX\j
					if(!RemoveStringQuotes(term+2)){
						SetError(43,NULL,cp);
						goto error;
					}
					i3=FormatString_EscapeSequence(term+2);
					term+=2;

					goto StrLiteral;
				}
				else if(IsVariableTopChar(term[0])||
					term[0]=='*'||
					(term[0]=='.'&&IsVariableTopChar(term[1]))){
					//////////////////
					// 炩̎ʎq

					bool isLiteral;
					if( TermOpe( term, baseType, resultType, isLiteral, &bUseHeap[sp] ) ){
						if(resultType.IsNull()){
							//߂l݂ȂƂ
							for(i2=0;;i2++){
								if(term[i2]=='('||term[i2]=='\0'){
									term[i2]=0;
									break;
								}
							}
							SetError(38,term,cp);

							goto error;
						}

						type_stack[sp] = resultType.GetBasicType();
						index_stack[sp] = resultType.GetIndex();

						if( !isLiteral ){
							bLiteralCalculation=0;
						}

						if( resultType.GetBasicType() & FLAG_CAST ){
							// ^̂
							SetError();
						}
						else{
							if( resultType.IsReal() == false && UseReg==REG_R14 ){
								//mov qword ptr[rsp+offset],r14     X^bNt[𗘗p
								pobj_sf->push(REG_R14);
							}
							if( resultType.IsReal() && XmmReg==REG_XMM4 ){
								if(resultType.IsDouble()){
									//movsd qword ptr[rsp+offset],xmm4	X^bNt[𗘗p
									pobj_sf->push(REG_XMM4,sizeof(double));
								}
								if(resultType.IsSingle()){
									//movss dword ptr[rsp+offset],xmm4	X^bNt[𗘗p
									pobj_sf->push(REG_XMM4,sizeof(float));
								}
							}

							if( resultType.IsReal() ){
								pobj_reg->LockXmmReg();
							}
							else{
								pobj_reg->LockReg();
							}
						}

						sp++;
						break;
					}


					// Nothing
					if( lstrcmp( term, "Nothing" ) == 0 ){
						isNothing_stack[sp] = true;

						type_stack[sp] = DEF_OBJECT;
						if( baseType.IsObject() ){
							index_stack[sp] = baseType.GetIndex();
						}
						else{
							index_stack[sp] = (LONG_PTR)pobj_DBClass->GetObjectClassPtr();
						}

						bLiteralCalculation = 0;

						//xor reg,reg
						op_zero_reg( UseReg );

						if(UseReg==REG_R14){
							//mov qword ptr[rsp+offset],r14     X^bNt[𗘗p
							pobj_sf->push(REG_R14);
						}

						pobj_reg->LockReg();
						sp++;
						break;
					}


					//////////////
					// 萔̏ꍇ
					//////////////

					i3 = CDBConst::obj.GetBasicType(term);
					if(i3){
						if( CDBConst::obj.IsStringPtr( term ) ){
							//e

							double dbl = CDBConst::obj.GetDoubleData(term);
							memcpy(&i64data,&dbl,sizeof(double));

							//oCg
							i3=lstrlen((char *)i64data);

							memcpy(term,(char *)i64data,i3);
							term[i3]=0;
							goto StrLiteral;
						}

						type_stack[sp] = i3;
						if(IsRealNumberType(i3)){
							//
							double dbl = CDBConst::obj.GetDoubleData(term);
							memcpy(&i64data,&dbl,sizeof(double));
							goto Literal;
						}
						else if(IsWholeNumberType(i3)){
							//
							i64data = CDBConst::obj.GetWholeData(term);
							goto Literal;
						}
						/*else if(i3==DEF_STRING){
							//e

							//oCg
							i3=(int)dbl;

							memcpy(term,temporary,i3);
							goto StrLiteral;
						}*/
						else{
							SetError(1,NULL,0);
							goto error;
						}
					}


					//Y鎯ʎqȂƂ̓G[ɂ
					bError=1;
					SetError(3,term,cp);
					type_stack[sp]=DEF_DOUBLE;
				}
				else{
					//el
					type_stack[sp]=GetLiteralValue(term,&i64data,baseType.GetBasicType());
Literal:
					if(type_stack[sp]==DEF_DOUBLE){
						//64rbg^
						bXmm=1;

						if(XmmReg==REG_XMM4){
							//mov r14,i64data
							op_mov64_ToReg(REG_R14,i64data);


							//mov qword ptr[rsp+offset],r14     X^bNt[𗘗p
							pobj_sf->push(REG_R14);
						}
						else{
							i3 = dataTable.Add( i64data );

							//movlpd xmm_reg,qword ptr[data table offset]
							OpBuffer[obp++]=(char)0x66;
							OpBuffer[obp++]=(char)0x0F;
							OpBuffer[obp++]=(char)0x12;
							OpBuffer[obp++]=(char)(0x04 | REGISTER_OPERAND(XmmReg)<<3);
							OpBuffer[obp++]=(char)0x25;
							*((long *)(OpBuffer+obp))=i3;
							pobj_DataTableSchedule->add();
							obp+=sizeof(long);
						}
					}
					else if(type_stack[sp]==DEF_SINGLE){
						//32rbg^
						bXmm=1;

						float flt;
						int i32data;
						memcpy(&dbl,&i64data,sizeof(double));
						flt=(float)dbl;
						memcpy(&i32data,&flt,sizeof(long));

						if(XmmReg==REG_XMM4){
							SetError();		// TODO: 
							//push term
							op_push_value(i32data);
						}
						else{
							i3=dataTable.Add( i32data );

							//movss xmm_reg,dword ptr[data table offset]
							OpBuffer[obp++]=(char)0xF3;
							OpBuffer[obp++]=(char)0x0F;
							OpBuffer[obp++]=(char)0x10;
							OpBuffer[obp++]=(char)(0x04 | REGISTER_OPERAND(XmmReg)<<3);
							OpBuffer[obp++]=(char)0x25;
							*((long *)(OpBuffer+obp))=i3;
							pobj_DataTableSchedule->add();
							obp+=sizeof(long);
						}
					}
					else{
						//

						index_stack[sp]=GetLiteralIndex(i64data);

						//mov reg,i64data
						op_mov64_ToReg(UseReg,i64data);

						if(UseReg==REG_R14){
							//mov qword ptr[rsp+offset],r14     X^bNt[𗘗p
							pobj_sf->push(REG_R14);
						}
					}
				}

				if(bXmm) pobj_reg->LockXmmReg();
				else pobj_reg->LockReg();

				sp++;
				break;

			//_Zq
			case CALC_XOR:
			case CALC_OR:
			case CALC_AND:
				if(!CalcTwoTerm_Logical(idCalc,type_stack,index_stack,&sp)) goto error;
				break;
			case CALC_NOT:
				//value[sp-1]=Not value[sp-1]
				//NOTZq
				if(!Calc_Not(type_stack,sp)) goto error;
				break;

			//rZq
			case CALC_PE:		//value[sp-2] <= value[sp-1]
			case CALC_QE:		//value[sp-2] >= value[sp-1]
			case CALC_P:		//value[sp-2] <  value[sp-1]
			case CALC_Q:		//value[sp-2] >  value[sp-1]
			case CALC_NOTEQUAL:	//value[sp-2] <> value[sp-1]
			case CALC_EQUAL:	//value[sp-2] =  value[sp-1]				
				if(!CalcTwoTerm_Relational(idCalc,type_stack,index_stack,&sp)) goto error;
				break;

			//rbgVtg
			case CALC_SHL:	//value[sp-2] << value[sp-1]
			case CALC_SHR:	//value[sp-2] >> value[sp-1]
				if(!Calc_Shift(idCalc,type_stack,&sp)) goto error;
				break;

			//ZpZ
			case CALC_ADDITION:
			case CALC_SUBTRACTION:
			case CALC_PRODUCT:
				if(!CalcTwoTerm_Arithmetic(idCalc,type_stack,index_stack,&sp)) goto error;
				break;
			case CALC_MOD:
				//value[sp-2]%=value[sp-1]
				//]Z
				if(!Calc_Mod(type_stack,index_stack,&sp)) goto error;
				break;
			case CALC_QUOTIENT:
				//value[sp-2]/=value[sp-1];
				//Z
				if(!Calc_Divide(type_stack,&sp,baseType.GetBasicType())) goto error;
				break;
			case CALC_INTQUOTIENT:
				//value[sp-2]/=value[sp-1]
				//Z
				if(!Calc_IntDivide(type_stack,index_stack,&sp)) goto error;
				break;
			case CALC_MINUSMARK:
				//value[sp-1]=-value[sp-1]
				//]
				if(!Calc_MinusMark(type_stack,sp)) goto error;
				break;
			case CALC_POWER:
				//ׂ扉Zi_Ẑ݁j
				if(!Calc_Power(type_stack,&sp)) goto error;
				break;
			case CALC_AS:
				//LXg
				if(!Calc_Cast(type_stack,index_stack,&sp)) goto error;
				break;
			case CALC_BYVAL:
				//|C^^Qƌ^
				if( PTR_LEVEL( type_stack[sp-1] ) <= 0 ){
					//|C^^ł͂ȂƂ
					SetError( 3, NULL, cp );
					goto error;
				}

				type_stack[sp-1] = PTR_LEVEL_DOWN( type_stack[sp-1] );

				break;

			default:
				SetError(300,NULL,cp);
				goto error;
		}
	}

	if(bError) goto error;

	if(sp!=1){
		SetError(1,NULL,cp);
		goto error;
	}

	if(bLiteralCalculation){
		//EӒll̒萔̏ꍇ
		Type resultType;
		StaticCalculation(true, expression,baseType.GetBasicType(),&i64data,resultType);

		obp=BeforeObp;
		pobj_SubAddrSchedule->num=Before_ProcAddrScheduleNum;
		pobj_DataTableSchedule->num=Before_DataTableScheduleNum;
		pobj_Reloc->copy(pobj_BackReloc);
		pobj_sf->num=Before_StackFrameScheduleNum;
		*pobj_reg=objReg_Backup;

		if(resultType.IsReal()){
			if(baseType.IsReal()) resultType=baseType;

			XmmReg=pobj_reg->LockXmmReg();

			if(resultType.IsDouble()){
				i3 = dataTable.Add( i64data );

				//movlpd xmm_reg,qword ptr[data table offset]
				OpBuffer[obp++]=(char)0x66;
				OpBuffer[obp++]=(char)0x0F;
				OpBuffer[obp++]=(char)0x12;
				OpBuffer[obp++]=(char)(0x04 | REGISTER_OPERAND(XmmReg)<<3);
				OpBuffer[obp++]=(char)0x25;
				*((long *)(OpBuffer+obp))=i3;
				pobj_DataTableSchedule->add();
				obp+=sizeof(long);
			}
			if(resultType.IsSingle()){
				memcpy(&dbl,&i64data,sizeof(_int64));

				float flt;
				int i32data;
				flt=(float)dbl;
				memcpy(&i32data,&flt,sizeof(long));

				i3 = dataTable.Add( i32data );

				//movss xmm_reg,dword ptr[data table offset]
				OpBuffer[obp++]=(char)0xF3;
				OpBuffer[obp++]=(char)0x0F;
				OpBuffer[obp++]=(char)0x10;
				OpBuffer[obp++]=(char)(0x04 | REGISTER_OPERAND(XmmReg)<<3);
				OpBuffer[obp++]=(char)0x25;
				*((long *)(OpBuffer+obp))=i3;
				pobj_DataTableSchedule->add();
				obp+=sizeof(long);
			}
		}
		else{
			if(!resultType.Is64()){
				//iL/j

				i3=(long)i64data;

				if(resultType.GetBasicSize()==sizeof(char)) i3=i3&0x000000FF;
				if(resultType.GetBasicSize()==sizeof(short)) i3=i3&0x0000FFFF;

				i64data=(_int64)i3;
			}

			UseReg=pobj_reg->LockReg();

			//mov reg,i64data
			op_mov64_ToReg(UseReg,i64data);
		}

		type_stack[0]=resultType.GetBasicType();
		index_stack[0]=resultType.GetIndex();
	}
	else{
		//EӒll̒萔ł͂ȂƂ
		if(IS_LITERAL(index_stack[0])) index_stack[0]=-1;
	}

	if(pbUseHeap) *pbUseHeap=bUseHeap[0];

	if(IsRealNumberType(type_stack[0]))
		*pReg=pobj_reg->UnlockXmmReg();
	else
		*pReg=pobj_reg->UnlockReg();


	if(bInitRegSwitch){
		//`FbNioOj
		pobj_reg->bug_check();

		//ƃWX^
		delete pobj_reg;
		pobj_reg=0;
	}

	resultType.SetType( type_stack[0], index_stack[0] );

	bool isSuccessful = true;
	goto finish;



	//////////////////
	// G[
	//////////////////

error:

	*pobj_reg=objReg_Backup;

	if(bInitRegSwitch){
		//ƃWX^
		delete pobj_reg;
		pobj_reg=0;
	}

	isSuccessful = false;
	goto finish;




finish:

	for(i=0;i<pnum;i++){
		if(values[i]) HeapDefaultFree(values[i]);
	}

	//ĔzuXPW[obNAbv
	delete pobj_BackReloc;

	return isSuccessful;
}
