#pragma once

#include <windows.h>

enum SCOPE_TYPE{
	//x[X
	SCOPE_TYPE_BASE,

	//
	SCOPE_TYPE_IF,

	//[v
	SCOPE_TYPE_DO,
	SCOPE_TYPE_FOR,
	SCOPE_TYPE_WHILE,

	//P[X
	SCOPE_TYPE_SELECT,
};

class CScope{
protected:
	int level;
	int StartAddress;
	SCOPE_TYPE TypeOfStatement;

	DWORD *pBreakSchedule;
	int nBreakSchedule;

public:
	CScope( int level, int addr, SCOPE_TYPE TypeOfStatement );
	~CScope();

	int GetStartAddress();
	SCOPE_TYPE GetTypeOfStatement();

	virtual void Break() = 0;
	virtual void RunScheduleOfBreak() = 0;
};

class CLexicalScopes{
protected:
	CScope **ppScopes;
	int level;

	CScope *SearchScope( SCOPE_TYPE TypeOfStatement );

	virtual CScope *CreateScope( int level, int addr, SCOPE_TYPE TypeOfStatement ) = 0;
public:
	CLexicalScopes();
	~CLexicalScopes();

	//i֐RpC̊JnɌĂяoj
	void Init(int addr);

	// XR[vJn
	void Start( int addr, SCOPE_TYPE TypeOfStatement );

	//XR[vI
	void End();

	//XR[voXe[gg
	void Break();

	int GetNowLevel(void);
	void SetNowLevel( int level );
	int GetStartAddress(void);

	//XR[vĨfXgN^Ăяo
	virtual void CallDestructorsOfScopeEnd() = 0;

	//ReturnXe[ggp̃fXgN^Ăяo
	virtual void CallDestructorsOfReturn( int BaseLevel = 0 ) = 0;
};

