#pragma once

#include "Type.h"
#include "Symbol.h"

class Variable : public Type
{
	const NamespaceScopes namespaceScopes;
	string name;
	bool isConst;
	bool isRef;
	bool isArray;
	int subScripts[MAX_ARRAYDIM];

	bool isParameter;

public:
	Variable( const string &name, const Type &type, bool isConst = false, bool isRef = false )
		: Type( type )
		, name( name )
		, isConst( isConst )
		, isRef( isRef )
		, isArray( false )
		, isParameter( false)
	{
		subScripts[0] = -1;
	}
	Variable( const NamespaceScopes &namespaceScopes, const string &name, const Type &type, bool isConst = false, bool isRef = false )
		: namespaceScopes( namespaceScopes )
		, Type( type )
		, name( name )
		, isConst( isConst )
		, isRef( isRef )
		, isArray( false )
		, isParameter( false)
	{
		subScripts[0] = -1;
	}
	Variable( const Variable &var )
		: Type( var )
		, name( var.name )
		, isConst( var.isConst )
		, isRef( var.isRef )
		, isArray( false )
		, isParameter( false )
	{
		subScripts[0] = -1;
		if( var.isArray ){
			SetArray( var.subScripts );
		}
	}
	~Variable(){}

	void SetArray( const int *pSubScripts ){
		isArray = true;
		memcpy( this->subScripts, pSubScripts, sizeof(int) * MAX_ARRAYDIM );
	}

	const string &GetName() const
	{
		return name;
	}

	bool IsEqualSymbol( const Symbol &symbol, bool isSupportStaticMember = true ) const;

	void ConstOff(){
		isConst = false;
	}
	void ConstOn(){
		isConst = true;
	}
	bool IsConst() const
	{
		return isConst;
	}
	bool IsRef() const
	{
		return isRef;
	}
	bool IsArray()const
	{
		return isArray;
	}
	const int *GetSubScriptsPtr() const
	{
		return subScripts;
	}

	void ThisIsParameter(){
		isParameter = true;
	}
	bool IsParameter() const
	{
		return isParameter;
	}


	int GetMemorySize() const
	{
		if( isRef || isParameter ){
			return PTR_SIZE;
		}

		int size = Type::GetSize();

		if( isArray ){
			int num = 1;
			for( int i=0; i<MAX_ARRAYDIM; i++){
				if(subScripts[i]==-1) break;
				num *= subScripts[i]+1;
			}
			size *= num;
		}

		if( size % PTR_SIZE ){
			size += PTR_SIZE-(size%PTR_SIZE);
		}

		return size;
	}


	/* --- ItZbg ---

		O[oϐŏobt@Ȃꍇ͍ŏʃrbg1ZbgA
		obt@̗LʂB
		ǐAXPW[sɂAۂ̔zuɕёւj*/
	int offset;

	//RXgN^pp[^
	string paramStrForConstructor;

	//LVJXR[vp
	int ScopeStartAddress;
	int ScopeEndAddress;
	int ScopeLevel;
	BOOL bLiving;


	int source_code_address;


	static int GetSubScriptCounts(const int *ss){
		// z̗vf擾
		int i,i2;
		for(i=0,i2=1;i<255;i++){
			if(ss[i]==-1) break;
			i2*=ss[i]+1;
		}
		return i2;
	}
};

class Variables : public vector<Variable *>
{
public:
	Variables(){}
	~Variables(){
		clear();
	}

	void clear(){
		for( int i=0; i<(int)this->size(); i++ ){
			delete (*this)[i];
		}

		vector<Variable *>::clear();
	}

	bool DuplicateCheck( const Symbol &symbol ) const;

	const Variable *BackSearch( const Symbol &symbol ) const;

	const Variable *Find( const Symbol &symbol )const;
};

extern Variables globalVars;
