#pragma once

#include "Prototype.h"
#include "Member.h"
#include "Method.h"
#include "LexicalAnalysis.h"

class InheritedInterface
{
	CClass *pInterfaceClass;
	int vtblOffset;
public:
	InheritedInterface( CClass *pInterfaceClass, int vtblOffset )
		: pInterfaceClass( pInterfaceClass )
		, vtblOffset( vtblOffset )
	{
	}

	CClass &GetInterfaceClass() const{
		return *pInterfaceClass;
	}
	int GetVtblOffset() const
	{
		return vtblOffset;
	}
};
typedef vector<InheritedInterface> Interfaces;

class CClass : public Prototype
{
public:
	// o̎Qƕ@
	enum RefType{
		Non = 0,		// no reference member
		Dot,			// obj.member
		Pointer,		// obj->member
	};

	// ^̎
	enum ClassType{
		Class,
		Interface,
		Enum,
		Delegate,
		Structure,
	};

private:
	ClassType classType;

	bool isReady;
	void Readed(){
		isReady = true;
	}
	bool IsReady() const{
		return isReady;
	}

	// importĂ閼O
	NamespaceScopesCollection importedNamespaces;

	// pC^[tFCX
	Interfaces interfaces;

	// Blittable^
	Type blittableType;

	// Io
	Members dynamicMembers;

	// ÓIo
	Members staticMembers;

	// I\bh
	Methods methods;
	int ConstructorMemberSubIndex;
	int DestructorMemberSubIndex;
	int vtblNum;					// z֐̐

	// ÓI\bh
	Methods staticMethods;

public:
	//pNXւ̃|C^
	const CClass *pobj_InheritsClass;

	//ACgl
	int iAlign;

	CClass( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const string &name );
	~CClass();

	const NamespaceScopesCollection &GetImportedNamespaces() const
	{
		return importedNamespaces;
	}

	// C^[tFCX
	bool HasInterfaces() const
	{
		return ( interfaces.size() != 0 );
	}
	bool IsInheritsInterface( const CClass *pInterfaceClass ) const;

	// Blittable^
	bool IsBlittableType() const
	{
		return !blittableType.IsNull();
	}
	const Type &GetBlittableType() const
	{
		return blittableType;
	}
	void SetBlittableType( const Type &type ){
		blittableType = type;
	}

	bool IsClass() const;
	bool IsInterface() const;
	bool IsEnum() const;
	bool IsDelegate() const;
	bool IsStructure() const;
	void SetClassType( ClassType classType )
	{
		this->classType = classType;
	}

	//p
	bool Inherits( const char *inheritNames, int nowLine );
	bool InheritsClass( const CClass &inheritsClass, int nowLine );
	bool InheritsInterface( const CClass &inheritsClass, int nowLine );

	//oA\bh̒ǉ
	void AddMember( Prototype::Accessibility accessibility, bool idConst, bool isRef, char *buffer );
	void AddStaticMember( Prototype::Accessibility accessibility, bool isConst, bool isRef, char *buffer, int nowLine );

	//d`FbN
	BOOL DupliCheckAll(const char *name);
	BOOL DupliCheckMember(const char *name);

	const Members &GetDynamicMembers() const
	{
		return dynamicMembers;
	}
	const Members &GetStaticMembers() const
	{
		return staticMembers;
	}
	Members &GetDynamicMembers()
	{
		return dynamicMembers;
	}
	Members &GetStaticMembers()
	{
		return staticMembers;
	}

	const Methods &GetMethods() const
	{
		return methods;
	}
	const Methods &GetStaticMethods() const
	{
		return staticMethods;
	}
	Methods &GetMethods()
	{
		return methods;
	}
	Methods &GetStaticMethods()
	{
		return staticMethods;
	}

	//ftHg RXgN^ \bh擾
	const CMethod *GetConstructorMethod() const;

	//fXgN^ \bh擾
	const CMethod *GetDestructorMethod() const;

	// vtblɑ݂鉼z֐̐
	int GetVtblNum() const
	{
		return vtblNum;
	}
	void SetVtblNum( int vtblNum )
	{
		this->vtblNum = vtblNum;
	}
	void AddVtblNum( int vtblNum )
	{
		this->vtblNum += vtblNum;
	}
	bool IsExistVirtualFunctions() const
	{
		return ( vtblNum > 0 );
	}

	// ȏTCY擾
	int GetSize() const;

	// õItZbg擾
	int GetMemberOffset( const char *memberName, int *pMemberNum = NULL ) const;

private:
	// ACgl擾
	int GetAlignment() const;


	//vtbl
private:
	mutable long vtbl_offset;
public:
	int GetFuncNumInVtbl( const UserProc *pUserProc ) const;
	LONG_PTR GetVtblGlobalOffset(void) const;
	void ActionVtblSchedule(LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection);
	bool IsAbstract() const;


	//RXgN^RpCĂ邩ǂ̃`FbNtO
private:
	mutable bool isCompilingConstructor;
public:
	void NotifyStartConstructorCompile() const;
	void NotifyFinishConstructorCompile() const;
	bool IsCompilingConstructor() const;

	//fXgN^RpCĂ邩ǂ̃`FbNtO
private:
	mutable bool isCompilingDestructor;
public:
	void NotifyStartDestructorCompile() const;
	void NotifyFinishDestructorCompile() const;
	bool IsCompilingDestructor() const;


	//g̔hNXǂmF
	bool IsSubClass( const CClass *pClass ) const;

	//gƓ܂͔hNXǂmF
	bool IsEqualsOrSubClass( const CClass *pClass ) const;

	// gƓ܂͔hNXANXǂmF
	bool IsEqualsOrSubClassOrSuperClass( const CClass &objClass ) const;


	//`Xgp
	CClass *pobj_NextClass;


	static bool SplitName( const char *desc, char *object, char *member, CClass::RefType &refType ){
		int lastIndex = -1;
		for( int i=0; desc[i]; i++ ){
			if( desc[i] == '(' ){
				i=JumpStringInPare(desc,i+1);
				continue;
			}
			else if( desc[i] == '[' ){
				i=JumpStringInBracket(desc,i+1);
				continue;
			}
			else if(desc[i]=='.'||(desc[i]==1&&desc[i+1]==ESC_PSMEM)){
				lastIndex = i;
			}
		}
		if( lastIndex == -1 ){
			lstrcpy( member, desc );
			return false;
		}

		if(desc[lastIndex]=='.'){
			lstrcpy(member,desc+lastIndex+1);
			refType = CClass::Dot;
		}
		else{
			lstrcpy(member,desc+lastIndex+2);
			refType = CClass::Pointer;
		}

		if( object ){
			lstrcpy( object, desc );
			object[lastIndex]=0;
		}

		return true;
	}
	static bool SplitName( const char *desc, char *object, char *member ){
		CClass::RefType dummyRefType;
		return SplitName( desc, object, member, dummyRefType );
	}
};

#define MAX_CLASS_HASH 65535
class Classes
{
	int hash(const char *name) const;
	void DestroyClass(CClass *pobj_c);
public:
	CClass *pobj_ClassHash[MAX_CLASS_HASH];

	Classes();
	~Classes();
	void Clear();

	const CClass *Find( const string &fullName ) const;
	const CClass *Find( const NamespaceScopes &namespaceScopes, const string &name ) const;

	CClass *AddClass( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const char *name,int nowLine);

	void ActionVtblSchedule(LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection);

private:
	void AddMethod(CClass *pobj_c, Prototype::Accessibility accessibility, BOOL bStatic, bool isConst, bool isAbstract,
		bool isVirtual, bool isOverride, char *buffer, int nowLine);
	BOOL MemberVar_LoopRefCheck(const CClass &objClass);
public:
	void GetAllClassInfo(void);
	void Compile_System_InitializeUserTypes();


	/////////////////////////////
	// NX
	/////////////////////////////
	CClass *pStringClass;
	CClass *pObjectClass;
	CClass *GetStringClassPtr() const;
	CClass *GetObjectClassPtr() const;


	/////////////////////////////
	// ݃RpC̏
	/////////////////////////////
private:
	const CClass *pCompilingClass;
	const CMethod *pCompilingMethod;
public:
	//RpCJn̒ʒm󂯎郁\bh
	void StartCompile( UserProc *pUserProc );

	//݃RpC̃\bh擾
	const CClass *GetNowCompilingClass() const;
	const CMethod *GetNowCompilingMethodInfo();


	/////////////////////
	// Ce[^
	/////////////////////
private:
	CClass **ppobj_IteClass;
	int iIteMaxNum;
	int iIteNextNum;
public:
	void Iterator_Init(void);
	void Iterator_Reset(void);
	BOOL Iterator_HasNext(void);
	CClass *Iterator_GetNext(void);
	int Iterator_GetMaxCount(void);
};
