#include <jenga/include/smoothie/Class.h>

bool Variable::IsEqualSymbol( const Symbol &symbol, bool isSupportStaticMember ) const
{
	if( GetName() == symbol.GetName()
		&& NamespaceScopes::IsSameArea( this->namespaceScopes, symbol.GetNamespaceScopes() ) )
	{
		return true;
	}

	if( isSupportStaticMember && symbol.GetNamespaceScopes().size() >= 1 )
	{
		// ÓIol
		NamespaceScopes namespaceScopes( symbol.GetNamespaceScopes() );
		string name = namespaceScopes[namespaceScopes.size()-1] + "." + symbol.GetName();
		namespaceScopes.pop_back();

		return IsEqualSymbol( Symbol( namespaceScopes, name ), false );
	}
	return false;
}


bool Variables::DuplicateCheck( const Symbol &symbol ) const
{
	//LVJXR[vlďd
	for( int i=(int)this->size()-1; i>=0 ; i-- ){
		Variable &var = *(*this)[i];
		if( var.bLiving											//݂̃XR[vŗLȂ
			&& var.ScopeLevel == obj_LexScopes.GetNowLevel()	//݂̃XR[vƓꃌx
			){
				if( var.IsEqualSymbol( symbol ) ){
					return true;
				}
		}
	}
	return false;
}

const Variables::Variable *BackSearch( const Symbol &symbol ) const
{
	//LVJXR[vlăobNT[`
	for( int i=(int)this->size()-1; i>=0 ; i-- ){
		Variable &var = *(*this)[i];
		if( var.bLiving											//݂̃XR[vŗLȂ
			&& var.ScopeLevel <= obj_LexScopes.GetNowLevel()	//݂̃XR[vx𒴂Ȃ́iReturnɂlj
			){
				if( var.IsEqualSymbol( symbol ) ){
					return &var;
				}
		}
	}
	return NULL;
}

const Variables::Variable *Find( const Symbol &symbol )const
{
	int max = (int)this->size();
	for( int i=0; i<max; i++ ){
		Variable *pVar = (*this)[i];
		if( pVar->IsEqualSymbol( symbol ) ){
			return pVar;
		}
	}
	return NULL;
}
