#pragma once

#include <vector>
#include <string>

#include <windows.h>
#include <stdlib.h>

#include "BasicFixed.h"

using namespace std;

struct INCLUDEFILEINFO{
	char **ppFileNames;
	int FilesNum;
	int LineOfFile[MAX_LEN];
};

class Text{
protected:
	char *buffer;
	int length;

public:

	Text(){
		buffer = (char *)calloc( 1, 1 );
		length = 0;
	}
	~Text(){
		free( buffer );
	}

	bool ReadFile( const string &filePath );

	static void Text::SlideString(char *buffer, int slide){
		char *temp;
		temp=(char *)malloc(lstrlen(buffer)+1);
		lstrcpy(temp,buffer);
		lstrcpy(buffer+slide,temp);
		free(temp);
	}
};

class BasicSource : public Text
{
	static const string generateDirectiveName;

	void Realloc( int newLength ){
		buffer = (char *)realloc( buffer, newLength + 255 );

		length = newLength;

		extern char *basbuf;
		basbuf = buffer + 2;
	}

	void IncludeFiles();

	void ChangeReturnLineChar();

	void RemoveComments();

	bool ReadFile_InIncludeDirective( const string &filePath );
	void DirectiveIncludeOrRequire();

	void RemoveReturnLineUnderbar();

public:
	BasicSource(){}
	~BasicSource(){}

	char *GetBuffer(){
		return buffer+2;
	}
	const char *GetBuffer() const
	{
		return buffer+2;
	}
	int GetLength() const
	{
		return length-2;
	}

	void SetBuffer( const char *buffer );

	bool ReadFile( const string &filePath );

	bool Generate( const string &genName, const char *buffer );

	void Addition( const char *buffer );

	void operator = ( const BasicSource &source ){
		Realloc( source.length );
		lstrcpy( buffer, source.buffer );
	}

	char operator[]( int index ) const
	{
		if( index>GetLength() )
		{
			throw "bad access";
		}
		return buffer[2+index];
	}
};
