#include <jenga/include/smoothie/LexicalAnalysis.h>

#include <windows.h>

bool IsVariableTopChar(char c){
	if((c>='A'&&c<='Z')||(c>='a'&&c<='z')||c=='_')
	{
		return true;
	}
	return false;
}
bool IsVariableChar(char c){
	if((c>='A'&&c<='Z')||(c>='a'&&c<='z')||(c>='0'&&c<='9')||
		c=='%'||c=='!'||c=='#'||c=='$'||
		c=='_'||c=='.')
	{
		return true;
	}
	return false;
}
bool IsBlank(char c){
	if(c==' '||c=='\t') return 1;
	return 0;
}
int GetOneParameter(const char *Parameter,int pos,char *retAns){
	int i,i2,i3,IsStr;
	for(i=pos,i2=0,IsStr=0;;i++,i2++){
		if(Parameter[i]=='\"') IsStr^=1;
		else if(Parameter[i]=='('&&IsStr==0){
			i3=GetStringInPare(retAns+i2,Parameter+i);
			i+=i3-1;
			i2+=i3-1;
			continue;
		}
		else if(Parameter[i]=='['&&IsStr==0){
			i3=GetStringInBracket(retAns+i2,Parameter+i);
			i+=i3-1;
			i2+=i3-1;
			continue;
		}
		else if(Parameter[i]==','&&IsStr==0){
			retAns[i2]=0;
			i++;
			break;
		}

		if(IsCommandDelimitation(Parameter[i])&&IsStr==0
			|| Parameter[i] == ')' && IsStr == 0 ){
				retAns[i2]=0;
				break;
		}

		retAns[i2]=Parameter[i];
	}
	return i;
}
int JumpOneParameter(char *Parameter,int i){
	int i2,IsStr;
	for(i2=0,IsStr=0;;i++,i2++){
		if(Parameter[i]=='\"') IsStr^=1;
		else if(Parameter[i]=='('&&IsStr==0){
			i=JumpStringInPare(Parameter,i+1);
			continue;
		}
		else if(Parameter[i]=='['&&IsStr==0){
			i=JumpStringInBracket(Parameter,i+1);
			continue;
		}
		else if(Parameter[i]==','&&IsStr==0){
			i++;
			break;
		}
		if(IsCommandDelimitation(Parameter[i])) break;
	}
	return i;
}
int GetStringInQuotation(char *buffer,char *ReadBuffer){
	int i;

	if(ReadBuffer[0]=='\"'){
		buffer[0]=ReadBuffer[0];
		i=1;
	}
	else i=0;

	for(;;i++){
		buffer[i]=ReadBuffer[i];
		if(IsDBCSLeadByte(ReadBuffer[i])){
			i++;
			buffer[i]=ReadBuffer[i];
			continue;
		}
		if(ReadBuffer[i]=='\"'){
			i++;
			buffer[i]=0;
			break;
		}
		if(ReadBuffer[i]=='\0') return 0;
	}
	return i;
}
int GetStringInPare(char *buffer,const char *ReadBuffer){
	int i,IsStr,PareNum;
	for(i=0,IsStr=0,PareNum=0;;i++){
		buffer[i]=ReadBuffer[i];
		if(IsDBCSLeadByte(ReadBuffer[i])){
			i++;
			buffer[i]=ReadBuffer[i];
			continue;
		}
		if(ReadBuffer[i]=='\"') IsStr^=1;
		else if(ReadBuffer[i]=='('&&IsStr==0) PareNum++;
		else if(ReadBuffer[i]==')'&&IsStr==0){
			PareNum--;
			if(PareNum==0){
				i++;
				buffer[i]=0;
				break;
			}
		}
		else if(ReadBuffer[i]=='\0') return 0;
	}
	return i;
}
int GetStringInBracket(char *buffer,const char *ReadBuffer){
	int i,IsStr,PareNum;
	for(i=0,IsStr=0,PareNum=0;;i++){
		buffer[i]=ReadBuffer[i];
		if(IsDBCSLeadByte(ReadBuffer[i])){
			i++;
			buffer[i]=ReadBuffer[i];
			continue;
		}
		if(ReadBuffer[i]=='\"') IsStr^=1;
		else if(ReadBuffer[i]=='['&&IsStr==0) PareNum++;
		else if(ReadBuffer[i]==']'&&IsStr==0){
			PareNum--;
			if(PareNum==0){
				i++;
				buffer[i]=0;
				break;
			}
		}
		else if(ReadBuffer[i]=='\0') return 0;
	}
	return i;
}
int JumpStringInPare(const char *buffer,int pos){
	int PareNum;
	for(PareNum=1;;pos++){
		if(buffer[pos]=='\"'){
			for(pos++;;pos++){
				if(buffer[pos]=='\"') break;
			}
			continue;
		}
		else if(buffer[pos]=='(') PareNum++;
		else if(buffer[pos]==')'){
			PareNum--;
			if(PareNum==0) return pos;
		}
		else if(buffer[pos]=='\0') break;
	}
	return 0;
}
int JumpStringInBracket(const char *buffer,int pos){
	int PareNum;
	for(PareNum=1;;pos++){
		if(buffer[pos]=='\"'){
			for(pos++;;pos++){
				if(buffer[pos]=='\"') break;
			}
			continue;
		}
		else if(buffer[pos]=='[') PareNum++;
		else if(buffer[pos]==']'){
			PareNum--;
			if(PareNum==0) return pos;
		}
		else if(buffer[pos]=='\0') break;
	}
	return 0;
}
bool IsCommandDelimitation( char c ){
	if( c == '\n' || c == ':' || c == '\0' ){
		return true;
	}

	return false;
}

int GetStringInPare_RemovePare(char *buffer,const char *ReadBuffer){
	int i,IsStr,PareNum;
	for(i=0,IsStr=0,PareNum=1;;i++){
		buffer[i]=ReadBuffer[i];
		if(IsDBCSLeadByte(ReadBuffer[i])){
			i++;
			buffer[i]=ReadBuffer[i];
			continue;
		}
		if(ReadBuffer[i]=='\"') IsStr^=1;
		else if(ReadBuffer[i]=='('&&IsStr==0) PareNum++;
		else if(ReadBuffer[i]==')'&&IsStr==0){
			PareNum--;
			if(PareNum==0){
				buffer[i]=0;
				break;
			}
		}
		else if(ReadBuffer[i]=='\0') return 0;
	}
	return i;
}
