#pragma once

#include <vector>
#include <string>

#include "Type.h"
#include "Namespace.h"

using namespace std;

class TypeDefCollection;

class TypeDef{
	friend TypeDefCollection;

	NamespaceScopes namespaceScopes;

	string name;
	string baseName;
	Type baseType;
public:
	TypeDef( const NamespaceScopes &namespaceScopes, const string &name, const string &baseName, int nowLine );
	~TypeDef();

	const string &GetName() const
	{
		return name;
	}
	const string &GetBaseName() const
	{
		return baseName;
	}
	const Type &GetBaseType() const
	{
		return baseType;
	}

	bool IsEqualSymbol( const NamespaceScopes &namespaceScopes, const string &name ) const;
	bool IsEqualSymbol( const string &name ) const;
};

class TypeDefCollection : public vector<TypeDef>
{
public:
	TypeDefCollection();
	~TypeDefCollection();

	void Add( const NamespaceScopes &namespaceScopes, const string &name, const string &baseName, int nowLine );
	int GetIndex( const NamespaceScopes &namespaceScopes, const string &name ) const;
	int GetIndex( const string &fullName ) const;

private:
	void Add( const NamespaceScopes &namespaceScopes, const string &expression, int nowLine );
public:
	void Init();
};
