#include <stdlib.h>

#include <jenga/include/smoothie/Smoothie.h>
#include <jenga/include/smoothie/Class.h>
#include <jenga/include/smoothie/SmoothieException.h>


class CLoopRefCheck{
	char **names;
	int num;
	void init(){
		int i;
		for(i=0;i<num;i++){
			free(names[i]);
		}
		free(names);
	}
public:
	CLoopRefCheck()
	{
		names=(char **)malloc(1);
		num=0;
	}
	~CLoopRefCheck()
	{
		init();
	}
	void add(const char *lpszInheritsClass)
	{
		names=(char **)realloc(names,(num+1)*sizeof(char *));
		names[num]=(char *)malloc(lstrlen(lpszInheritsClass)+1);
		lstrcpy(names[num],lpszInheritsClass);
		num++;
	}
	void del(const char *lpszInheritsClass)
	{
		int i;
		for(i=0;i<num;i++){
			if(lstrcmp(names[i],lpszInheritsClass)==0){
				free(names[i]);
				break;
			}
		}
		if(i!=num){
			num--;
			for(;i<num;i++){
				names[i]=names[i+1];
			}
		}
	}
	BOOL check(const CClass &inheritsClass) const
	{
		//[vp`FbN
		int i;
		for(i=0;i<num;i++){
			if( inheritsClass.GetName() == names[i] ){
				return 1;
			}
		}
		return 0;
	}
};
CLoopRefCheck *pobj_LoopRefCheck;




CClass::CClass( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const string &name )
	: isReady( false )
	, Prototype( namespaceScopes, name )
	, importedNamespaces( importedNamespaces )
	, ConstructorMemberSubIndex( 0 )
	, DestructorMemberSubIndex( 0 )
	, classType( Class )
	, pobj_InheritsClass( NULL )
	, vtblNum( 0 )
	, iAlign( 0 )
	, vtbl_offset( -1 )
	, isCompilingConstructor( false )
	, isCompilingDestructor( false )
	, pobj_NextClass( NULL )
{
}
CClass::~CClass(){
	// Io
	BOOST_FOREACH( CMember *member, dynamicMembers ){
		delete member;
	}

	// ÓIo
	BOOST_FOREACH( CMember *member, staticMembers ){
		delete member;
	}
}

bool CClass::IsInheritsInterface( const CClass *pInterfaceClass ) const
{
	BOOST_FOREACH( const InheritedInterface &objInterface, interfaces ){
		if( pInterfaceClass == &objInterface.GetInterfaceClass() ){
			return true;
		}
	}
	return false;
}

bool CClass::IsClass() const
{
	return classType == CClass::Class;
}
bool CClass::IsInterface() const
{
	return classType == CClass::Interface;
}
bool CClass::IsEnum() const
{
	return classType == CClass::Enum;
}
bool CClass::IsDelegate() const
{
	return classType == CClass::Delegate;
}
bool CClass::IsStructure() const
{
	return classType == CClass::Structure;
}

bool CClass::Inherits( const char *inheritNames, int nowLine ){
	int i = 0;
	bool isInheritsClass = false;
	while( true ){

		char temporary[VN_SIZE];
		for( int i2=0;; i++, i2++ ){
			if( inheritNames[i] == '\0' || inheritNames[i] == ',' ){
				temporary[i2] = 0;
				break;
			}
			temporary[i2] = inheritNames[i];
		}

		//pNX擾
		const CClass *pInheritsClass = Smoothie::meta.classes.Find(temporary);
		if( !pInheritsClass ){
			throw SmoothieException(106,temporary,nowLine);
			return false;
		}

		if( pInheritsClass->IsInterface() ){
			// C^[tFCX͂ƂŌp
		}
		else if( pInheritsClass->IsClass() ){
			// NXp
			isInheritsClass = true;

			if( !InheritsClass( *pInheritsClass, nowLine ) ){
				return false;
			}
		}
		else{
			throw SmoothieException(135,NULL,nowLine);
			return false;
		}

		if( inheritNames[i] == '\0' ){
			break;
		}
		i++;
	}

	if( !isInheritsClass ){
		// NXpĂȂƂ
		const CClass *pObjectClass = Smoothie::meta.classes.Find("Object");
		if( !pObjectClass ){
			throw SmoothieException(106,"Object",i);
			return false;
		}

		if( !InheritsClass( *pObjectClass, nowLine ) ){
			return false;
		}
	}

	i=0;
	while( true ){

		char temporary[VN_SIZE];
		for( int i2=0;; i++, i2++ ){
			if( inheritNames[i] == '\0' || inheritNames[i] == ',' ){
				temporary[i2] = 0;
				break;
			}
			temporary[i2] = inheritNames[i];
		}

		//pNX擾
		const CClass *pInheritsClass = Smoothie::meta.classes.Find(temporary);
		if( !pInheritsClass ){
			throw SmoothieException(106,temporary,nowLine);
			return false;
		}

		if( pInheritsClass->IsInterface() ){
			// C^[tFCXp
			if( !InheritsInterface( *pInheritsClass, nowLine ) ){
				return false;
			}
		}
		else if( pInheritsClass->IsClass() ){
			// NX͂p
		}
		else{
			throw SmoothieException(135,NULL,nowLine);
			return false;
		}

		if( inheritNames[i] == '\0' ){
			break;
		}
		i++;
	}

	return true;
}
/*
bool CClass::InheritsClass( const CClass &inheritsClass, int nowLine ){

	//[vpłȂ`FbN
	if(pobj_LoopRefCheck->check(inheritsClass)){
		throw SmoothieException(123,inheritsClass.GetName(),nowLine);
		return false;
	}

	if( !inheritsClass.IsReady() ){
		//p悪ǂݎĂȂƂ
		pobj_LoopRefCheck->add(this->GetName().c_str());
		Smoothie::meta.classes.GetClass_recur(inheritsClass.GetName().c_str());
		pobj_LoopRefCheck->del(this->GetName().c_str());
	}

	//oRs[
	BOOST_FOREACH( CMember *inheritsClassDynamicMember, inheritsClass.dynamicMembers ){
		CMember *pMember = new CMember( *inheritsClassDynamicMember );

		// ANZVreB
		if( inheritsClassDynamicMember->IsPrivate() ){
			pMember->SetAccessibility( Prototype::None );
		}
		else{
			pMember->SetAccessibility( inheritsClassDynamicMember->GetAccessibility() );
		}

		dynamicMembers.push_back( pMember );
	}

	//\bhRs[
	BOOST_FOREACH( const CMethod *pBaseMethod, inheritsClass.methods ){
		CMethod *pMethod = new DynamicMethod( *pBaseMethod );

		// ANZVreB
		if(pBaseMethod->GetAccessibility() == Prototype::Private){
			pMethod->SetAccessibility( Prototype::None );
		}
		else{
			pMethod->SetAccessibility( pBaseMethod->GetAccessibility() );
		}

		//pobj_Inherits
		// pClassIndexZbgiqplj
		if(pBaseMethod->GetInheritsClassPtr()==0){
			pMethod->SetInheritsClassPtr( &inheritsClass );
		}
		else{
			pMethod->SetInheritsClassPtr( pBaseMethod->GetInheritsClassPtr() );
		}

		methods.push_back( pMethod );
	}

	//z֐̐
	AddVtblNum( inheritsClass.GetVtblNum() );

	//p̃NXoƂĕێ
	pobj_InheritsClass = &inheritsClass;

	return true;
}
bool CClass::InheritsInterface( const CClass &inheritsInterface, int nowLine ){

	//[vpłȂ`FbN
	if(pobj_LoopRefCheck->check(inheritsInterface)){
		throw SmoothieException(123,inheritsInterface.GetName(),nowLine);
		return false;
	}

	if( !inheritsInterface.IsReady() ){
		//p悪ǂݎĂȂƂ
		pobj_LoopRefCheck->add(this->GetName().c_str());
		Smoothie::meta.classes.GetClass_recur(inheritsInterface.GetName().c_str());
		pobj_LoopRefCheck->del(this->GetName().c_str());
	}

	//\bhRs[
	BOOST_FOREACH( const CMethod *pBaseMethod, inheritsInterface.methods ){
		CMethod *pMethod = new DynamicMethod( *pBaseMethod );

		// ANZVreB
		if(pBaseMethod->GetAccessibility() == Prototype::Private){
			pMethod->SetAccessibility( Prototype::None );
		}
		else{
			pMethod->SetAccessibility( pBaseMethod->GetAccessibility() );
		}

		//pobj_Inherits
		// pClassIndexZbgiqplj
		if(pBaseMethod->GetInheritsClassPtr()==0){
			pMethod->SetInheritsClassPtr( &inheritsInterface );
		}
		else{
			pMethod->SetInheritsClassPtr( pBaseMethod->GetInheritsClassPtr() );
		}

		methods.push_back( pMethod );
	}

	interfaces.push_back( InheritedInterface( const_cast<CClass *>(&inheritsInterface), vtblNum ) );

	//z֐̐
	AddVtblNum( inheritsInterface.GetVtblNum() );

	return true;
}
void CClass::AddMember( Prototype::Accessibility accessibility, bool isConst, bool isRef, char *buffer ){
	CMember *pMember = new CMember( this, accessibility, isConst, isRef, buffer );
	dynamicMembers.push_back( pMember );
}
void CClass::AddStaticMember( Prototype::Accessibility accessibility, bool isConst, bool isRef, char *buffer, int nowLine ){
	CMember *pMember = new CMember( this, accessibility, isConst, isRef, buffer, nowLine );
	staticMembers.push_back( pMember );
}*/
BOOL CClass::DupliCheckAll(const char *name){
	//d`FbN

	//o
	if(DupliCheckMember(name)) return 1;

	//\bh
	BOOST_FOREACH( const CMethod *pMethod, methods ){
		if( lstrcmp( name, pMethod->pUserProc->GetName().c_str() ) == 0 ){
			return 1;
		}
	}

	return 0;
}
BOOL CClass::DupliCheckMember(const char *name){
	//d`FbN

	// Io
	BOOST_FOREACH( CMember *pMember, dynamicMembers ){
		if( GetName() == pMember->GetName() ){
			return 1;
		}
	}

	// ÓIo
	BOOST_FOREACH( CMember *pMember, staticMembers ){
		if( GetName() == pMember->GetName() ){
			return 1;
		}
	}

	return 0;
}

//ftHg RXgN^ \bh擾
const CMethod *CClass::GetConstructorMethod() const
{
	if( ConstructorMemberSubIndex == -1 ) return NULL;
	return methods[ConstructorMemberSubIndex];
}

//fXgN^ \bh擾
const CMethod *CClass::GetDestructorMethod() const
{
	if( DestructorMemberSubIndex == -1 ) return NULL;
	return methods[DestructorMemberSubIndex];
}

//TCY擾
int CClass::GetSize() const
{
	return GetMemberOffset( NULL, NULL );
}

//õItZbg擾
int CClass::GetMemberOffset( const char *memberName, int *pMemberNum ) const
{
	int i2;

	//z֐݂ꍇ͊֐Xgւ̃|C^̃TCYǉ
	int offset = IsExistVirtualFunctions() ? PTR_SIZE : 0;

	int alignment;
	if(iAlign) alignment=iAlign;
	else alignment=1;

	int iMaxAlign=0;
	int i = -1;
	BOOST_FOREACH( CMember *pMember, dynamicMembers ){
		i++;

		i2 = pMember->GetType().GetSize();

		//ACgZo
		int member_size;
		if( pMember->GetType().IsStruct() ){
			//oNX̃ACg擾
			member_size=pMember->GetType().GetClass().GetAlignment();
		}
		else{
			//oTCY擾
			member_size=i2;
		}
		if(iMaxAlign<member_size) iMaxAlign=member_size;

		//ACgl
		if(iAlign&&iAlign<member_size){
			if(offset%alignment) offset+=alignment-(offset%alignment);
		}
		else{
			if(alignment<member_size) alignment=member_size;

			if(member_size==0){
				//oȂNX
				//ȂiItZbǧvZȂj
			}
			else{
				if(offset%member_size) offset+=member_size-(offset%member_size);
			}
		}

		if(memberName){
			//ow肪ꍇ́AItZbgԂ
			if( pMember->GetName() == memberName ){
				if(pMemberNum) *pMemberNum=i;
				return offset;
			}
		}

		//zloTCY擾
		member_size=i2 * Variable::GetSubScriptCounts(pMember->SubScripts);

		//oTCYZ
		offset+= member_size;
	}

	if(iMaxAlign<alignment) alignment=iMaxAlign;

	//ACgl
	if(alignment){
		if(offset%alignment) offset+=alignment-(offset%alignment);
	}

	if(pMemberNum) *pMemberNum=i;
	return offset;
}

int CClass::GetAlignment() const
{
	//z֐݂ꍇ͊֐Xgւ̃|C^̃TCYǉ
	int alignment = IsExistVirtualFunctions() ? PTR_SIZE : 0;

	BOOST_FOREACH( CMember *pMember, dynamicMembers ){
		int member_size;
		if(pMember->GetType().IsStruct()){
			//oNX̃ACg擾
			member_size=pMember->GetType().GetClass().GetAlignment();
		}
		else{
			//oTCY擾
			member_size = pMember->GetType().GetSize();
		}

		//ACgZbg
		if(alignment<member_size) alignment=member_size;
	}

	if(alignment==0) return 0;

	if(iAlign) alignment=iAlign;

	return alignment;
}



int CClass::GetFuncNumInVtbl( const UserProc *pUserProc ) const
{
	int n = 0;
	BOOST_FOREACH( const CMethod *pMethod, methods ){
		if( pMethod->pUserProc == pUserProc ) break;
		if( pMethod->IsVirtual() ) n++;
	}
	return n;
}
/*
LONG_PTR CClass::GetVtblGlobalOffset(void) const
{

	//ɑ݂ꍇ͂Ԃ
	if(vtbl_offset!=-1) return vtbl_offset;



	//////////////////////////////////////
	// ݂ȂƂ͐Vɐ
	//////////////////////////////////////

	UserProc **ppsi;
	ppsi=(UserProc **)malloc(GetVtblNum()*sizeof(GlobalProc *));

	//֐e[uɒlZbg
	int i2 = 0;
	BOOST_FOREACH( const CMethod *pMethod, methods ){
		if(pMethod->IsVirtual()){
			pMethod->pUserProc->Using();

			if(pMethod->IsAbstract()){
				extern int cp;
				throw SmoothieException(300,NULL,cp);

				ppsi[i2]=0;
			}
			else{
				ppsi[i2]=pMethod->pUserProc;
			}
			i2++;
		}
	}

	vtbl_offset=dataTable.AddBinary((void *)ppsi,GetVtblNum()*sizeof(LONG_PTR));

	for( int i=0; i < GetVtblNum(); i++ ){
		pobj_Reloc->AddSchedule_DataSection(vtbl_offset+i*sizeof(LONG_PTR));
	}

	free(ppsi);

	return vtbl_offset;
}
void CClass::ActionVtblSchedule(LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection){
	if(vtbl_offset==-1) return;

	LONG_PTR *pVtbl;
	pVtbl=(LONG_PTR *)((char *)dataTable.GetPtr()+vtbl_offset);

	int i;
	for(i=0;i<GetVtblNum();i++){
		GlobalProc *pUserProc;
		pUserProc=(GlobalProc *)pVtbl[i];
		if(!pUserProc) continue;
		pVtbl[i]=pUserProc->beginOpAddress+ImageBase+MemPos_CodeSection;
	}
}*/
bool CClass::IsAbstract() const
{
	// (abstract)̉z֐ꍇtrueԂ

	BOOST_FOREACH( const CMethod *pMethod, methods ){
		if(pMethod->IsVirtual()){
			if(pMethod->IsAbstract()){
				return true;
			}
		}
	}

	return false;
}

// RXgN^̃RpCJn
void CClass::NotifyStartConstructorCompile() const
{
	isCompilingConstructor = true;
}

//RXgN^̃RpCI
void CClass::NotifyFinishConstructorCompile() const
{
	isCompilingConstructor = false;
}

//RXgN^RpCǂ𔻕
bool CClass::IsCompilingConstructor() const
{
	return isCompilingConstructor;
}

//fXgN^̃RpCJn
void CClass::NotifyStartDestructorCompile() const{
	isCompilingDestructor = true;
}

//fXgN^̃RpCI
void CClass::NotifyFinishDestructorCompile() const{
	isCompilingDestructor = false;
}

//fXgN^RpCǂ𔻕
bool CClass::IsCompilingDestructor() const
{
	return isCompilingDestructor;
}

//g̔hNXǂmF
bool CClass::IsSubClass( const CClass *pClass ) const
{
	pClass = pClass->pobj_InheritsClass;
	while( pClass ){
		if( this == pClass ) return true;
		pClass = pClass->pobj_InheritsClass;
	}
	return false;
}

//gƓ܂͔hNXǂmF
bool CClass::IsEqualsOrSubClass( const CClass *pClass ) const
{
	if( IsEquals( pClass ) ) return true;
	return IsSubClass( pClass );
}

// gƓ܂͔hNXANXǂmF
bool CClass::IsEqualsOrSubClassOrSuperClass( const CClass &objClass ) const
{
	if( IsEquals( &objClass ) ) return true;
	if( IsSubClass( &objClass ) ) return true;
	if( objClass.IsSubClass( this ) ) return true;
	return false;
}



int Classes::hash(const char *name) const{
	int key;

	for(key=0;*name!='\0';name++){
		key=((key<<8)+ *name )%MAX_CLASS_HASH;
	}

	return key;
}

void Classes::DestroyClass(CClass *pobj_c){
	if(pobj_c->pobj_NextClass){
		DestroyClass(pobj_c->pobj_NextClass);
	}

	delete pobj_c;
}

Classes::Classes():
	pStringClass( NULL ),
	pObjectClass( NULL ),
	pCompilingClass( NULL ),
	pCompilingMethod( NULL ),
	ppobj_IteClass( NULL ),
	iIteMaxNum( 0 ),
	iIteNextNum( 0 )
{
	memset( pobj_ClassHash, 0, MAX_CLASS_HASH * sizeof(CClass *) );
}
Classes::~Classes(){
	int i;
	for(i=0;i<MAX_CLASS_HASH;i++){
		if(pobj_ClassHash[i]) DestroyClass(pobj_ClassHash[i]);
	}

	if(ppobj_IteClass) free(ppobj_IteClass);
}

void Classes::ActionVtblSchedule(LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection){
	int i;
	for(i=0;i<MAX_CLASS_HASH;i++){
		if(pobj_ClassHash[i]){
			CClass *pobj_c;
			pobj_c=pobj_ClassHash[i];
			while(1){
				pobj_c->ActionVtblSchedule(ImageBase,MemPos_CodeSection);

				if(pobj_c->pobj_NextClass==0) break;
				pobj_c=pobj_c->pobj_NextClass;
			}
		}
	}
}

const CClass *Classes::Find( const NamespaceScopes &namespaceScopes, const string &name ) const
{
	int key;
	key=hash(name.c_str());

	if( namespaceScopes.size() == 0 && name == "Object" ){
		return GetObjectClassPtr();
	}
	else if( namespaceScopes.size() == 0 && name == "String" ){
		return GetStringClassPtr();
	}

	if(pobj_ClassHash[key]){
		CClass *pobj_c;
		pobj_c=pobj_ClassHash[key];
		while(1){
			if( pobj_c->IsEqualSymbol( namespaceScopes, name ) ){
				//OԂƃNXv
				return pobj_c;
			}

			if(pobj_c->pobj_NextClass==0) break;
			pobj_c=pobj_c->pobj_NextClass;
		}
	}

	// TypeDef
	int index = Smoothie::meta.typeDefs.GetIndex( namespaceScopes, name );
	if( index != -1 ){
		Type type = Smoothie::meta.typeDefs[index].GetBaseType();
		if( type.IsObject() ){
			return &type.GetClass();
		}
	}

	return NULL;
}
const CClass *Classes::Find( const string &fullName ) const
{
	char AreaName[VN_SIZE] = "";		//IuWFNgϐ
	char NestName[VN_SIZE] = "";		//qo
	bool isNest = CClass::SplitName( fullName.c_str(), AreaName, NestName );

	return Find( NamespaceScopes( AreaName ), NestName );
}

CClass *Classes::AddClass( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const char *name,int nowLine){
	//////////////////////////////////////////////////////////////////////////
	// NXǉ
	// Ô݂o^B̑̏SetClass\bhŁI
	//////////////////////////////////////////////////////////////////////////

	CClass *pobj_c;
	pobj_c=new CClass(namespaceScopes, importedNamespaces, name);

	if(lstrcmp(name,"String")==0){
		//StringNX
		pStringClass=pobj_c;
	}
	if( lstrcmp( name, "Object" ) == 0 ){
		pObjectClass = pobj_c;
	}


	/////////////////////////////////
	// nbVf[^ɒǉ
	/////////////////////////////////

	int key;
	key=hash(name);

	if(pobj_ClassHash[key]){
		CClass *pobj_c2;
		pobj_c2=pobj_ClassHash[key];
		while(1){
			if( pobj_c2->IsEqualSymbol( namespaceScopes, name ) ){
				//OԋyуNXdꍇ
				throw SmoothieException(15,name,nowLine);
				return 0;
			}

			if(pobj_c2->pobj_NextClass==0) break;
			pobj_c2=pobj_c2->pobj_NextClass;
		}
		pobj_c2->pobj_NextClass=pobj_c;
	}
	else{
		pobj_ClassHash[key]=pobj_c;
	}

	return pobj_c;	
}



CClass *Classes::GetStringClassPtr() const
{
	if( !pStringClass ){
		throw SmoothieException();
		return NULL;
	}
	return pStringClass;
}
CClass *Classes::GetObjectClassPtr() const
{
	if( !pObjectClass ){
		throw SmoothieException();
		return NULL;
	}
	return pObjectClass;
}

void Classes::StartCompile( UserProc *pUserProc ){
	pCompilingClass = pUserProc->GetParentClassPtr();
	if( pCompilingClass ){
		pCompilingClass->Using();

		pCompilingMethod = pCompilingClass->GetMethods().GetMethodPtr( pUserProc );
		if( !pCompilingMethod ){
			pCompilingMethod = pCompilingClass->GetStaticMethods().GetMethodPtr( pUserProc );
			if( !pCompilingMethod ){
				throw SmoothieException(300);
			}
		}
	}
	else{
		pCompilingMethod = NULL;
	}
}
const CClass *Classes::GetNowCompilingClass() const
{
	return pCompilingClass;
}
const CMethod *Classes::GetNowCompilingMethodInfo(){
	return pCompilingMethod;
}




//////////////////////
// Ce[^
//////////////////////

void Classes::Iterator_Init(void){
	if(ppobj_IteClass) free(ppobj_IteClass);

	iIteMaxNum=0;
	iIteNextNum=0;
	ppobj_IteClass=(CClass **)malloc(1);

	int i;
	for(i=0;i<MAX_CLASS_HASH;i++){
		if(pobj_ClassHash[i]){
			CClass *pobj_c;
			pobj_c=pobj_ClassHash[i];
			while(1){
				ppobj_IteClass=(CClass **)realloc(ppobj_IteClass,(iIteMaxNum+1)*sizeof(CClass *));
				ppobj_IteClass[iIteMaxNum]=pobj_c;
				iIteMaxNum++;

				if(pobj_c->pobj_NextClass==0) break;
				pobj_c=pobj_c->pobj_NextClass;
			}
		}
	}
}
void Classes::Iterator_Reset(void){
	iIteNextNum = 0;
}
BOOL Classes::Iterator_HasNext(void){
	if(iIteNextNum<iIteMaxNum) return 1;
	return 0;
}
CClass *Classes::Iterator_GetNext(void){
	CClass *pobj_c;
	pobj_c=ppobj_IteClass[iIteNextNum];
	iIteNextNum++;
	return pobj_c;
}
int Classes::Iterator_GetMaxCount(void){
	return iIteMaxNum;
}
