#include <jenga/include/smoothie/Prototype.h>
#include <jenga/include/smoothie/Member.h>
#include <jenga/include/smoothie/BasicFixed.h>

bool Prototype::IsEqualSymbol( const NamespaceScopes &namespaceScopes, const string &name ) const
{
	if( GetName() != name ){
		return false;
	}

	return NamespaceScopes::IsSameArea( GetNamespaceScopes(), namespaceScopes );
}
bool Prototype::IsEqualSymbol( const Prototype &prototype ) const
{
	return IsEqualSymbol( prototype.GetNamespaceScopes(), prototype.GetName() );
}
bool Prototype::IsEqualSymbol( const string &fullName ) const
{
	char AreaName[VN_SIZE] = "";		//IuWFNgϐ
	char NestName[VN_SIZE] = "";		//qo
	bool isNest = CMember::SplitName( fullName.c_str(), AreaName, NestName );

	return IsEqualSymbol( NamespaceScopes( AreaName ), NestName );
}
