#pragma once

#include <string>
#include <vector>

#include "Type.h"
#include "Class.h"
#include "Source.h"

using namespace std;

class CClass;

class CMember : public MemberPrototype
{
	string name;
	Type type;
	bool isConst;

	string initializeExpression;
	string constructParameter;
public:
	int SubScripts[MAX_ARRAYDIM];

	int source_code_address;

	const string &GetName() const
	{
		return name;
	}
	void SetName( const string &name )
	{
		this->name = name;
	}

	Type GetType() const
	{
		return type;
	}

	bool IsConst()
	{
		return isConst;
	}

	const string &GetInitializeExpression() const
	{
		return initializeExpression;
	}
	const string &GetConstructParameter() const
	{
		return constructParameter;
	}

	CMember( Prototype::Accessibility accessibility, const string &name, const Type &type, bool isConst )
		: MemberPrototype( accessibility )
		, name( name )
		, type( type )
		, isConst( isConst )
	{
	}
	CMember( CClass *pobj_c, Prototype::Accessibility accessibility, bool idConst, bool isRef, char *buffer, int nowLine=-1 );
	CMember( CMember &member );
	~CMember();
	static void InitStaticMember(void);

	static bool SplitName( const char *desc, char *object, char *member, CClass::RefType &refType ){
		int lastIndex = -1;
		for( int i=0; desc[i]; i++ ){
			if( desc[i] == '(' ){
				i=BasicSource::JumpStringInPare(desc,i+1);
				continue;
			}
			else if( desc[i] == '[' ){
				i=BasicSource::JumpStringInBracket(desc,i+1);
				continue;
			}
			else if(desc[i]=='.'||(desc[i]==1&&desc[i+1]==ESC_PSMEM)){
				lastIndex = i;
			}
		}
		if( lastIndex == -1 ){
			lstrcpy( member, desc );
			return false;
		}

		if(desc[lastIndex]=='.'){
			lstrcpy(member,desc+lastIndex+1);
			refType = CClass::Dot;
		}
		else{
			lstrcpy(member,desc+lastIndex+2);
			refType = CClass::Pointer;
		}

		if( object ){
			lstrcpy( object, desc );
			object[lastIndex]=0;
		}

		return true;
	}
	static bool SplitName( const char *desc, char *object, char *member ){
		CClass::RefType dummyRefType;
		return SplitName( desc, object, member, dummyRefType );
	}
};
typedef std::vector<CMember *> Members;
