#include "common.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif

CDBClass *pobj_DBClass;

CClass *pobj_CompilingClass;
CClass *pobj_StringClass;

int AddDataTable(char *buffer,int length);



CMember::CMember( CClass *pobj_c, DWORD access, bool isConst, char *buffer, int NowLine ){
	extern int cp;

	//\
	char VarName[VN_SIZE];
	char init_buf[VN_SIZE];
	char constract_parameter[VN_SIZE];
	if(!GetDimentionFormat(buffer,VarName,SubScripts,&TypeInfo,init_buf,constract_parameter))
		return;

	//d`FbN
	if(pobj_c->DupliCheckAll(VarName)){
		SetError(15,VarName,cp);
		return;
	}

	if(TypeInfo.type==DEF_OBJECT){
		if(TypeInfo.u.pobj_Class->IsHoldAbstractFunction()){
			//ۃNXƂ
			SetError(125,TypeInfo.u.pobj_Class->name,cp);
		}
	}

	//o
	name=(char *)HeapAlloc(hHeap,0,lstrlen(VarName)+1);
	lstrcpy(name,VarName);

	//ANZX
	dwAccess=access;

	//萔ǂ
	this->isConst = isConst;

	//f[^
	InitBuf=(char *)HeapAlloc(hHeap,0,lstrlen(init_buf)+1);
	lstrcpy(InitBuf,init_buf);

	//RXgN^p̃p[^
	ConstractParameter=(char *)HeapAlloc(hHeap,0,lstrlen(constract_parameter)+1);
	lstrcpy(ConstractParameter,constract_parameter);

	//\[XR[ḧʒu
	source_code_address=NowLine;
}
CMember::CMember(CMember *pobj){
	//Rs[RXgN^
	memset(this,0,sizeof(CMember));

	//name
	name=(char *)HeapAlloc(hHeap,0,lstrlen(pobj->name)+1);
	lstrcpy(name,pobj->name);

	//萔ǂ
	isConst = pobj->isConst;

	//SubScripts
	memcpy(SubScripts,pobj->SubScripts,MAX_ARRAYDIM*sizeof(int));

	//TypeInfo
	TypeInfo=pobj->TypeInfo;

	//\[XR[ḧʒu
	source_code_address=pobj->source_code_address;
}
CMember::CMember(){
	memset(this,0,sizeof(CMember));
}
CMember::~CMember(){
	HeapDefaultFree(name);
	if(InitBuf) HeapDefaultFree(InitBuf);
	if(ConstractParameter) HeapDefaultFree(ConstractParameter);
}

bool CMember::IsConst(){
	return isConst;
}

void CMember::InitStaticMember(void){
	//ÓIoO[öɍ쐬

	//Ce[^Zbg
	extern CDBClass *pobj_DBClass;
	pobj_DBClass->Iterator_Reset();

	int back_cp=cp;

	while(pobj_DBClass->Iterator_HasNext()){
		CClass *pobj_c;
		pobj_c=pobj_DBClass->Iterator_GetNext();

		int i;
		char temporary[VN_SIZE];
		for(i=0;i<pobj_c->iStaticMemberNum;i++){
			sprintf(temporary,"%s.%s",pobj_c->name,pobj_c->ppobj_StaticMember[i]->name);
			AddGlobalVariable(
				temporary,
				pobj_c->ppobj_StaticMember[i]->SubScripts,
				&pobj_c->ppobj_StaticMember[i]->TypeInfo,
				GetTypeSize(pobj_c->ppobj_StaticMember[i]->TypeInfo.type,pobj_c->ppobj_StaticMember[i]->TypeInfo.u.lpIndex),
				pobj_c->ppobj_StaticMember[i]->InitBuf,
				pobj_c->ppobj_StaticMember[i]->ConstractParameter,
				0);

			if(pobj_c->ppobj_StaticMember[i]->TypeInfo.type==DEF_OBJECT){
				//G[p
				cp=pobj_c->ppobj_StaticMember[i]->source_code_address;

				CallConstractor(temporary,
					pobj_c->ppobj_StaticMember[i]->SubScripts,
					pobj_c->ppobj_StaticMember[i]->TypeInfo,
					pobj_c->ppobj_StaticMember[i]->ConstractParameter);
			}

			//lCeBuR[hobt@̍Ċm
			extern int obp_AllocSize;
			if(obp_AllocSize<obp+8192){
				obp_AllocSize+=8192;
				OpBuffer=(char *)HeapReAlloc(hHeap,0,OpBuffer,obp_AllocSize); //matea
			}
		}
	}

	cp=back_cp;
}



CMethod::CMethod(CMethod *pobj){
	//Rs[RXgN^
	memset(this,0,sizeof(CMethod));

	psi=pobj->psi;

	bAbstract=pobj->bAbstract;

	bVirtual=pobj->bVirtual;
}
CMethod::CMethod(){
	memset(this,0,sizeof(CMethod));
}
CMethod::~CMethod(){
}




CClass::CClass(char *name){
	memset(this,0,sizeof(CClass));

	vtbl_offset=-1;

	this->name=(char *)HeapAlloc(hHeap,0,lstrlen(name)+1);
	lstrcpy(this->name,name);

	isCompilingConstructor = 0;
}
CClass::~CClass(){
	int i;

	//NX
	HeapDefaultFree(name);

	if(ppobj_Member){
		//o
		for(i=0;i<iMemberNum;i++){
			delete ppobj_Member[i];
		}
		HeapDefaultFree(ppobj_Member);
		ppobj_Member=0;
	}

	if(ppobj_Method){
		//\bh
		for(i=0;i<iMethodNum;i++){
			delete ppobj_Method[i];
		}
		HeapDefaultFree(ppobj_Method);
		ppobj_Method=0;
	}

	if(ppobj_StaticMember){
		//ÓIo
		for(i=0;i<iStaticMemberNum;i++){
			delete ppobj_StaticMember[i];
		}
		HeapDefaultFree(ppobj_StaticMember);
		ppobj_StaticMember=0;
	}

	if(ppobj_StaticMethod){
		//ÓI\bh
		for(i=0;i<iStaticMethodNum;i++){
			delete ppobj_StaticMethod[i];
		}
		HeapDefaultFree(ppobj_StaticMethod);
		ppobj_StaticMethod=0;
	}
}
void CClass::AddMember( DWORD dwAccess, bool isConst, char *buffer ){
	ppobj_Member = (CMember **)HeapReAlloc( hHeap, 0, ppobj_Member, ( iMemberNum + 1 ) * sizeof(CMember *) );
	ppobj_Member[iMemberNum] = new CMember( this, dwAccess, isConst, buffer );
	iMemberNum++;
}
void CClass::AddStaticMember( DWORD dwAccess, bool isConst, char *buffer, int NowLine ){
	ppobj_StaticMember=(CMember **)HeapReAlloc(hHeap,0,ppobj_StaticMember,(iStaticMemberNum+1)*sizeof(CMember *));
	ppobj_StaticMember[iStaticMemberNum]=new CMember( this, dwAccess, isConst, buffer, NowLine );
	iStaticMemberNum++;
}
void CClass::AddMethod(SUBINFO *psi,DWORD dwAccess,BOOL bAbstract,BOOL bVirtual){
	ppobj_Method=(CMethod **)HeapReAlloc(hHeap,0,ppobj_Method,(iMethodNum+1)*sizeof(CMethod *));
	ppobj_Method[iMethodNum]=new CMethod();
	ppobj_Method[iMethodNum]->psi=psi;
	ppobj_Method[iMethodNum]->dwAccess=dwAccess;
	ppobj_Method[iMethodNum]->bAbstract=bAbstract;
	ppobj_Method[iMethodNum]->bVirtual=bVirtual;
	ppobj_Method[iMethodNum]->pobj_InheritsClass=0;

	iMethodNum++;
}
void CClass::AddStaticMethod(SUBINFO *psi,DWORD dwAccess){
	ppobj_StaticMethod=(CMethod **)HeapReAlloc(hHeap,0,ppobj_StaticMethod,(iStaticMethodNum+1)*sizeof(CMethod *));
	ppobj_StaticMethod[iStaticMethodNum]=new CMethod();
	ppobj_StaticMethod[iStaticMethodNum]->psi=psi;
	ppobj_StaticMethod[iStaticMethodNum]->dwAccess=dwAccess;
	ppobj_StaticMethod[iStaticMethodNum]->bAbstract=0;
	ppobj_StaticMethod[iStaticMethodNum]->bVirtual=0;
	ppobj_StaticMethod[iStaticMethodNum]->pobj_InheritsClass=0;

	iStaticMethodNum++;
}
BOOL CClass::DupliCheckAll(char *name){
	//d`FbN

	int i;

	//o
	if(DupliCheckMember(name)) return 1;

	//\bh
	for(i=0;i<iMethodNum;i++){
		if(lstrcmp(name,ppobj_Method[i]->psi->name)==0){
			return 1;
		}
	}

	return 0;
}
BOOL CClass::DupliCheckMember(char *name){
	//d`FbN

	int i;

	//o
	for(i=0;i<iMemberNum;i++){
		if(lstrcmp(name,ppobj_Member[i]->name)==0){
			return 1;
		}
	}

	//ÓIo
	for(i=0;i<iStaticMemberNum;i++){
		if(lstrcmp(name,ppobj_StaticMember[i]->name)==0){
			return 1;
		}
	}

	return 0;
}

LONG_PTR CClass::AddVtblDataTable(SUBINFO **ppsi,int length){
	return AddDataTable((char *)ppsi,length);
}
LONG_PTR CClass::GetVtblGlobalOffset(void){
	if(vtbl_offset!=-1) return vtbl_offset;

	SUBINFO **ppsi;
	ppsi=(SUBINFO **)HeapAlloc(hHeap,0,vtbl_num*sizeof(SUBINFO *));

	//֐e[uɒlZbg
	int i,i2,i3=0;
	for(i=0;i < iMethodNum;i++){
		if(ppobj_Method[i]->bVirtual){
			for(i2=iMethodNum-1; i2>=i; i2--){
				if(lstrcmp(ppobj_Method[i]->psi->name,ppobj_Method[i2]->psi->name)==0){
					pobj_CompilingClass->ppobj_Method[i2]->psi->bUse=1;

					if(ppobj_Method[i2]->bAbstract){
						extern int cp;
						SetError(300,NULL,cp);

						ppsi[i3]=0;
					}
					else ppsi[i3]=pobj_CompilingClass->ppobj_Method[i2]->psi;
					i3++;

					break;
				}
			}
		}
	}

	vtbl_offset=AddDataTable((char *)ppsi,vtbl_num*sizeof(LONG_PTR));

	for(i=0;i<vtbl_num;i++){
		pobj_Reloc->AddSchedule_DataSection(vtbl_offset+i*sizeof(LONG_PTR));
	}

	HeapDefaultFree(ppsi);

	return vtbl_offset;
}
void CClass::ActionVtblSchedule(LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection){
	if(vtbl_offset==-1) return;

	extern char *DataTable;
	LONG_PTR *pVtbl;
	pVtbl=(LONG_PTR *)(DataTable+vtbl_offset);

	int i;
	for(i=0;i<vtbl_num;i++){
		SUBINFO *psi;
		psi=(SUBINFO *)pVtbl[i];
		if(!psi) continue;
		pVtbl[i]=psi->CompileAddress+ImageBase+MemPos_CodeSection;
	}
}
BOOL CClass::IsHoldAbstractFunction(void){
	//̉z֐ꍇ1Ԃ

	int i,i2,i3=0;
	for(i=0;i < iMethodNum;i++){
		if(ppobj_Method[i]->bVirtual){
			for(i2=iMethodNum-1; i2>=i; i2--){
				if(lstrcmp(ppobj_Method[i]->psi->name,ppobj_Method[i2]->psi->name)==0){

					if(ppobj_Method[i2]->bAbstract){
						return 1;
					}

					break;
				}
			}
		}
	}

	//R|WV̊֌Wɂ郁o
	for(i=0;i < iMemberNum;i++){
		if(ppobj_Member[i]->TypeInfo.type==DEF_OBJECT){
			if(ppobj_Member[i]->TypeInfo.u.pobj_Class->IsHoldAbstractFunction())
				return 1;
		}
	}

	return 0;
}


SUBINFO **CClass::GetOperatorSubInfo(BYTE idCalc,int &num){
	//i[̂߂̍\̔zp
	SUBINFO **ppArray_si;
	ppArray_si=(SUBINFO **)HeapAlloc(hHeap,0,sizeof(SUBINFO *)*1024);
	num=0;

	int i;
	for(i=0;i<iMethodNum;i++){
		char *temp;
		temp=ppobj_Method[i]->psi->name;
		if(temp[0]==1&&temp[1]==ESC_OPERATOR){
			if((BYTE)temp[2]==idCalc){
				ppArray_si[num]=ppobj_Method[i]->psi;
				num++;
			}
		}
	}

	return ppArray_si;
}

// RXgN^̃RpCJn
void CClass::NotifyStartConstructorCompile(){
	isCompilingConstructor = true;
}

//RXgN^̃RpCI
void CClass::NotifyFinishConstructorCompile(){
	isCompilingConstructor = false;
}

//RXgN^RpCǂ𔻕
bool CClass::IsCompilingConstructor(){
	return isCompilingConstructor;
}


int CDBClass::hash(char *name){
	int key;

	for(key=0;*name!='\0';name++){
		key=((key<<8)+ *name )%MAX_CLASS_HASH;
	}

	return key;
}

void CDBClass::DestroyClass(CClass *pobj_c){
	if(pobj_c->pobj_NextClass){
		DestroyClass(pobj_c->pobj_NextClass);
	}

	delete pobj_c;
}

CDBClass::CDBClass(){
	memset(this,0,sizeof(CDBClass));
}
CDBClass::~CDBClass(){
	int i;
	for(i=0;i<MAX_CLASS_HASH;i++){
		if(pobj_ClassHash[i]) DestroyClass(pobj_ClassHash[i]);
	}

	if(ppobj_IteClass) HeapDefaultFree(ppobj_IteClass);
}

void CDBClass::ActionVtblSchedule(LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection){
	int i;
	for(i=0;i<MAX_CLASS_HASH;i++){
		if(pobj_ClassHash[i]){
			CClass *pobj_c;
			pobj_c=pobj_ClassHash[i];
			while(1){
				pobj_c->ActionVtblSchedule(ImageBase,MemPos_CodeSection);

				if(pobj_c->pobj_NextClass==0) break;
				pobj_c=pobj_c->pobj_NextClass;
			}
		}
	}
}

CClass *CDBClass::check(char *name){
	int key;
	key=hash(name);

	if(pobj_ClassHash[key]){
		CClass *pobj_c;
		pobj_c=pobj_ClassHash[key];
		while(1){
			if(lstrcmp(name,pobj_c->name)==0){
				//dꍇ
				return pobj_c;
			}

			if(pobj_c->pobj_NextClass==0) break;
			pobj_c=pobj_c->pobj_NextClass;
		}
	}
	return 0;
}

CClass *CDBClass::AddClass(char *name,int NowLine){
	//////////////////////////////////////////////////////////////////////////
	// NXǉ
	// Ô݂o^B̑̏SetClass\bhŁI
	//////////////////////////////////////////////////////////////////////////

	CClass *pobj_c;
	pobj_c=new CClass(name);

	if(lstrcmp(name,"String")==0){
		//StringNX
		pobj_StringClass=pobj_c;
	}


	/////////////////////////////////
	// nbVf[^ɒǉ
	/////////////////////////////////

	int key;
	key=hash(name);

	if(pobj_ClassHash[key]){
		CClass *pobj_c2;
		pobj_c2=pobj_ClassHash[key];
		while(1){
			if(lstrcmp(name,pobj_c2->name)==0){
				//dꍇ
				SetError(15,name,NowLine);
				return 0;
			}

			if(pobj_c2->pobj_NextClass==0) break;
			pobj_c2=pobj_c2->pobj_NextClass;
		}
		pobj_c2->pobj_NextClass=pobj_c;
	}
	else{
		pobj_ClassHash[key]=pobj_c;
	}

	return pobj_c;	
}

void CDBClass::InitNames(void){
	extern char *basbuf;
	int i;

	for(i=0;;i++){
		if(basbuf[i]=='\0') break;

		if(basbuf[i]==1&&(
			basbuf[i+1]==ESC_CLASS||
			basbuf[i+1]==ESC_TYPE||
			basbuf[i+1]==ESC_INTERFACE
			)){
				int NowLine;
				NowLine=i;

				i+=2;
				//ACgCq
				if(_memicmp(basbuf+i,"Align(",6)==0){
					i+=6;
					i=JumpStringInPare(basbuf,i)+1;
				}

				int i2;
				char temporary[VN_SIZE];
				for(i2=0;;i++,i2++){
					if(!IsVariableChar(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
				}

				//NXǉ
				pobj_DBClass->AddClass(temporary,NowLine);
		}
	}
}


void CDBClass::AddMemberSub(CClass *pobj_c,DWORD dwAccess,BOOL bStatic,BOOL bAbstract,BOOL bVirtual,BOOL bOverride,char *buffer,int NowLine){
	int i,i2;
	char temporary[VN_SIZE];

	i=2;
	for(i2=0;;i++,i2++){
		if(buffer[i]=='('||buffer[i]=='\0'){
			temporary[i2]=0;
			break;
		}
		temporary[i2]=buffer[i];
	}


	//֐nbV֓o^
	SUBINFO *psi;
	psi=AddSubData(buffer,NowLine,bVirtual,pobj_c,bStatic);
	if(!psi) return;


	////////////////////////////////////////////////////////////
	// RXgN^AfXgN^̃ANZVreB`FbN
	////////////////////////////////////////////////////////////
	BOOL fConstructor=0,bDestructor=0;

	if(lstrcmp(temporary,pobj_c->name)==0){
		if(psi->ParmNum==1) fConstructor=1;
		if(psi->ParmNum==2){
			if(psi->pParmInfo[1].type==DEF_OBJECT&&
				psi->pParmInfo[1].u.pobj_c==pobj_c) fConstructor=2;
		}
	}
	else if(temporary[0]=='~'){
		//fXgN^̏ꍇ̖͂O`FbNs
		if(lstrcmp(temporary+1,pobj_c->name)!=0)
			SetError(117,NULL,NowLine);
		else
			bDestructor=1;
	}
	if(fConstructor||bDestructor){
		if(dwAccess!=ACCESS_PUBLIC){
			SetError(116,NULL,NowLine);
			dwAccess=ACCESS_PUBLIC;
		}
	}


	if(fConstructor==1) pobj_c->ConstructorMemberSubIndex=pobj_c->iMethodNum;
	else if(fConstructor==2) pobj_c->CopyConstructorMemberSubIndex=pobj_c->iMethodNum;
	else if(bDestructor) pobj_c->DestructorMemberSubIndex=pobj_c->iMethodNum;



	//////////////////
	// d`FbN
	//////////////////

	if(pobj_c->DupliCheckMember(temporary)){
		SetError(15,temporary,NowLine);
		return;
	}

	//o֐
	for(i=0;i<pobj_c->iMethodNum;i++){
		//X[p[NXƏdꍇ̓I[o[Chs
		if(pobj_c->ppobj_Method[i]->pobj_InheritsClass) continue;

		if(lstrcmp(temporary,pobj_c->ppobj_Method[i]->psi->name)==0){
			if(CompareParameter(
				pobj_c->ppobj_Method[i]->psi->pParmInfo,pobj_c->ppobj_Method[i]->psi->ParmNum,
				psi->pParmInfo,psi->ParmNum
				)==0){
				//֐Ap[^vƂ
				SetError(15,psi->name,NowLine);
				return;
			}
		}
	}

	//z֐̏ꍇ
	if(bAbstract) psi->bCompile=1;


	for(i=0;i<pobj_c->iMethodNum;i++){
		if(lstrcmp(temporary,pobj_c->ppobj_Method[i]->psi->name)==0){
			if(CompareParameter(
				pobj_c->ppobj_Method[i]->psi->pParmInfo,pobj_c->ppobj_Method[i]->psi->ParmNum,
				psi->pParmInfo,psi->ParmNum
				)==0){

				if(pobj_c->ppobj_Method[i]->psi->bVirtual){
					//o֐㏑
					pobj_c->ppobj_Method[i]->psi=psi;
					pobj_c->ppobj_Method[i]->bAbstract=0;

					if(!bOverride){
						SetError(127,NULL,NowLine);
					}
					if(pobj_c->ppobj_Method[i]->dwAccess!=dwAccess){
						SetError(128,NULL,NowLine);
					}
					return;
				}
			}
		}
	}

	if(psi->bVirtual){
		pobj_c->vtbl_num++;
	}

	if(bOverride){
		SetError(12,"Override",NowLine);
	}

	if(bStatic){
		pobj_c->AddStaticMethod(psi,dwAccess);
	}
	else{
		pobj_c->AddMethod(psi,dwAccess,bAbstract,bVirtual);
	}
}

BOOL CDBClass::MemberVar_LoopRefCheck(CClass *pobj_c){
	int i,i2,bRet=1;
	for(i=0;i<pobj_c->iMemberNum;i++){
		if(pobj_c->ppobj_Member[i]->TypeInfo.type==DEF_OBJECT){
			//zQƂłȂ`FbN
			if(pobj_LoopRefCheck->check(pobj_c->ppobj_Member[i]->TypeInfo.u.pobj_Class->name)){
				extern int cp;
				SetError(123,pobj_c->ppobj_Member[i]->TypeInfo.u.pobj_Class->name,cp);
				return 0;
			}

			pobj_LoopRefCheck->add(pobj_c->name);

			i2=MemberVar_LoopRefCheck(pobj_c->ppobj_Member[i]->TypeInfo.u.pobj_Class);
			if(bRet==1) bRet=i2;

			pobj_LoopRefCheck->del(pobj_c->name);
		}
	}

	return bRet;
}

void CDBClass::GetClass_recur(char *lpszInheritsClass){
	extern char *basbuf;
	int i,i2,i3,sub_address,top_pos;
	DWORD dwClassType;
	DWORD dwAccess;
	char temporary[8192];

	for(i=0;;i++){
		if(basbuf[i]=='\0') break;

		CClass *pobj_c;

		if(basbuf[i]==1&&basbuf[i+1]==ESC_INTERFACE){
			//////////////////////////
			// C^[tFCX
			//////////////////////////

			top_pos=i;

			i+=2;

			//C^[tFCX擾
			GetIdentifierToken( temporary, basbuf, i );

			pobj_c=pobj_DBClass->check(temporary);
			if(!pobj_c) continue;

			if(lpszInheritsClass){
				if(lstrcmp(lpszInheritsClass,pobj_c->name)!=0){
					//pǂݗp
					continue;
				}
			}

			if(pobj_c->ppobj_Member){
				//ɐǂ݂ĂƂ
				continue;
			}

			//op
			pobj_c->ppobj_Member=(CMember **)HeapAlloc(hHeap,0,1);
			pobj_c->iMemberNum=0;
			pobj_c->ppobj_StaticMember=(CMember **)HeapAlloc(hHeap,0,1);
			pobj_c->iStaticMemberNum=0;
			pobj_c->ppobj_Method=(CMethod **)HeapAlloc(hHeap,0,1);
			pobj_c->iMethodNum=0;
			pobj_c->ppobj_StaticMethod=(CMethod **)HeapAlloc(hHeap,0,1);
			pobj_c->iStaticMethodNum=0;

			pobj_c->ConstructorMemberSubIndex=-1;
			pobj_c->CopyConstructorMemberSubIndex=-1;
			pobj_c->DestructorMemberSubIndex=-1;

			if(basbuf[i+1]==1&&basbuf[i+2]==ESC_INHERITS){
				//psꍇ
				for(i+=3,i2=0;;i++,i2++){
					if(IsCommandDelimitation(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
				}

				if(lstrcmpi(temporary,pobj_c->name)==0){
					SetError(105,temporary,i);
					goto Interface_InheritsError;
				}

				//pNX擾
				pobj_c->pobj_InheritsClass=check(temporary);
				if(!pobj_c->pobj_InheritsClass){
					SetError(106,temporary,i);
					goto Interface_InheritsError;
				}

				//[vpłȂ`FbN
				if(pobj_LoopRefCheck->check(temporary)){
					SetError(123,temporary,i);
					goto Interface_InheritsError;
				}

				if(pobj_c->pobj_InheritsClass->ppobj_Member==0){
					//p悪ǂݎĂȂƂ
					pobj_LoopRefCheck->add(pobj_c->name);
					GetClass_recur(temporary);
					pobj_LoopRefCheck->del(pobj_c->name);
				}

				//oϐRs[
				pobj_c->ppobj_Member=(CMember **)HeapReAlloc(
					hHeap,
					0,
					pobj_c->ppobj_Member,
					pobj_c->pobj_InheritsClass->iMemberNum*sizeof(CMember *));
				pobj_c->iMemberNum=pobj_c->pobj_InheritsClass->iMemberNum;
				for(i3=0;i3<pobj_c->pobj_InheritsClass->iMemberNum;i3++){
					pobj_c->ppobj_Member[i3]=new CMember(pobj_c->pobj_InheritsClass->ppobj_Member[i3]);

					//dwAccess
					if(pobj_c->pobj_InheritsClass->ppobj_Member[i3]->dwAccess==ACCESS_PRIVATE)
						pobj_c->ppobj_Member[i3]->dwAccess=ACCESS_NON;
					else pobj_c->ppobj_Member[i3]->dwAccess=pobj_c->pobj_InheritsClass->ppobj_Member[i3]->dwAccess;
				}

				//o֐Rs[
				pobj_c->ppobj_Method=(CMethod **)HeapReAlloc(
					hHeap,
					0,
					pobj_c->ppobj_Method,
					pobj_c->pobj_InheritsClass->iMethodNum*sizeof(CMethod *));
				pobj_c->iMethodNum=pobj_c->pobj_InheritsClass->iMethodNum;
				for(i3=0;i3<pobj_c->pobj_InheritsClass->iMethodNum;i3++){
					pobj_c->ppobj_Method[i3]=new CMethod(pobj_c->pobj_InheritsClass->ppobj_Method[i3]);

					//dwAccess
					if(pobj_c->pobj_InheritsClass->ppobj_Method[i3]->dwAccess==ACCESS_PRIVATE)
						pobj_c->ppobj_Method[i3]->dwAccess=ACCESS_NON;
					else pobj_c->ppobj_Method[i3]->dwAccess=pobj_c->pobj_InheritsClass->ppobj_Method[i3]->dwAccess;

					//pobj_Inherits
					// pClassIndexZbgiqplj
					if(pobj_c->pobj_InheritsClass->ppobj_Method[i3]->pobj_InheritsClass==0)
						pobj_c->ppobj_Method[i3]->pobj_InheritsClass=pobj_c->pobj_InheritsClass;
					else
						pobj_c->ppobj_Method[i3]->pobj_InheritsClass=
							pobj_c->pobj_InheritsClass->ppobj_Method[i3]->pobj_InheritsClass;
				}

				//z֐̐
				pobj_c->vtbl_num=pobj_c->pobj_InheritsClass->vtbl_num;
			}
			else{
				//p
				pobj_c->pobj_InheritsClass=0;

				//z֐̐
				pobj_c->vtbl_num=0;
			}
Interface_InheritsError:

			//oϐA֐擾
			while(1){
				i++;

				//G[
				if(basbuf[i]==1&&(basbuf[i+1]==ESC_CLASS||basbuf[i+1]==ESC_TYPE||basbuf[i+1]==ESC_INTERFACE)){
					SetError(22,"Interface",i);
					i--;
					break;
				}

				if(basbuf[i]==1&&basbuf[i+1]==ESC_INHERITS){
					SetError(111,NULL,i);
					break;
				}

				sub_address=i;

				for(i2=0;;i++,i2++){
					if(IsCommandDelimitation(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
				}
				if(temporary[0]=='\0'){
					if(basbuf[i]=='\0'){
						i--;
						SetError(22,"Interface",top_pos);
						break;
					}
					continue;
				}

				//End InterfaceLq̏ꍇ
				if(temporary[0]==1&&temporary[1]==ESC_ENDINTERFACE) break;

				if(!(temporary[0]==1&&(
					temporary[1]==ESC_SUB||temporary[1]==ESC_FUNCTION
					))){
					SetError(1,NULL,i);
					break;
				}

				//o֐ǉ
				AddMemberSub(pobj_c,ACCESS_PUBLIC,0,1,1,0,temporary,sub_address);
			}
		}

		if(basbuf[i]==1&&(basbuf[i+1]==ESC_CLASS||basbuf[i+1]==ESC_TYPE)){
			//////////////////////////
			// NX
			//////////////////////////

			top_pos=i;

			dwClassType=basbuf[i+1];

			i+=2;

			//ACgCq
			int iAlign=0;
			if(_memicmp(basbuf+i,"Align(",6)==0){
				i+=6;
				i+=GetStringInPare_RemovePare(temporary,basbuf+i)+1;
				iAlign=atoi(temporary);

				if(!(iAlign==1||iAlign==2||iAlign==4||iAlign==8||iAlign==16))
					SetError(51,NULL,i);
			}


			//NX擾
			GetIdentifierToken( temporary, basbuf, i );

			pobj_c=pobj_DBClass->check(temporary);
			if(!pobj_c) continue;

			if(lpszInheritsClass){
				if(lstrcmp(lpszInheritsClass,pobj_c->name)!=0){
					//pǂݗp
					continue;
				}
			}

			if(pobj_c->ppobj_Member){
				//ɐǂ݂ĂƂ
				continue;
			}

			pobj_c->iAlign=iAlign;

			//op
			pobj_c->ppobj_Member=(CMember **)HeapAlloc(hHeap,0,1);
			pobj_c->iMemberNum=0;
			pobj_c->ppobj_StaticMember=(CMember **)HeapAlloc(hHeap,0,1);
			pobj_c->iStaticMemberNum=0;
			pobj_c->ppobj_Method=(CMethod **)HeapAlloc(hHeap,0,1);
			pobj_c->iMethodNum=0;
			pobj_c->ppobj_StaticMethod=(CMethod **)HeapAlloc(hHeap,0,1);
			pobj_c->iStaticMethodNum=0;

			pobj_c->ConstructorMemberSubIndex=-1;
			pobj_c->CopyConstructorMemberSubIndex=-1;
			pobj_c->DestructorMemberSubIndex=-1;

			//ANZX̏lZbg
			if(dwClassType==ESC_CLASS) dwAccess=ACCESS_PRIVATE;
			else dwAccess=ACCESS_PUBLIC;

			if(basbuf[i+1]==1&&basbuf[i+2]==ESC_INHERITS){
				//psꍇ
				for(i+=3,i2=0;;i++,i2++){
					if(IsCommandDelimitation(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
				}

				if(lstrcmpi(temporary,pobj_c->name)==0){
					SetError(105,temporary,i);
					goto InheritsError;
				}

				//pNX擾
				pobj_c->pobj_InheritsClass=check(temporary);
				if(!pobj_c->pobj_InheritsClass){
					SetError(106,temporary,i);
					goto InheritsError;
				}

				//[vpłȂ`FbN
				if(pobj_LoopRefCheck->check(temporary)){
					SetError(123,temporary,i);
					goto InheritsError;
				}

				if(pobj_c->pobj_InheritsClass->ppobj_Member==0){
					//p悪ǂݎĂȂƂ
					pobj_LoopRefCheck->add(pobj_c->name);
					GetClass_recur(temporary);
					pobj_LoopRefCheck->del(pobj_c->name);
				}

				//oϐRs[
				pobj_c->ppobj_Member=(CMember **)HeapReAlloc(
					hHeap,
					0,
					pobj_c->ppobj_Member,
					pobj_c->pobj_InheritsClass->iMemberNum*sizeof(CMember *));
				pobj_c->iMemberNum=pobj_c->pobj_InheritsClass->iMemberNum;
				for(i3=0;i3<pobj_c->pobj_InheritsClass->iMemberNum;i3++){
					pobj_c->ppobj_Member[i3]=new CMember(pobj_c->pobj_InheritsClass->ppobj_Member[i3]);

					//dwAccess
					if(pobj_c->pobj_InheritsClass->ppobj_Member[i3]->dwAccess==ACCESS_PRIVATE)
						pobj_c->ppobj_Member[i3]->dwAccess=ACCESS_NON;
					else pobj_c->ppobj_Member[i3]->dwAccess=pobj_c->pobj_InheritsClass->ppobj_Member[i3]->dwAccess;
				}

				//o֐Rs[
				pobj_c->ppobj_Method=(CMethod **)HeapReAlloc(
					hHeap,
					0,
					pobj_c->ppobj_Method,
					pobj_c->pobj_InheritsClass->iMethodNum*sizeof(CMethod *));
				pobj_c->iMethodNum=pobj_c->pobj_InheritsClass->iMethodNum;
				for(i3=0;i3<pobj_c->pobj_InheritsClass->iMethodNum;i3++){
					pobj_c->ppobj_Method[i3]=new CMethod(pobj_c->pobj_InheritsClass->ppobj_Method[i3]);

					//dwAccess
					if(pobj_c->pobj_InheritsClass->ppobj_Method[i3]->dwAccess==ACCESS_PRIVATE)
						pobj_c->ppobj_Method[i3]->dwAccess=ACCESS_NON;
					else pobj_c->ppobj_Method[i3]->dwAccess=pobj_c->pobj_InheritsClass->ppobj_Method[i3]->dwAccess;

					//pobj_Inherits
					// pClassIndexZbgiqplj
					if(pobj_c->pobj_InheritsClass->ppobj_Method[i3]->pobj_InheritsClass==0)
						pobj_c->ppobj_Method[i3]->pobj_InheritsClass=pobj_c->pobj_InheritsClass;
					else
						pobj_c->ppobj_Method[i3]->pobj_InheritsClass=
							pobj_c->pobj_InheritsClass->ppobj_Method[i3]->pobj_InheritsClass;
				}

				//z֐̐
				pobj_c->vtbl_num=pobj_c->pobj_InheritsClass->vtbl_num;
			}
			else{
				//p
				pobj_c->pobj_InheritsClass=0;

				//z֐̐
				pobj_c->vtbl_num=0;
			}
InheritsError:

			//oϐA֐擾
			while(1){
				i++;

				//G[
				if(basbuf[i]==1&&(basbuf[i+1]==ESC_CLASS||basbuf[i+1]==ESC_TYPE)){
					SetError(22,"Class",i);
					i--;
					break;
				}

				if(basbuf[i]==1&&basbuf[i+1]==ESC_INHERITS){
					SetError(111,NULL,i);
					break;
				}

				//StaticCq
				BOOL bStatic;
				if(basbuf[i]==1&&basbuf[i+1]==ESC_STATIC){
					bStatic=1;
					i+=2;
				}
				else bStatic=0;

				//ConstCq
				bool isConst = false;
				if( basbuf[i] == 1 && basbuf[i + 1] == ESC_CONST ){
					isConst = true;
					i += 2;
				}

				if(basbuf[i]==1&&(
					basbuf[i+1]==ESC_ABSTRACT||basbuf[i+1]==ESC_VIRTUAL||basbuf[i+1]==ESC_OVERRIDE||
					basbuf[i+1]==ESC_SUB||basbuf[i+1]==ESC_FUNCTION
					)){
					i3=basbuf[i+1];
					sub_address=i;
				}
				else i3=0;

				BOOL bVirtual=0,bAbstract=0,bOverride=0;
				if(i3==ESC_ABSTRACT){
					bAbstract=1;
					bVirtual=1;
					i+=2;

					i3=basbuf[i+1];
				}
				else if(i3==ESC_VIRTUAL){
					bAbstract=0;
					bVirtual=1;
					i+=2;

					i3=basbuf[i+1];
				}
				else if(i3==ESC_OVERRIDE){
					bOverride=1;
					bVirtual=1;

					i+=2;

					i3=basbuf[i+1];
				}

				for(i2=0;;i++,i2++){
					if(IsCommandDelimitation(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
				}
				if(temporary[0]=='\0'){
					if(basbuf[i]=='\0'){

						if(dwClassType==ESC_CLASS)
							SetError(22,"Class",top_pos);
						else
							SetError(22,"Type",top_pos);

						i--;
						break;
					}
					continue;
				}

				//End ClassLq̏ꍇ
				if(temporary[0]==1&&temporary[1]==ESC_ENDCLASS&&dwClassType==ESC_CLASS) break;
				if(temporary[0]==1&&temporary[1]==ESC_ENDTYPE&&dwClassType==ESC_TYPE) break;

				//ANZXύX
				if(lstrcmpi(temporary,"Private")==0){
					dwAccess=ACCESS_PRIVATE;
					continue;
				}
				if(lstrcmpi(temporary,"Public")==0){
					dwAccess=ACCESS_PUBLIC;
					continue;
				}
				if(lstrcmpi(temporary,"Protected")==0){
					dwAccess=ACCESS_PROTECTED;
					continue;
				}

				extern int cp;
				if(i3==0){
					if(bStatic){
						//ÓIoǉ
						cp=i;	//G[p
						pobj_c->AddStaticMember( dwAccess, isConst, temporary, i);
					}
					else{
						//oǉ
						cp=i;	//G[p
						pobj_c->AddMember( dwAccess, isConst, temporary );


						if(pobj_c->ppobj_Member[pobj_c->iMemberNum-1]->TypeInfo.type==DEF_OBJECT){
							if(pobj_c->ppobj_Member[pobj_c->iMemberNum-1]->TypeInfo.u.pobj_Class->ppobj_Member==0){
								//QƐ悪ǂݎĂȂƂ
								GetClass_recur(pobj_c->ppobj_Member[pobj_c->iMemberNum-1]->TypeInfo.u.pobj_Class->name);
							}
						}


						if(pobj_c->ppobj_Member[pobj_c->iMemberNum-1]->TypeInfo.type==DEF_OBJECT){
							//zQƂ̃`FbN
							pobj_LoopRefCheck->add(pobj_c->name);
							if(!MemberVar_LoopRefCheck(pobj_c->ppobj_Member[pobj_c->iMemberNum-1]->TypeInfo.u.pobj_Class)){
								//G[
								pobj_c->ppobj_Member[pobj_c->iMemberNum-1]->TypeInfo.type=DEF_PTR_VOID;
							}
							pobj_LoopRefCheck->del(pobj_c->name);
						}
					}
				}
				else{
					//\bhǉ
					cp=i;	//G[p
					AddMemberSub(pobj_c,dwAccess,bStatic,bAbstract,bVirtual,bOverride,temporary,sub_address);

					if(bAbstract) continue;

					for(;;i++){
						if(basbuf[i]=='\0'){
							i--;
							break;
						}
						if(basbuf[i-1]!='*'&&
							basbuf[i]==1&&(
							basbuf[i+1]==ESC_SUB||
							basbuf[i+1]==ESC_FUNCTION||
							basbuf[i+1]==ESC_MACRO||
							basbuf[i+1]==ESC_TYPE||
							basbuf[i+1]==ESC_CLASS||
							basbuf[i+1]==ESC_INTERFACE||
							basbuf[i+1]==ESC_ENUM)){
							GetDefaultNameFromES(i3,temporary);
							SetError(22,temporary,i);
						}
						if(basbuf[i]==1&&basbuf[i+1]==GetEndXXXCommand((char)i3)){
							i+=2;
							break;
						}
					}
				}
			}
		}
	}
}

void CDBClass::GetObjectClassInfo(void){
	//[vp`FbNp̃NX
	pobj_LoopRefCheck=new CLoopRefCheck();

	//NX擾
	GetClass_recur(0);

	delete pobj_LoopRefCheck;
	pobj_LoopRefCheck=0;
}




//////////////////////
// Ce[^
//////////////////////

void CDBClass::Iterator_Reset(void){
	if(ppobj_IteClass) HeapDefaultFree(ppobj_IteClass);

	iIteMaxNum=0;
	iIteNextNum=0;
	ppobj_IteClass=(CClass **)HeapAlloc(hHeap,0,1);

	int i;
	for(i=0;i<MAX_CLASS_HASH;i++){
		if(pobj_ClassHash[i]){
			CClass *pobj_c;
			pobj_c=pobj_ClassHash[i];
			while(1){
				ppobj_IteClass=(CClass **)HeapReAlloc(hHeap,0,ppobj_IteClass,(iIteMaxNum+1)*sizeof(CClass *));
				ppobj_IteClass[iIteMaxNum]=pobj_c;
				iIteMaxNum++;

				if(pobj_c->pobj_NextClass==0) break;
				pobj_c=pobj_c->pobj_NextClass;
			}
		}
	}
}
BOOL CDBClass::Iterator_HasNext(void){
	if(iIteNextNum<iIteMaxNum) return 1;
	return 0;
}
CClass *CDBClass::Iterator_GetNext(void){
	CClass *pobj_c;
	pobj_c=ppobj_IteClass[iIteNextNum];
	iIteNextNum++;
	return pobj_c;
}
int CDBClass::Iterator_GetMaxCount(void){
	return iIteMaxNum;
}
