#include "common.h"


TypeDef::TypeDef( const NamespaceScopes &namespaceScopes, const string &name, const string &baseName )
	: namespaceScopes( namespaceScopes )
	, name( name )
	, baseName( baseName )
{
	if( !Type::StringToType( baseName, baseType ) ){
		SetError(3, baseName, cp );
		return;
	}
}
TypeDef::~TypeDef(){
}

bool TypeDef::IsEqualSymbol( const NamespaceScopes &namespaceScopes, const string &name ) const
{
	if( GetName() != name ){
		return false;
	}
	return NamespaceScopes::IsSameArea( this->namespaceScopes, namespaceScopes );
}
bool TypeDef::IsEqualSymbol( const string &fullName ) const
{
	char AreaName[VN_SIZE] = "";		//IuWFNgϐ
	char NestName[VN_SIZE] = "";		//qo
	bool isNest = SplitMemberName( fullName.c_str(), AreaName, NestName );

	if( IsEqualSymbol( NamespaceScopes( AreaName ), NestName ) ){
		return true;
	}

	if( isNest ){
		// ÓIol

		char AreaName2[VN_SIZE] = "";		//IuWFNgϐ
		char NestName2[VN_SIZE] = "";		//qo
		bool isNest = SplitMemberName( AreaName, AreaName2, NestName2 );
		lstrcat( NestName2, "." );
		lstrcat( NestName2, NestName );

		return IsEqualSymbol( NamespaceScopes( AreaName2 ), NestName2 );
	}

	return false;
}



TypeDefCollection::TypeDefCollection(){
}
TypeDefCollection::~TypeDefCollection(){
}
void TypeDefCollection::Add( const NamespaceScopes &namespaceScopes, const string &name, const string &baseName ){
	TypeDef typeDef( namespaceScopes, name, baseName );
	this->push_back( typeDef );
}
int TypeDefCollection::GetIndex( const NamespaceScopes &namespaceScopes, const string &name ) const{
	int max = (int)(*this).size();
	for( int i=0; i<max; i++ ){
		if( (*this)[i].IsEqualSymbol( namespaceScopes, name ) ){
			return i;
		}
	}
	return -1;
}
int TypeDefCollection::GetIndex( const string &fullName ) const{
	char AreaName[VN_SIZE] = "";		//IuWFNgϐ
	char NestName[VN_SIZE] = "";		//qo
	bool isNest = SplitMemberName( fullName.c_str(), AreaName, NestName );

	return GetIndex( NamespaceScopes( AreaName ), NestName );
}

void TypeDefCollection::Add( const NamespaceScopes &namespaceScopes, const string &expression, int nowLine ){
	int i;
	char temporary[VN_SIZE];

	for(i=0;;i++){
		if(expression[i]=='='||expression[i]=='\0'){
			temporary[i]=0;
			break;
		}
		temporary[i]=expression[i];
	}

	if(expression[i]!='='){
		SetError(10,"TypeDef",nowLine);
		return;
	}

	const char *pTemp=expression.c_str()+i+1;

	//ʕ̃G[`FbNiV^j
	i=0;
	for(;;i++){
		if(temporary[i]=='\0') break;
		if(!IsVariableChar(temporary[i])){
			SetError(10,"TypeDef",nowLine);
			return;
		}
	}

	//ʕ̃G[`FbNiRs[̌^j
	if(pTemp[0]=='*'&&pTemp[1]==1&&(pTemp[2]==ESC_FUNCTION||pTemp[2]==ESC_SUB)){
		//֐|C^
		if(pTemp[3]!='('){
			SetError(10,"TypeDef",nowLine);
			return;
		}
	}
	else{
		i=0;
		while(pTemp[i]=='*') i++;
		for(;;i++){
			if(pTemp[i]=='\0') break;
			if(!IsVariableChar(pTemp[i])){
				SetError(10,"TypeDef",nowLine);
				return;
			}
		}
	}

	//ʎqdĂꍇ̓G[ɂ
	if(lstrcmp(temporary,pTemp)==0){
		SetError(1,NULL,nowLine);
		return;
	}



	//////////////////////////
	// TypeDefǉ
	//////////////////////////

	//G[p
	extern int cp;
	cp = nowLine;

	Add( namespaceScopes, temporary, pTemp );
}

void TypeDefCollection::Init(){
	// 
	clear();

	// OԊǗ
	NamespaceScopes &namespaceScopes = Smoothie::Lexical::liveingNamespaceScopes;
	namespaceScopes.clear();

	// ImportsꂽOԂ̊Ǘ
	NamespaceScopesCollection &importedNamespaces = Smoothie::Temp::importedNamespaces;
	importedNamespaces.clear();

	int i=-1, i2;
	char temporary[VN_SIZE];
	while(1){
		extern char *basbuf;

		i++;

		if( basbuf[i] == 1 && basbuf[i+1] == ESC_NAMESPACE ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( basbuf[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=basbuf[i];
			}
			namespaceScopes.push_back( temporary );

			continue;
		}
		else if( basbuf[i] == 1 && basbuf[i+1] == ESC_ENDNAMESPACE ){
			if( namespaceScopes.size() <= 0 ){
				SetError(12, "End Namespace", i );
			}
			else{
				namespaceScopes.pop_back();
			}

			i += 2;
			continue;
		}
		else if( basbuf[i] == 1 && basbuf[i+1] == ESC_IMPORTS ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( basbuf[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=basbuf[i];
			}
			if( !importedNamespaces.Imports( temporary ) )
			{
				SetError(64,temporary,cp );
			}

			continue;
		}
		else if( basbuf[i] == 1 && basbuf[i+1] == ESC_CLEARNAMESPACEIMPORTED ){
			importedNamespaces.clear();
			continue;
		}

		if( basbuf[i]==1 ){
			char temporary[VN_SIZE];
			if(basbuf[i+1]==ESC_TYPEDEF){
				int i2 = 0;
				for(i+=2;;i2++,i++){
					if(basbuf[i]=='\n'){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
					if(basbuf[i]=='\0') break;
				}
				Add( namespaceScopes, temporary, i );

				continue;
			}
			else if( basbuf[i+1] == ESC_CONST && basbuf[i+2] == 1 && basbuf[i+3] == ESC_ENUM ){
				int i2 = 0;
				for(i+=4;;i2++,i++){
					if(!IsVariableChar(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
					if(basbuf[i]=='\0') break;
				}
				Add( namespaceScopes, temporary, "Long" );
			}
		}

		//̍s
		for(;;i++){
			if(IsCommandDelimitation(basbuf[i])) break;
		}
		if(basbuf[i]=='\0') break;
	}
}
