#include "../common.h"


NamespaceScopes::NamespaceScopes( const string &namespaceStr ){
	if( namespaceStr.size() == 0 ){
		return;
	}

	string::size_type i = 0;
	while( true ){
		string::size_type i2 = namespaceStr.find( '.', i );

		string tempName = namespaceStr.substr( i, i2-i );

		push_back( tempName );

		if( i2 == string::npos ){
			break;
		}

		i = i2 + 1;
	}
}

bool NamespaceScopes::IsImported() const
{
	BOOST_FOREACH( const NamespaceScopes &namespaceScopes, Smoothie::Temp::importedNamespaces ){
		if( this->IsEqual( namespaceScopes ) ){
			return true;
		}
	}
	return false;
}
bool NamespaceScopes::IsLiving() const
{
	if( IsBelong( *this, Smoothie::Lexical::liveingNamespaceScopes ) ){
		return true;
	}
	return false;
}

// Ă邩`FbN
// :
// this =   "Discoversoft.ActiveBasic"
// living = "Discoversoft.ActiveBasic"
// name =   "ActiveBasic"
// ̏ꍇAliving  name ĂB
bool NamespaceScopes::IsCoverd( const string &name ) const
{
	if( IsEqual( name ) ){
		return true;
	}

	string thisStr = ToString();

	NamespaceScopes tempLivingNamespaceScopes = Smoothie::Lexical::liveingNamespaceScopes;

	while( tempLivingNamespaceScopes.size() ){
		NamespaceScopes tempNamespaceScopes = tempLivingNamespaceScopes;

		string tempStr = tempNamespaceScopes.ToString() + "." + name;
		if( thisStr == tempStr ){
			return true;
		}

		tempLivingNamespaceScopes.pop_back();
	}
	return false;
}
bool NamespaceScopes::IsCoverd( const NamespaceScopes &namespaceScopes ) const
{
	return IsCoverd( namespaceScopes.ToString() );
}


void NamespaceScopesCollection::SplitNamespace( const char *fullName, char *namespaceStr, char *simpleName ) const
{
	NamespaceScopes namespaceScopes( fullName );
	bool hasSimpleName = false;
	while( namespaceScopes.size() > 0 ){
		if( IsExist( namespaceScopes ) ){
			break;
		}
		namespaceScopes.pop_back();

		hasSimpleName = true;
	}

	lstrcpy( namespaceStr, namespaceScopes.ToString().c_str() );

	bool hasNamespace = false;
	if( namespaceStr[0] ){
		hasNamespace = true;
	}

	int dotLength = 0;
	if( hasSimpleName && hasNamespace ){
		dotLength = 1;
	}

	lstrcpy( simpleName, fullName + lstrlen( namespaceStr ) + dotLength );
}
bool NamespaceScopesCollection::Imports( const string &namespaceStr ){
	NamespaceScopes namespaceScopes( namespaceStr );
	if( !Smoothie::meta.namespaceScopesCollection.IsExist( namespaceScopes ) ){
		return false;
	}

	this->push_back( namespaceScopes );

	return true;
}
bool NamespaceScopesCollection::CollectNamespaces( const char *source, NamespaceScopesCollection &namespaceScopesCollection )
{
	int i, i2;
	char temporary[VN_SIZE];

	bool isSuccessful = true;

	// OԊǗ
	NamespaceScopes namespaceScopes;

	for(i=0;;i++){
		if(source[i]=='\0') break;

		if( source[i] == 1 && source[i+1] == ESC_NAMESPACE ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( source[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}
			namespaceScopes.push_back( temporary );

			if( !namespaceScopesCollection.IsExist( namespaceScopes ) ){
				namespaceScopesCollection.push_back( namespaceScopes );
			}

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_ENDNAMESPACE ){
			if( namespaceScopes.size() <= 0 ){
				SetError(12, "End Namespace", i );
				isSuccessful = false;
			}
			else{
				namespaceScopes.pop_back();
			}

			i += 2;
			continue;
		}
	}

	if( namespaceScopes.size() > 0 ){
		SetError(63,NULL,-1);
		isSuccessful = false;
	}

	return isSuccessful;
}
