#include <Program.h>

#include "../BasicCompiler_Common/common.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif


void Diagnose(){
	char temporary[8192];

	{
		///////////////////////////////////////////////////////////////////
		// O[o / [J R[ḧ̃TCY𒲂ׂ
		///////////////////////////////////////////////////////////////////

		extern int obp;
		extern int GlobalOpBufferSize;
		sprintf(temporary, "%d", GlobalOpBufferSize/1024 );
		trace_for_size( (string)"O[ö̃R[hTCY: " + temporary + "KB" );
		sprintf(temporary, "%d", (obp-GlobalOpBufferSize)/1024 );
		trace_for_size( (string)"[J̈̃R[hTCY: " + temporary + "KB" );
		sprintf(temporary, "%d", obp/1024 );
		trace_for_size( (string)"R[hTCY: " + temporary + "KB" );
	}

	{
		///////////////////////////////////////////////////////////////////
		// O[o֐ANX\bh̃TCY𒲂ׂ
		///////////////////////////////////////////////////////////////////

		int codeSizeOfGlobalProc = 0;
		int codeSizeOfClassMethod = 0;
		for(int i2=0;i2<MAX_HASH;i2++){
			extern GlobalProc **ppSubHash;
			GlobalProc *pUserProc = ppSubHash[i2];
			while(pUserProc){
				if( pUserProc->IsCompiled() ){
					if( pUserProc->HasParentClass() ){
						codeSizeOfClassMethod += pUserProc->GetCodeSize();
					}
					else{
						codeSizeOfGlobalProc += pUserProc->GetCodeSize();
					}
				}

				pUserProc=pUserProc->pNextData;
			}
		}

		sprintf(temporary, "%d", codeSizeOfGlobalProc/1024 );
		trace_for_size( (string)"O[o֐̃R[hTCY: " + temporary + "KB" );
		sprintf(temporary, "%d", codeSizeOfClassMethod/1024 );
		trace_for_size( (string)"NX\bh̃R[hTCY: " + temporary + "KB" );
	}

	{
		///////////////////////////////////////////////////////////////////
		// EnumɕKvȂ̃R[hTCY𒲂ׂ
		///////////////////////////////////////////////////////////////////
		int codeSizeOfEnum = 0;

		// Ce[^Zbg
		extern Classes *pobj_DBClass;
		pobj_DBClass->Iterator_Reset();

		while( pobj_DBClass->Iterator_HasNext() ){
			int codeSizeOfClass = 0;

			CClass &objClass = *pobj_DBClass->Iterator_GetNext();

			if( !objClass.IsEnum() ){
				// 񋓌^ȊO͖
				continue;
			}

			// I\bh
			foreach( const CMethod *pMethod, objClass.GetMethods() ){
				if( pMethod->pUserProc->IsCompiled() ){
					codeSizeOfClass += pMethod->pUserProc->GetCodeSize();
				}
			}

			// ÓI\bh
			foreach( const CMethod *pMethod, objClass.GetStaticMethods() ){
					codeSizeOfClass += pMethod->pUserProc->GetCodeSize();
			}

			codeSizeOfEnum += codeSizeOfClass;
		}

		sprintf(temporary, "%d", codeSizeOfEnum/1024 );
		trace_for_size( (string)"Enum̃R[hTCY: " + temporary + "KB" );
	}

	trace_for_size( "\n\n" );

	{
		///////////////////////////////////////////////////////////////////
		// NX̃TCY𒲂ׂ
		///////////////////////////////////////////////////////////////////

		// Ce[^Zbg
		extern Classes *pobj_DBClass;
		pobj_DBClass->Iterator_Reset();

		while( pobj_DBClass->Iterator_HasNext() ){
			int codeSizeOfClass = 0;

			CClass &objClass = *pobj_DBClass->Iterator_GetNext();

			// I\bh
			foreach( const CMethod *pMethod, objClass.GetMethods() ){
				if( pMethod->pUserProc->IsCompiled() ){
					codeSizeOfClass += pMethod->pUserProc->GetCodeSize();
				}
			}

			// ÓI\bh
			foreach( const CMethod *pMethod, objClass.GetStaticMethods() ){
					codeSizeOfClass += pMethod->pUserProc->GetCodeSize();
			}

			if( codeSizeOfClass ){
				temporary[0]=0;
				lstrcat( temporary, "------------------------------------------------------------------\n" );
				sprintf( temporary + lstrlen(temporary), "y %s NX̃R[hz\n", objClass.GetName().c_str() );
				sprintf( temporary + lstrlen(temporary), "class code size: %d bytes\n", codeSizeOfClass );
				lstrcat( temporary, "------------------------------------------------------------------\n" );
				lstrcat( temporary, "\n" );
				trace_for_size( temporary );
			}
		}
	}
}
