#include "common.h"

void StepCompileProgress(void){
	extern HWND hMainDlg;
	PostMessage(GetDlgItem(hMainDlg,IDC_PROGRESS),PBM_STEPIT,0,0);
}

void Delete_ci(CONSTINFO *pci){
	int i;

	HeapDefaultFree(pci->name);
	if(pci->StrValue) HeapDefaultFree(pci->StrValue);
	if(pci->ParmNum){
		for(i=0;i<pci->ParmNum;i++)
			HeapDefaultFree(pci->ppParm[i]);
		HeapDefaultFree(pci->ppParm);
	}

	if(pci->pNextData){
		Delete_ci(pci->pNextData);
	}

	HeapDefaultFree(pci);
}
void DeleteConstInfo(CONSTINFO **ppConstHash){
	int i;

	for(i=0;i<MAX_HASH;i++){
		if(ppConstHash[i]){
			Delete_ci(ppConstHash[i]);
		}
	}
	HeapDefaultFree(ppConstHash);
}

void AddSourceCode(char *buffer){
	char *temp;
	temp=(char *)HeapAlloc(hHeap,0,lstrlen(buffer)+8192);
	lstrcpy(temp,buffer);

	//GXP[vV[PXݒ
	SetEscapeSequenceFormat(temp);

	//R}hΉ
	ChangeCommandToCode(temp);

	//Ōɓ\t
	Smoothie::Lexical::source.Addition( temp );

	HeapDefaultFree(temp);
}

void OutputExe(void){
	extern HANDLE hHeap;
	extern char *basbuf;
	extern int ErrorNum;
	extern BOOL bStopCompile;
	extern HWND hMainDlg;
	int i2,i3;
	char temp2[MAX_PATH];

	//vOXo[̐ݒ
	PostMessage(GetDlgItem(hMainDlg,IDC_PROGRESS),PBM_SETRANGE,0,MAKELPARAM(0,6));
	PostMessage(GetDlgItem(hMainDlg,IDC_PROGRESS),PBM_SETSTEP,1,0);

	//"f"
	SetDlgItemText(hMainDlg,IDOK,STRING_STOP);

	//ftO
	bStopCompile=0;

	//TuVXẽ^Cv
	extern unsigned short TypeOfSubSystem;
	TypeOfSubSystem=IMAGE_SUBSYSTEM_WINDOWS_GUI;

	//vOt@Cǂݍ
	extern char SourceFileName[MAX_PATH];
	if( !Smoothie::Lexical::source.ReadFile( SourceFileName ) ){
		SetError(201,SourceFileName,-1);
		goto EndCompile;
	}

	//C[Wx[X̐ݒ
	extern DWORD ImageBase;
	extern BOOL bDll;
	if(bDll) ImageBase=0x10000000;
	else ImageBase=0x00400000;

	extern BOOL bError;
	if(bError||bStopCompile) goto EndCompile;


	//////////////////////////
	// ԃR[h̐Jn
	extern BOOL bClipCompileView;

	//"œK..."
	CompileMessage(STRING_COMPILE_OPTIMIZING);

	//JbR𑊌݃`FbNi_uNH[g`FbN`FbN܂ށj
	CheckParenthesis(basbuf);

	if(bError||bStopCompile) goto EndCompile;

	//RpC_CAÕvOXo[グ
	StepCompileProgress();

	//fBNeBu
	DirectiveCheck();

	//Nextߌ𐳋K\ɕϊ
	//NextCommandFormat(basbuf);

	//GXP[vV[PXݒ
	SetEscapeSequenceFormat(basbuf);

	//DefߌFunctionߌɕϊ
	DefCommandFormat(basbuf);

	//ׂĂIfߌubN`ɕϊ
	IfCommandFormat(basbuf);

	//΂ɂȂ閽ߌ𑊌݃`FbN
	//CheckPareCommand();

	if(bError||bStopCompile) goto EndCompile;

	/*
	//萔Ɋւ
	extern CONSTINFO **ppConstHash;
	ppConstHash=(CONSTINFO **)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,MAX_HASH*sizeof(CONSTINFO *));
	*/

	//RpC_CAÕvOXo[グ
	StepCompileProgress();

	//dG[Ǘ̃m
	extern char **SynonymErrorWords;
	extern int SynonymErrorNum;
	SynonymErrorNum=0;
	SynonymErrorWords=(char **)HeapAlloc(hHeap,0,1);

	ChangeCommandToCode(basbuf);

	//dG[Ǘ̃
	for(i3=0;i3<SynonymErrorNum;i3++) HeapDefaultFree(SynonymErrorWords[i3]);
	HeapDefaultFree(SynonymErrorWords);
	SynonymErrorWords=0;

	if(bError||bStopCompile){
		//萔Ɋւ
		goto EndCompile;
	}

	StepCompileProgress();


	///////////////////////
	// RpCJn

	//"RpC..."
	CompileMessage(STRING_COMPILE_COMPILING);

	//O[oϐɊւ
	extern int AllGlobalVarSize;
	extern int AllInitGlobalVarSize;
	globalVars.clear();
	AllGlobalVarSize=0;
	AllInitGlobalVarSize=0;


	/*
	int t,t2;
	t=GetTickCount();
	Compile();
	t2=GetTickCount();
	t2-=t;
	char s[100];
	sprintf(s,"%d",t2);
	MessageBox(0,s,"test",0);*/
	Compile();

	//\[X
	extern RESOURCEDATAINFO *pCursorResourceInfo;
	extern RESOURCEDATAINFO *pIconResourceInfo;
	extern RESOURCEDATAINFO *pBitmapResourceInfo;
	HeapDefaultFree(pCursorResourceInfo);
	HeapDefaultFree(pBitmapResourceInfo);
	HeapDefaultFree(pIconResourceInfo);

	//R[hƍsԍ̊֌W
	extern LINEINFO *pLineInfo;
	HeapDefaultFree(pLineInfo);

	//Tu[`i[U[`j̃
	extern GlobalProc **ppSubHash;
	extern char **ppMacroNames;
	extern int MacroNum;
	DeleteSubInfo(ppSubHash,ppMacroNames,MacroNum);

	//DeclareiDLL֐j̃
	DeleteDeclareInfo();

	//֐|C^̃
	DeleteProcPtrInfo();

	//萔Ɋւ
	extern CONSTINFO **ppConstHash;
	DeleteConstInfo(ppConstHash);

	//RpC_CAÕvOXo[グ
	StepCompileProgress();


	//////////////////////////
	// I
EndCompile:
	if(bStopCompile){
		PostMessage(GetDlgItem(hMainDlg,IDC_PROGRESS),PBM_SETPOS,0,0);

		//"RpC̓[U[ɂ蒆f܂B"
		CompileMessage(STRING_COMPILE_STOP);
	}
	else{
		extern int CompileMsgNum;
		extern int WarningNum;
		if(bError==0){
			//"RpC͐Ɋ܂iG[:%dAx:%dj"
			sprintf(temp2,STRING_COMPILE_SUCCESS,ErrorNum-CompileMsgNum-WarningNum,WarningNum);
		}
		else{
			//"RpC͒f܂iG[:%dAx:%dj"
			sprintf(temp2,STRING_COMPILE_ERROR,ErrorNum-CompileMsgNum-WarningNum,WarningNum);
		}

		CompileMessage("");
		CompileMessage("-----------------------------------------------------");
		CompileMessage(temp2);
	}

	//""
	SetDlgItemText(hMainDlg,IDOK,STRING_CLOSE);

#ifdef _DEBUG
	// fobO[ĥƂ̓_CAOBĂ
	ShowWindow(hMainDlg,SW_SHOW);
#endif

	//#include
	extern INCLUDEFILEINFO IncludeFileInfo;
	for(i2=0;i2<IncludeFileInfo.FilesNum;i2++)
		HeapDefaultFree(IncludeFileInfo.ppFileNames[i2]);
	HeapDefaultFree(IncludeFileInfo.ppFileNames);
}
int MainThread(DWORD dummy){
	extern BOOL bDebugCompile;
	extern BOOL bDebugRun;
	extern int bError;

	if(bDebugRun){
		if(bDebugCompile){
			bDebugRun=0;

			//fobORpC
			OutputExe();

			bDebugRun=1;
		}

		//fobOs
		if(bError==0) DebugProgram();
	}
	else{
		//[XRpC
		OutputExe();
	}

	return 0;
}
