#include <Program.h>

#include "common.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif

#define OVERLOAD_MIN_LEVEL 0
#define OVERLOAD_MAX_LEVEL 6
#define OVERLOAD_LEVEL0 0		// ^ȂBɓ
#define OVERLOAD_LEVEL1 1		// ^ȂBx1ȏ̓IuWFNg̏ꍇ͔h֌Wl
#define OVERLOAD_LEVEL2 2		// ^ȂB^/^xł̓ꐫ`FbNiTCYƍj
#define OVERLOAD_LEVEL3 3		// ^ȂB^/^xł̓ꐫ`FbN
#define OVERLOAD_LEVEL4 4		// ^Bɓ
#define OVERLOAD_LEVEL5 5		// ^B^/^xł̓ꐫ`FbN
#define OVERLOAD_LEVEL6 6		// ^Bl^/NX^xł̓ꐫ`FbN

ParamImpl::ParamImpl(const char *buffer):
	returnType()
{
	///////////////////////////
	// p[^𐮗
	///////////////////////////

	extern HANDLE hHeap;
	int i,i2,i3;
	char temporary[VN_SIZE];

	i=0;
	ParmsNum=0;
	while(1){
		if(buffer[i]=='\0') break;

		for(i2=0;;i2++,i++){
			if(buffer[i]=='\"'){
				temporary[i2]=buffer[i];
				for(i++,i2++;;i++,i2++){
					temporary[i2]=buffer[i];
					if(buffer[i]=='\"') break;
				}
				continue;
			}

			if(buffer[i]=='('){
				i3=GetStringInPare(temporary+i2,buffer+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(buffer[i]=='['){
				i3=GetStringInBracket(temporary+i2,buffer+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}

			if(buffer[i]==','||buffer[i]=='\0'){
				temporary[i2]=0;
				break;
			}
			temporary[i2]=buffer[i];
		}

		Parms[ParmsNum]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
		lstrcpy(Parms[ParmsNum],temporary);
		ParmsNum++;

		types.push_back( Type() );

		if(buffer[i]==',') i++;
	}
}
ParamImpl::ParamImpl(const Parameters &params):
	returnType()
{
	ParmsNum = 0;
	foreach( Parameter *pParam, params ){
		Parms[ParmsNum]=0;
		ParmsNum++;

		types.push_back( *pParam );
	}
}
ParamImpl::~ParamImpl(){
	int i2;

	//p[^
	for(i2=0;i2<ParmsNum;i2++){
		if(Parms[i2]==(char *)-1) continue;

		if(Parms[i2]) HeapDefaultFree(Parms[i2]);
	}
}

void ParamImpl::SetReturnType( const Type &returnType ){
	this->returnType = returnType;
}

bool ParamImpl::EvaluateOverloadScore( int level, const Parameters &targetParms, const Type &targetResultType ){
	//p[^ʂăI[o[[h

	//p[^̌sv̏ꍇ
	int max = (int)targetParms.size();

	if( ParmsNum > max ){
		// 葽Ƃ
		// ŕsv
		return false;
	}

	Type argType;
	for(int i=0;i<max;i++){
		Parameter &param = *targetParms[i];

		if( i >= ParmsNum ){
			// Ƃ
			if( param.GetInitValue().size() > 0 ){
				// lw肳Ăp[^l
				return true;
			}
			else{
				return false;
			}
		}

		if(Parms[i]){
			Type nullParam( DEF_NON );

			NumOpe_GetType(Parms[i],
				( level <= OVERLOAD_LEVEL3 )? nullParam : param,
				argType);
		}
		else{
			argType = types[i];
		}

		if(argType.GetBasicType()!=param.GetBasicType()){
			if( level == OVERLOAD_LEVEL0 || level == OVERLOAD_LEVEL1 || level==OVERLOAD_LEVEL4 ){
				return false;
			}
			else if( level == OVERLOAD_LEVEL2 ){
				if( !(argType.IsWhole() && param.IsWhole() && argType.GetBasicSize() == param.GetBasicSize() ) ){
					// TCYႢ
					return false;
				}
			}
			else if( level == OVERLOAD_LEVEL3 || level==OVERLOAD_LEVEL5){
				if(!(
					argType.IsWhole()&&param.IsWhole()||
					argType.IsReal()&&param.IsReal()
					)){
						return false;
				}
				if( argType.IsPointer() || param.IsPointer() )
				{
					// |C^^̕s͔F߂Ȃ
					return false;
				}
			}
			else if(level==OVERLOAD_LEVEL6){
				if(argType.IsObject()||param.IsObject()) return false;
			}
		}
		else{
			//if(NATURAL_TYPE(argType.GetBasicType())==DEF_OBJECT || NATURAL_TYPE(argType.GetBasicType())==DEF_STRUCT){
			if( NATURAL_TYPE(argType.GetBasicType())==DEF_STRUCT){
				if(argType.GetIndex()!=param.GetIndex()){
					return false;
				}
			}
			else if( NATURAL_TYPE(argType.GetBasicType())==DEF_OBJECT ){
				if( level == OVERLOAD_LEVEL0 ){
					if( !param.GetClass().IsEquals( &argType.GetClass() ) ){
						return false;
					}
				}
				else{
					if( !param.GetClass().IsEqualsOrSubClass( &argType.GetClass() ) ){
						return false;
					}
				}
			}
		}
	}

	if( !targetResultType.IsNull() ){
		//߂lrΏۂɂ
		if( !returnType.Equals( targetResultType ) ){
			return false;
		}
	}

	return true;
}

UserProc *ParamImpl::_OverloadSolution( const char *name, std::vector<UserProc *> &subs, bool isEnabledReturnType ){
	int sw=0;
	UserProc *pUserProc;
	pUserProc=0;

	for( int level=OVERLOAD_MIN_LEVEL; level<=OVERLOAD_MAX_LEVEL; level++ ){

		foreach( UserProc *pTempUserProc, subs ){

			if(EvaluateOverloadScore( level, pTempUserProc->Params(), isEnabledReturnType?pTempUserProc->ReturnType():Type() )){
				trace_for_overload( "x" << level <<	" K..." << pTempUserProc->_paramStr );

				if(sw){
					if( isEnabledReturnType ){
						SetError(52,name,cp);

						return 0;
					}
					else{
						// ߂lr郂[hɂčĂуI[o[[h݂

						trace_for_overload( "߂lr郂[hɐ؂ւăI[o[[h݂" );

						return OverloadSolution(name,subs, true);
					}
				}
				sw=1;

				pUserProc = pTempUserProc;
			}
			else
			{
				trace_for_overload( "x" << level <<	" ~sK..." << pTempUserProc->_paramStr );
			}
		}

		if( sw ) break;
	}

	if(!sw){
		foreach( UserProc *pTempUserProc, subs ){

			//G[`FbN
			if(pTempUserProc->Params().size()==this->ParmsNum){
				if(sw){
					sw=0;
					break;
				}
				sw=1;

				pUserProc=pTempUserProc;
			}
		}
	}

	if(!sw){
		SetError(52,name,cp);

		return 0;
	}


	return pUserProc;
}
UserProc *ParamImpl::OverloadSolution( const char *name, std::vector<UserProc *> &subs, bool isEnabledReturnType ){
	trace_for_overload( "" );
	trace_for_overload( "" );
	trace_for_overload( " I[o[[h(" << name << ")" );

	UserProc *result = _OverloadSolution( name, subs, isEnabledReturnType );

	trace_for_overload( " ܂" );
	trace_for_overload( "" );
	trace_for_overload( "" );

	return result;
}

void ParamImpl::ApplyDefaultParameters( const Parameters &params ){
	if( ParmsNum == (int)params.size() ){
		// ftHg̓KpsKvȂƂ
		return;
	}

	while( ParmsNum < (int)params.size() ){
		Parameter &param = *params[ParmsNum];

		Parms[ParmsNum]=(char *)HeapAlloc(hHeap,0,param.GetInitValue().size() + 1 );
		lstrcpy(Parms[ParmsNum],param.GetInitValue().c_str() );
		ParmsNum++;
	}
}

bool ParamImpl::ErrorCheck( const string &procName, const Parameters &params, int SecondParmNum ){
	if( SecondParmNum == -1 ) SecondParmNum = (int)params.size();

	if(ParmsNum>(int)params.size() && params.size() != 0){
		if(params[params.size()-1]->GetBasicType()!=DEF_ELLIPSE){
			//p[^Ƃ
			SetError(10,procName,cp);
			return false;
		}
	}
	else if(ParmsNum<(int)params.size()){
		if(ParmsNum<SecondParmNum){
			if(params[ParmsNum]->GetBasicType()==DEF_ELLIPSE){
				return true;
			}

			//p[^ȂƂ
			SetError(10,procName,cp);
			return false;
		}

		//ȗp[^ "0" w肷
		for(;ParmsNum < (int)params.size();ParmsNum++){
			extern HANDLE hHeap;
			char temporary[64];
			if(params[ParmsNum]->IsRef() == false) lstrcpy(temporary,"0");
			else sprintf(temporary,"%c%c0",1,ESC_BYVAL);
			Parms[ParmsNum]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
			lstrcpy(Parms[ParmsNum],temporary);
		}
	}

	return true;
}

void ParamImpl::MacroParameterSupport( const Parameters &params ){
	for(int i=0;i<ParmsNum;i++){
		if(Parms[i][0]=='\0'){
			extern HANDLE hHeap;
			char temporary[64];
			if( params[i]->IsRef() == false ) lstrcpy(temporary,"0");
			else sprintf(temporary,"%c%c0",1,ESC_BYVAL);
			HeapDefaultFree(Parms[i]);
			Parms[i]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
			lstrcpy(Parms[i],temporary);
		}
	}
}
