#include "Common.h"

#if defined(JPN)
//{
#include "pj_msg_jpn.h"
#else
//p
#include "pj_msg_eng.h"
#endif

int GetWndInfoNum(char *name){
	extern PROJECTINFO ProjectInfo;
	int i;
	for(i=0;i<ProjectInfo.NumberOfWindows;i++){
		if(lstrcmpi(name,ProjectInfo.pWindowInfo[i].name)==0) return i;
	}
	return -1;
}
void ChangeDivisionToOrSign(char *CopyBuffer,const char *ReadBuffer){
	int i,i2;
	for(i=0,i2=0;;i++,i2++){
		if(ReadBuffer[i]=='|'){
			CopyBuffer[i2]=0;
			lstrcpy(CopyBuffer+i2," or ");
			i2+=3;
			continue;
		}
		CopyBuffer[i2]=ReadBuffer[i];
		if(ReadBuffer[i]=='\0') break;
	}
}
void ChangeOrSignToDivision(char *CopyBuffer,const char *ReadBuffer){
	int i,i2,IsStr;
	for(i=0,i2=0,IsStr=0;;i++,i2++){
		if(ReadBuffer[i]=='\"') IsStr^=1;
		if(ReadBuffer[i]=='\0'){
			CopyBuffer[i2]=0;
			break;
		}
		if(ReadBuffer[i+3]=='\0'){
			memcpy(CopyBuffer+i2,ReadBuffer+i,3);
			CopyBuffer[i2+3]=0;
			break;
		}
		if((ReadBuffer[i]==' '||ReadBuffer[i]=='\t')&&
			(ReadBuffer[i+1]=='O'||ReadBuffer[i+1]=='o')&&(ReadBuffer[i+2]=='R'||ReadBuffer[i+2]=='r')&&
			(ReadBuffer[i+3]==' '||ReadBuffer[i+3]=='\t')&&IsStr==0){
			CopyBuffer[i2]='|';
			i+=3;
			continue;
		}
		CopyBuffer[i2]=ReadBuffer[i];
	}
}

HGLOBAL Rad_GetChildInfoClipboardData(int WndNum,int WndInfoNum){
	//CHILDINFO\̂Nbv{[hpf[^ipByteobt@jɕϊ
	extern PROJECTINFO ProjectInfo;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	HGLOBAL hGlobal;
	BYTE *pByte;
	int i2,i3,MemSize;
	CHILDINFO *pChildInfo;

	for(i3=0;;i3++){
		if(MdiInfo[WndNum].MdiRadInfo->SelectingItem[i3]==-1) break;
	}
	

	hGlobal=GlobalAlloc(GMEM_MOVEABLE,sizeof(int));
	pByte=(BYTE *)GlobalLock(hGlobal);
	*((int *)pByte)=i3;
	GlobalUnlock(hGlobal);
	i2=sizeof(int);

	MemSize=i2;

	for(i3--;i3>=0;i3--){
		pChildInfo=&ProjectInfo.pWindowInfo[WndInfoNum].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[i3]];

		MemSize+=lstrlen(pChildInfo->IdName)+1+
			sizeof(POINT)+
			sizeof(SIZE)+
			lstrlen(pChildInfo->caption)+1+
			sizeof(DWORD)+
			sizeof(DWORD)+
			sizeof(int)+
			sizeof(int)+
			lstrlen(pChildInfo->ImageCtrlInfo.path)+1;

		hGlobal=GlobalReAlloc(hGlobal,MemSize,0);
		pByte=(BYTE *)GlobalLock(hGlobal);

		lstrcpy((char *)pByte+i2,pChildInfo->IdName);
		i2+=lstrlen(pChildInfo->IdName)+1;

		memcpy(pByte+i2,&pChildInfo->pos,sizeof(POINT));
		i2+=sizeof(POINT);

		memcpy(pByte+i2,&pChildInfo->size,sizeof(SIZE));
		i2+=sizeof(SIZE);

		lstrcpy((char *)pByte+i2,pChildInfo->caption);
		i2+=lstrlen(pChildInfo->caption)+1;

		memcpy(pByte+i2,&pChildInfo->style,sizeof(DWORD));
		i2+=sizeof(DWORD);

		memcpy(pByte+i2,&pChildInfo->ExStyle,sizeof(DWORD));
		i2+=sizeof(DWORD);

		memcpy(pByte+i2,&pChildInfo->Control,sizeof(int));
		i2+=sizeof(int);

		memcpy(pByte+i2,&pChildInfo->ImageCtrlInfo.type,sizeof(int));
		i2+=sizeof(int);

		if(!pChildInfo->ImageCtrlInfo.path){
			lstrcpy((char *)pByte+i2,"");
			i2++;
		}
		else{
			lstrcpy((char *)pByte+i2,pChildInfo->ImageCtrlInfo.path);
			i2+=lstrlen(pChildInfo->ImageCtrlInfo.path)+1;
		}

		GlobalUnlock(hGlobal);
	}

	return hGlobal;
}
void Rad_PasteChildInfoClipboardData(int WndNum,HGLOBAL hGlobal){
	//hGlobalɊi[ĂNbv{[hf[^RADʂɑ}
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	BYTE *pByte;
	int i2,i3,WndInfoNum;
	CHILDINFO ChildInfo;
	char temporary[255];

	for(i2=1;i2<MAX_RAD_SELITEM;i2++) MdiInfo[WndNum].MdiRadInfo->SelectingItem[i2]=-1;

	WndInfoNum=GetWndInfoNum(MdiInfo[WndNum].path);
	pByte=(BYTE *)GlobalLock(hGlobal);
	i3=*((int *)pByte);
	i2=sizeof(int);

	for(i3--;i3>=0;i3--){
		//IdNameo͕ύX\
		ChildInfo.IdName=(char *)temporary;
		lstrcpy(ChildInfo.IdName,(char *)pByte+i2);
		i2+=lstrlen(ChildInfo.IdName)+1;

		memcpy(&ChildInfo.pos,pByte+i2,sizeof(POINT));
		i2+=sizeof(POINT);

		memcpy(&ChildInfo.size,pByte+i2,sizeof(SIZE));
		i2+=sizeof(SIZE);

		ChildInfo.caption=(char *)pByte+i2;
		i2+=lstrlen(ChildInfo.caption)+1;

		memcpy(&ChildInfo.style,pByte+i2,sizeof(DWORD));
		i2+=sizeof(DWORD);

		memcpy(&ChildInfo.ExStyle,pByte+i2,sizeof(DWORD));
		i2+=sizeof(DWORD);

		memcpy(&ChildInfo.Control,pByte+i2,sizeof(int));
		i2+=sizeof(int);

		memcpy(&ChildInfo.ImageCtrlInfo.type,pByte+i2,sizeof(int));
		i2+=sizeof(int);

		ChildInfo.ImageCtrlInfo.path=(char *)pByte+i2;
		if(lstrlen(ChildInfo.ImageCtrlInfo.path)==0){
			ChildInfo.ImageCtrlInfo.path=0;
			i2++;
		}
		else i2+=lstrlen(ChildInfo.ImageCtrlInfo.path)+1;

		ChildInfo.pos.x+=17;
		ChildInfo.pos.y+=10;

		MdiInfo[WndNum].MdiRadInfo->SelectingItem[i3]=InsertDlgItem(WndNum,
			WndInfoNum,
			-1,
			&ChildInfo.pos,
			&ChildInfo.size,
			ChildInfo.IdName,
			ChildInfo.caption,
			ChildInfo.style,
			ChildInfo.ExStyle,
			ChildInfo.Control,
			ChildInfo.ImageCtrlInfo.type,
			ChildInfo.ImageCtrlInfo.path,
			2);
	}

	GlobalUnlock(hGlobal);

	ChangePropertyWindow(WndNum,WndInfoNum);
}

char *FormatCaption(char *caption){
	extern HANDLE hHeap;
	int i2,i3,BufSize;
	char *buffer;

	BufSize=256*2;
	buffer=(char *)HeapAlloc(hHeap,0,BufSize);
	for(i2=0,i3=0;;i2++,i3++){
		if(i2+256>=BufSize){
			BufSize+=256;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufSize);
		}
		if(caption[i3]=='\"'){
			lstrcpy(buffer+i2,"\"+Chr$(34)+\"");
			i2+=lstrlen(buffer+i2);
			i2--;
			continue;
		}
		buffer[i2]=caption[i3];
		if(caption[i3]=='\0') break;
	}

	return buffer;
}
char *SetCaptionSequence(char *caption){
	extern HANDLE hHeap;
	int i2,i3,BufSize;
	char *buffer;

	BufSize=256*2;
	buffer=(char *)HeapAlloc(hHeap,0,BufSize);
	for(i2=0,i3=0;;i2++,i3++){
		if(i2+256>=BufSize){
			BufSize+=256;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufSize);
		}
		buffer[i2]=caption[i3];
		if(caption[i3]=='\"'){
			buffer[i2++]='\\';
			buffer[i2]='1';
		}
		else if(caption[i3]=='\\'){
			buffer[i2++]='\\';
			buffer[i2]='\\';
		}
		else if(caption[i3]=='\0') break;
	}

	return buffer;
}
void RestoreCaptionSequence(char *caption){
	int i2,i3;

	for(i2=0,i3=0;;i2++,i3++){
		caption[i2]=caption[i3];
		if(caption[i3]=='\\'){
			i3++;
			if(caption[i3]=='1') caption[i2]='\"';
			else caption[i2]=caption[i3];
		}
		else if(caption[i3]=='\0') break;
	}
}

//ev[g\[Xt@CɒlZbg
char *PermutationWndPgmTemplate(char *pBuf,char *pPjName, char *pWndName, char *pHandleName, char *pProcName){
	extern HANDLE hHeap;
	int i,i2;

	for(i=0;;i++){
		if(pBuf[i]=='\0') break;
		if(memicmp(pBuf+i,"#name#",6)==0){
			//vWFNgu
			i2=lstrlen(pPjName);
			if(i2>6) pBuf=(char *)HeapReAlloc(hHeap,HEAP_ZERO_MEMORY,pBuf,lstrlen(pBuf)+(i2-6)+1);
			SlideString(pBuf+i+6,i2-6);
			memcpy(pBuf+i,pPjName,i2);
		}
		if(memicmp(pBuf+i,"#window#",8)==0){
			//EBhEu
			i2=lstrlen(pWndName);
			if(i2>6) pBuf=(char *)HeapReAlloc(hHeap,HEAP_ZERO_MEMORY,pBuf,lstrlen(pBuf)+(i2-8)+1);
			SlideString(pBuf+i+8,i2-8);
			memcpy(pBuf+i,pWndName,i2);
		}
		if(memicmp(pBuf+i,"#handle#",8)==0){
			//nhu
			i2=lstrlen(pHandleName);
			if(i2>6) pBuf=(char *)HeapReAlloc(hHeap,HEAP_ZERO_MEMORY,pBuf,lstrlen(pBuf)+(i2-8)+1);
			SlideString(pBuf+i+8,i2-8);
			memcpy(pBuf+i,pHandleName,i2);
		}
		if(memicmp(pBuf+i,"#procedure#",11)==0){
			//vV[Wu
			i2=lstrlen(pProcName);
			if(i2>6) pBuf=(char *)HeapReAlloc(hHeap,HEAP_ZERO_MEMORY,pBuf,lstrlen(pBuf)+(i2-11)+1);
			SlideString(pBuf+i+11,i2-11);
			memcpy(pBuf+i,pProcName,i2);
		}
	}

	return pBuf;
}

BOOL GetItemNotifyMessageNameByEvent(char *buffer,int ClassID,const char *EventName){
	if(lstrcmp(EventName,"Click")==0) lstrcpy(buffer,"NM_CLICK");
	else if(lstrcmp(EventName,"CustomDraw")==0) lstrcpy(buffer,"NM_CUSTOMDRAW");
	else if(lstrcmp(EventName,"DblClick")==0) lstrcpy(buffer,"NM_DBLCLK");
	else if(lstrcmp(EventName,"KillFocus")==0) lstrcpy(buffer,"NM_KILLFOCUS");
	else if(lstrcmp(EventName,"OutOfMemory")==0) lstrcpy(buffer,"NM_OUTOFMEMORY");
	else if(lstrcmp(EventName,"RClick")==0) lstrcpy(buffer,"NM_RCLICK");
	else if(lstrcmp(EventName,"RDblClick")==0) lstrcpy(buffer,"NM_RDBLCLK");
	else if(lstrcmp(EventName,"ReleasedCapture")==0) lstrcpy(buffer,"NM_RELEASEDCAPTURE");
	else if(lstrcmp(EventName,"Return")==0) lstrcpy(buffer,"NM_RETURN");
	else if(lstrcmp(EventName,"SetFocus")==0) lstrcpy(buffer,"NM_SETFOCUS");
	else{
		if(ClassID==CT_LISTVIEW){
			if(lstrcmp(EventName,"BeginDrag")==0) lstrcpy(buffer,"LVN_BEGINDRAG");
			else if(lstrcmp(EventName,"BeginLabelEdit")==0) lstrcpy(buffer,"LVN_BEGINLABELEDIT");
			else if(lstrcmp(EventName,"BeginRDrag")==0) lstrcpy(buffer,"LVN_BEGINRDRAG");
			else if(lstrcmp(EventName,"ColumnClick")==0) lstrcpy(buffer,"LVN_COLUMNCLICK");
			else if(lstrcmp(EventName,"DeleteAllItems")==0) lstrcpy(buffer,"LVN_DELETEALLITEMS");
			else if(lstrcmp(EventName,"DeleteItem")==0) lstrcpy(buffer,"LVN_DELETEITEM");
			else if(lstrcmp(EventName,"EndLabelEdit")==0) lstrcpy(buffer,"LVN_ENDLABELEDIT");
			else if(lstrcmp(EventName,"GetDispInfo")==0) lstrcpy(buffer,"LVN_GETDISPINFO");
			else if(lstrcmp(EventName,"InsertItem")==0) lstrcpy(buffer,"LVN_INSERTITEM");
			else if(lstrcmp(EventName,"ItemChanged")==0) lstrcpy(buffer,"LVN_ITEMCHANGED");
			else if(lstrcmp(EventName,"ItemChanging")==0) lstrcpy(buffer,"LVN_ITEMCHANGING");
			else if(lstrcmp(EventName,"KeyDown")==0) lstrcpy(buffer,"LVN_KEYDOWN");
			else if(lstrcmp(EventName,"SetDispInfo")==0) lstrcpy(buffer,"LVN_SETDISPINFO");
			else return 0;
		}
		else if(ClassID==CT_UPDOWN){
			if(lstrcmp(EventName,"Deltapos")==0) lstrcpy(buffer,"UDN_DELTAPOS");
			else return 0;
		}
		else return 0;
		//
	}
	return 1;
}
BOOL GetNotifyCommandByItemMessage(WINDOW_INFO *pWindowInfo,ITEMEVENTINFO *pItemEventInfo,char *Command,char *spaces){
	int i,i2,i3,sw;
	char temporary[MAX_PATH];

	i2=0;
	sw=0;
	for(i=0;;i++){
		if(pItemEventInfo[i].IdName==0) break;
		if(pItemEventInfo[i].ClassID==CT_LISTVIEW||
			pItemEventInfo[i].ClassID==CT_TREEVIEW||
			pItemEventInfo[i].ClassID==CT_UPDOWN||
			pItemEventInfo[i].ClassID==CT_PROGRESSBAR||
			pItemEventInfo[i].ClassID==CT_TRACKBAR){
			//R Rg[iWM_NOTIFYj
			sw=1;
			sprintf(Command+i2,"%sCase %s\r\n",spaces,pItemEventInfo[i].IdName);
			i2+=lstrlen(Command+i2);
			sprintf(Command+i2,"%s\tSelect Case pnmHdr->code\r\n",spaces);
			i2+=lstrlen(Command+i2);
			for(i3=0;i3<pItemEventInfo[i].EventNum;i3++){
				if(GetItemNotifyMessageNameByEvent(temporary,pItemEventInfo[i].ClassID,pItemEventInfo[i].pEventNames[i3])){
					sprintf(Command+i2,"%s\t\tCase %s\r\n",spaces,temporary);
					i2+=lstrlen(Command+i2);
					sprintf(Command+i2,"%s\t\t\t%s_%s_%s(ByVal (pnmHdr As VoidPtr))\r\n",spaces,pWindowInfo->name,pItemEventInfo[i].IdName,pItemEventInfo[i].pEventNames[i3]);
					i2+=lstrlen(Command+i2);
				}
			}
			sprintf(Command+i2,"%s\tEnd Select\r\n",spaces);
			i2+=lstrlen(Command+i2);
		}
	}
	return sw;
}
void GetItemMessageNameByEvent(char *buffer,int ClassID,const char *EventName){
	if(ClassID==CT_BUTTON||
		ClassID==CT_CHECKBOX||
		ClassID==CT_RADIOBUTTON){
		if(lstrcmp(EventName,"Click")==0) lstrcpy(buffer,"BN_CLICKED");
		else if(lstrcmp(EventName,"DblClick")==0) lstrcpy(buffer,"BN_DBLCLK");
	}
	else if(ClassID==CT_COMBOBOX){
		if(lstrcmp(EventName,"CloseUp")==0) lstrcpy(buffer,"CBN_CLOSEUP");
		else if(lstrcmp(EventName,"DblClick")==0) lstrcpy(buffer,"CBN_DBLCLK");
		else if(lstrcmp(EventName,"DropDown")==0) lstrcpy(buffer,"CBN_DROPDOWN");
		else if(lstrcmp(EventName,"EditChange")==0) lstrcpy(buffer,"CBN_EDITCHANGE");
		else if(lstrcmp(EventName,"EditUpdate")==0) lstrcpy(buffer,"CBN_EDITUPDATE");
		else if(lstrcmp(EventName,"ErrSpace")==0) lstrcpy(buffer,"CBN_ERRSPACE");
		else if(lstrcmp(EventName,"KillFocus")==0) lstrcpy(buffer,"CBN_KILLFOCUS");
		else if(lstrcmp(EventName,"SelChange")==0) lstrcpy(buffer,"CBN_SELCHANGE");
		else if(lstrcmp(EventName,"SelEndCancel")==0) lstrcpy(buffer,"CBN_SELENDCANCEL");
		else if(lstrcmp(EventName,"SelEndOk")==0) lstrcpy(buffer,"CBN_SELENDOK");
		else if(lstrcmp(EventName,"SetFocus")==0) lstrcpy(buffer,"CBN_SETFOCUS");
	}
	else if(ClassID==CT_EDIT){
		if(lstrcmp(EventName,"Change")==0) lstrcpy(buffer,"EN_CHANGE");
		else if(lstrcmp(EventName,"ErrSpace")==0) lstrcpy(buffer,"EN_ERRSPACE");
		else if(lstrcmp(EventName,"HScroll")==0) lstrcpy(buffer,"EN_HSCROLL");
		else if(lstrcmp(EventName,"KillFocus")==0) lstrcpy(buffer,"EN_KILLFOCUS");
		else if(lstrcmp(EventName,"MaxText")==0) lstrcpy(buffer,"EN_MAXTEXT");
		else if(lstrcmp(EventName,"SetFocus")==0) lstrcpy(buffer,"EN_SETFOCUS");
		else if(lstrcmp(EventName,"Update")==0) lstrcpy(buffer,"EN_UPDATE");
		else if(lstrcmp(EventName,"VScroll")==0) lstrcpy(buffer,"EN_VSCROLL");
	}
	else if(ClassID==CT_IMAGEBOX||
		ClassID==CT_STATIC){
		if(lstrcmp(EventName,"Click")==0) lstrcpy(buffer,"STN_CLICKED");
		else if(lstrcmp(EventName,"DblClick")==0) lstrcpy(buffer,"STN_DBLCLK");
	}
	else if(ClassID==CT_LISTBOX){
		if(lstrcmp(EventName,"SelChange")==0) lstrcpy(buffer,"LBN_SELCHANGE");
		else if(lstrcmp(EventName,"DblClick")==0) lstrcpy(buffer,"LBN_DBLCLK");
		else if(lstrcmp(EventName,"ErrSpace")==0) lstrcpy(buffer,"LBN_ERRSPACE");
		else if(lstrcmp(EventName,"KillFocus")==0) lstrcpy(buffer,"LBN_KILLFOCUS");
		else if(lstrcmp(EventName,"SelCancel")==0) lstrcpy(buffer,"LBN_SELCANCEL");
		else if(lstrcmp(EventName,"SetFocus")==0) lstrcpy(buffer,"LBN_SETFOCUS");
	}
}
void GetCommandByItemMessage(WINDOW_INFO *pWindowInfo,ITEMEVENTINFO *pItemEventInfo,char *Command,char *spaces){
	extern HANDLE hHeap;
	int i,i2,i3;
	char temporary[MAX_PATH];

	i2=0;
	for(i=0;;i++){
		if(pItemEventInfo[i].IdName==0) break;
		if(pItemEventInfo[i].ClassID!=CT_LISTVIEW&&
			pItemEventInfo[i].ClassID!=CT_PROGRESSBAR&&
			pItemEventInfo[i].ClassID!=CT_TREEVIEW&&
			pItemEventInfo[i].ClassID!=CT_TRACKBAR&&
			pItemEventInfo[i].ClassID!=CT_UPDOWN
			){
			//WM_COMMAND
			sprintf(Command+i2,"%sCase %s\r\n",spaces,pItemEventInfo[i].IdName);
			i2+=lstrlen(Command+i2);
			if(pItemEventInfo[i].ClassID==CT_MENU){
				sprintf(Command+i2,"%s\t%s_%s_MenuClick()\r\n",spaces,pWindowInfo->name,pItemEventInfo[i].IdName);
				i2+=lstrlen(Command+i2);
				for(i3=0;i3<pItemEventInfo[i].EventNum;i3++)
					HeapDefaultFree(pItemEventInfo[i].pEventNames[i3]);
			}
			else{
				sprintf(Command+i2,"%s\tSelect Case HIWORD(wParam)\r\n",spaces);
				i2+=lstrlen(Command+i2);
				for(i3=0;i3<pItemEventInfo[i].EventNum;i3++){
					GetItemMessageNameByEvent(temporary,pItemEventInfo[i].ClassID,pItemEventInfo[i].pEventNames[i3]);
					sprintf(Command+i2,"%s\t\tCase %s\r\n",spaces,temporary);
					i2+=lstrlen(Command+i2);
					sprintf(Command+i2,"%s\t\t\t%s_%s_%s()\r\n",spaces,pWindowInfo->name,pItemEventInfo[i].IdName,pItemEventInfo[i].pEventNames[i3]);
					i2+=lstrlen(Command+i2);
					HeapDefaultFree(pItemEventInfo[i].pEventNames[i3]);
				}
				sprintf(Command+i2,"%s\tEnd Select\r\n",spaces);
				i2+=lstrlen(Command+i2);
			}
			HeapDefaultFree(pItemEventInfo[i].IdName);
			HeapDefaultFree(pItemEventInfo[i].pEventNames);
		}
		else{
			//WM_NOTIFỸ
			for(i3=0;i3<pItemEventInfo[i].EventNum;i3++)
				HeapDefaultFree(pItemEventInfo[i].pEventNames[i3]);
			HeapDefaultFree(pItemEventInfo[i].IdName);
			HeapDefaultFree(pItemEventInfo[i].pEventNames);
		}
	}
}

void GetItemClassName(char *buffer,int Control){
	switch(Control){
		case CT_BUTTON:
		case CT_CHECKBOX:
		case CT_GROUPBOX:
		case CT_RADIOBUTTON:
			lstrcpy(buffer,"BUTTON");
			break;
		case CT_COMBOBOX:
			lstrcpy(buffer,"COMBOBOX");
			break;
		case CT_EDIT:
			lstrcpy(buffer,"EDIT");
			break;
		case CT_HSCROLLBAR:
		case CT_VSCROLLBAR:
			lstrcpy(buffer,"SCROLLBAR");
			break;
		case CT_LISTBOX:
			lstrcpy(buffer,"LISTBOX");
			break;
		case CT_LISTVIEW:
			lstrcpy(buffer,"SysListView32");
			break;
		case CT_IMAGEBOX:
		case CT_STATIC:
			lstrcpy(buffer,"STATIC");
			break;
		case CT_PROGRESSBAR:
			lstrcpy(buffer,"msctls_progress32");
			break;
		case CT_TRACKBAR:
			lstrcpy(buffer,"msctls_trackbar32");
			break;
		case CT_TREEVIEW:
			lstrcpy(buffer,"SysTreeView32");
			break;
		//CT_UPDOWNCreateUpDownControl֐œƎɍ쐬
	}
}
long GetCommandByMessage(int WndInfoNum,const char *MessageName,BOOL bProcedureCall,char *Command,char *spaces){
	extern PROJECTINFO ProjectInfo;
	int i,i2,sw;
	char temporary[MAX_PATH],*temp2;
	WINDOW_INFO *pWindowInfo;

	pWindowInfo=&ProjectInfo.pWindowInfo[WndInfoNum];

	Command[0]=0;


	/////////////////////
	// Default R}h

	if(lstrcmp(MessageName,"Activate")==0){
		sprintf(Command,"%sCase WM_ACTIVATE\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(LOWORD(wParam),HIWORD(wParam))\r\n",spaces,pWindowInfo->name,MessageName);
	}
	else if(lstrcmp(MessageName,"Create")==0){
		if(pWindowInfo->type==WNDTYPE_MODALDLG||pWindowInfo->type==WNDTYPE_MODELESSDLG)
			sprintf(Command,"%sCase WM_INITDIALOG\r\n",spaces);
		else sprintf(Command,"%sCase WM_CREATE\r\n",spaces);
		i=lstrlen(Command);

		sprintf(Command+i,"%s\t%s=hWnd\r\n",spaces,pWindowInfo->HandleName);
		i+=lstrlen(Command+i);

		if(pWindowInfo->MenuID){
			//j[쐬
			for(i2=0;i2<ProjectInfo.NumberOfMenu;i2++){
				if(lstrcmpi(ProjectInfo.pMenuInfo[i2].IdName,pWindowInfo->MenuID)==0) break;
			}
			if(i2!=ProjectInfo.NumberOfMenu){
				sprintf(Command+i,"%s\tSetMenu(hWnd,hMenu_%s)\r\n",spaces,ProjectInfo.pMenuInfo[i2].IdName);
				i+=lstrlen(Command+i);
			}
		}

		//qEBhE쐬
		for(i2=0,sw=0;i2<pWindowInfo->NumberOfChildWindows;i2++){
			if(pWindowInfo->pChildInfo[i2].Control==CT_UPDOWN){
				sprintf(Command+i,"%s\tCreateUpDownControl(%d,%d,%d,%d,%d,hWnd,%s,GetWindowLongPtr(hWnd,GWLP_HINSTANCE) As HINSTANCE,0,0,100,0)\r\n",
					spaces,
					pWindowInfo->pChildInfo[i2].style,
					pWindowInfo->pChildInfo[i2].pos.x,pWindowInfo->pChildInfo[i2].pos.y,
					pWindowInfo->pChildInfo[i2].size.cx,pWindowInfo->pChildInfo[i2].size.cy,
					pWindowInfo->pChildInfo[i2].IdName);
				i+=lstrlen(Command+i);
			}
			else{
				GetItemClassName(temporary,pWindowInfo->pChildInfo[i2].Control);
				temp2=FormatCaption(pWindowInfo->pChildInfo[i2].caption);
				sprintf(Command+i,"%s\tCreateWindowEx(&H%08x,\"%s\",\"%s\",&H%08x,%d,%d,%d,%d,hWnd,%s As HMENU,GetModuleHandle(0),0)\r\n",
					spaces,
					pWindowInfo->pChildInfo[i2].ExStyle,
					temporary,
					temp2,
					pWindowInfo->pChildInfo[i2].style,
					pWindowInfo->pChildInfo[i2].pos.x,
					pWindowInfo->pChildInfo[i2].pos.y,
					pWindowInfo->pChildInfo[i2].size.cx,
					pWindowInfo->pChildInfo[i2].size.cy,
					pWindowInfo->pChildInfo[i2].IdName);
				i+=lstrlen(Command+i);
				HeapDefaultFree(temp2);
				sprintf(Command+i,"%s\tSendMessage(GetDlgItem(hWnd,%s),WM_SETFONT,hFont_%s As WPARAM,0)\r\n",
					spaces,
					pWindowInfo->pChildInfo[i2].IdName,
					pWindowInfo->name);
				i+=lstrlen(Command+i);

				if(pWindowInfo->pChildInfo[i2].Control==CT_IMAGEBOX){
					//C[W {bNX̏ꍇ
					if((pWindowInfo->pChildInfo[i2].style&0x000F)==SS_ICON){
						if(pWindowInfo->pChildInfo[i2].ImageCtrlInfo.type==IMGTYPE_FILE){
							if(strstr(pWindowInfo->pChildInfo[i2].ImageCtrlInfo.path,":")||
								strstr(pWindowInfo->pChildInfo[i2].ImageCtrlInfo.path,"\\\\")){
								sprintf(Command+i,"%s\thImage_%s_%s=LoadImage(GetWindowLongPtr(hWnd,GWLP_HINSTANCE) As HINSTANCE,\"%s\",IMAGE_ICON,0,0,LR_DEFAULTSIZE or LR_LOADFROMFILE)\r\n",
									spaces,
									pWindowInfo->name,
									pWindowInfo->pChildInfo[i2].IdName,
									pWindowInfo->pChildInfo[i2].ImageCtrlInfo.path);
							}
							else{
								if(sw==0){
									sw=1;
									lstrcpy(Command+i,"\r\n");
									i+=2;
									sprintf(Command+i,"%s\tDim ImageFilePath[MAX_PATH] As Byte\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\tDim ModulePath[MAX_PATH] As Byte, i As Long\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\tGetModuleFileName(GetModuleHandle(0),ModulePath,MAX_PATH)\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\tFor i=lstrlen(ModulePath)-1 To 0 Step -1\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\t\tIf ModulePath[i]=&H5C Then Exit For\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\tNext\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\tModulePath[i+1]=0\r\n",spaces);
									i+=lstrlen(Command+i);
									lstrcpy(Command+i,"\r\n");
									i+=2;
								}
								sprintf(Command+i,"%s\twsprintf(ImageFilePath,\"%%s%s\",ModulePath)\r\n",spaces,pWindowInfo->pChildInfo[i2].ImageCtrlInfo.path);
								i+=lstrlen(Command+i);
								sprintf(Command+i,"%s\thImage_%s_%s=LoadImage(GetWindowLongPtr(hWnd,GWLP_HINSTANCE) As HINSTANCE,ImageFilePath,IMAGE_ICON,0,0,LR_DEFAULTSIZE or LR_LOADFROMFILE)\r\n",
									spaces,
									pWindowInfo->name,
									pWindowInfo->pChildInfo[i2].IdName);
							}
							i+=lstrlen(Command+i);
						}
						else if(pWindowInfo->pChildInfo[i2].ImageCtrlInfo.type==IMGTYPE_RES){
							sprintf(Command+i,"%s\thImage_%s_%s=LoadImage(GetWindowLongPtr(hWnd,GWLP_HINSTANCE) As HINSTANCE,%s As *Byte,IMAGE_ICON,0,0,LR_DEFAULTSIZE)\r\n",
								spaces,
								pWindowInfo->name,
								pWindowInfo->pChildInfo[i2].IdName,
								pWindowInfo->pChildInfo[i2].ImageCtrlInfo.path);
							i+=lstrlen(Command+i);
						}
						sprintf(Command+i,"%s\tSendMessage(GetDlgItem(hWnd,%s),STM_SETICON,hImage_%s_%s As WPARAM,0)\r\n",
							spaces,
							pWindowInfo->pChildInfo[i2].IdName,
							pWindowInfo->name,
							pWindowInfo->pChildInfo[i2].IdName);
						i+=lstrlen(Command+i);
					}
					else if((pWindowInfo->pChildInfo[i2].style&0x000F)==SS_BITMAP){
						if(pWindowInfo->pChildInfo[i2].ImageCtrlInfo.type==IMGTYPE_FILE){
							if(strstr(pWindowInfo->pChildInfo[i2].ImageCtrlInfo.path,":")||
								strstr(pWindowInfo->pChildInfo[i2].ImageCtrlInfo.path,"\\\\")){
								sprintf(Command+i,"%s\thImage_%s_%s=LoadImage(GetWindowLongPtr(hWnd,GWLP_HINSTANCE) As HINSTANCE,\"%s\",IMAGE_BITMAP,0,0,LR_DEFAULTSIZE or LR_LOADFROMFILE)\r\n",
									spaces,
									pWindowInfo->name,
									pWindowInfo->pChildInfo[i2].IdName,
									pWindowInfo->pChildInfo[i2].ImageCtrlInfo.path);
							}
							else{
								if(sw==0){
									sw=1;
									lstrcpy(Command+i,"\r\n");
									i+=2;
									sprintf(Command+i,"%s\tDim ImageFilePath[MAX_PATH] As Byte\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\tDim ModulePath[MAX_PATH] As Byte, i As Long\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\tGetModuleFileName(GetModuleHandle(0),ModulePath,MAX_PATH)\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\tFor i=lstrlen(ModulePath)-1 To 0 Step -1\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\t\tIf ModulePath[i]=&H5C Then Exit For\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\tNext\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\tModulePath[i+1]=0\r\n",spaces);
									i+=lstrlen(Command+i);
									lstrcpy(Command+i,"\r\n");
									i+=2;
								}
								sprintf(Command+i,"%s\twsprintf(ImageFilePath,\"%%s%s\",ModulePath)\r\n",spaces,pWindowInfo->pChildInfo[i2].ImageCtrlInfo.path);
								i+=lstrlen(Command+i);
								sprintf(Command+i,"%s\thImage_%s_%s=LoadImage(GetWindowLongPtr(hWnd,GWLP_HINSTANCE) As HINSTANCE,ImageFilePath,IMAGE_BITMAP,0,0,LR_LOADFROMFILE)\r\n",
									spaces,
									pWindowInfo->name,
									pWindowInfo->pChildInfo[i2].IdName);
							}
							i+=lstrlen(Command+i);
						}
						else if(pWindowInfo->pChildInfo[i2].ImageCtrlInfo.type==IMGTYPE_RES){
							sprintf(Command+i,"%s\thImage_%s_%s=LoadImage(GetWindowLongPtr(hWnd,GWLP_HINSTANCE) As HINSTANCE,%s As *Byte,IMAGE_BITMAP,0,0,LR_DEFAULTSIZE)\r\n",
								spaces,
								pWindowInfo->name,
								pWindowInfo->pChildInfo[i2].IdName,
								pWindowInfo->pChildInfo[i2].ImageCtrlInfo.path);
							i+=lstrlen(Command+i);
						}
						sprintf(Command+i,"%s\tSendMessage(GetDlgItem(hWnd,%s),STM_SETIMAGE,IMAGE_BITMAP,hImage_%s_%s As LPARAM)\r\n",
							spaces,
							pWindowInfo->pChildInfo[i2].IdName,
							pWindowInfo->name,
							pWindowInfo->pChildInfo[i2].IdName);
						i+=lstrlen(Command+i);
					}
				}
			}
		}

		if(bProcedureCall)
			sprintf(Command+i,"%s\t%s_%s(ByVal (lParam As VoidPtr))\r\n",spaces,pWindowInfo->name,MessageName);
		return WM_CREATE;
	}
	else if(lstrcmp(MessageName,"Destroy")==0){
		sprintf(Command,"%sCase WM_DESTROY\r\n",spaces);
		i=lstrlen(Command);
		if(bProcedureCall){
			sprintf(Command+i,"%s\t%s_%s()\r\n",spaces,pWindowInfo->name,MessageName);
			i+=lstrlen(Command+i);
		}

		if(pWindowInfo->MenuID){
			//j[
			for(i2=0;i2<ProjectInfo.NumberOfMenu;i2++){
				if(lstrcmpi(ProjectInfo.pMenuInfo[i2].IdName,pWindowInfo->MenuID)==0) break;
			}
			if(i2!=ProjectInfo.NumberOfMenu){
				sprintf(Command+i,"%s\tSetMenu(hWnd,NULL)\r\n",spaces);
				i+=lstrlen(Command+i);
			}
		}

		//C[W {bNXp̕ϐ
		for(i2=0;i2<pWindowInfo->NumberOfChildWindows;i2++){
			if(pWindowInfo->pChildInfo[i2].Control==CT_IMAGEBOX){
				if((pWindowInfo->pChildInfo[i2].style&0x000F)==SS_ICON)
					sprintf(Command+i,"%s\tDestroyIcon(hImage_%s_%s)\r\n",spaces,pWindowInfo->name,pWindowInfo->pChildInfo[i2].IdName);
				else if((pWindowInfo->pChildInfo[i2].style&0x000F)==SS_BITMAP)
					sprintf(Command+i,"%s\tDeleteObject(hImage_%s_%s)\r\n",spaces,pWindowInfo->name,pWindowInfo->pChildInfo[i2].IdName);
				i+=lstrlen(Command+i);
			}
		}
		return WM_DESTROY;
	}
	else if(lstrcmp(MessageName,"DropFiles")==0){
		sprintf(Command,"%sCase WM_DROPFILES\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As HDROP)\r\n",spaces,pWindowInfo->name,MessageName);
	}
	else if(lstrcmp(MessageName,"HScroll")==0){
		sprintf(Command,"%sCase WM_HSCROLL\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(LOWORD(wParam),HIWORD(wParam),lParam As HWND)\r\n",spaces,pWindowInfo->name,MessageName);
	}
	else if(lstrcmp(MessageName,"KeyDown")==0){
		sprintf(Command,"%sCase WM_KEYDOWN\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,lParam As Long)\r\n",spaces,pWindowInfo->name,MessageName);
	}
	else if(lstrcmp(MessageName,"KeyPress")==0){
		sprintf(Command,"%sCase WM_CHAR\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,lParam As Long)\r\n",spaces,pWindowInfo->name,MessageName);
	}
	else if(lstrcmp(MessageName,"KeyUp")==0){
		sprintf(Command,"%sCase WM_KEYUP\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,lParam As Long)\r\n",spaces,pWindowInfo->name,MessageName);
	}
	else if(lstrcmp(MessageName,"LButtonDown")==0){
		sprintf(Command,"%sCase WM_LBUTTONDOWN\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->name,MessageName);
	}
	else if(lstrcmp(MessageName,"LButtonDblClick")==0){
		sprintf(Command,"%sCase WM_LBUTTONDBLCLK\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->name,MessageName);
	}
	else if(lstrcmp(MessageName,"LButtonUp")==0){
		sprintf(Command,"%sCase WM_LBUTTONUP\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->name,MessageName);
	}
	else if(lstrcmp(MessageName,"MButtonDown")==0){
		sprintf(Command,"%sCase WM_MBUTTONDOWN\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->name,MessageName);
	}
	else if(lstrcmp(MessageName,"MButtonDblClick")==0){
		sprintf(Command,"%sCase WM_MBUTTONDBLCLK\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->name,MessageName);
	}
	else if(lstrcmp(MessageName,"MButtonUp")==0){
		sprintf(Command,"%sCase WM_MBUTTONUP\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->name,MessageName);
	}
	else if(lstrcmp(MessageName,"MouseMove")==0){
		sprintf(Command,"%sCase WM_MOUSEMOVE\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->name,MessageName);
	}
	else if(lstrcmp(MessageName,"Move")==0){
		sprintf(Command,"%sCase WM_MOVE\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->name,MessageName);
	}
	else if(lstrcmp(MessageName,"Notify")==0){
		//RRg[bZ[WƋɑ}
		return WM_NOTIFY;
	}
	else if(lstrcmp(MessageName,"Paint")==0){
		sprintf(Command,"%sCase WM_PAINT\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\tDim ps As PAINTSTRUCT\r\n",spaces);
		i+=lstrlen(Command+i);
		sprintf(Command+i,"%s\tDim hDC As HDC\r\n",spaces);
		i+=lstrlen(Command+i);
		sprintf(Command+i,"%s\thDC=BeginPaint(hWnd,ps)\r\n",spaces);
		i+=lstrlen(Command+i);
		sprintf(Command+i,"%s\t%s_%s(hDC)\r\n",spaces,pWindowInfo->name,MessageName);
		i+=lstrlen(Command+i);
		sprintf(Command+i,"%s\tEndPaint(hWnd,ps)\r\n",spaces);
		return WM_PAINT;
	}
	else if(lstrcmp(MessageName,"QueryClose")==0){
		sprintf(Command,"%sCase WM_CLOSE\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\tDim cancel=0 As Integer\r\n",spaces);
		i+=lstrlen(Command+i);
		if(bProcedureCall){
			sprintf(Command+i,"%s\t%s_%s(cancel)\r\n",spaces,pWindowInfo->name,MessageName);
			i+=lstrlen(Command+i);
		}
		if(pWindowInfo->type==WNDTYPE_MODALDLG)
			sprintf(Command+i,"%s\tIf cancel=0 Then EndDialog(hWnd,0)\r\n",spaces);
		else
			sprintf(Command+i,"%s\tIf cancel=0 Then DestroyWindow(hWnd)\r\n",spaces);
		return WM_CLOSE;
	}
	else if(lstrcmp(MessageName,"RButtonDblClick")==0){
		sprintf(Command,"%sCase WM_RBUTTONDBLCLK\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->name,MessageName);
	}
	else if(lstrcmp(MessageName,"RButtonDown")==0){
		sprintf(Command,"%sCase WM_RBUTTONDOWN\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->name,MessageName);
	}
	else if(lstrcmp(MessageName,"RButtonUp")==0){
		sprintf(Command,"%sCase WM_RBUTTONUP\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->name,MessageName);
	}
	else if(lstrcmp(MessageName,"Resize")==0){
		sprintf(Command,"%sCase WM_SIZE\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->name,MessageName);
	}
	else if(lstrcmp(MessageName,"SetFocus")==0){
		sprintf(Command,"%sCase WM_SETFOCUS\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s()\r\n",spaces,pWindowInfo->name,MessageName);
	}
	else if(lstrcmp(MessageName,"Timer")==0){
		sprintf(Command,"%sCase WM_TIMER\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As DWord)\r\n",spaces,pWindowInfo->name,MessageName);
	}
	else if(lstrcmp(MessageName,"VScroll")==0){
		sprintf(Command,"%sCase WM_VSCROLL\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(LOWORD(wParam),HIWORD(wParam),lParam As HWND)\r\n",spaces,pWindowInfo->name,MessageName);
	}


	///////////////////
	// MMSYS R}h

	else if(lstrcmp(MessageName,"MciNotify")==0){
		sprintf(Command,"%sCase MM_MCINOTIFY\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam,lParam)\r\n",spaces,pWindowInfo->name,MessageName);
	}
	return 0;
}

char **GetMenuItemConstData(MENU_INFO *pMenuInfo,int NumberOfMenu,int *ConstNumber,char **ppNames,int *NamesNum,char *buffer,int *base){
	extern HANDLE hHeap;
	int i,i2,sw1;

	for(i=0;i<NumberOfMenu;i++){
		if(pMenuInfo[i].pMenuInfo){
			//|bvAbv
			ppNames=GetMenuItemConstData(pMenuInfo[i].pMenuInfo,pMenuInfo[i].NumberOfMenu,ConstNumber,ppNames,NamesNum,buffer,base);
		}
		else if(pMenuInfo[i].type==MFT_STRING){
			//d`FbN
			for(i2=0,sw1=0;i2<*NamesNum;i2++){
				if(lstrcmpi(ppNames[i2],pMenuInfo[i].IdName)==0){
					sw1=1;
					break;
				}
			}
			if(sw1==0){
				ppNames=(char **)HeapReAlloc(hHeap,0,ppNames,sizeof(char *)*((*NamesNum)+1));
				ppNames[*NamesNum]=pMenuInfo[i].IdName;
				(*NamesNum)++;

				sprintf(buffer+(*base),"Const %s=%d\r\n",pMenuInfo[i].IdName,*ConstNumber);
				(*base)+=lstrlen(buffer+(*base));
				(*ConstNumber)++;
			}
		}
	}
	return ppNames;
}
int GetMakeMenuCommand(MENU_INFO *pMenuInfo,int NumberOfMenu,char *MenuHandle,char *Command,BOOL bMain){
	int i,i2;
	char temporary[MAX_PATH];

	i=0;
	sprintf(Command+i,"Dim %s As HMENU\r\n",MenuHandle);
	i+=lstrlen(Command+i);
	if(bMain) sprintf(Command+i,"%s=CreateMenu()\r\n",MenuHandle);
	else sprintf(Command+i,"%s=CreatePopupMenu()\r\n",MenuHandle);
	i+=lstrlen(Command+i);

	for(i2=NumberOfMenu-1;i2>=0;i2--){
		if(pMenuInfo[i2].pMenuInfo){
			sprintf(temporary,"%s_%d",MenuHandle,i2);
			i+=GetMakeMenuCommand(pMenuInfo[i2].pMenuInfo,pMenuInfo[i2].NumberOfMenu,temporary,Command+i,0);
			sprintf(Command+i,"InsMenu %s,0,MF_BYPOSITION,Ex\"%s\",0,%s,%d\r\n",
				MenuHandle,
				pMenuInfo[i2].caption,
				temporary,
				pMenuInfo[i2].state);
			i+=lstrlen(Command+i);
		}
		else{
			if(pMenuInfo[i2].type==MFT_STRING){
				sprintf(Command+i,"InsMenu %s,0,MF_BYPOSITION,Ex\"%s\",%s,0,%d\r\n",
					MenuHandle,
					pMenuInfo[i2].caption,
					pMenuInfo[i2].IdName,
					pMenuInfo[i2].state);
				i+=lstrlen(Command+i);
			}
			else if(pMenuInfo[i2].type==MFT_SEPARATOR){
				sprintf(Command+i,"InsMenu %s,0,MF_BYPOSITION,\"\"\r\n",
					MenuHandle);
				i+=lstrlen(Command+i);
			}
		}
	}
	return i;
}
int GetDestroyMenuCommand(MENU_INFO *pMenuInfo,int NumberOfMenu,char *MenuHandle,char *Command){
	int i,i2;
	char temporary[MAX_PATH];

	i=0;
	sprintf(Command+i,"\tDestroyMenu(%s)\r\n",MenuHandle);
	i+=lstrlen(Command+i);

	for(i2=NumberOfMenu-1;i2>=0;i2--){
		if(pMenuInfo[i2].pMenuInfo){
			sprintf(temporary,"%s_%d",MenuHandle,i2);
			i+=GetDestroyMenuCommand(pMenuInfo[i2].pMenuInfo,pMenuInfo[i2].NumberOfMenu,temporary,Command+i);
		}
	}
	return i;
}
void SaveWindowProgram(){
	extern HANDLE hHeap;
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3,i4,i5,i6,sw1,sw2,sw3,sw4,size;
	char *buffer,**ppNames,temporary[MAX_PATH];
	WINDOW_INFO *pWindowInfo;

	pWindowInfo=ProjectInfo.pWindowInfo;

	size=2;
	buffer=(char *)HeapAlloc(hHeap,0,65535*size);
	lstrcpy(buffer,"'̃t@C̓EBhE`t@Ci*.wndjƂɐĂ܂\r\n\r\n");
	i2=lstrlen(buffer);

	if(ProjectInfo.dwOption&PJ_OP_COMMCTRL){
		//R}Rg[
		lstrcpy(buffer+i2,"Dim _RadSys_InitCtrls As INITCOMMONCONTROLSEX\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"_RadSys_InitCtrls.dwSize=Len(_RadSys_InitCtrls)\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"_RadSys_InitCtrls.dwICC=ICC_WIN95_CLASSES\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"InitCommonControlsEx(_RadSys_InitCtrls)\r\n\r\n");
		i2+=lstrlen(buffer+i2);
	}


	////////////
	//ID`

	ppNames=(char **)HeapAlloc(hHeap,0,1);
	for(i=0,i4=1000,i5=0;i<ProjectInfo.NumberOfWindows;i++){
		for(i3=0;i3<pWindowInfo[i].NumberOfChildWindows;i3++){

			//d`FbN
			for(i6=0,sw1=0;i6<i5;i6++){
				if(lstrcmpi(ppNames[i6],pWindowInfo[i].pChildInfo[i3].IdName)==0){
					sw1=1;
					break;
				}
			}
			if(sw1) continue;

			ppNames=(char **)HeapReAlloc(hHeap,0,ppNames,sizeof(char *)*(i5+1));
			ppNames[i5]=pWindowInfo[i].pChildInfo[i3].IdName;
			i5++;

			sprintf(buffer+i2,"Const %s=%d\r\n",pWindowInfo[i].pChildInfo[i3].IdName,i4);
			i2+=lstrlen(buffer+i2);
			i4++;

			while(i2>65535*(size-1)){
				size++;
				buffer=(char *)HeapReAlloc(hHeap,0,buffer,65535*size);
			}
		}
	}

	//j[ID`
	ppNames=GetMenuItemConstData(ProjectInfo.pMenuInfo,ProjectInfo.NumberOfMenu,&i4,ppNames,&i5,buffer,&i2);

	HeapDefaultFree(ppNames);
	lstrcpy(buffer+i2,"\r\n");
	i2+=lstrlen(buffer+i2);


	//nhϐ`
	for(i=0;i<ProjectInfo.NumberOfWindows;i++){
		sprintf(buffer+i2,"Dim %s As HWND\r\n",pWindowInfo[i].HandleName);
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"Dim hFont_%s As HFONT\r\n",pWindowInfo[i].name);
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"hFont_%s=CreateFont(%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,\"%s\")\r\n",
			pWindowInfo[i].name,
			pWindowInfo[i].LogFont.lfHeight,
			pWindowInfo[i].LogFont.lfWidth,
			pWindowInfo[i].LogFont.lfEscapement,
			pWindowInfo[i].LogFont.lfOrientation,
			pWindowInfo[i].LogFont.lfWeight,
			pWindowInfo[i].LogFont.lfItalic,
			pWindowInfo[i].LogFont.lfUnderline,
			pWindowInfo[i].LogFont.lfStrikeOut,
			pWindowInfo[i].LogFont.lfCharSet,
			pWindowInfo[i].LogFont.lfOutPrecision,
			pWindowInfo[i].LogFont.lfClipPrecision,
			pWindowInfo[i].LogFont.lfQuality,
			pWindowInfo[i].LogFont.lfPitchAndFamily,
			pWindowInfo[i].LogFont.lfFaceName);
		i2+=lstrlen(buffer+i2);

		while(i2>65535*(size-1)){
			size++;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,65535*size);
		}
	}

	//wiɎgpuV`
	lstrcpy(buffer+i2,"Dim h3DFaceBrush As HBRUSH\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"h3DFaceBrush=CreateSolidBrush(GetSysColor(COLOR_3DFACE))\r\n");
	i2+=lstrlen(buffer+i2);
	for(i=0;i<ProjectInfo.NumberOfWindows;i++){
		if(pWindowInfo[i].bgColor<=0&&
			pWindowInfo[i].bgColor!=-(int)RGB(255,255,255)&&
			pWindowInfo[i].bgColor!=-(int)RGB(0,0,0)){
				sprintf(buffer+i2,"Dim _RadSys_hBackBrush%d As HBRUSH\r\n",i);
				i2+=lstrlen(buffer+i2);
				sprintf(buffer+i2,"_RadSys_hBackBrush%d=CreateSolidBrush(%d)\r\n",i,-pWindowInfo[i].bgColor);
				i2+=lstrlen(buffer+i2);
		}
		if(pWindowInfo[i].bgColor>=0x1000){
				sprintf(buffer+i2,"Dim _RadSys_hBackBrush%d As HBRUSH\r\n",i);
				i2+=lstrlen(buffer+i2);
				sprintf(buffer+i2,"_RadSys_hBackBrush%d=CreatePatternBrush(LoadImage(GetModuleHandle(0),%s,IMAGE_BITMAP,0,0,LR_DEFAULTSIZE or LR_SHARED))\r\n",
					i,
					ProjectInfo.res.pBitmapResInfo[pWindowInfo[i].bgColor-0x1000].IdName);
				i2+=lstrlen(buffer+i2);
		}
	}

	lstrcpy(buffer+i2,"\r\n");
	i2+=lstrlen(buffer+i2);

	//C[W {bNXp̕ϐ`
	for(i=0;i<ProjectInfo.NumberOfWindows;i++){
		for(i3=0;i3<pWindowInfo[i].NumberOfChildWindows;i3++){
			if(pWindowInfo[i].pChildInfo[i3].Control==CT_IMAGEBOX){
				if((pWindowInfo[i].pChildInfo[i3].style&0x000F)==SS_ICON||
					(pWindowInfo[i].pChildInfo[i3].style&0x000F)==SS_BITMAP){
					sprintf(buffer+i2,"Dim hImage_%s_%s As HANDLE\r\n",pWindowInfo[i].name,pWindowInfo[i].pChildInfo[i3].IdName);
					i2+=lstrlen(buffer+i2);

					while(i2>65535*(size-1)){
						size++;
						buffer=(char *)HeapReAlloc(hHeap,0,buffer,65535*size);
					}
				}
			}
		}
	}

	lstrcpy(buffer+i2,"\r\n");
	i2+=lstrlen(buffer+i2);

	//j[쐬
	for(i=0;i<ProjectInfo.NumberOfMenu;i++){
		sprintf(temporary,"hMenu_%s",ProjectInfo.pMenuInfo[i].IdName);

		//InsertMenuItemS
		i2+=GetMakeMenuCommand(ProjectInfo.pMenuInfo[i].pMenuInfo,ProjectInfo.pMenuInfo[i].NumberOfMenu,temporary,buffer+i2,1);

		lstrcpy(buffer+i2,"\r\n");
		i2+=lstrlen(buffer+i2);

		while(i2>65535*(size-1)){
			size++;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,65535*size);
		}
	}


	//////////////////////////
	//IuWFNg̉
	sprintf(buffer+i2,"Sub %s_DestroyObjects()\r\n",ProjectInfo.name);
	i2+=lstrlen(buffer+i2);

	//j[
	for(i=0;i<ProjectInfo.NumberOfMenu;i++){
		sprintf(temporary,"hMenu_%s",ProjectInfo.pMenuInfo[i].IdName);
		i2+=GetDestroyMenuCommand(ProjectInfo.pMenuInfo[i].pMenuInfo,ProjectInfo.pMenuInfo[i].NumberOfMenu,temporary,buffer+i2);

		while(i2>65535*(size-1)){
			size++;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,65535*size);
		}
	}

	for(i=0;i<ProjectInfo.NumberOfWindows;i++){
		//tHgnh
		sprintf(buffer+i2,"\tDeleteObject(hFont_%s)\r\n",ProjectInfo.pWindowInfo[i].name);
		i2+=lstrlen(buffer+i2);

		while(i2>65535*(size-1)){
			size++;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,65535*size);
		}
	}

	//wiuV
	lstrcpy(buffer+i2,"\tDeleteObject(h3DFaceBrush)\r\n");
	i2+=lstrlen(buffer+i2);
	for(i=0;i<ProjectInfo.NumberOfWindows;i++){
		if(pWindowInfo[i].bgColor<=0&&
			pWindowInfo[i].bgColor!=-(int)RGB(255,255,255)&&
			pWindowInfo[i].bgColor!=-(int)RGB(0,0,0)){
				sprintf(buffer+i2,"\tDeleteObject(_RadSys_hBackBrush%d)\r\n",i);
				i2+=lstrlen(buffer+i2);
		}
	}

	sprintf(buffer+i2,"End Sub\r\n\r\n");
	i2+=lstrlen(buffer+i2);

	//[U[`̃R[obN֐݂邩ǂ
	BOOL bAvailUserProc[MAX_WNDNUM];


	for(i=0;i<ProjectInfo.NumberOfWindows;i++){
		if(i!=0){
			lstrcpy(buffer+i2,"\r\n");
			i2+=lstrlen(buffer+i2);
		}

		//////////////////////////
		//R[obN֐𐶐

		//bZ[W𒊏o
		ITEMEVENTINFO *pItemEventInfo;
		ppNames=GetProcedureNamesOfMessageCall(i,&pItemEventInfo,&i3,&bAvailUserProc[i]);

		sprintf(buffer+i2,"Function EventCall_%s(hWnd As HWND, message As DWord, wParam As WPARAM, lParam As LPARAM) As LRESULT\r\n",pWindowInfo[i].name);
		i2+=lstrlen(buffer+i2);

		lstrcpy(buffer+i2,"\tSelect Case message\r\n");
		i2+=lstrlen(buffer+i2);

		//ʏ탁bZ[WS
		for(i4=0,sw1=0,sw2=0,sw3=0,sw4=0;i4<i3;i4++){
			i5=GetCommandByMessage(i,ppNames[i4],1,buffer+i2,"\t\t");
			i2+=lstrlen(buffer+i2);
			if(i5==WM_CREATE) sw1=1;
			else if(i5==WM_DESTROY) sw2=1;
			else if(i5==WM_CLOSE) sw3=1;
			else if(i5==WM_NOTIFY) sw4=1;
			HeapDefaultFree(ppNames[i4]);
		}
		HeapDefaultFree(ppNames);

		//WM_CREATEAWM_DESTROYAWM_PAINTĂяoĂȂꍇ
		if(!sw1){
			GetCommandByMessage(i,"Create",0,buffer+i2,"\t\t");
			i2+=lstrlen(buffer+i2);
		}
		if(!sw2){
			GetCommandByMessage(i,"Destroy",0,buffer+i2,"\t\t");
			i2+=lstrlen(buffer+i2);
		}
		if(!sw3){
			GetCommandByMessage(i,"QueryClose",0,buffer+i2,"\t\t");
			i2+=lstrlen(buffer+i2);
		}

		//ACebZ[WSiWM_NOTIFYj
		if(pItemEventInfo[0].IdName){
			i3=i2;
			lstrcpy(buffer+i2,"\t\tCase WM_NOTIFY\r\n");
			i2+=lstrlen(buffer+i2);
			if(sw4){
				sprintf(buffer+i2,"\t\t\t%s_Notify(ByVal (lParam As *NMHDR))\r\n",pWindowInfo[i].name);
				i2+=lstrlen(buffer+i2);
			}
			lstrcpy(buffer+i2,"\t\t\tDim pnmHdr As *NMHDR\r\n");
			i2+=lstrlen(buffer+i2);
			lstrcpy(buffer+i2,"\t\t\tpnmHdr=lParam As *NMHDR\r\n");
			i2+=lstrlen(buffer+i2);
			lstrcpy(buffer+i2,"\t\t\tSelect Case LOWORD(wParam)\r\n");
			i2+=lstrlen(buffer+i2);

			if(GetNotifyCommandByItemMessage(&pWindowInfo[i],pItemEventInfo,buffer+i2,"\t\t\t\t")){
				i2+=lstrlen(buffer+i2);

				lstrcpy(buffer+i2,"\t\t\tEnd Select\r\n");
				i2+=lstrlen(buffer+i2);
			}
			else{
				//WM_NOTIFY폜
				i2=i3;
				if(sw4) goto DefaultNotifyEvent;
			}
		}
		else if(sw4){
DefaultNotifyEvent:
			lstrcpy(buffer+i2,"\t\tCase WM_NOTIFY\r\n");
			i2+=lstrlen(buffer+i2);
			sprintf(buffer+i2,"\t\t\t%s_Notify(ByVal (lParam As *NMHDR))\r\n",pWindowInfo[i].name);
			i2+=lstrlen(buffer+i2);
		}

		//ACebZ[WSiWM_COMMANDj
		if(pItemEventInfo[0].IdName){
			lstrcpy(buffer+i2,"\t\tCase WM_COMMAND\r\n");
			i2+=lstrlen(buffer+i2);
			lstrcpy(buffer+i2,"\t\t\tSelect Case LOWORD(wParam)\r\n");
			i2+=lstrlen(buffer+i2);

			//pItemEventInfoIdNameAEventNameõ͂̊֐ōs
			GetCommandByItemMessage(&pWindowInfo[i],pItemEventInfo,buffer+i2,"\t\t\t\t");
			i2+=lstrlen(buffer+i2);

			lstrcpy(buffer+i2,"\t\t\tEnd Select\r\n");
			i2+=lstrlen(buffer+i2);
		}
		HeapDefaultFree(pItemEventInfo);

		// DefWindowProc֐
		lstrcpy(buffer+i2,"\t\tCase Else\r\n");
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"\t\t\tEventCall_%s=DefWindowProc(hWnd,message,wParam,lParam)\r\n",pWindowInfo[i].name);
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\t\t\tExit Function\r\n");
		i2+=lstrlen(buffer+i2);

		lstrcpy(buffer+i2,"\tEnd Select\r\n");
		i2+=lstrlen(buffer+i2);

		sprintf(buffer+i2,"\tEventCall_%s=0\r\n",pWindowInfo[i].name);
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"End Function\r\n");
		i2+=lstrlen(buffer+i2);

		while(i2>65535*(size-1)){
			size++;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,65535*size);
		}
	}


	//////////////////////////
	//_CAO{bNX֘A

	//NXo^
	lstrcpy(buffer+i2,"\r\nFunction DefaultCallProc(hWnd As HWND, message As DWord, wParam As WPARAM, lParam As LPARAM) As LRESULT\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"\tDefaultCallProc=DefWindowProc(hWnd,message,wParam,lParam)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"End Function\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"\r\nDim _RadSys_dlgwcl As WNDCLASSEX\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"FillMemory(VarPtr(_RadSys_dlgwcl),Len(_RadSys_dlgwcl),0)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_dlgwcl.cbSize=Len(_RadSys_dlgwcl)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_dlgwcl.hInstance=GetModuleHandle(0)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_dlgwcl.style=CS_HREDRAW or CS_VREDRAW or CS_DBLCLKS\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_dlgwcl.hIcon=LoadIcon(NULL,MAKEINTRESOURCE(IDI_APPLICATION))\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_dlgwcl.hIconSm=LoadIcon(NULL,MAKEINTRESOURCE(IDI_WINLOGO))\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_dlgwcl.hCursor=LoadCursor(NULL,MAKEINTRESOURCE(IDC_ARROW))\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_dlgwcl.lpszClassName=\"NORMALDLG\"\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_dlgwcl.hbrBackground=h3DFaceBrush\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_dlgwcl.lpfnWndProc=AddressOf(DefaultCallProc)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"RegisterClassEx(_RadSys_dlgwcl)\r\n");
	i2+=lstrlen(buffer+i2);

	//DialogBox֐
	lstrcpy(buffer+i2,"\r\nFunction DialogBox(hOwnerWnd As HWND, TemplateName As LPSTR) As LONG_PTR\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"\tDim hDlg As HWND\r\n");
	i2+=lstrlen(buffer+i2);
	for(i=0,sw1=0;i<ProjectInfo.NumberOfWindows;i++){
		if(pWindowInfo[i].type==WNDTYPE_MODALDLG){
			if(sw1==0){
				sprintf(buffer+i2,"\tIf lstrcmp(TemplateName,\"%s\")=0 Then\r\n",pWindowInfo[i].name);
				i2+=lstrlen(buffer+i2);
				sw1=1;
			}
			else{
				sprintf(buffer+i2,"\tElseIf lstrcmp(TemplateName,\"%s\")=0 Then\r\n",pWindowInfo[i].name);
				i2+=lstrlen(buffer+i2);
			}
			sprintf(buffer+i2,"\t\t%s=CreateWindowEx(&H%08x,\"NORMALDLG\",\"%s\",&H%08x,%d,%d,%d,%d,hOwnerWnd,%d As HMENU,GetModuleHandle(0),0)\r\n",
				pWindowInfo[i].HandleName,
				pWindowInfo[i].ExStyle,
				pWindowInfo[i].caption,
				pWindowInfo[i].style,
				pWindowInfo[i].pos.x,
				pWindowInfo[i].pos.y,
				pWindowInfo[i].size.cx,
				pWindowInfo[i].size.cy,
				pWindowInfo[i].id);
			i2+=lstrlen(buffer+i2);
			sprintf(buffer+i2,"\t\thDlg=%s\r\n",
				pWindowInfo[i].HandleName);
			i2+=lstrlen(buffer+i2);
			if(bAvailUserProc[i]){
				sprintf(buffer+i2,"\t\tSetWindowLongPtr(%s,GWLP_WNDPROC,AddressOf(%s) As LONG_PTR)\r\n",
					pWindowInfo[i].HandleName,
					pWindowInfo[i].CallBackName);
			}
			else{
				sprintf(buffer+i2,"\t\tSetWindowLongPtr(%s,GWLP_WNDPROC,AddressOf(EventCall_%s) As LONG_PTR)\r\n",
					pWindowInfo[i].HandleName,
					pWindowInfo[i].name);
			}
			i2+=lstrlen(buffer+i2);
			sprintf(buffer+i2,"\t\tSendMessage(%s,WM_INITDIALOG,0,0)\r\n",pWindowInfo[i].HandleName);
			i2+=lstrlen(buffer+i2);
			if(pWindowInfo[i].IconResName){
				sprintf(buffer+i2,"\t\tSendMessage(%s,WM_SETICON,ICON_SMALL,LoadIcon(GetModuleHandle(0),MAKEINTRESOURCE(%s)) As LPARAM)\r\n",pWindowInfo[i].HandleName,pWindowInfo[i].IconResName);
				i2+=lstrlen(buffer+i2);
			}
			sprintf(buffer+i2,"\t\tShowWindow(%s,SW_SHOW)\r\n",pWindowInfo[i].HandleName);
			i2+=lstrlen(buffer+i2);
		}
		while(i2>65535*(size-1)){
			size++;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,65535*size);
		}
	}
	if(sw1){
		lstrcpy(buffer+i2,"\tElse\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\t\tExit Function\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\tEnd If\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\tEnableWindow(hOwnerWnd,0)\r\n\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\tDim msg As MSG, iResult As Long\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\tDo\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\t\tiResult=GetMessage(msg,0,0,0)\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\t\tIf iResult=0 or iResult=-1 Then Exit Do\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\t\tIf IsDialogMessage(hDlg,msg) Then Continue\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\t\tTranslateMessage(msg)\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\t\tDispatchMessage(msg)\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\tLoop\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\tDialogBox=msg.wParam\r\n");
		i2+=lstrlen(buffer+i2);
	}
	lstrcpy(buffer+i2,"End Function\r\n");
	i2+=lstrlen(buffer+i2);

	//EndDialog֐
	lstrcpy(buffer+i2,"Sub EndDialog(hWnd As HWND, lResult As Long)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"\tEnableWindow(GetWindow(hWnd,GW_OWNER),1)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"\tDestroyWindow(hWnd)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"\tPostMessage(0,WM_QUIT,lResult,0)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"End Sub\r\n");
	i2+=lstrlen(buffer+i2);

	//CreateDialog֐
	lstrcpy(buffer+i2,"\r\nFunction CreateDialog(hOwnerWnd As HWND, TemplateName As LPSTR) As HWND\r\n");
	i2+=lstrlen(buffer+i2);
	for(i=0;i<ProjectInfo.NumberOfWindows;i++){
		if(pWindowInfo[i].type==WNDTYPE_MODELESSDLG){
			sprintf(buffer+i2,"\tIf lstrcmp(TemplateName,\"%s\")=0 Then\r\n",pWindowInfo[i].name);
			i2+=lstrlen(buffer+i2);

			sprintf(buffer+i2,"\t\t%s=CreateWindowEx(&H%08x,\"NORMALDLG\",\"%s\",&H%08x,%d,%d,%d,%d,hOwnerWnd,%d As HMENU,GetModuleHandle(0),0)\r\n",
				pWindowInfo[i].HandleName,
				pWindowInfo[i].ExStyle,
				pWindowInfo[i].caption,
				pWindowInfo[i].style,
				pWindowInfo[i].pos.x,
				pWindowInfo[i].pos.y,
				pWindowInfo[i].size.cx,
				pWindowInfo[i].size.cy,
				pWindowInfo[i].id);
			i2+=lstrlen(buffer+i2);
			sprintf(buffer+i2,"\t\tCreateDialog=%s\r\n",pWindowInfo[i].HandleName);
			i2+=lstrlen(buffer+i2);
			if(bAvailUserProc[i]){
				sprintf(buffer+i2,"\t\tSetWindowLongPtr(%s,GWLP_WNDPROC,AddressOf(%s) As LONG_PTR)\r\n",
					pWindowInfo[i].HandleName,
					pWindowInfo[i].CallBackName);
			}
			else{
				sprintf(buffer+i2,"\t\tSetWindowLongPtr(%s,GWLP_WNDPROC,AddressOf(EventCall_%s) As LONG_PTR)\r\n",
					pWindowInfo[i].HandleName,
					pWindowInfo[i].name);
			}
			i2+=lstrlen(buffer+i2);
			sprintf(buffer+i2,"\t\tSendMessage(%s,WM_INITDIALOG,0,0)\r\n",pWindowInfo[i].HandleName);
			i2+=lstrlen(buffer+i2);
			if(pWindowInfo[i].IconResName){
				sprintf(buffer+i2,"\t\tSendMessage(%s,WM_SETICON,ICON_SMALL,LoadIcon(GetModuleHandle(0),MAKEINTRESOURCE(%s)) As LPARAM)\r\n",pWindowInfo[i].HandleName,pWindowInfo[i].IconResName);
				i2+=lstrlen(buffer+i2);
			}
			sprintf(buffer+i2,"\tEnd If\r\n",pWindowInfo[i].name);
			i2+=lstrlen(buffer+i2);
		}
		while(i2>65535*(size-1)){
			size++;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,65535*size);
		}
	}
	lstrcpy(buffer+i2,"End Function\r\n");
	i2+=lstrlen(buffer+i2);


	///////////////////////
	// ۑiCallback.wbpj
	sprintf(temporary,"%sCallback.wbp",ProjectInfo.dir);
	WriteBuffer(temporary,buffer,i2);



	lstrcpy(buffer,"'̃t@C̓EBhE`t@Ci*.wndjƂɐĂ܂\r\n\r\n");
	i2=lstrlen(buffer);

	lstrcpy(buffer+i2,"Dim _RadSys_wcl As WNDCLASSEX\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"FillMemory(VarPtr(_RadSys_wcl),Len(_RadSys_wcl),0)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_wcl.cbSize=Len(_RadSys_wcl)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_wcl.hInstance=GetModuleHandle(0)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_wcl.style=CS_HREDRAW or CS_VREDRAW or CS_DBLCLKS\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_wcl.hCursor=LoadCursor(NULL,MAKEINTRESOURCE(IDC_ARROW))\r\n");
	i2+=lstrlen(buffer+i2);

	for(i=0;i<ProjectInfo.NumberOfWindows;i++){
		if(pWindowInfo[i].type==WNDTYPE_DEFAULT){
			//////////////////////
			//ʏEBhE쐬

			lstrcpy(buffer+i2,"\r\n");
			i2+=2;

			if(pWindowInfo[i].IconResName==0){
				lstrcpy(buffer+i2,"_RadSys_wcl.hIcon=LoadIcon(NULL,MAKEINTRESOURCE(IDI_APPLICATION))\r\n");
				i2+=lstrlen(buffer+i2);
				lstrcpy(buffer+i2,"_RadSys_wcl.hIconSm=LoadIcon(NULL,MAKEINTRESOURCE(IDI_WINLOGO))\r\n");
				i2+=lstrlen(buffer+i2);
			}
			else{
				sprintf(buffer+i2,"_RadSys_wcl.hIcon=LoadIcon(_RadSys_wcl.hInstance,MAKEINTRESOURCE(%s))\r\n",pWindowInfo[i].IconResName);
				i2+=lstrlen(buffer+i2);
				sprintf(buffer+i2,"_RadSys_wcl.hIconSm=LoadIcon(_RadSys_wcl.hInstance,MAKEINTRESOURCE(%s))\r\n",pWindowInfo[i].IconResName);
				i2+=lstrlen(buffer+i2);
			}

			sprintf(buffer+i2,"_RadSys_wcl.lpszClassName=\"NORMAL%d\"\r\n",i);
			i2+=lstrlen(buffer+i2);
			if(bAvailUserProc[i])
				sprintf(buffer+i2,"_RadSys_wcl.lpfnWndProc=AddressOf(%s)\r\n",pWindowInfo[i].CallBackName);
			else sprintf(buffer+i2,"_RadSys_wcl.lpfnWndProc=AddressOf(EventCall_%s)\r\n",pWindowInfo[i].name);
			i2+=lstrlen(buffer+i2);
			if(pWindowInfo[i].bgColor==COLOR_3DFACE)
				lstrcpy(buffer+i2,"_RadSys_wcl.hbrBackground=h3DFaceBrush\r\n");
			else if(pWindowInfo[i].bgColor==-(int)RGB(255,255,255))
				lstrcpy(buffer+i2,"_RadSys_wcl.hbrBackground=GetStockObject(WHITE_BRUSH)\r\n");
			else if(pWindowInfo[i].bgColor==-(int)RGB(0,0,0))
				lstrcpy(buffer+i2,"_RadSys_wcl.hbrBackground=GetStockObject(BLACK_BRUSH)\r\n");
			else if(pWindowInfo[i].bgColor<=0||
				pWindowInfo[i].bgColor>=0x1000){
				//Fw܂̓rbg}bv
				sprintf(buffer+i2,"_RadSys_wcl.hbrBackground=_RadSys_hBackBrush%d\r\n",i);
			}
			i2+=lstrlen(buffer+i2);
			lstrcpy(buffer+i2,"RegisterClassEx(_RadSys_wcl)\r\n");
			i2+=lstrlen(buffer+i2);
			sprintf(buffer+i2,"CreateWindowEx(&H%08x,\"%s%d\",\"%s\",&H%08x,%d,%d,%d,%d,0,0,GetModuleHandle(0),0)\r\n",
				pWindowInfo[i].ExStyle,
				pWindowInfo[i].ClassName,i,
				pWindowInfo[i].caption,
				pWindowInfo[i].style,
				pWindowInfo[i].pos.x,
				pWindowInfo[i].pos.y,
				pWindowInfo[i].size.cx,
				pWindowInfo[i].size.cy);
			i2+=lstrlen(buffer+i2);
		}

		while(i2>65535*(size-1)){
			size++;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,65535*size);
		}
	}


	/////////////////////////
	// ۑiMakeWindow.wbpj
	sprintf(temporary,"%sMakeWindow.wbp",ProjectInfo.dir);
	WriteBuffer(temporary,buffer,i2);
	HeapDefaultFree(buffer);
}
int GetSaveMenuData(char *buffer,int SpaceNum,MENU_INFO *pMenuInfo,int ItemNum){
	int i,i2;
	char spaces[MAX_PATH];

	memset(spaces,' ',SpaceNum*4);
	spaces[SpaceNum*4]=0;

	for(i=0,i2=0;i<ItemNum;i++){
		if(pMenuInfo[i].pMenuInfo){
			sprintf(buffer+i2,"%sPOPUP     = \"%s\",%d\r\n",spaces,pMenuInfo[i].caption,pMenuInfo[i].state);
			i2+=lstrlen(buffer+i2);
			i2+=GetSaveMenuData(buffer+i2,SpaceNum+1,pMenuInfo[i].pMenuInfo,pMenuInfo[i].NumberOfMenu);
			sprintf(buffer+i2,"%sEND\r\n",spaces);
			i2+=lstrlen(buffer+i2);
		}
		else if(pMenuInfo[i].type==MFT_STRING){
			sprintf(buffer+i2,"%sITEM      = %s,\"%s\",%d\r\n",spaces,pMenuInfo[i].IdName,pMenuInfo[i].caption,pMenuInfo[i].state);
			i2+=lstrlen(buffer+i2);
		}
		else if(pMenuInfo[i].type==MFT_SEPARATOR){
			sprintf(buffer+i2,"%sSEPARATOR\r\n",spaces);
			i2+=lstrlen(buffer+i2);
		}
	}
	return i2;
}
void SaveWindowFile(char *path,WINDOW_INFO *pWindowInfo,int NumberOfWindowInfo){
	extern HANDLE hHeap;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3,size;
	char *buffer,*temporary;

	size=2;
	buffer=(char *)HeapAlloc(hHeap,0,GENERAL_SIZE*size);
	for(i=0,i2=0;i<NumberOfWindowInfo;i++){
		sprintf(buffer+i2,"WINDOW:%s\r\n",pWindowInfo[i].name);
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"    HANDLE    = %s\r\n",pWindowInfo[i].HandleName);
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"    POINT     = %d,%d\r\n",pWindowInfo[i].pos.x,pWindowInfo[i].pos.y);
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"    SIZE      = %d,%d\r\n",pWindowInfo[i].size.cx,pWindowInfo[i].size.cy);
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"    CAPTION   = \"%s\"\r\n",pWindowInfo[i].caption);
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"    STYLE     = &H%08x\r\n",pWindowInfo[i].style);
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"    EXSTYLE   = &H%08x\r\n",pWindowInfo[i].ExStyle);
		i2+=lstrlen(buffer+i2);
		if(pWindowInfo[i].MenuID){
			sprintf(buffer+i2,"    MENUID    = %s\r\n",pWindowInfo[i].MenuID);
			i2+=lstrlen(buffer+i2);
		}
		sprintf(buffer+i2,"    ID        = %d\r\n",pWindowInfo[i].id);
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"    BGCOLOR   = %d\r\n",pWindowInfo[i].bgColor);
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"    FONT      = %d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,\"%s\"\r\n",
			pWindowInfo[i].LogFont.lfHeight,
			pWindowInfo[i].LogFont.lfWidth,
			pWindowInfo[i].LogFont.lfEscapement,
			pWindowInfo[i].LogFont.lfOrientation,
			pWindowInfo[i].LogFont.lfWeight,
			pWindowInfo[i].LogFont.lfItalic,
			pWindowInfo[i].LogFont.lfUnderline,
			pWindowInfo[i].LogFont.lfStrikeOut,
			pWindowInfo[i].LogFont.lfCharSet,
			pWindowInfo[i].LogFont.lfOutPrecision,
			pWindowInfo[i].LogFont.lfClipPrecision,
			pWindowInfo[i].LogFont.lfQuality,
			pWindowInfo[i].LogFont.lfPitchAndFamily,
			pWindowInfo[i].LogFont.lfFaceName);
		i2+=lstrlen(buffer+i2);
		if(pWindowInfo[i].IconResName){
			sprintf(buffer+i2,"    ICONID    = %s\r\n",pWindowInfo[i].IconResName);
			i2+=lstrlen(buffer+i2);
		}
		sprintf(buffer+i2,"    CLASS     = \"%s\"\r\n",pWindowInfo[i].ClassName);
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"    CALLBACK  = %s\r\n",pWindowInfo[i].CallBackName);
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"    TYPE      = %d\r\n",pWindowInfo[i].type);
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"    FILEPATH  = %s\r\n",pWindowInfo[i].filepath);
		i2+=lstrlen(buffer+i2);
		for(i3=0;i3<pWindowInfo[i].NumberOfChildWindows;i3++){
			temporary=SetCaptionSequence(pWindowInfo[i].pChildInfo[i3].caption);
			sprintf(buffer+i2,"    ITEM      = %s,%d,%d,%d,%d,\"%s\",&H%08x,&H%08x,%d",
				pWindowInfo[i].pChildInfo[i3].IdName,
				pWindowInfo[i].pChildInfo[i3].pos.x,pWindowInfo[i].pChildInfo[i3].pos.y,
				pWindowInfo[i].pChildInfo[i3].size.cx,pWindowInfo[i].pChildInfo[i3].size.cy,
				temporary,
				pWindowInfo[i].pChildInfo[i3].style,
				pWindowInfo[i].pChildInfo[i3].ExStyle,
				pWindowInfo[i].pChildInfo[i3].Control
			);
			i2+=lstrlen(buffer+i2);
			HeapDefaultFree(temporary);
			if(pWindowInfo[i].pChildInfo[i3].Control==CT_IMAGEBOX){
				sprintf(buffer+i2,",%d,\"%s\"",pWindowInfo[i].pChildInfo[i3].ImageCtrlInfo.type,pWindowInfo[i].pChildInfo[i3].ImageCtrlInfo.path);
				i2+=lstrlen(buffer+i2);
			}
			lstrcpy(buffer+i2,"\r\n");
			i2+=lstrlen(buffer+i2);
			if(i2-GENERAL_SIZE<GENERAL_SIZE){
				size++;
				buffer=(char *)HeapReAlloc(hHeap,0,buffer,GENERAL_SIZE*size);
			}
		}
		sprintf(buffer+i2,"END\r\n",pWindowInfo[i].name);
		i2+=lstrlen(buffer+i2);
		if(i2-GENERAL_SIZE<GENERAL_SIZE){
			size++;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,GENERAL_SIZE*size);
		}
	}
	for(i=0;i<ProjectInfo.NumberOfMenu;i++){
		sprintf(buffer+i2,"MENU:%s\r\n",ProjectInfo.pMenuInfo[i].IdName);
		i2+=lstrlen(buffer+i2);
		i2+=GetSaveMenuData(buffer+i2,1,ProjectInfo.pMenuInfo[i].pMenuInfo,ProjectInfo.pMenuInfo[i].NumberOfMenu);
		sprintf(buffer+i2,"END\r\n",pWindowInfo[i].name);
		i2+=lstrlen(buffer+i2);
		if(i2-GENERAL_SIZE<GENERAL_SIZE){
			size++;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,GENERAL_SIZE*size);
		}
	}
	WriteBuffer(path,buffer,i2);
	HeapDefaultFree(buffer);

	extern PROJECTINFO ProjectInfo;
	ProjectInfo.ModifyOfMaterial=0;
}

MENU_INFO *GetMenuData(char *buffer,int *pPos,int *pMenuNum){
	extern HANDLE hHeap;
	int i,i2,i3,i4;
	char temporary[MAX_PATH],*temp2,temp3[MAX_PATH];
	MENU_INFO *pMenuInfo;

	temp2=(char *)HeapAlloc(hHeap,0,lstrlen(buffer)+1);

	*pMenuNum=0;
	pMenuInfo=(MENU_INFO *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,1);

	for(i=*pPos;;i++){
		if(buffer[i]=='\0') return 0;
		if((buffer[i]=='\r'&&buffer[i+1]=='\n')||i==0){
			if(buffer[i]=='\r'&&buffer[i+1]=='\n')  i+=2;
			for(i2=0;;i++,i2++){
				if(!IsVariableChar(buffer[i])){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			if(i2==0){
				i--;
				continue;
			}
			if(buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temp2[i2]=0;
						break;
					}
					temp2[i2]=buffer[i];
				}
			}
			else{
				temp2[0]=0;
				i2=0;
			}


			if(lstrcmpi(temporary,"POPUP")==0){
				(*pMenuNum)++;
				pMenuInfo=(MENU_INFO *)HeapReAlloc(hHeap,HEAP_ZERO_MEMORY,pMenuInfo,(*pMenuNum)*sizeof(MENU_INFO));
				i3=*pMenuNum-1;

				i4=GetOneParameter(temp2,0,temp3);
				RemoveStringQuotes(temp3);
				pMenuInfo[i3].caption=(char *)HeapAlloc(hHeap,0,lstrlen(temp3)+1);
				lstrcpy(pMenuInfo[i3].caption,temp3);

				i4=GetOneParameter(temp2,i4,temp3);
				pMenuInfo[i3].state=GetValue(temp3);

				pMenuInfo[i3].pMenuInfo=GetMenuData(buffer,&i,&pMenuInfo[i3].NumberOfMenu);
			}
			else if(lstrcmpi(temporary,"ITEM")==0){
				(*pMenuNum)++;
				pMenuInfo=(MENU_INFO *)HeapReAlloc(hHeap,HEAP_ZERO_MEMORY,pMenuInfo,(*pMenuNum)*sizeof(MENU_INFO));
				i3=*pMenuNum-1;

				i4=GetOneParameter(temp2,0,temp3);
				pMenuInfo[i3].IdName=(char *)HeapAlloc(hHeap,0,lstrlen(temp3)+1);
				lstrcpy(pMenuInfo[i3].IdName,temp3);

				i4=GetOneParameter(temp2,i4,temp3);
				RemoveStringQuotes(temp3);
				pMenuInfo[i3].caption=(char *)HeapAlloc(hHeap,0,lstrlen(temp3)+1);
				lstrcpy(pMenuInfo[i3].caption,temp3);

				i4=GetOneParameter(temp2,i4,temp3);
				pMenuInfo[i3].state=GetValue(temp3);

				pMenuInfo[i3].type=0;
			}
			else if(lstrcmpi(temporary,"SEPARATOR")==0){
				(*pMenuNum)++;
				pMenuInfo=(MENU_INFO *)HeapReAlloc(hHeap,HEAP_ZERO_MEMORY,pMenuInfo,(*pMenuNum)*sizeof(MENU_INFO));
				i3=*pMenuNum-1;

				pMenuInfo[i3].type=MFT_SEPARATOR;
			}
			else if(lstrcmpi(temporary,"END")==0) break;
			i--;
		}
	}
	*pPos=i;

	HeapDefaultFree(temp2);

	return pMenuInfo;
}
_int8 OpenWindowFile(char *path){
	extern HANDLE hHeap;
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3,i4,i5;
	char *buffer,temporary[MAX_PATH],*temp2,temp3[MAX_PATH];
	CHILDINFO *pChildInfo;

	buffer=ReadBuffer(path);
	if(!buffer) return 0;
	temp2=(char *)HeapAlloc(hHeap,0,lstrlen(buffer)+1);
	ChangeOrSignToDivision(temp2,buffer);
	KillSpaces(temp2,buffer);
	//temp2͂̌̏̈ꎞۑobt@ɂp̂ŉȂ

	ProjectInfo.NumberOfMenu=0;
	ProjectInfo.pMenuInfo=(MENU_INFO *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,1);

	ProjectInfo.NumberOfWindows=0;
	ProjectInfo.pWindowInfo=(WINDOW_INFO *)HeapAlloc(hHeap,0,1);

	for(i=0,i3=0;;i++){
		if(buffer[i]=='\0') break;
		if((buffer[i]=='\r'&&buffer[i+1]=='\n')||i==0){
			if(buffer[i]=='\r'&&buffer[i+1]=='\n')  i+=2;
			for(i2=0;;i++,i2++){
				if(!IsVariableChar(buffer[i])){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			if(i2==0){
				i--;
				continue;
			}
			if(buffer[i]==':'||buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temp2[i2]=0;
						break;
					}
					temp2[i2]=buffer[i];
				}
			}
			else{
				temp2[0]=0;
				i2=0;
			}


			//////////////
			//EBhE
			if(lstrcmpi(temporary,"WINDOW")==0&&i3==0){
				ProjectInfo.NumberOfWindows++;
				ProjectInfo.pWindowInfo=(WINDOW_INFO *)HeapReAlloc(hHeap,HEAP_ZERO_MEMORY,ProjectInfo.pWindowInfo,ProjectInfo.NumberOfWindows*sizeof(WINDOW_INFO));
				i4=ProjectInfo.NumberOfWindows-1;
				i3=1;

				ProjectInfo.pWindowInfo[i4].name=(char *)HeapAlloc(hHeap,0,i2+1);
				lstrcpy(ProjectInfo.pWindowInfo[i4].name,temp2);

				ProjectInfo.pWindowInfo[i4].NumberOfChildWindows=0;
				ProjectInfo.pWindowInfo[i4].pChildInfo=(CHILDINFO *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,1);
			}
			else if(lstrcmpi(temporary,"HANDLE")==0&&i3==1){
				ProjectInfo.pWindowInfo[i4].HandleName=(char *)HeapAlloc(hHeap,0,i2+1);
				lstrcpy(ProjectInfo.pWindowInfo[i4].HandleName,temp2);
			}
			else if(lstrcmpi(temporary,"POINT")==0&&i3==1){
				sscanf(temp2,"%d,%d",
					&ProjectInfo.pWindowInfo[i4].pos.x,
					&ProjectInfo.pWindowInfo[i4].pos.y);
				if(ProjectInfo.pWindowInfo[i4].pos.x==-1) ProjectInfo.pWindowInfo[i4].pos.x=CW_USEDEFAULT;
				if(ProjectInfo.pWindowInfo[i4].pos.y==-1) ProjectInfo.pWindowInfo[i4].pos.y=CW_USEDEFAULT;
			}
			else if(lstrcmpi(temporary,"SIZE")==0&&i3==1){
				sscanf(temp2,"%d,%d",
					&ProjectInfo.pWindowInfo[i4].size.cx,
					&ProjectInfo.pWindowInfo[i4].size.cy);
			}
			else if(lstrcmpi(temporary,"CAPTION")==0&&i3==1){
				if(temp2[0]=='\"'&&temp2[lstrlen(temp2)-1]=='\"'){
					temp2[lstrlen(temp2)-1]=0;
					ProjectInfo.pWindowInfo[i4].caption=(char *)HeapAlloc(hHeap,0,i2+1);
					lstrcpy(ProjectInfo.pWindowInfo[i4].caption,temp2+1);
				}
			}
			else if(lstrcmpi(temporary,"STYLE")==0&&i3==1) ProjectInfo.pWindowInfo[i4].style=GetValue(temp2);
			else if(lstrcmpi(temporary,"EXSTYLE")==0&&i3==1) ProjectInfo.pWindowInfo[i4].ExStyle=GetValue(temp2);
			else if(lstrcmpi(temporary,"MENUID")==0&&i3==1){
				ProjectInfo.pWindowInfo[i4].MenuID=(char *)HeapAlloc(hHeap,0,i2+1);
				lstrcpy(ProjectInfo.pWindowInfo[i4].MenuID,temp2);
			}
			else if(lstrcmpi(temporary,"ID")==0&&i3==1) ProjectInfo.pWindowInfo[i4].id=GetValue(temp2);
			else if(lstrcmpi(temporary,"BGCOLOR")==0&&i3==1){
				ProjectInfo.pWindowInfo[i4].bgColor=GetValue(temp2);
				if(ProjectInfo.dwVersion<=3){
					//vWFNgo[W3ȑÔƂ͐Vlɕϊ
					if(ProjectInfo.pWindowInfo[i4].bgColor==-1)
						ProjectInfo.pWindowInfo[i4].bgColor=-(int)RGB(255,255,255);
				}
			}
			else if(lstrcmpi(temporary,"FONT")==0&&i3==1){
				i5=GetOneParameter(temp2,0,temp3);
				ProjectInfo.pWindowInfo[i4].LogFont.lfHeight=GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				ProjectInfo.pWindowInfo[i4].LogFont.lfWidth=GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				ProjectInfo.pWindowInfo[i4].LogFont.lfEscapement=GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				ProjectInfo.pWindowInfo[i4].LogFont.lfOrientation=GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				ProjectInfo.pWindowInfo[i4].LogFont.lfWeight=GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				ProjectInfo.pWindowInfo[i4].LogFont.lfItalic=(BYTE)GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				ProjectInfo.pWindowInfo[i4].LogFont.lfUnderline=(BYTE)GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				ProjectInfo.pWindowInfo[i4].LogFont.lfStrikeOut=(BYTE)GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				ProjectInfo.pWindowInfo[i4].LogFont.lfCharSet=(BYTE)GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				ProjectInfo.pWindowInfo[i4].LogFont.lfOutPrecision=(BYTE)GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				ProjectInfo.pWindowInfo[i4].LogFont.lfClipPrecision=(BYTE)GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				ProjectInfo.pWindowInfo[i4].LogFont.lfQuality=(BYTE)GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				ProjectInfo.pWindowInfo[i4].LogFont.lfPitchAndFamily=(BYTE)GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				RemoveStringQuotes(temp3);
				lstrcpy(ProjectInfo.pWindowInfo[i4].LogFont.lfFaceName,temp3);
			}
			else if(lstrcmpi(temporary,"ICONID")==0&&i3==1){
				ProjectInfo.pWindowInfo[i4].IconResName=(char *)HeapAlloc(hHeap,0,i2+1);
				lstrcpy(ProjectInfo.pWindowInfo[i4].IconResName,temp2);
			}
			else if(lstrcmpi(temporary,"CLASS")==0&&i3==1){
				if(temp2[0]=='\"'&&temp2[lstrlen(temp2)-1]=='\"'){
					temp2[lstrlen(temp2)-1]=0;
					ProjectInfo.pWindowInfo[i4].ClassName=(char *)HeapAlloc(hHeap,0,i2+1);
					lstrcpy(ProjectInfo.pWindowInfo[i4].ClassName,temp2+1);
				}
			}
			else if(lstrcmpi(temporary,"CALLBACK")==0&&i3==1){
				ProjectInfo.pWindowInfo[i4].CallBackName=(char *)HeapAlloc(hHeap,0,i2+1);
				lstrcpy(ProjectInfo.pWindowInfo[i4].CallBackName,temp2);
			}

			//ȑÕo[WƂ̌݊p
			else if(lstrcmpi(temporary,"DLGTMP")==0&&i3==1) ProjectInfo.pWindowInfo[i4].type=GetValue(temp2);

			else if(lstrcmpi(temporary,"TYPE")==0&&i3==1) ProjectInfo.pWindowInfo[i4].type=GetValue(temp2);
			else if(lstrcmpi(temporary,"FILEPATH")==0&&i3==1){
				ProjectInfo.pWindowInfo[i4].filepath=(char *)HeapAlloc(hHeap,0,i2+1);
				lstrcpy(ProjectInfo.pWindowInfo[i4].filepath,temp2);
			}
			else if(lstrcmpi(temporary,"ITEM")==0&&i3==1){
				ProjectInfo.pWindowInfo[i4].pChildInfo=(CHILDINFO *)HeapReAlloc(hHeap,HEAP_ZERO_MEMORY,ProjectInfo.pWindowInfo[i4].pChildInfo,(ProjectInfo.pWindowInfo[i4].NumberOfChildWindows+1)*sizeof(CHILDINFO));
				pChildInfo=&ProjectInfo.pWindowInfo[i4].pChildInfo[ProjectInfo.pWindowInfo[i4].NumberOfChildWindows];

				//ID
				i5=GetOneParameter(temp2,0,temp3);
				pChildInfo->IdName=(char *)HeapAlloc(hHeap,0,lstrlen(temp3)+1);
				lstrcpy(pChildInfo->IdName,temp3);

				//ʒu
				i5=GetOneParameter(temp2,i5,temp3);
				pChildInfo->pos.x=GetValue(temp3);
				i5=GetOneParameter(temp2,i5,temp3);
				pChildInfo->pos.y=GetValue(temp3);
				i5=GetOneParameter(temp2,i5,temp3);
				pChildInfo->size.cx=GetValue(temp3);
				i5=GetOneParameter(temp2,i5,temp3);
				pChildInfo->size.cy=GetValue(temp3);

				//eLXg
				i5=GetOneParameter(temp2,i5,temp3);
				RemoveStringQuotes(temp3);
				RestoreCaptionSequence(temp3);
				pChildInfo->caption=(char *)HeapAlloc(hHeap,0,lstrlen(temp3)+1);
				lstrcpy(pChildInfo->caption,temp3);

				//X^C
				i5=GetOneParameter(temp2,i5,temp3);
				pChildInfo->style=GetValue(temp3);

				//gX^C
				i5=GetOneParameter(temp2,i5,temp3);
				pChildInfo->ExStyle=GetValue(temp3);

				//NX
				i5=GetOneParameter(temp2,i5,temp3);
				pChildInfo->Control=GetValue(temp3);

				if(pChildInfo->Control==CT_IMAGEBOX){
					//C[W {bNX̏ꍇ
					i5=GetOneParameter(temp2,i5,temp3);
					pChildInfo->ImageCtrlInfo.type=GetValue(temp3);
					i5=GetOneParameter(temp2,i5,temp3);
					RemoveStringQuotes(temp3);
					pChildInfo->ImageCtrlInfo.path=(char *)HeapAlloc(hHeap,0,lstrlen(temp3)+1);
					lstrcpy(pChildInfo->ImageCtrlInfo.path,temp3);
				}

				ProjectInfo.pWindowInfo[i4].NumberOfChildWindows++;
			}


			////////////
			//j[
			else if(lstrcmpi(temporary,"MENU")==0&&i3==0){
				ProjectInfo.NumberOfMenu++;
				ProjectInfo.pMenuInfo=(MENU_INFO *)HeapReAlloc(hHeap,HEAP_ZERO_MEMORY,ProjectInfo.pMenuInfo,ProjectInfo.NumberOfMenu*sizeof(MENU_INFO));
				i4=ProjectInfo.NumberOfMenu-1;

				//ID
				ProjectInfo.pMenuInfo[i4].IdName=(char *)HeapAlloc(hHeap,0,lstrlen(temp2)+1);
				lstrcpy(ProjectInfo.pMenuInfo[i4].IdName,temp2);
				ProjectInfo.pMenuInfo[i4].pMenuInfo=GetMenuData(buffer,&i,&ProjectInfo.pMenuInfo[i4].NumberOfMenu);
				if(!ProjectInfo.pMenuInfo[i4].pMenuInfo){
					//"EBhE`t@CĂ܂B\n\n%s"
					sprintf(temporary,STRING_ERROR_BROKEN_WNDFILE,path);
					MessageBox(hOwner,temporary,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);

					HeapDefaultFree(temp2);
					HeapDefaultFree(buffer);
					return 0;
				}
			}


			else if(lstrcmpi(temporary,"END")==0&&i3) i3=0;
			else{
				//"EBhE`t@CĂ܂B\n\n%s"
				sprintf(temporary,STRING_ERROR_BROKEN_WNDFILE,path);
				MessageBox(hOwner,temporary,APPLICATION_NAME,MB_OK|MB_ICONEXCLAMATION);

				HeapDefaultFree(temp2);
				HeapDefaultFree(buffer);
				return 0;
			}
			i--;
		}
	}

	HeapDefaultFree(temp2);
	HeapDefaultFree(buffer);
	return 1;
}

struct NEW_WINDOW{
	char name[MAX_PATH];
	char HandleName[MAX_PATH];
	char CallBackName[MAX_PATH];
	BOOL type;
};
NEW_WINDOW NewWindow;
BOOL CALLBACK DlgProject_NewWindow(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	char temporary[MAX_PATH],temp2[MAX_PATH];
	switch(message){
		case WM_INITDIALOG:
			SetPosCenter(hwnd);
			SendDlgItemMessage(hwnd,IDC_AUTOSET,BM_SETCHECK,BST_CHECKED,0);
			SendMessage(hwnd,WM_COMMAND,IDC_AUTOSET,0);
			SendDlgItemMessage(hwnd,IDC_MODALDLG,BM_SETCHECK,BST_CHECKED,0);
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					GetDlgItemText(hwnd,IDC_WINDOWNAME,NewWindow.name,MAX_PATH);
					GetDlgItemText(hwnd,IDC_WINDOWHANDLE,NewWindow.HandleName,MAX_PATH);
					GetDlgItemText(hwnd,IDC_WINDOWPROC,NewWindow.CallBackName,MAX_PATH);
					if(SendDlgItemMessage(hwnd,IDC_DEFWINDOW,BM_GETCHECK,0,0))
						NewWindow.type=WNDTYPE_DEFAULT;
					else if(SendDlgItemMessage(hwnd,IDC_MODALDLG,BM_GETCHECK,0,0))
						NewWindow.type=WNDTYPE_MODALDLG;
					else if(SendDlgItemMessage(hwnd,IDC_MODELESSDLG,BM_GETCHECK,0,0))
						NewWindow.type=WNDTYPE_MODELESSDLG;
					EndDialog(hwnd,1);
					return 1;
				case IDCANCEL:
					EndDialog(hwnd,0);
					return 1;
				case IDC_WINDOWNAME:
					if(HIWORD(wParam)==EN_CHANGE) SendMessage(hwnd,WM_COMMAND,IDC_AUTOSET,0);
					return 1;
				case IDC_AUTOSET:
					if(SendDlgItemMessage(hwnd,IDC_AUTOSET,BM_GETCHECK,0,0)){
						SendDlgItemMessage(hwnd,IDC_WINDOWHANDLE,EM_SETREADONLY,1,0);
						SendDlgItemMessage(hwnd,IDC_WINDOWPROC,EM_SETREADONLY,1,0);
						GetDlgItemText(hwnd,IDC_WINDOWNAME,temporary,MAX_PATH);
						if(temporary[0]){
							sprintf(temp2,"h%s",temporary);
							SetDlgItemText(hwnd,IDC_WINDOWHANDLE,temp2);
							sprintf(temp2,"%sProc",temporary);
							SetDlgItemText(hwnd,IDC_WINDOWPROC,temp2);
						}
						else{
							SetDlgItemText(hwnd,IDC_WINDOWHANDLE,"");
							SetDlgItemText(hwnd,IDC_WINDOWPROC,"");
						}
					}
					else{
						SendDlgItemMessage(hwnd,IDC_WINDOWHANDLE,EM_SETREADONLY,0,0);
						SendDlgItemMessage(hwnd,IDC_WINDOWPROC,EM_SETREADONLY,0,0);
					}
					return 1;
			}
			break;
	}
	return 0;
}
void GetDefaultWindowFont(LOGFONT *LogFont){
	LogFont->lfHeight=-12;
	LogFont->lfWidth=0;
	LogFont->lfEscapement=0;
	LogFont->lfOrientation=0;
	LogFont->lfWeight=FW_REGULAR;
	LogFont->lfItalic=0;
	LogFont->lfUnderline=0;
	LogFont->lfStrikeOut=0;
	LogFont->lfCharSet=SHIFTJIS_CHARSET;
	LogFont->lfOutPrecision=OUT_STROKE_PRECIS;
	LogFont->lfClipPrecision=CLIP_STROKE_PRECIS;
	LogFont->lfQuality=DRAFT_QUALITY;
	LogFont->lfPitchAndFamily=FF_SWISS;
	lstrcpy(LogFont->lfFaceName,"lr oSVbN");
}
void Project_Window_Insert(void){
	extern HANDLE hHeap;
	extern PROJECTINFO ProjectInfo;
	int i;
	char temporary[MAX_PATH],temp2[1024],*pTemp;

	if(!DialogBox(hResInst,MAKEINTRESOURCE(IDD_PROJECT_NEWWINDOW),hOwner,DlgProject_NewWindow)) return;

	//d`FbN
	sprintf(temporary,"%s.sbp",NewWindow.name);
	if(ProjectInfo.pobj_DBFileInfo->dupli_check(temporary)){
		sprintf(temp2,"\"%s\" t@C͊ɃvWFNgɑ݂܂B",temporary);
		MessageBox(hOwner,temp2,APPLICATION_NAME,MB_OK|MB_ICONEXCLAMATION);
		return;
	}
	for(i=0;i<ProjectInfo.NumberOfWindows;i++){
		if(lstrcmpi(NewWindow.name,ProjectInfo.pWindowInfo[i].name)==0){
			//"\"%s\" EBhE͊ɃvWFNgɑ݂܂B"
			sprintf(temporary,STRING_DUPLICATIONERROR_WINDOW_IN_PROJECT,ProjectInfo.pWindowInfo[i].name);
			MessageBox(hOwner,temporary,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
			return;
		}
		if(lstrcmpi(NewWindow.HandleName,ProjectInfo.pWindowInfo[i].HandleName)==0){
			//"\"%s\" nh͊ɃvWFNgɑ݂܂B"
			sprintf(temporary,STRING_DUPLICATIONERROR_HANDLE_IN_PROJECT,ProjectInfo.pWindowInfo[i].HandleName);
			MessageBox(hOwner,temporary,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
			return;
		}
		if(lstrcmpi(NewWindow.CallBackName,ProjectInfo.pWindowInfo[i].CallBackName)==0){
			//"\"%s\" vV[W͊ɃvWFNgɑ݂܂B"
			sprintf(temporary,STRING_DUPLICATIONERROR_PROC_IN_PROJECT,ProjectInfo.pWindowInfo[i].CallBackName);
			MessageBox(hOwner,temporary,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
			return;
		}
	}

	//ProjectInfo.pWindowInfo\̂ɒǉ
	ProjectInfo.pWindowInfo=(WINDOW_INFO *)HeapReAlloc(hHeap,0,ProjectInfo.pWindowInfo,(ProjectInfo.NumberOfWindows+1)*sizeof(WINDOW_INFO));


	///////////////////////////////////////
	//ProjectInfo.pWindowInfo\̂ݒ

	//EBhE
	ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].name=(char *)HeapAlloc(hHeap,0,lstrlen(NewWindow.name)+1);
	lstrcpy(ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].name,NewWindow.name);

	//nh
	ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].HandleName=(char *)HeapAlloc(hHeap,0,lstrlen(NewWindow.HandleName)+1);
	lstrcpy(ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].HandleName,NewWindow.HandleName);

	//ʒu
	ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].pos.x=-1;
	ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].pos.y=-1;
	ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].size.cx=480;
	ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].size.cy=360;

	//EBhEeLXg
	ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].caption=(char *)HeapAlloc(hHeap,0,lstrlen(NewWindow.name)+1);
	lstrcpy(ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].caption,NewWindow.name);

	//X^C
	switch(NewWindow.type){
		case WNDTYPE_DEFAULT:
			//ʏEBhE
			ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].style=WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|WS_THICKFRAME|WS_MINIMIZEBOX|WS_MAXIMIZEBOX;
			break;
		case WNDTYPE_MODALDLG:
		case WNDTYPE_MODELESSDLG:
			//_CAO ev[giő剻Aŏ{^ȂāAטgɂj
			ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].style=WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU;
			break;
	}

	//gX^C
	ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].ExStyle=0;

	//j[
	ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].MenuID=0;

	//ID
	ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].id=0;

	//wiF
	ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].bgColor=COLOR_3DFACE;

	//tHg
	GetDefaultWindowFont(&ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].LogFont);

	//ACR
	ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].IconResName=0;

	//NX
	lstrcpy(temporary,"NORMAL");
	ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].ClassName=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
	lstrcpy(ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].ClassName,temporary);

	//R[obN֐
	ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].CallBackName=(char *)HeapAlloc(hHeap,0,lstrlen(NewWindow.CallBackName)+1);
	lstrcpy(ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].CallBackName,NewWindow.CallBackName);

	//^Cv
	ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].type=NewWindow.type;

	//qEBhE
	ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].NumberOfChildWindows=0;
	ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].pChildInfo=(CHILDINFO *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,1);


	//bZ[Wt@C
	sprintf(temporary,"%s.ab",ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].name);
	ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].filepath=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
	lstrcpy(ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].filepath,temporary);


	//////////////////////////
	// bZ[Wt@C
	//////////////////////////

	//ev[gǂݍ
#if defined(JPN)
	//{t@C
	sprintf(temporary,"%sSubOperation\\new_window_template.sbp",pj_editor_Dir);
#else
	//pt@C
	sprintf(temporary,"%sSubOperation\\new_window_template_e.sbp",pj_editor_Dir);
#endif
	pTemp=ReadBuffer(temporary);

	//#name#vWFNgɒu
	pTemp=PermutationWndPgmTemplate(pTemp,
		ProjectInfo.name,
		NewWindow.name,
		NewWindow.HandleName,
		NewWindow.CallBackName);

	sprintf(temporary,"%s%s.ab",ProjectInfo.dir,ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].name);

	//
	WriteBuffer(temporary,pTemp,lstrlen(pTemp));
	Project_File_Insert(temporary);

	HeapDefaultFree(pTemp);


	//////////////////////
	//c[r[ɒǉ

	extern HWND hMaterialTreeView;
	TV_INSERTSTRUCT tv;
	tv.hInsertAfter=TVI_SORT;
	tv.item.mask=TVIF_TEXT|TVIF_IMAGE|TVIF_SELECTEDIMAGE;
	tv.item.iImage=2;
	tv.item.iSelectedImage=2;
	tv.hParent=ProjectInfo.hWindowTreeItem;
	tv.item.pszText=ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].name;

	ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].hTreeItem=TreeView_InsertItem(hMaterialTreeView,&tv);

	TreeView_SelectItem(hMaterialTreeView,ProjectInfo.pWindowInfo[ProjectInfo.NumberOfWindows].hTreeItem);


	ProjectInfo.NumberOfWindows++;
	ProjectInfo.ModifyOfMaterial=1;

	NewRadWindow(ProjectInfo.NumberOfWindows-1);
}
void Project_Window_Delete(int WndInfoNum){
	extern HANDLE hHeap;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i;

	//EBhEJĂꍇ͕
	for(i=0;i<MAX_WNDNUM;i++){
		if(MdiInfo[i].hwnd&&lstrcmpi(ProjectInfo.pWindowInfo[WndInfoNum].name,MdiInfo[i].path)==0){
			SendMessage(MdiInfo[i].hwnd,WM_CLOSE,0,0);
			break;
		}
	}

	//EBhẼ
	HeapDefaultFree(ProjectInfo.pWindowInfo[WndInfoNum].name);
	HeapDefaultFree(ProjectInfo.pWindowInfo[WndInfoNum].filepath);
	HeapDefaultFree(ProjectInfo.pWindowInfo[WndInfoNum].HandleName);
	HeapDefaultFree(ProjectInfo.pWindowInfo[WndInfoNum].caption);
	HeapDefaultFree(ProjectInfo.pWindowInfo[WndInfoNum].ClassName);
	HeapDefaultFree(ProjectInfo.pWindowInfo[WndInfoNum].CallBackName);

	//qEBhẼ
	for(i=0;i<ProjectInfo.pWindowInfo[WndInfoNum].NumberOfChildWindows;i++){
		HeapDefaultFree(ProjectInfo.pWindowInfo[WndInfoNum].pChildInfo[i].IdName);
		HeapDefaultFree(ProjectInfo.pWindowInfo[WndInfoNum].pChildInfo[i].caption);
	}
	HeapDefaultFree(ProjectInfo.pWindowInfo[WndInfoNum].pChildInfo);

	//c[r[폜
	extern HWND hMaterialTreeView;
	TreeView_DeleteItem(hMaterialTreeView,ProjectInfo.pWindowInfo[WndInfoNum].hTreeItem);

	//ProjectInfo.pWindowInfo\̂폜
	ProjectInfo.NumberOfWindows--;
	for(i=WndInfoNum;i<ProjectInfo.NumberOfWindows;i++) ProjectInfo.pWindowInfo[i]=ProjectInfo.pWindowInfo[i+1];
	if(ProjectInfo.NumberOfWindows==0) ProjectInfo.pWindowInfo=(WINDOW_INFO *)HeapReAlloc(hHeap,0,ProjectInfo.pWindowInfo,1);
	else ProjectInfo.pWindowInfo=(WINDOW_INFO *)HeapReAlloc(hHeap,0,ProjectInfo.pWindowInfo,ProjectInfo.NumberOfWindows*sizeof(WINDOW_INFO));

	ProjectInfo.ModifyOfMaterial=1;
}
