#include "common.h"

void TextEdit_UndoCommand(int WndNum){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i;
	TEXTEDIT_UNDOSTATE *pUndoState;

	//Cfg̃Cfg𖳌ɂ
	if(MdiInfo[WndNum].IndentStr) CancelBeforeAutoIndent(WndNum);

	pUndoState=MdiInfo[WndNum].pMdiTextEdit->pTextEditUndoState;
	i=pUndoState->NowPos-1;
	if(i==-1) i=MAX_UNDONUM-1;
	if(!pUndoState->Command[i]){
		MessageBeep(0);
		return;
	}
	pUndoState->NowPos=i;

	//I͈͂Zbg
	GetCaretPosFromBufferIndex(MdiInfo[WndNum].pMdiTextEdit->buffer,
		pUndoState->Range[pUndoState->NowPos].cpMin,
		&MdiInfo[WndNum].pMdiTextEdit->StartCaretPos);
	GetCaretPosFromBufferIndex(MdiInfo[WndNum].pMdiTextEdit->buffer,
		pUndoState->Range[pUndoState->NowPos].cpMax,
		&MdiInfo[WndNum].pMdiTextEdit->EndCaretPos);

	switch(pUndoState->Command[pUndoState->NowPos]){
		case TEXTEDIT_UNDO_KEY:
		case TEXTEDIT_UNDO_PASTE:
			TextEdit_Replace(WndNum,"",1);
			break;
		case TEXTEDIT_UNDO_SELKEY:
			TextEdit_Replace(WndNum,pUndoState->DelStr[pUndoState->NowPos],1);
			break;
	}

	TextEdit_ScrollCaret(WndNum,0);
	ResetCaretPos(WndNum);

	//ɖ߂A蒼j[Zbg
	ResetState_UndoMenu();

	//ύXʒm
	MdiInfo[WndNum].pMdiTextEdit->NofityUndoRedoToModify();
}
void TextEdit_RedoCommand(int WndNum){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	TEXTEDIT_UNDOSTATE *pUndoState;

	pUndoState=MdiInfo[WndNum].pMdiTextEdit->pTextEditUndoState;
	if(!pUndoState->Command[pUndoState->NowPos]){
		MessageBeep(0);
		return;
	}

	switch(pUndoState->Command[pUndoState->NowPos]){
		case TEXTEDIT_UNDO_KEY:
		case TEXTEDIT_UNDO_PASTE:
			//I͈͂Zbg
			GetCaretPosFromBufferIndex(MdiInfo[WndNum].pMdiTextEdit->buffer,
				pUndoState->Range[pUndoState->NowPos].cpMin,
				&MdiInfo[WndNum].pMdiTextEdit->StartCaretPos);
			GetCaretPosFromBufferIndex(MdiInfo[WndNum].pMdiTextEdit->buffer,
				pUndoState->Range[pUndoState->NowPos].cpMin,
				&MdiInfo[WndNum].pMdiTextEdit->EndCaretPos);

			TextEdit_Replace(WndNum,pUndoState->KeyStr[pUndoState->NowPos],1);
			break;
		case TEXTEDIT_UNDO_SELKEY:
			//I͈͂Zbg
			GetCaretPosFromBufferIndex(MdiInfo[WndNum].pMdiTextEdit->buffer,
				pUndoState->DelRange[pUndoState->NowPos].cpMin,
				&MdiInfo[WndNum].pMdiTextEdit->StartCaretPos);
			GetCaretPosFromBufferIndex(MdiInfo[WndNum].pMdiTextEdit->buffer,
				pUndoState->DelRange[pUndoState->NowPos].cpMax,
				&MdiInfo[WndNum].pMdiTextEdit->EndCaretPos);

			TextEdit_Replace(WndNum,pUndoState->KeyStr[pUndoState->NowPos],1);
			break;
	}

	TextEdit_ScrollCaret(WndNum,0);
	ResetCaretPos(WndNum);

	pUndoState->NowPos++;
	if(pUndoState->NowPos==MAX_UNDONUM) pUndoState->NowPos=0;

	//ɖ߂A蒼j[Zbg
	ResetState_UndoMenu();

	//ύXʒm
	MdiInfo[WndNum].pMdiTextEdit->NofityUndoRedoToModify();
}

BOOL bUndoDelimitation(char c){
	if(c==' '||c=='\t'||
		c=='\"'||
		c==','||c==':'||c==';'||
		c=='('||c==')'||
		c=='+'||c=='-'||c=='*'||c=='/'||c=='^'||c=='\\'||c=='<'||c=='>'||c=='=') return 1;
	return 0;
}
void TextEdit_NoticeChanging(int WndNum,int Command,char *KeyStr,char *DelStr,CHARRANGE *Range,CHARRANGE *DelRange){
	extern HANDLE hHeap;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i;
	TEXTEDIT_UNDOSTATE *pUndoState;

	pUndoState=MdiInfo[WndNum].pMdiTextEdit->pTextEditUndoState;

	//Redoꂽꍇ̕svȃf[^폜
	for(i=pUndoState->NowPos;;i++){
		if(i==MAX_UNDONUM) i=0;
		if(pUndoState->Command[i]==0) break;
		TextEdit_DeleteUndoData(pUndoState,i);
	}

	i=pUndoState->NowPos-1;
	if(i==-1) i=MAX_UNDONUM-1;
	if(pUndoState->Command[i]==Command&&
		pUndoState->Command[i]==TEXTEDIT_UNDO_KEY){
		if(pUndoState->Range[i].cpMax==Range->cpMin&&KeyStr[0]!='\r'){
			if(!(bUndoDelimitation(pUndoState->KeyStr[i][0])^bUndoDelimitation(KeyStr[0]))){
				pUndoState->KeyStr[i]=(char *)HeapReAlloc(hHeap,0,pUndoState->KeyStr[i],lstrlen(pUndoState->KeyStr[i])+lstrlen(KeyStr)+1);
				lstrcat(pUndoState->KeyStr[i],KeyStr);
				pUndoState->Range[i].cpMax+=lstrlen(KeyStr);

				HeapDefaultFree(KeyStr);

				//ɖ߂A蒼j[Zbg
				ResetState_UndoMenu();
				return;
			}
		}
	}

	//f[^XV
	pUndoState->Command[pUndoState->NowPos]=Command;
	pUndoState->KeyStr[pUndoState->NowPos]=KeyStr;
	pUndoState->DelStr[pUndoState->NowPos]=DelStr;
	pUndoState->Range[pUndoState->NowPos]=*Range;
	if(DelRange) pUndoState->DelRange[pUndoState->NowPos]=*DelRange;

	pUndoState->NowPos++;
	if(pUndoState->NowPos==MAX_UNDONUM) pUndoState->NowPos=0;
	if(pUndoState->Command[pUndoState->NowPos]){
		//ԌÂ؂̂Ă
		TextEdit_DeleteUndoData(pUndoState,pUndoState->NowPos);
	}

	//ɖ߂A蒼j[Zbg
	ResetState_UndoMenu();
}

void TextEdit_DeleteUndoData(TEXTEDIT_UNDOSTATE *pUndoState,int pos){
	if(pUndoState->KeyStr[pos]) HeapDefaultFree(pUndoState->KeyStr[pos]);
	if(pUndoState->DelStr[pos]) HeapDefaultFree(pUndoState->DelStr[pos]);
	pUndoState->Command[pos]=0;
}
