#include "common.h"

CFileInfo::CFileInfo(char *path,HTREEITEM hTreeItem){
	m_path=(char *)HeapAlloc(hHeap,0,lstrlen(path)+1);
	lstrcpy(m_path,path);
	m_hTreeItem=hTreeItem;
}
CFileInfo::~CFileInfo(){
	HeapDefaultFree(m_path);
}
void CFileInfo::GetFullPath(char *buffer){
	lstrcpy(buffer,m_path);
	::GetFullPath(buffer,ProjectInfo.dir);
}


CDBFileInfo::CDBFileInfo(){
	iNum=0;
	ppobj_FileInfo=(CFileInfo **)HeapAlloc(hHeap,0,1);
}
CDBFileInfo::~CDBFileInfo(){
	int i;
	for(i=0;i<iNum;i++){
		delete ppobj_FileInfo[i];
	}
	HeapDefaultFree(ppobj_FileInfo);
}

void CDBFileInfo::add(char *path,HTREEITEM hTreeItem){
	ppobj_FileInfo=(CFileInfo **)HeapReAlloc(hHeap,0,ppobj_FileInfo,(iNum+1)*sizeof(CFileInfo *));
	ppobj_FileInfo[iNum]=new CFileInfo(path,hTreeItem);
	iNum++;
}
void CDBFileInfo::del(HTREEITEM hTreeItem){
	int i;
	for(i=0;i<iNum;i++){
		if(ppobj_FileInfo[i]->m_hTreeItem==hTreeItem) break;
	}
	if(i==iNum) return;

	delete ppobj_FileInfo[i];

	iNum--;
	for(;i<iNum;i++) ppobj_FileInfo[i]=ppobj_FileInfo[i+1];
}
char *CDBFileInfo::GetPath(HTREEITEM hTreeItem){
	int i;
	for(i=0;i<iNum;i++){
		if(ppobj_FileInfo[i]->m_hTreeItem==hTreeItem) break;
	}
	if(i==iNum) return 0;
	return ppobj_FileInfo[i]->m_path;
}
BOOL CDBFileInfo::IsMainFile(HTREEITEM hTreeItem){
	int i;
	for(i=0;i<iNum;i++){
		if(ppobj_FileInfo[i]->m_hTreeItem==hTreeItem) break;
	}
	if(i==0) return 1;
	return 0;
}
void CDBFileInfo::SetTreeItem(int index,HTREEITEM hTreeItem){
	ppobj_FileInfo[index]->m_hTreeItem=hTreeItem;
}
void CDBFileInfo::ResetTree(void){
	TV_INSERTSTRUCT tv;

	TreeView_DeleteAllItems(pobj_FileTree->hTree);

	tv.hInsertAfter=TVI_SORT;
	tv.item.mask=TVIF_TEXT|TVIF_IMAGE|TVIF_SELECTEDIMAGE;

	tv.hParent=TVI_ROOT;
	tv.item.iImage=0;
	tv.item.iSelectedImage=0;
	tv.item.pszText="Source Files";
	tv.hParent=TreeView_InsertItem(pobj_FileTree->hTree,&tv);

	int i;
	char temporary[MAX_PATH],temp2[MAX_PATH];
	for(i=0;i<iNum;i++){
		_splitpath(ppobj_FileInfo[i]->m_path,0,0,temporary,temp2);
		lstrcat(temporary,temp2);
		tv.item.iImage=2;
		tv.item.iSelectedImage=2;
		tv.item.pszText=temporary;
		ppobj_FileInfo[i]->m_hTreeItem=TreeView_InsertItem(pobj_FileTree->hTree,&tv);
	}
}
BOOL CDBFileInfo::dupli_check(char *path){
	//d`FbN
	int i;
	for(i=0;i<iNum;i++){
		if(lstrcmpi(ppobj_FileInfo[i]->m_path,path)==0){
			return 1;
		}
	}
	return 0;
}
