#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

BOOL CalcTwoTerm_Relational(int idCalc,int *type,LONG_PTR *index_stack,int *pStackPointer){
	int reg1,reg2;
	int AnswerType;

	int sp;
	sp=*pStackPointer;

	AnswerType=NeutralizationType(type[sp-2],index_stack[sp-2],type[sp-1],index_stack[sp-1]);

	if(IsRealNumberType(AnswerType)){
		////////////////
		// Z
		////////////////
		int xmm_reg1,xmm_reg2;

		//2̍K؂ȃWX^ɃZbg
		SetTowTermToReg_RealCalc(AnswerType,type,sp,&xmm_reg1,&xmm_reg2);

		if(AnswerType==DEF_DOUBLE){
			//comisd xmm_reg1,xmm_reg2
			op_comisd(xmm_reg1,xmm_reg2);
		}
		else if(AnswerType==DEF_SINGLE){
			//comiss xmm_reg1,xmm_reg2
			op_comiss(xmm_reg1,xmm_reg2);
		}

		//XmmWX^
		pobj_reg->UnlockXmmReg();

		//ėpWX^m
		reg1=pobj_reg->LockReg();
	}
	else if(Is64Type(AnswerType)){
		//////////////////////
		// 64rbgZ
		//////////////////////

		//2̍K؂ȃWX^ɃZbg
		SetTowTermToReg_Whole64Calc(type,sp,&reg1,&reg2);

		//cmp reg1,reg2
		op_cmp_reg(sizeof(_int64),reg1,reg2);
	}
	else{
		//////////////////////
		// 32rbgZ
		//////////////////////

		//2̍K؂ȃWX^ɃZbg
		SetTowTermToReg_Whole32Calc(type,sp,&reg1,&reg2);

		//cmp reg1,reg2
		op_cmp_reg(sizeof(long),reg1,reg2);
	}


	////////////////////
	// 
	////////////////////

	if(idCalc==CALC_PE){
		//	reg1 <= reg2
		if(IsSignedType(AnswerType)&&IsWholeNumberType(AnswerType)){
			//艉Z
			//jle
			OpBuffer[obp++]=(char)0x7E;
		}
		else{
			//ȂZ
			//jbe
			OpBuffer[obp++]=(char)0x76;
		}
	}
	else if(idCalc==CALC_QE){
		//  reg1 >= reg2
		if(IsSignedType(AnswerType)&&IsWholeNumberType(AnswerType)){
			//艉Z
			//jge
			OpBuffer[obp++]=(char)0x7D;
		}
		else{
			//ȂZ
			//jae
			OpBuffer[obp++]=(char)0x73;
		}
	}
	else if(idCalc==CALC_P){
		//	reg1 < reg2
		if(IsSignedType(AnswerType)&&IsWholeNumberType(AnswerType)){
			//艉Z
			//jl
			OpBuffer[obp++]=(char)0x7C;
		}
		else{
			//ȂZ
			//jb
			OpBuffer[obp++]=(char)0x72;
		}
	}
	else if(idCalc==CALC_Q){
		//  reg1 > reg2
		if(IsSignedType(AnswerType)&&IsWholeNumberType(AnswerType)){
			//艉Z
			//jg
			OpBuffer[obp++]=(char)0x7F;
		}
		else{
			//ȂZ
			//ja
			OpBuffer[obp++]=(char)0x77;
		}
	}
	else if(idCalc==CALC_NOTEQUAL){
		//  reg1 <> reg2

		//jne
		OpBuffer[obp++]=(char)0x75;
	}
	else if(idCalc==CALC_EQUAL){
		//  reg1 = reg2

		//je
		OpBuffer[obp++]=(char)0x74;
	}
	OpBuffer[obp++]=(char)0x05;


	//////////////////////
	// FALSEZbg
	//////////////////////

	//xor reg1,reg1
	op_zero_reg(reg1);

	//jmp 7imovщzj
	OpBuffer[obp++]=(char)0xEB;
	OpBuffer[obp++]=(char)0x07;


	///////////////////
	// TrueZbg
	///////////////////

	//mov reg1,1
	op_mov_RV(sizeof(_int64),reg1,1);


	if(reg1==REG_R14){
		//mov qword ptr[rsp+offset],r14     X^bNt[𗘗p
		pobj_sf->push(REG_R14);
	}

	sp--;

	*pStackPointer=sp;

	type[sp-1]=DEF_BOOLEAN;

	return 1;
}
