#include "../BasicCompiler_Common/common.h"
#include "opcode.h"

int ParamImpl::NewTempParameters( const string &procName, const Parameters &params, int SecondParmNum ){
	if( SecondParmNum == -1 ) SecondParmNum = (int)params.size();

	///////////////////////////////////////////////////////
	// ꎞIuWFNg炩߃X^bNɐςł
	///////////////////////////////////////////////////////

	useTempObject = false;

	//ꎞQƂ̐
	nCountOfTempObjects = 0;

	BOOL bEllipse;
	if(params.size()){
		if(params[params.size()-1]->GetBasicType()==DEF_ELLIPSE) bEllipse=1;
		else bEllipse=0;
	}
	else bEllipse=0;

	for(int i2=ParmsNum-1;i2>=0;i2--){
		useTempParameters[i2] = false;

		if(bEllipse&&i2<=(int)params.size()-2) bEllipse=0;

		if(i2==0){
			if( params[i2]->GetVarName() == "_System_LocalThis" ){
				//IuWFNgȏp[^This|C^
				continue;
			}
		}
		if( i2==0||i2==1 ){
			if( params[i2]->GetVarName() == procName ){
				//IuWFNgȏ܂͑p[^̖߂lpIuWFNg
				continue;
			}
		}

		Type dummyType;
		BOOL bByVal;
		if(bEllipse){
			NumOpe_GetType( Parms[i2], Type(), dummyType );
			bByVal=1;
		}
		else{
			dummyType = *params[i2];
			bByVal = ( params[i2]->IsRef() == false ) ? TRUE:FALSE;
		}


		if( !bByVal ){
			//|C^Q
			if(Parms[i2][0]==1&&Parms[i2][1]==ESC_BYVAL){
				//|C^w
				continue;
			}

			if( !GetVarType( Parms[i2], Type(), FALSE ) ){
				//ϐł͂ȂƂ
				Type calcType;
				NumOpe( Parms[i2], dummyType, calcType );
				//ŃX^bNɐς

				nCountOfTempObjects++;

				if( !calcType.IsStruct() ){
					//ꎞQƂ쐬

					//push esp
					op_push( REG_ESP );

					nCountOfTempObjects++;
				}

				bool result = CheckDifferentType(
					dummyType,
					calcType,
					procName.c_str(),
					i2);

				if( result ){
					useTempParameters[i2] = true;
					useTempObject = true;

					types[i2] = calcType;
				}
			}
		}
	}

	return nCountOfTempObjects * PTR_SIZE;
}

void ParamImpl::DeleteTempParameters(){
	///////////////////////////////////////////////////////
	// ꎞIuWFNgj
	///////////////////////////////////////////////////////
	if( !useTempObject ) return;

	for(int i2=ParmsNum-1;i2>=0;i2--){
		if( useTempParameters[i2] ){
			if( types[i2].IsStruct() ){
				// \̂̈ꎞ

				//

				//call free
				extern UserProc *pSub_free;
				op_call(pSub_free);
			}
			else{
				if( types[i2].Is64() ){
					//pop ... QƂ
					//pop ... 32rbg
					//pop ... 32rbg
					op_add_esp( PTR_SIZE * 3 );
				}
				else{
					//pop ... QƂ
					//pop ... l
					op_add_esp( PTR_SIZE * 2 );
				}
			}
		}
	}
}

void ParamImpl::SetStructParameter( const Type &baseType, const char *expression ){
	int object_size = baseType.GetClass().GetSize();

	//push object_size
	op_push_V(object_size);

	//call calloc
	extern UserProc *pSub_calloc;
	op_call(pSub_calloc);

	//push eaxiŃvbVꂽlۂɃp[^ƂĈnj
	op_push(REG_EAX);

	//push eax
	op_push(REG_EAX);

	Type calcType;
	BOOL bUseHeap;
	NumOpe( expression,
		baseType,
		calcType,
		&bUseHeap );

	// X^bNɂ̃f[^iRs[ARs[j̒lKvƂ
	SetStructVariable( baseType, calcType, bUseHeap );
}

int ParamImpl::SetParameter( const string &procName, const Parameters &params, int SecondParmNum ){
	if( SecondParmNum == -1 ) SecondParmNum = (int)params.size();

	///////////////////////////////////////////////////////////
	// p[^WX^yуX^bNt[ɃZbg
	///////////////////////////////////////////////////////////
	int i2,i3;

	BOOL bEllipse;
	if( params.size() ){
		if(params[params.size()-1]->GetBasicType()==DEF_ELLIPSE) bEllipse=1;
		else bEllipse=0;
	}
	else bEllipse=0;

	BOOL bHas_System_LocalThis=0;
	if(ParmsNum>=1){
		if( params[0]->GetVarName() == "_System_LocalThis" ){
			bHas_System_LocalThis=1;
		}
	}

	//߂lp̕ϐ擾
	const char *lpszVarNameToReturn = (procName[0]==1&&procName[1]==ESC_OPERATOR)?"_System_ReturnValue":procName.c_str();

	//p[^WX^ƃX^bNɊi[
	int ParmSize=0;
	RELATIVE_VAR RelativeVar;
	int nCountOfNowTempObjects = 0;
	for(i2=ParmsNum-1;i2>=0;i2--){
		if(bEllipse&&i2<=(int)params.size()-2) bEllipse=0;

		if(i2==0){
			if( params[i2]->GetVarName() == "_System_LocalThis" ){
				//IuWFNgȏp[^This|C^
				continue;
			}
		}
		if(i2==0||i2==1){
			if( params[i2]->GetVarName() == lpszVarNameToReturn ){
				//IuWFNgȏ܂͑p[^̖߂lpIuWFNg
				continue;
			}
		}

		Type dummyType;
		BOOL bByVal;
		if(bEllipse){
			NumOpe_GetType( Parms[i2], Type(), dummyType );
			bByVal=1;
		}
		else{
			dummyType = *params[i2];
			bByVal = ( params[i2]->IsRef() == false ) ? TRUE:FALSE;
		}

		if(bByVal==1){
			//lQ

			if(Parms[i2][0]==1&&Parms[i2][1]==ESC_BYVAL){
				char temp2[255];
				sprintf(temp2,"%s֐̑%dp[^",procName,i2+1);
				SetError(19,temp2,cp);
				continue;
			}

			if( dummyType.IsStruct() ){
				SetStructParameter( dummyType, Parms[i2] );
				goto next;
			}

			extern LONG_PTR ProcPtr_BaseIndex;
			LONG_PTR back_ProcPtr_BaseIndex = ProcPtr_BaseIndex;
			if( dummyType.IsProcPtr() ){
				ProcPtr_BaseIndex = dummyType.GetIndex();
			}
			else{
				ProcPtr_BaseIndex=-1;
			}

			BOOL bCalcUseHeap;
			Type calcType;
			if( !NumOpe( Parms[i2], dummyType, calcType, &bCalcUseHeap ) ){
				break;
			}

			ProcPtr_BaseIndex=back_ProcPtr_BaseIndex;

			if( calcType.IsObject() ){
				if( !dummyType.IsObject()
					||
					dummyType.IsObject() &&
					!dummyType.GetClass().IsEqualsOrSubClass( &calcType.GetClass() ) ){
						//LXgZq̃I[o[[hɑΉ
						CallCastOperatorProc( calcType, bCalcUseHeap,dummyType );
				}
			}

			if(!bEllipse){
				//^`FbN
				// TODO: _System_ReturnValuelĂȂH
				if(bHas_System_LocalThis) i3=i2-1;
				else i3=i2;
				CheckDifferentType(
					dummyType,
					calcType,
					procName.c_str(),
					i3);
			}

			if( dummyType.IsDouble() ){
				ChangeTypeToDouble( calcType.GetBasicType() );
				ParmSize+=sizeof(long)*2;
			}
			else if( dummyType.IsSingle() ){
				ChangeTypeToSingle( calcType.GetBasicType() );
				ParmSize+=sizeof(long);
			}
			else if( dummyType.Is64() ){
				ChangeTypeToInt64( calcType.GetBasicType() );
				ParmSize+=sizeof(long)*2;
			}
			else if( dummyType.IsLong() || dummyType.IsDWord()
				|| dummyType.IsPointer()
				|| dummyType.IsObject() || dummyType.IsStruct() ){
					ChangeTypeToLong( calcType.GetBasicType() );
					ParmSize+=sizeof(long);
			}
			else if( dummyType.IsInteger() || dummyType.IsWord() ){
				ChangeTypeToInteger( calcType.GetBasicType() );
				ParmSize+=sizeof(long);
			}
			else if( dummyType.IsSByte() || dummyType.IsByte() || dummyType.IsBoolean() ){
				ChangeTypeToByte( calcType.GetBasicType() );
				ParmSize+=sizeof(long);
			}
			else{
				SetError(300,NULL,cp);
			}
		}
		else{
			//|C^Q
			if(Parms[i2][0]==1&&Parms[i2][1]==ESC_BYVAL){
				//|C^w

				Type calcType;
				if( !NumOpe( Parms[i2]+2, dummyType, calcType) ){
					break;
				}

				ChangeTypeToLong( calcType.GetBasicType() );

				dummyType.PtrLevelUp();

				//^`FbN
				if(bHas_System_LocalThis) i3=i2-1;
				else i3=i2;
				CheckDifferentType(
					dummyType,
					calcType,
					procName.c_str(),
					i3);
			}
			else{
				if( useTempParameters[i2] ){
					//ꎞIuWFNgRs[

					if( !types[i2].IsStruct() ){
						// ꎞQƂ̂߂̗̈l
						nCountOfNowTempObjects++;
					}

					nCountOfNowTempObjects++;

					//mov eax, dword ptr[esp+offset]
					op_mov_RM(
						sizeof(long),
						REG_EAX,
						REG_ESP,
						( ( ParmsNum - i2 - 1 ) + ( nCountOfTempObjects - nCountOfNowTempObjects ) ) * PTR_SIZE,
						MOD_BASE_DISP32 );

					//push eax
					op_push(REG_EAX);
				}
				else{
					//ϐ̃AhX擾
					Type varType;
					if(GetVarOffset(
						false,
						false,
						Parms[i2],
						&RelativeVar,
						varType)){
							if( !dummyType.IsAny() ){
								//^`FbNs
								if( dummyType.GetBasicType() == varType.GetBasicType() ){
									if( dummyType.IsObject() ){
										if( !dummyType.GetClass().IsEqualsOrSubClass( &varType.GetClass() ) ){
											SetError(11,Parms[i2],cp);
										}
									}
									else if( dummyType.IsStruct() ){
										if( !dummyType.GetClass().IsEquals( &varType.GetClass() ) ){
											SetError(11,Parms[i2],cp);
										}
									}
								}
								else if( (varType.GetBasicType()&FLAG_PTR)
									&&((varType.GetBasicType()^FLAG_PTR)==dummyType.GetBasicType())){
									//|C^QƂŁAz̐擪|C^̂Ƃ
								}
								else{
									SetError(11,Parms[i2],cp);
								}
							}

							//ϐAhXWX^ɃZbg
							SetVarPtrToEax(&RelativeVar);

							//push eax
							op_push(REG_EAX);
					}
				}
			}

			ParmSize+=PTR_SIZE;
		}

next:;
	}

	return ParmSize;
}
