#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

BOOL Calc_Xor(int *type,LONG_PTR *index_stack,int *pStackPointer){
	//value[sp-2] xor= value[sp-1]
	//xorZ

	int sp;
	sp=*pStackPointer;

	if(IsRealNumberType(type[sp-2])||IsRealNumberType(type[sp-1])){
		//ꂩ̍̂Ƃ
		SetError(45,"xor",cp);
		return 0;
	}

	if(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD||
		type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
		////////////////////
		// 64rbgZ
		////////////////////

		//264rbgɑΉ
		if(type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
			//264rbgl̂Ƃ

			//pop ebx
			op_pop(REG_EBX);

			//pop ecx
			op_pop(REG_ECX);
		}
		else{
			//2̑l̂Ƃ

			//pop eax
			op_pop(REG_EAX);

			if(IsSignedType(type[sp-1])){
				//g
				//edx:eax  eax
				
				//cdq
				op_cdq();
			}
			else{
				//rbgg
				//edx:eax  eax

				//xor edx,edx
				op_zero_reg(REG_EDX);
			}

			//mov ebx,eax
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0xD8;

			//mov ecx,edx
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0xCA;
		}

		if(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD){
			//164rbgl̂Ƃ

			//xor dword ptr[esp],ebx
			OpBuffer[obp++]=(char)0x31;
			OpBuffer[obp++]=(char)0x1C;
			OpBuffer[obp++]=(char)0x24;

			//xor dword ptr[esp+sizeof(long)],ecx
			OpBuffer[obp++]=(char)0x31;
			OpBuffer[obp++]=(char)0x4C;
			OpBuffer[obp++]=(char)0x24;
			OpBuffer[obp++]=(char)0x04;
		}
		else{
			//1̑l̂Ƃ
			if(IsSignedType(type[sp-2])){
				//pop eax
				op_pop(REG_EAX);

				//g
				//edx:eax  eax

				//cdq
				op_cdq();
			}
			else{
				//pop eax
				op_pop(REG_EAX);

				//rbgg
				//edx:eax  eax

				//xor edx,edx
				op_zero_reg(REG_EDX);
			}

			//xor ebx,eax
			OpBuffer[obp++]=(char)0x33;
			OpBuffer[obp++]=(char)0xD8;

			//xor ecx,edx
			OpBuffer[obp++]=(char)0x33;
			OpBuffer[obp++]=(char)0xCA;

			//push ecx
			op_push(REG_ECX);

			//push ebx
			op_push(REG_EBX);
		}

		sp--;
		if(type[sp-1]==DEF_QWORD&&type[sp]==DEF_QWORD) type[sp-1]=DEF_QWORD;
		else type[sp-1]=DEF_INT64;
	}
	else{
		////////////////////
		// Z
		////////////////////

		//pop ebx
		op_pop(REG_EBX);

		//pop eax
		op_pop(REG_EAX);

		//sub esp,4
		op_sub_esp(4);

		//xor eax,ebx
		OpBuffer[obp++]=(char)0x33;
		OpBuffer[obp++]=(char)0xC3;

		//mov dword ptr[esp],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x04;
		OpBuffer[obp++]=(char)0x24;

		sp--;
		type[sp-1]=NeutralizationType(type[sp-1],index_stack[sp-1],type[sp],index_stack[sp]);
	}

	*pStackPointer=sp;
	return 1;
}

BOOL Calc_Or(int *type,LONG_PTR *index_stack,int *pStackPointer){
	//value[sp-2] or= value[sp-1]
	//orZ

	int sp;
	sp=*pStackPointer;

	if(IsRealNumberType(type[sp-2])||IsRealNumberType(type[sp-1])){
		//ꂩ̍̂Ƃ
		SetError(45,"or",cp);
		return 0;
	}

	if(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD||
		type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
		////////////////////
		// 64rbgZ
		////////////////////

		//264rbgɑΉ
		if(type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
			//264rbgl̂Ƃ

			//pop ebx
			op_pop(REG_EBX);

			//pop ecx
			op_pop(REG_ECX);
		}
		else{
			//232rbgl̂Ƃ

			//pop eax
			op_pop(REG_EAX);

			if(IsSignedType(type[sp-1])){
				//g
				//edx:eax  eax
				
				//cdq
				op_cdq();
			}
			else{
				//rbgg
				//edx:eax  eax

				//xor edx,edx
				op_zero_reg(REG_EDX);
			}

			//mov ebx,eax
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0xD8;

			//mov ecx,edx
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0xCA;
		}

		if(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD){
			//164rbgl̂Ƃ

			//or dword ptr[esp],ebx
			OpBuffer[obp++]=(char)0x09;
			OpBuffer[obp++]=(char)0x1C;
			OpBuffer[obp++]=(char)0x24;

			//or dword ptr[esp+sizeof(long)],ecx
			OpBuffer[obp++]=(char)0x09;
			OpBuffer[obp++]=(char)0x4C;
			OpBuffer[obp++]=(char)0x24;
			OpBuffer[obp++]=(char)0x04;
		}
		else{
			//132rbgl̂Ƃ
			if(IsSignedType(type[sp-2])){
				//pop eax
				op_pop(REG_EAX);

				//g
				//edx:eax  eax

				//cdq
				op_cdq();
			}
			else{
				//pop eax
				op_pop(REG_EAX);

				//rbgg
				//edx:eax  eax

				//xor edx,edx
				op_zero_reg(REG_EDX);
			}

			//or ebx,eax
			OpBuffer[obp++]=(char)0x0B;
			OpBuffer[obp++]=(char)0xD8;

			//or ecx,edx
			OpBuffer[obp++]=(char)0x0B;
			OpBuffer[obp++]=(char)0xCA;

			//push ecx
			op_push(REG_ECX);

			//push ebx
			op_push(REG_EBX);
		}

		sp--;
		if(type[sp-1]==DEF_QWORD&&type[sp]==DEF_QWORD) type[sp-1]=DEF_QWORD;
		else type[sp-1]=DEF_INT64;
	}
	else{
		////////////////////
		// 32rbgZ
		////////////////////

		//pop ebx
		op_pop(REG_EBX);

		//pop eax
		op_pop(REG_EAX);

		//sub esp,4
		op_sub_esp(4);

		//or eax,ebx
		OpBuffer[obp++]=(char)0x0B;
		OpBuffer[obp++]=(char)0xC3;

		//mov dword ptr[esp],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x04;
		OpBuffer[obp++]=(char)0x24;

		sp--;
		type[sp-1]=NeutralizationType(type[sp-1],index_stack[sp-1],type[sp],index_stack[sp]);
	}

	*pStackPointer=sp;
	return 1;
}

BOOL Calc_And(int *type,LONG_PTR *index_stack,int *pStackPointer){
	//value[sp-2] and= value[sp-1]
	//andZ

	int sp;
	sp=*pStackPointer;

	if(IsRealNumberType(type[sp-2])||IsRealNumberType(type[sp-1])){
		//ꂩ̍̂Ƃ
		SetError(45,"and",cp);
		return 0;
	}

	if(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD||
		type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
		////////////////////
		// 64rbgZ
		////////////////////

		//264rbgɑΉ
		if(type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
			//264rbgl̂Ƃ

			//pop ebx
			op_pop(REG_EBX);

			//pop ecx
			op_pop(REG_ECX);
		}
		else{
			//232rbgl̂Ƃ

			//pop eax
			op_pop(REG_EAX);

			if(IsSignedType(type[sp-1])){
				//g
				//edx:eax  eax
				
				//cdq
				op_cdq();
			}
			else{
				//rbgg
				//edx:eax  eax

				//xor edx,edx
				op_zero_reg(REG_EDX);
			}

			//mov ebx,eax
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0xD8;

			//mov ecx,edx
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0xCA;
		}

		if(type[sp-2]==DEF_INT64||type[sp-2]==DEF_QWORD){
			//164rbgl̂Ƃ

			//and dword ptr[esp],ebx
			OpBuffer[obp++]=(char)0x21;
			OpBuffer[obp++]=(char)0x1C;
			OpBuffer[obp++]=(char)0x24;

			//and dword ptr[esp+sizeof(long)],ecx
			OpBuffer[obp++]=(char)0x21;
			OpBuffer[obp++]=(char)0x4C;
			OpBuffer[obp++]=(char)0x24;
			OpBuffer[obp++]=(char)0x04;
		}
		else{
			//132rbgl̂Ƃ
			if(IsSignedType(type[sp-2])){
				//pop eax
				op_pop(REG_EAX);

				//g
				//edx:eax  eax

				//cdq
				op_cdq();
			}
			else{
				//pop eax
				op_pop(REG_EAX);

				//rbgg
				//edx:eax  eax

				//xor edx,edx
				op_zero_reg(REG_EDX);
			}

			//and ebx,eax
			OpBuffer[obp++]=(char)0x23;
			OpBuffer[obp++]=(char)0xD8;

			//and ecx,edx
			OpBuffer[obp++]=(char)0x23;
			OpBuffer[obp++]=(char)0xCA;

			//push ecx
			op_push(REG_ECX);

			//push ebx
			op_push(REG_EBX);
		}

		sp--;
		if(type[sp-1]==DEF_QWORD&&type[sp]==DEF_QWORD) type[sp-1]=DEF_QWORD;
		else type[sp-1]=DEF_INT64;
	}
	else{
		////////////////////
		// 32rbgZ
		////////////////////

		//pop ebx
		op_pop(REG_EBX);

		//pop eax
		op_pop(REG_EAX);

		//sub esp,4
		op_sub_esp(4);

		//and eax,ebx
		OpBuffer[obp++]=(char)0x23;
		OpBuffer[obp++]=(char)0xC3;

		//mov dword ptr[esp],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x04;
		OpBuffer[obp++]=(char)0x24;

		sp--;
		type[sp-1]=NeutralizationType(type[sp-1],index_stack[sp-1],type[sp],index_stack[sp]);
	}

	*pStackPointer=sp;
	return 1;
}

BOOL Calc_Not(int *type,int sp){
	//value[sp-1]=Not value[sp-1]
	//NOTZq

	if(IsRealNumberType(type[sp-1])){
		//̂Ƃ
		SetError(45,"Not",cp);
		return 0;
	}

	if( type[sp - 1] == DEF_BOOLEAN ){
		//pop eax
		op_pop( REG_EAX );

		//cmp eax,0
		op_cmp_value(GetTypeSize(type[sp-1],-1),REG_EAX,0);

		//setne al
		op_setne( REG_EAX );

		//and eax,000000FFh
		op_and_RV(REG_EAX,(int)0xFF);

		//neg
		op_neg( REG_EAX );

		//sbb eax, eax
		op_sbb_RR( REG_EAX, REG_EAX );

		//add eax, 1
		op_add_RV8( REG_EAX, 1 );

		//push eax
		op_push( REG_EAX );
	}
	else if(type[sp-1]==DEF_INT64||type[sp-1]==DEF_QWORD){
		////////////////////
		// 64rbgZ
		////////////////////

		//not dword ptr[esp]
		OpBuffer[obp++]=(char)0xF7;
		OpBuffer[obp++]=(char)0x14;
		OpBuffer[obp++]=(char)0x24;

		//not dword ptr[esp+4]
		OpBuffer[obp++]=(char)0xF7;
		OpBuffer[obp++]=(char)0x54;
		OpBuffer[obp++]=(char)0x24;
		OpBuffer[obp++]=(char)0x04;
	}
	else{
		////////////////////
		// 32rbgZ
		////////////////////

		//not dword ptr[esp]
		OpBuffer[obp++]=(char)0xF7;
		OpBuffer[obp++]=(char)0x14;
		OpBuffer[obp++]=(char)0x24;
	}

	return 1;
}
