#include "../BasicCompiler_Common/common.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif

extern HANDLE hHeap;

void CallConstructor( const char *ObjectName,const int *SubScripts,const Type &type,const char *Parameter){
	if( !type.IsObject() ){
		return;
	}

	/////////////////////////////////////
	// NXIuWFNg̏ꍇ
	// RXgN^̌Ăяo
	/////////////////////////////////////

	UserProc *pUserProc;
	pUserProc=GetMethodHash(ObjectName,type.GetClass().GetName().c_str(),Parameter);
	if(!pUserProc){
		if(Parameter[0]) SetError(113,type.GetClass().GetName().c_str(),cp);
		return;
	}


	char temporary[VN_SIZE];

	if(SubScripts[0]!=-1){
		int ss[MAX_ARRAYDIM];
		memset(ss,0,MAX_ARRAYDIM*sizeof(int));
		while(1){
			int i3;
			for(i3=0;;i3++){
				if(SubScripts[i3]==-1) break;

				if(ss[i3]>SubScripts[i3]){
					ss[i3]=0;
					ss[i3+1]++;
				}
				else break;
			}
			if(SubScripts[i3]==-1) break;
			sprintf(temporary,"%s[%d",ObjectName,ss[0]);
			for(i3=1;;i3++){
				if(SubScripts[i3]==-1) break;

				sprintf(temporary+lstrlen(temporary),",%d",ss[i3]);
			}
			lstrcat(temporary,"]");

			Type dummyType;
			sprintf(temporary+lstrlen(temporary),".%s",type.GetClass().GetName().c_str());
			CallProc( PROC_DEFAULT,
				pUserProc,
				temporary,
				Parameter,
				dummyType );

			ss[0]++;


			//lCeBuR[hobt@̍Ċm
			ReallocNativeCodeBuffer();
		}
	}
	else{
		Type dummyType;
		sprintf(temporary,"%s.%s",ObjectName,type.GetClass().GetName().c_str());
		CallProc( PROC_DEFAULT,
			pUserProc,
			temporary,
			Parameter,
			dummyType );
	}
}

bool Operator_New( const char *expression, const Type &baseType, Type &resultType ){
	char CreateParameter[VN_SIZE],objectSizeStr[VN_SIZE];
	int i,i2;

	i=0;

	if(expression[0]=='['){
		i=GetStringInBracket(objectSizeStr,expression);

		SlideString(objectSizeStr+1,-1);
		objectSizeStr[i-2]=0;
	}
	else objectSizeStr[0]=0;

	char typeName[VN_SIZE];
	for(i2=0;;i++,i2++){
		if(expression[i]=='('){
			typeName[i2]=0;

			//RXgN^ɓnp[^擾
			i2=GetStringInPare(CreateParameter,expression+i);
			RemoveStringPare(CreateParameter);
			i+=i2;
			if(expression[i]!='\0'){
				SetError(42,NULL,cp);
				return false;
			}
			break;
		}
		typeName[i2]=expression[i];
		if(expression[i]=='\0'){
			CreateParameter[0]=0;
			break;
		}
	}

	if( !Type::StringToType( typeName, resultType ) ){
		SetError(3,typeName,cp);
		return false;
	}

	if( !resultType.IsObject() ){
		////////////////////////
		// ʏ̃f[^^̏ꍇ
		////////////////////////

		SetError(121,NULL,cp);
		return false;
	}

	Operator_New( resultType.GetClass(), objectSizeStr, CreateParameter, baseType );

	if( !baseType.IsObject() ){
		// IuWFNg|C^
		resultType.SetBasicType( DEF_PTR_OBJECT );
	}

	return true;
}
