#include "common.h"
#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif


CLexicalScopes obj_LexScopes;


CScope::CScope( int level, int addr, SCOPE_TYPE TypeOfStatement ){
	this->level = level;
	this->StartAddress = addr;
	this->TypeOfStatement = TypeOfStatement;

	pBreakSchedule = (DWORD *)malloc( 1 );
	nBreakSchedule = 0;
}
CScope::~CScope(){
	free( pBreakSchedule );
}

int CScope::GetStartAddress(){
	return StartAddress;
}
SCOPE_TYPE CScope::GetTypeOfStatement(){
	return TypeOfStatement;
}

void CScope::Break(){
	//̃[JIuWFNg
	obj_LexScopes.CallDestructorsOfReturn( level );

	//jmp ...(Next addr)
	OpBuffer[obp++]=(char)0xE9;

	pBreakSchedule=(DWORD *)realloc( pBreakSchedule, ( nBreakSchedule + 1 ) * sizeof(DWORD) );
	pBreakSchedule[nBreakSchedule]=obp;
	nBreakSchedule++;

	obp+=sizeof(long);
}
void CScope::RunScheduleOfBreak(){
	for(int i=0;i<nBreakSchedule;i++){
		*((long *)(OpBuffer+pBreakSchedule[i]))=obp-(pBreakSchedule[i]+sizeof(long));
	}
}


CScope *CLexicalScopes::SearchScope( SCOPE_TYPE TypeOfStatement ){
	for( int i = level; i>=0; i-- ){
		if( ppScopes[i]->GetTypeOfStatement() == TypeOfStatement ){
			return ppScopes[i];
		}
	}
	return NULL;
}

CLexicalScopes::CLexicalScopes(){
	ppScopes = (CScope **)malloc( 1 );
	level=0;
}
CLexicalScopes::~CLexicalScopes(){
	free( ppScopes );
}
void CLexicalScopes::Init(int addr){
	// TODO: G[`FbN

	level = -1;
	Start( addr, SCOPE_TYPE_BASE );
}
void CLexicalScopes::Start( int addr, SCOPE_TYPE TypeOfStatement ){
	level++;
	ppScopes = (CScope **)realloc( ppScopes, ( level + 1 ) * sizeof( CScope * ) );
	ppScopes[level] = new CScope( level, addr, TypeOfStatement );
}
void CLexicalScopes::End(){
	if( level <= 0 ){
		SetError(300,NULL,cp);
		return;
	}

	//fXgN^Ă
	CallDestructorsOfScopeEnd();

	Variables &vars = UserProc::IsGlobalAreaCompiling()?
		globalVars :
		UserProc::CompilingUserProc().localVars;

	//gpς݃[Jϐ̐`FbNO
	foreach( Variable *pVar, vars ){
		if(pVar->bLiving&&pVar->ScopeLevel==level){
			pVar->bLiving=0;
			extern int obp;
			pVar->ScopeEndAddress=obp;
		}
	}


	//XR[voXPW[
	ppScopes[level]->RunScheduleOfBreak();


	//XR[vx
	delete ppScopes[level];
	level--;
}

void CLexicalScopes::ExitFor(){
	CScope *pScope = SearchScope( SCOPE_TYPE_FOR );
	if( !pScope ){
		SetError(12,"Exit For",cp);
		return;
	}

	pScope->Break();
}
void CLexicalScopes::ExitWhile(){
	CScope *pScope = SearchScope( SCOPE_TYPE_WHILE );
	if( !pScope ){
		SetError(12,"Exit While",cp);
		return;
	}

	pScope->Break();
}
void CLexicalScopes::ExitDo(){
	CScope *pScope = SearchScope( SCOPE_TYPE_DO );
	if( !pScope ){
		SetError(12,"Exit Do",cp);
		return;
	}

	pScope->Break();
}

int CLexicalScopes::GetNowLevel(){
	return level;
}
void CLexicalScopes::SetNowLevel( int level ){
	this->level = level;
}
int CLexicalScopes::GetStartAddress(){
	return ppScopes[level]->GetStartAddress();
}


// XR[vĨfXgN^Ăяo
void CLexicalScopes::CallDestructorsOfScopeEnd(){

	Variables &vars = UserProc::IsGlobalAreaCompiling()?
		globalVars :
		UserProc::CompilingUserProc().localVars;


	int i3;
	int indexSystemGC=-1;
	for( i3 = (int)vars.size() - 1; i3 >= 0; i3-- ){		//mۂ̂Ƌtŉ邽߁AobNT[`ɂ

		Variable *pVar = vars[i3];

		if( UserProc::IsGlobalAreaCompiling() && GetNowLevel() == 0 ){
			if( pVar->GetName() == "_System_GC" ){
				indexSystemGC=i3;
				continue;
			}
		}

		//ꃌx̃LVJXR[v݂̂m
		if(!pVar->bLiving) continue;
		if( pVar->ScopeLevel != GetNowLevel() ) continue;

		if( pVar->IsStruct() && pVar->IsParameter() ){
			//\̃p[^Ƃ

			//

#ifdef _AMD64_
			//x64rbgR[h

			//mov rcx,qword ptr[rsp+offset]
			op_mov_RM(sizeof(_int64),REG_RCX,REG_RSP,
				-pVar->offset,
				MOD_BASE_DISP32);
			obp-=sizeof(long);
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
#else
			//x86R[h

			//mov ecx,dword ptr[ebp+offset]
			op_mov_RM(sizeof(long),REG_ECX,REG_EBP,-pVar->offset,MOD_BASE_DISP32);
			obp-=sizeof(long);
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//push ecx
			op_push(REG_ECX);
#endif

			//call free
			extern UserProc *pSub_free;
			op_call(pSub_free);


			if( UserProc::IsGlobalAreaCompiling() ){
				//ɂ͗ȂnY
				SetError(300,NULL,cp);
			}
		}
	}

	if(indexSystemGC!=-1){
		//_System_GCIuWFNg̃fXgN^̌Ăяo
		const CMethod *method = vars[indexSystemGC]->GetClass().GetDestructorMethod();
		if( method ){
			Opcode_CallProc("",method->pUserProc,0,vars[indexSystemGC]->GetName().c_str(),DEF_OBJECT);
		}
	}
}

// ReturnXe[ggŔsfXgN^𐶐
void CLexicalScopes::CallDestructorsOfReturn( int BaseLevel ){
	//݂̃XR[vxޔ
	int backupScopeLevel = GetNowLevel();

	for( int i = GetNowLevel(); i >= BaseLevel; i-- ){
		SetNowLevel( i );

		CallDestructorsOfScopeEnd();
	}

	//݂̃XR[vx𕜌
	SetNowLevel( backupScopeLevel );
}
