#include "../BasicCompiler_Common/common.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif

double dbl_stack[255];
_int64 i64stack[255];

bool IsNumberTopChar(const char *buffer){
	int c = buffer[0];
	if('0' <= c && c <= '9') return true;
	if(c == '&' && (buffer[1] == 'h' || buffer[1] == 'H' || buffer[1] == 'o' || buffer[1] == 'O')) return true;

	return false;
}
bool IsNumberChar(const char c){
	if('0' <= c && c <= '9') return true;
	if('a' <= c && c <= 'f') return true;
	if('A' <= c && c <= 'F') return true;
	if(c=='.' || c=='e'||c=='E') return true;

	return false;
}
BOOL IsJudgMark(const char *Command,int p){
	if(Command[p]==1){
		if(Command[p+1]==ESC_AND) return 1;
		if(Command[p+1]==ESC_OR) return 1;
		if(Command[p+1]==ESC_XOR) return 1;
		if(Command[p+1]==ESC_NOT) return 1;
	}
	return 0;
}
BOOL IsNumCalcMark(const char *Command,int p){
	if(Command[p]=='^'||Command[p]=='*'||Command[p]=='/'||Command[p]=='\\'||
		(Command[p]==1&&Command[p+1]==ESC_MOD)||Command[p]=='+'||Command[p]=='-'||
		Command[p]=='='||Command[p]=='<'||Command[p]=='>'||
		IsJudgMark(Command,p)||
		(Command[p]==1&&Command[p+1]==ESC_AS)||
		(Command[p]==1&&Command[p+1]==ESC_BYVAL)) return 1;
	return 0;
}
BOOL IsNumCalcMark_Back(const char *Command,int p){
	if(p==0){
		if(Command[p]=='^'||Command[p]=='*'||Command[p]=='/'||Command[p]=='\\'||
			Command[p]=='+'||Command[p]=='-'||
			Command[p]=='='||Command[p]=='<'||Command[p]=='>') return 1;
	}
	else{
		if(Command[p]=='^'||Command[p]=='*'||Command[p]=='/'||Command[p]=='\\'||
			(Command[p-1]==1&&Command[p]==ESC_MOD)||Command[p]=='+'||Command[p]=='-'||
			Command[p]=='='||Command[p]=='<'||Command[p]=='>'||
			IsJudgMark(Command,p-1)||
			(Command[p-1]==1&&Command[p]==ESC_AS)) return 1;
	}
	return 0;
}
BOOL IsStrCalcMark(const char c){
	if(c=='+'||c=='&') return 1;
	return 0;
}
BOOL IsExponent(const char *Command,int p){
	int i,sw;
	for(i=p-2,sw=FALSE;i>=0;i--){
		if(Command[i]>='0'&&Command[i]<='9') sw=TRUE;
		if(!((Command[i]>='0'&&Command[i]<='9')||Command[i]=='.')){
			if((IsNumCalcMark(Command,i)||Command[i]=='('||Command[i]==')')&&sw) return TRUE;
			return FALSE;
		}
		if(i==0&&sw) return TRUE;
	}
	return FALSE;
}

int CompStr(char *str1,int len1,char *str2,int len2){
	int i,len;

	if(len1<len2) len=len1;
	else len=len2;

	for(i=0;i<len;i++){
		if((unsigned char *)str1[i]>(unsigned char *)str2[i]) return 1;
		else if((unsigned char *)str1[i]<(unsigned char *)str2[i]) return -1;
	}
	if(len1>len2) return 1;
	else if(len1<len2) return -1;
	return 0;
}
void TypeErrorCheck(_int64 *stack,int sp,long calc){
	extern int cp;
	if(sp==0||calc==0) return;
	if(sp==1){
		if(stack[0]){
			SetError(9,NULL,cp);
			return;
		}
		return;
	}
	if(CALC_PE<=calc&&calc<=CALC_Q||calc==CALC_ADDITION){
		//񉉎Z\ȉZq
		if((stack[sp-2]&&stack[sp-1]==0)||(stack[sp-2]==0&&stack[sp-1])){
			SetError(9,NULL,cp);
			return;
		}
	}
	else{
		//񉉎ZłȂZq
		if(stack[sp-2]||stack[sp-1]){
			SetError(9,NULL,cp);
			return;
		}
	}
}


int GetLiteralIndex(_int64 i64data){
	if(i64data==0) return LITERAL_NULL;
	else if(-128<=i64data&&i64data<0) return LITERAL_M128_0;
	else if(0<i64data&&i64data<256) return LITERAL_0_255;
	else if(-32768<=i64data&&i64data<0) return LITERAL_M32768_0;
	else if(0<i64data&&i64data<65536) return LITERAL_0_65535;
	else if(i64data<0) return LITERAL_OTHER_MINUS;
	return LITERAL_OTHER_PLUS;
}


int NeutralizationType(int type1,LONG_PTR index1,int type2,LONG_PTR index2){

	if(type1==DEF_DOUBLE||type2==DEF_DOUBLE) return DEF_DOUBLE;
	if(type1==DEF_SINGLE||type2==DEF_SINGLE) return DEF_SINGLE;

	int size1,size2;
	size1=GetTypeSize(type1,index1);
	size2=GetTypeSize(type2,index2);
	if(size1<size2){
		size1=size2;
	}
	else if(type1==type2) return type1;

	if(IsPtrType(type1)||IsPtrType(type2)){
		if(IsPtrType(type1)) return type1;
		else return type2;
	}


	/////////////////////////////
	// Еel̏ꍇ
	// _ɕ
	/////////////////////////////
	if(IsSignedType(type1)&&IS_POSITIVE_LITERAL(index1)&&
		IsSignedType(type2)==0){
		type1=GetUnsignedType(type1);
	}
	if(IsSignedType(type1)==0&&
		IsSignedType(type2)&&IS_POSITIVE_LITERAL(index2)){
		type2=GetUnsignedType(type2);
	}


	if(IsSignedType(type1)||IsSignedType(type2)){
		//
		if(size1==sizeof(char))		return DEF_SBYTE;
		if(size1==sizeof(short))	return DEF_INTEGER;
		if(size1==sizeof(long))		return DEF_LONG;
		if(size1==sizeof(_int64))	return DEF_INT64;
	}
	else{
		//Ȃ
		if(size1==sizeof(char))		return DEF_BYTE;
		if(size1==sizeof(short))	return DEF_WORD;
		if(size1==sizeof(long))		return DEF_DWORD;
		if(size1==sizeof(_int64))	return DEF_QWORD;
	}

	extern int cp;
	SetError(300,NULL,cp);
	return 0;
}

void StaticTwoTerm(int idCalc,int *type_stack,LONG_PTR *index_stack,int *pStackPointer,int BaseType){
	int sp,AnswerType;

	sp=*pStackPointer;
 
	AnswerType=NeutralizationType(type_stack[sp-2],index_stack[sp-2],type_stack[sp-1],index_stack[sp-1]);

	if(IsRealNumberType(BaseType)&&idCalc==CALC_QUOTIENT) AnswerType=BaseType;

	if(IsRealNumberType(AnswerType)){
		///////////////
		// Z
		///////////////

		if(IsWholeNumberType(type_stack[sp-2])) dbl_stack[sp-2]=(double)i64stack[sp-2];
		if(IsWholeNumberType(type_stack[sp-1])) dbl_stack[sp-1]=(double)i64stack[sp-1];


		//rZ
		if(idCalc==CALC_PE){
			if(dbl_stack[sp-2]<=dbl_stack[sp-1]) i64stack[sp-2]=-1;
			else i64stack[sp-2]=0;
			AnswerType=DEF_LONG;
		}
		else if(idCalc==CALC_QE){
			if(dbl_stack[sp-2]>=dbl_stack[sp-1]) i64stack[sp-2]=-1;
			else i64stack[sp-2]=0;
			AnswerType=DEF_LONG;
		}
		else if(idCalc==CALC_P){
			if(dbl_stack[sp-2]<dbl_stack[sp-1]) i64stack[sp-2]=-1;
			else i64stack[sp-2]=0;
			AnswerType=DEF_LONG;
		}
		else if(idCalc==CALC_Q){
			if(dbl_stack[sp-2]>dbl_stack[sp-1]) i64stack[sp-2]=-1;
			else i64stack[sp-2]=0;
			AnswerType=DEF_LONG;
		}
		else if(idCalc==CALC_NOTEQUAL){
			if(dbl_stack[sp-2]!=dbl_stack[sp-1]) i64stack[sp-2]=-1;
			else i64stack[sp-2]=0;
			AnswerType=DEF_LONG;
		}
		else if(idCalc==CALC_EQUAL){
			if(dbl_stack[sp-2]==dbl_stack[sp-1]) i64stack[sp-2]=-1;
			else i64stack[sp-2]=0;
			AnswerType=DEF_LONG;
		}

		//_Z
		else if(idCalc==CALC_XOR)			dbl_stack[sp-2]=(double)((long)dbl_stack[sp-2]^(long)dbl_stack[sp-1]);
		else if(idCalc==CALC_OR)			dbl_stack[sp-2]=(double)((long)dbl_stack[sp-2]|(long)dbl_stack[sp-1]);
		else if(idCalc==CALC_AND)			dbl_stack[sp-2]=(double)((long)dbl_stack[sp-2]&(long)dbl_stack[sp-1]);

		//VtgZ
		else if(idCalc==CALC_SHL)			dbl_stack[sp-2]=(double)((DWORD)dbl_stack[sp-2]<<(DWORD)dbl_stack[sp-1]);
		else if(idCalc==CALC_SHR)			dbl_stack[sp-2]=(double)((DWORD)dbl_stack[sp-2]>>(DWORD)dbl_stack[sp-1]);

		//ZpZ
		else if(idCalc==CALC_ADDITION)		dbl_stack[sp-2]+=dbl_stack[sp-1];
		else if(idCalc==CALC_SUBTRACTION)	dbl_stack[sp-2]-=dbl_stack[sp-1];
		else if(idCalc==CALC_MOD)			dbl_stack[sp-2]=(double)((long)dbl_stack[sp-2]%(long)dbl_stack[sp-1]);
		else if(idCalc==CALC_PRODUCT)		dbl_stack[sp-2]*=dbl_stack[sp-1];
		else if(idCalc==CALC_QUOTIENT){
			if(dbl_stack[sp-1])
				dbl_stack[sp-2]/=dbl_stack[sp-1];
			else{
				//[G[n
				SetError(56,NULL,cp);
			}
		}
		else if(idCalc==CALC_INTQUOTIENT){
			if(dbl_stack[sp-1])
				dbl_stack[sp-2]=(double)(long)(dbl_stack[sp-2]/dbl_stack[sp-1]);
			else{
				//[G[n
				SetError(56,NULL,cp);
			}
		}
		else if(idCalc==CALC_POWER)			dbl_stack[sp-2]=pow(dbl_stack[sp-2],dbl_stack[sp-1]);
	}
	else{
		///////////////
		// Z
		///////////////

		if(IsRealNumberType(type_stack[sp-2])) i64stack[sp-2]=(_int64)dbl_stack[sp-2];
		if(IsRealNumberType(type_stack[sp-1])) i64stack[sp-1]=(_int64)dbl_stack[sp-1];


		//rZ
		if(idCalc==CALC_PE){
			if(IsSignedType(AnswerType)){
				if(i64stack[sp-2]<=i64stack[sp-1]) i64stack[sp-2]=-1;
				else i64stack[sp-2]=0;
			}
			else{
				if(((unsigned _int64)i64stack[sp-2])<=((unsigned _int64)i64stack[sp-1])) i64stack[sp-2]=-1;
				else i64stack[sp-2]=0;
			}
			AnswerType=DEF_LONG;
		}
		else if(idCalc==CALC_QE){
			if(IsSignedType(AnswerType)){
				if(i64stack[sp-2]>=i64stack[sp-1]) i64stack[sp-2]=-1;
				else i64stack[sp-2]=0;
			}
			else{
				if(((unsigned _int64)i64stack[sp-2])>=((unsigned _int64)i64stack[sp-1])) i64stack[sp-2]=-1;
				else i64stack[sp-2]=0;
			}
			AnswerType=DEF_LONG;
		}
		else if(idCalc==CALC_P){
			if(IsSignedType(AnswerType)){
				if(i64stack[sp-2]<i64stack[sp-1]) i64stack[sp-2]=-1;
				else i64stack[sp-2]=0;
			}
			else{
				if(((unsigned _int64)i64stack[sp-2])<((unsigned _int64)i64stack[sp-1])) i64stack[sp-2]=-1;
				else i64stack[sp-2]=0;
			}
			AnswerType=DEF_LONG;
		}
		else if(idCalc==CALC_Q){
			if(IsSignedType(AnswerType)){
				AnswerType=NeutralizationType(type_stack[sp-2],index_stack[sp-2],type_stack[sp-1],index_stack[sp-1]);
				if(i64stack[sp-2]>i64stack[sp-1]) i64stack[sp-2]=-1;
				else i64stack[sp-2]=0;
			}
			else{
				if(((unsigned _int64)i64stack[sp-2])>((unsigned _int64)i64stack[sp-1])) i64stack[sp-2]=-1;
				else i64stack[sp-2]=0;
			}
			AnswerType=DEF_LONG;
		}
		else if(idCalc==CALC_NOTEQUAL){
			if(i64stack[sp-2]!=i64stack[sp-1]) i64stack[sp-2]=-1;
			else i64stack[sp-2]=0;
			AnswerType=DEF_LONG;
		}
		else if(idCalc==CALC_EQUAL){
			if(i64stack[sp-2]==i64stack[sp-1]) i64stack[sp-2]=-1;
			else i64stack[sp-2]=0;
			AnswerType=DEF_LONG;
		}

		//_Z
		else if(idCalc==CALC_XOR)			i64stack[sp-2]^=i64stack[sp-1];
		else if(idCalc==CALC_OR)			i64stack[sp-2]|=i64stack[sp-1];
		else if(idCalc==CALC_AND)			i64stack[sp-2]&=i64stack[sp-1];

		//VtgZ
		else if(idCalc==CALC_SHL){
			i64stack[sp-2]<<=(DWORD)i64stack[sp-1];
			if(IsSignedType(AnswerType)) AnswerType=DEF_LONG;
			else AnswerType=DEF_DWORD;
		}
		else if(idCalc==CALC_SHR){
			i64stack[sp-2]>>=(DWORD)i64stack[sp-1];
			if(IsSignedType(AnswerType)) AnswerType=DEF_LONG;
			else AnswerType=DEF_DWORD;
		}

		//ZpZ
		else if(idCalc==CALC_ADDITION)		i64stack[sp-2]+=i64stack[sp-1];
		else if(idCalc==CALC_SUBTRACTION)	i64stack[sp-2]-=i64stack[sp-1];
		else if(idCalc==CALC_MOD)			i64stack[sp-2]%=i64stack[sp-1];
		else if(idCalc==CALC_PRODUCT)		i64stack[sp-2]*=i64stack[sp-1];
		else if(idCalc==CALC_QUOTIENT||
			idCalc==CALC_INTQUOTIENT){
			if(i64stack[sp-1])
				i64stack[sp-2]/=i64stack[sp-1];
			else{
				//[G[n
				SetError(56,NULL,cp);
			}
		}
		else if(idCalc==CALC_POWER)			i64stack[sp-2]=(_int64)pow((double)i64stack[sp-2],(double)i64stack[sp-1]);

		if(IsSignedType(AnswerType)){
			if(AnswerType==DEF_SBYTE&&(i64stack[sp-2]<CHAR_MIN||CHAR_MAX<i64stack[sp-2])){
				//L8rbgl͂ݏoƂ
				AnswerType=DEF_INTEGER;
			}
			if(AnswerType==DEF_INTEGER&&(i64stack[sp-2]<SHRT_MIN||SHRT_MAX<i64stack[sp-2])){
				//L16rbgl͂ݏoƂ
				AnswerType=DEF_LONG;
			}
			if(i64stack[sp-2]<LONG_MIN||LONG_MAX<i64stack[sp-2]){
				//L32rbgl͂ݏoƂ
				AnswerType=DEF_INT64;
			}
		}
		else{
			if(UINT_MAX<((unsigned _int64)i64stack[sp-2])){
				//32rbgl͂ݏoƂ
				AnswerType=DEF_QWORD;
			}
		}
	}

	type_stack[sp-2]=AnswerType;
	index_stack[sp-2]=-1;

	sp--;
	*pStackPointer=sp;
}

bool StaticCalculation(bool enableerror, const char *Command,int BaseType,_int64 *pi64data,Type &resultType,BOOL bDebuggingWatchList, bool *pIsMemoryAccessError){
	extern int cp;
	int i,i2,i3,PareNum;
	char Parms[1024],temporary[VN_SIZE],temp2[VN_SIZE];

	_int64 i64data;
	double nums[255];
	_int64 i64nums[255];
	char *StrPtr[255];
	long calc[255];
	_int64 stack[255];
	int type[255];
	LONG_PTR before_index[255];
	int sp,pnum;

	if( pIsMemoryAccessError ) *pIsMemoryAccessError = false;

	*pi64data=0;
	if(Command[0]=='\0') return false;

	for(i=0,i2=0,sp=0,pnum=0,PareNum=0;;i++,i2++){
		if(Command[i]=='\"'){
			Parms[i2]=Command[i];
			for(i++,i2++;;i++,i2++){
				Parms[i2]=Command[i];
				if(Command[i]=='\"') break;
			}
			continue;
		}
		else if(Command[i]=='['){
			i3=GetStringInBracket(Parms+i2,Command+i);
			i+=i3-1;
			i2+=i3-1;
			continue;
		}
		else if(Command[i]=='('){
			if(i==0){
				PareNum++;
				i2=-1;
				continue;
			}
			else if(IsNumCalcMark_Back(Command,i-1)||Command[i-1]=='('){
				PareNum++;
				i2=-1;
				continue;
			}
			else{
				//zϐ̏ꍇl
				i3=GetStringInPare(Parms+i2,Command+i);
				i+=i3-1;
				i2+=i3-1;
				continue;
			}
		}
		else if(Command[i]==')'){
			PareNum--;
			i2--;
			continue;
		}
		else if(IsNumCalcMark(Command,i)||Command[i]=='\0'){
			if((Command[i]=='+'||Command[i]=='-')&&(Command[i-1]=='e'||Command[i-1]=='E')){
				if(IsExponent(Command,i)){
					Parms[i2]=Command[i];
					continue;
				}
			}
			Parms[i2]=0;

			if(stack[sp-1]==CALC_AS&&Command[i]=='*'){
				for(i3=0;i3<i2;i3++){
					if(Parms[i2]!='*') break;
				}
				if(i3==i2){
					//"*"|C^w蕶ƂĔF
					Parms[i2]=Command[i];
					continue;
				}
			}

			calc[pnum]=0;
			if(i2){
				before_index[pnum]=-1;

				i3=GetCallProcName(Parms,temporary);
				if(Parms[i3]=='('){
					lstrcpy(temp2,Parms+i3+1);
					temp2[lstrlen(temp2)-1]=0;

					if(lstrcmpi(temporary,"SizeOf")==0){
						//SizeOf֐

						type[pnum]=DEF_LONG;

						Type tempType;
						if( !Type::StringToType( temp2, tempType ) ){
							if(enableerror) SetError(3,temp2,cp);
							return false;
						}
						i64nums[pnum] = tempType.GetSize();
						StrPtr[pnum]=0;
					}
					else{
						//萔֐

						if(!GetConstCalcBuffer(temporary,temp2,Parms)){
							if(enableerror) SetError(3,temporary,cp);
							return false;
						}

						Type tempType;
						StaticCalculation(enableerror, Parms,BaseType,&i64data,tempType);
						type[pnum] = tempType.GetBasicType();
						before_index[pnum] = tempType.GetIndex();
						if(tempType.IsReal()){
							//^
							memcpy(&nums[pnum],&i64data,sizeof(double));
						}
						else{
							//^
							i64nums[pnum]=i64data;
						}

						StrPtr[pnum]=0;
					}
				}
				else{
					if(Parms[0]=='\"'){
						//̏ꍇirZqlj
						RemoveStringQuotes(Parms);
						i2=lstrlen(Parms);

						nums[pnum]=i2;
						StrPtr[pnum]=(char *)HeapAlloc(hHeap,0,i2+1);
						memcpy(StrPtr[pnum],Parms,i2);
						StrPtr[pnum][i2]=0;

						type[pnum]=typeOfPtrChar;
						before_index[pnum]=LITERAL_STRING;
					}
					else if((Parms[0]=='e'||Parms[0]=='E')&&
						(Parms[1]=='x'||Parms[1]=='X')&&
						Parms[2]=='\"'){
						//g
						RemoveStringQuotes(Parms+2);
						i2=FormatString_EscapeSequence(Parms+2);
						nums[pnum]=i2;
						StrPtr[pnum]=(char *)HeapAlloc(hHeap,0,(int)i2+1);
						memcpy(StrPtr[pnum],Parms+2,i2);
						StrPtr[pnum][i2]=0;

						type[pnum]=typeOfPtrChar;
						before_index[pnum]=LITERAL_STRING;
					}
					else if(IsVariableTopChar(Parms[0])||Parms[0]=='*'||(Parms[0]=='.'&&IsVariableTopChar(Parms[1]))){
						if(bDebuggingWatchList){
							//////////////////////////
							// ϐifobÔ݁j
							//////////////////////////

							RELATIVE_VAR RelativeVar;
							int ss[MAX_ARRAYDIM];
							void *offset;
							DWORD dwData;
							SIZE_T accessBytes;
							float flt;

							extern HANDLE hDebugProcess;

							Type tempType;
							i3=Debugging_GetVarOffset(Parms,&RelativeVar,tempType,ss);
							if(i3==0){
								//G[
								return false;
							}
							if(i3==-1){
								//ɃANZXłȂƂ
								if( pIsMemoryAccessError ) *pIsMemoryAccessError = true;
								return false;
							}

							if(i3){
								StrPtr[pnum]=0;
								offset=(void *)Debugging_GetVarPtr(&RelativeVar);

								type[pnum]=tempType.GetBasicType();

								if(tempType.IsDouble()){
									i3=ReadProcessMemory(hDebugProcess,offset,&nums[pnum],sizeof(double),&accessBytes);
								}
								else if(tempType.IsSingle()){
									if(i3=ReadProcessMemory(hDebugProcess,offset,&flt,sizeof(float),&accessBytes)){
										nums[pnum]=(double)flt;
									}
								}
								else if(tempType.IsPointer()){
									LONG_PTR lpData;
									if(i3=ReadProcessMemory(hDebugProcess,offset,&lpData,sizeof(LONG_PTR),&accessBytes)){
										i64nums[pnum]=(_int64)lpData;
									}
								}
								else if(tempType.Is64()){
									type[pnum]=DEF_INT64;

									i3=ReadProcessMemory(hDebugProcess,offset,&i64nums[pnum],sizeof(_int64),&accessBytes);
								}

								else if(tempType.IsLong()){
									long lData;
									if(i3=ReadProcessMemory(hDebugProcess,offset,&lData,sizeof(long),&accessBytes)){
										i64nums[pnum]=(_int64)lData;
									}
								}
								else if(tempType.IsDWord()){
									if(i3=ReadProcessMemory(hDebugProcess,offset,&dwData,sizeof(DWORD),&accessBytes)){
										i64nums[pnum]=(_int64)dwData;
									}
								}
								else if(tempType.IsInteger()){
									short shortData;
									if(i3=ReadProcessMemory(hDebugProcess,offset,&shortData,sizeof(short),&accessBytes)){
										i64nums[pnum]=(_int64)shortData;
									}
								}
								else if(tempType.IsWord()){
									WORD wData;
									if(i3=ReadProcessMemory(hDebugProcess,offset,&wData,sizeof(WORD),&accessBytes)){
										i64nums[pnum]=(_int64)wData;
									}
								}
								else if(tempType.IsSByte()){
									char charData;
									if(i3=ReadProcessMemory(hDebugProcess,offset,&charData,sizeof(char),&accessBytes)){
										i64nums[pnum]=(_int64)charData;
									}
								}
								else if(tempType.IsByte()){
									BYTE byteData;
									if(i3=ReadProcessMemory(hDebugProcess,offset,&byteData,sizeof(BYTE),&accessBytes)){
										i64nums[pnum]=(_int64)byteData;
									}
								}
								else if(tempType.IsBoolean()){
									BYTE byteData;
									if(i3=ReadProcessMemory(hDebugProcess,offset,&byteData,sizeof(BYTE),&accessBytes)){
										i64nums[pnum]=(_int64)byteData;
									}
								}
								else return false;

								if(!i3){
									//ǂݍ݂Ɏs
									if( pIsMemoryAccessError ) *pIsMemoryAccessError = true;
									return false;
								}
								goto JumpConst;
							}
						}


						/////////
						//萔
						/////////
						StrPtr[pnum]=0;
						type[pnum] = CDBConst::obj.GetBasicType(Parms);
						if(type[pnum]){
							if(IsRealNumberType(type[pnum])){
								//^
								nums[pnum] = CDBConst::obj.GetDoubleData(Parms);
							}
							else if(IsWholeNumberType(type[pnum])){
								//
								i64nums[pnum] = CDBConst::obj.GetWholeData(Parms);
							}
/*							else if(type[pnum]==DEF_STRING){
								//e

								//oCg
								nums[pnum]=dbl;
								i2=(int)dbl;

								memcpy(Parms,temporary,(int)nums[pnum]);
								goto StrLiteral;
							}*/
							else{
								//G[
								if(enableerror) SetError(300,NULL,cp);
								return 0;
							}
							goto JumpConst;
						}


						//////////////
						// ^̏ꍇ
						//////////////

						{
							Type tempType;
							if( !Type::StringToType( Parms, tempType ) ){
								if(bDebuggingWatchList){
									if( pIsMemoryAccessError ) *pIsMemoryAccessError = true;
									return false;
								}
								//G[
								if(enableerror) SetError(3,Parms,cp);
								return false;
							}

							if( tempType.IsObject() ){
								if( tempType.GetClass().IsBlittableType() ){
									// Blittable^̂Ƃ͊{^ƂĈ
									tempType = tempType.GetClass().GetBlittableType();
								}
							}

							type[pnum] = tempType.GetBasicType();
							before_index[pnum] = tempType.GetIndex();
						}

JumpConst:;
					}
					else{
						//el
						StrPtr[pnum]=0;
						type[pnum]=GetLiteralValue(Parms,&i64data,BaseType);
						if(IsRealNumberType(type[pnum])){
							//^
							memcpy(&nums[pnum],&i64data,sizeof(double));
						}
						else{
							//^
							i64nums[pnum]=i64data;
							before_index[pnum]=GetLiteralIndex(i64data);
						}
					}
				}

				pnum++;
			}
			else{
				if(!(Command[i]=='+'||Command[i]=='-'||(Command[i]==1&&Command[i+1]==ESC_NOT))){
					if(enableerror) SetError(1,NULL,cp);
					return false;
				}
				if(Command[i]=='+'){
					i2=-1;
					continue;
				}
			}

			if(Command[i]=='\0'){
				for(;sp>0;pnum++){
					sp--;
					calc[pnum]=(int)stack[sp];
				}
				break;
			}

			//_Zq
			if(Command[i]==1&&Command[i+1]==ESC_XOR) i3=CALC_XOR;
			else if(Command[i]==1&&Command[i+1]==ESC_OR) i3=CALC_OR;
			else if(Command[i]==1&&Command[i+1]==ESC_AND) i3=CALC_AND;
			else if(Command[i]==1&&Command[i+1]==ESC_NOT) i3=CALC_NOT;

			//rbgZqiD揇ʂ͎ZpZq̌㕔j
			else if(Command[i]=='<'&&Command[i+1]=='<'){
				i3=CALC_SHL;
				i++;
			}
			else if(Command[i]=='>'&&Command[i+1]=='>'){
				i3=CALC_SHR;
				i++;
			}

			//rZq
			else if(Command[i]=='<'&&Command[i+1]=='='||
				Command[i]=='='&&Command[i+1]=='<'){
				i3=CALC_PE;
				i++;
			}
			else if(Command[i]=='>'&&Command[i+1]=='='||
				Command[i]=='='&&Command[i+1]=='>'){
				i3=CALC_QE;
				i++;
			}
			else if(Command[i]=='<'&&Command[i+1]=='>'||
				Command[i]=='>'&&Command[i+1]=='<'){
				i3=CALC_NOTEQUAL;
				i++;
			}
			else if(Command[i]=='=') i3=CALC_EQUAL;
			else if(Command[i]=='<') i3=CALC_P;
			else if(Command[i]=='>') i3=CALC_Q;

			//ZpZq
			else if(Command[i]=='+'||Command[i]=='&') i3=CALC_ADDITION;
			else if(Command[i]=='-'&&i2) i3=CALC_SUBTRACTION;
			else if(Command[i]==1&&Command[i+1]==ESC_MOD) i3=CALC_MOD;
			else if(Command[i]=='*') i3=CALC_PRODUCT;
			else if(Command[i]=='/') i3=CALC_QUOTIENT;
			else if(Command[i]=='\\') i3=CALC_INTQUOTIENT;
			else if(Command[i]=='-'&&i2==0) i3=CALC_MINUSMARK;
			else if(Command[i]=='^') i3=CALC_POWER;
			else if(Command[i]==1&&Command[i+1]==ESC_AS) i3=CALC_AS;
			else if(Command[i]==1&&Command[i+1]==ESC_BYVAL) i3=CALC_BYVAL;

			i3+=PareNum*100;
			if(sp){
				if(stack[sp-1]>i3-3&&
					(!(
					(stack[sp-1]%100==CALC_MINUSMARK||stack[sp-1]%100==CALC_NOT)&&
					(i3%100==CALC_MINUSMARK||i3%100==CALC_NOT)
					))
					){
					for(;sp>0;){
						sp--;
						calc[pnum]=(int)stack[sp];
						pnum++;
						if(!(stack[sp-1]>i3-3)) break;
					}
				}
			}
			stack[sp]=i3;
			sp++;

			if(Command[i]==1) i++;
			i2=-1;
			continue;
		}
		Parms[i2]=Command[i];
	}

	int type_stack[255];
	LONG_PTR index_stack[255];
	int idCalc;
	for(i=0,sp=0;i<pnum;i++){

		if( enableerror ){
			//^`FbNiłȂꍇ̓G[ɂj
			TypeErrorCheck(stack,sp,calc[i]%100);
		}

		idCalc=calc[i]%100;

		switch(idCalc){
			//l
			case 0:
				dbl_stack[sp]=nums[i];
				i64stack[sp]=i64nums[i];
				type_stack[sp]=type[i];
				index_stack[sp]=before_index[i];

				stack[sp]=(_int64)StrPtr[i];
				sp++;
				break;

			//_Z
			case CALC_NOT:
				if(IsRealNumberType(type_stack[sp-1])){
					//Z
					dbl_stack[sp-1]=(double)(~(long)dbl_stack[sp-1]);
				}
				else{
					//Z
					i64stack[sp-1]=~i64stack[sp-1];
				}
				break;

			//rZ
			case CALC_PE:
			case CALC_QE:
			case CALC_P:
			case CALC_Q:
			case CALC_NOTEQUAL:
			case CALC_EQUAL:

			//_Z
			case CALC_XOR:
			case CALC_OR:
			case CALC_AND:

			//VtgZ
			case CALC_SHL:
			case CALC_SHR:

			//ZpZ
			case CALC_ADDITION:
			case CALC_SUBTRACTION:
			case CALC_MOD:
			case CALC_PRODUCT:
			case CALC_QUOTIENT:
			case CALC_INTQUOTIENT:
			case CALC_POWER:
				StaticTwoTerm(idCalc,type_stack,index_stack,&sp,BaseType);
				break;

			case CALC_MINUSMARK:
				if(IsRealNumberType(type_stack[sp-1])){
					//Z
					dbl_stack[sp-1]=-dbl_stack[sp-1];
				}
				else{
					//Z
					i64stack[sp-1]=-i64stack[sp-1];
				}
				break;
			case CALC_AS:
				if(IsWholeNumberType(type_stack[sp-2])){
					if(IsRealNumberType(type_stack[sp-1])){
						dbl_stack[sp-2]=(double)i64stack[sp-2];
					}
				}
				if(IsRealNumberType(type_stack[sp-2])){
					if(IsWholeNumberType(type_stack[sp-1])){
						i64stack[sp-2]=(_int64)dbl_stack[sp-2];
					}
				}

				if( type_stack[sp-1] == DEF_OBJECT || type_stack[sp-1] == DEF_STRUCT ){
					// elł͂Ȃߔo
					return false;
				}

				type_stack[sp-2]=type_stack[sp-1];
				index_stack[sp-2]=index_stack[sp-1];
				sp--;
				break;
			case CALC_BYVAL:
				//G[
				break;
		}
	}
	if(stack[0]){
		//|C^
		*pi64data=(_int64)stack[0];
		resultType.SetType( type_stack[0], index_stack[0] );
		return true;
	}

	if(IsRealNumberType(type_stack[0])){
		//
		memcpy(pi64data,&dbl_stack[0],sizeof(double));
		resultType.SetType( type_stack[0], index_stack[0] );
		return true;
	}

	//
	*pi64data=i64stack[0];

	if(index_stack[0]==-1){
		if(Is64Type(type_stack[0])==0&&IsRealNumberType(type_stack[0])==0){
			//iL/j
			i64data=*pi64data;

			resultType.SetIndex( GetLiteralIndex(i64data) );
		}
	}
	else{
		resultType.SetIndex( index_stack[0] );
	}

	resultType.SetBasicType( type_stack[0] );
	return true;
}

#pragma optimize("", off)
#pragma warning(disable : 4748)
DWORD GetLiteralValue(char *value,_int64 *pi64,int BaseType){
	extern HANDLE hHeap;
	extern int cp;
	int i,i2,i3,sw1,sw2,bDbl;
	double dbl;
	char temporary[255];

	if(value[0]=='&'){
		_int64 i64temp;
		lstrcpy(temporary,value);

		if(temporary[1]=='o'||temporary[1]=='O'){
			for(i=2;;i++){
				i3=temporary[i]-0x30;
				if(i3<0||7<i3) break;
				temporary[i]=i3;
			}
			if(temporary[i]){
				SetError(57,NULL,cp);
				return DEF_BYTE;
			}

			i64temp=1;
			*pi64=0;
			for(i--;i>=2;i--){
				*pi64=(*pi64)+(_int64)(i64temp*temporary[i]);
				i64temp*=8;
			}
		}
		else if(temporary[1]=='h'||temporary[1]=='H'){
			CharUpper(temporary+2);
			for(i=2;;i++){
				i3=temporary[i]-0x30;
				if(i3<0||9<i3){
					i3=temporary[i]-0x41+10;
					if(i3<0xA||0xF<i3) break;
				}
				temporary[i]=i3;
			}
			if(temporary[i]){
				SetError(58,NULL,cp);
				return DEF_BYTE;
			}

			i64temp=1;
			*pi64=0;
			for(i--;i>=2;i--){
				*pi64=(*pi64)+(_int64)(i64temp*temporary[i]);
				i64temp*=0x10;
			}
		}
		else{
			SetError(12,"&",cp);
			return DEF_BYTE;
		}

		if(BaseType==DEF_INT64||BaseType==DEF_QWORD) return DEF_QWORD;

		if(((unsigned _int64)*pi64)<=UCHAR_MAX){
			//8rbg̃el
			return DEF_BYTE;
		}
		else if(((unsigned _int64)*pi64)<=USHRT_MAX){
			//16rbg̃el
			return DEF_WORD;
		}
		else if(((unsigned _int64)*pi64)<=UINT_MAX){
			//32rbg̃el
			return DEF_DWORD;
		}
		else{
			//64rbg̃el
			return DEF_QWORD;
		}
	}
	else if((value[0]>='0'&&value[0]<='9')||value[0]=='+'||value[0]=='-'||(value[0]=='.'&&(!IsVariableTopChar(value[1])))){
		for(i=0;;i++){
			if(value[i]!='-') break;
		}
		if(value[i]=='.'){
			SlideString(value+i,1);
			value[i]='0';
		}

		//G[`FbN
		bDbl=0;
		sw1=0;
		sw2=0;
		for(i2=i;;i2++){
			if(value[i2]=='\0') break;
			if(value[i2]=='.') bDbl=1;
			if(!((value[i2]>='0'&&value[i2]<='9')||value[i2]=='.')){
				if((value[i2]=='e'||value[i2]=='E')&&sw1==0){
					bDbl=1;
					sw1=1;
				}
				else if((value[i2]=='+'||value[i2]=='-')&&sw1==1&&sw2==0) sw2=1;
				else{
					extern BOOL bDebugRun;
					if(bDebugRun) return DEF_DOUBLE;

					SetError(3,value,cp);
					return DEF_DOUBLE;
				}
			}
		}

		if(bDbl){
			//̃el
			if(i%2) dbl=-atof(value+i);
			else dbl=atof(value+i);

			memcpy(pi64,&dbl,sizeof(double));

			if(BaseType==DEF_SINGLE) return DEF_SINGLE;

			return DEF_DOUBLE;
		}
		else{
			*pi64=_atoi64(value+i);
			if(i%2) *pi64=-(*pi64);

			if(BaseType==DEF_INT64||BaseType==DEF_QWORD) return BaseType;

			if(LONG_MIN<=*pi64&&*pi64<=LONG_MAX){
				//L32rbg̃el
				return DEF_LONG;
			}
			else if(*pi64<=UINT_MAX){
				//32rbg̃el
				return DEF_DWORD;
			}
			else{
				//L64rbg̃el
				return DEF_INT64;
			}
		}
	}

	extern BOOL bDebugRun;
	if(bDebugRun) return DEF_DOUBLE;

	SetError(33,NULL,cp);
	return DEF_DOUBLE;
}
#pragma optimize("", on)

BOOL GetConstCalcBuffer(const char *name,const char *Parameter,char *pCalcBuffer){
	extern HANDLE hHeap;
	int i2,i3,i4,num;
	char temporary[VN_SIZE];
	char *pParms[MAX_PARMS];

	CONSTINFO *pci;
	pci=GetConstHash(name);
	if(!pci) return 0;

	num=0;
	i2=0;
	while(1){
		i2=GetOneParameter(Parameter,i2,temporary);

		pParms[num]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
		lstrcpy(pParms[num],temporary);

		num++;
		if(Parameter[i2]=='\0') break;
	}
	if(num!=pci->ParmNum){
		extern int cp;
		for(i2=0;i2<num;i2++) HeapDefaultFree(pParms[i2]);
		SetError(10,name,cp);
		lstrcpy(pCalcBuffer,"0");
		return 1;
	}

	i2=0;
	i4=0;
	while(1){

		//̍擾
		for(i3=0;;i2++,i3++){
			if(!IsVariableChar(pci->StrValue[i2])){
				temporary[i3]=0;
				break;
			}
			temporary[i3]=pci->StrValue[i2];
		}

		//p[^Əƍ
		for(i3=0;i3<pci->ParmNum;i3++){
			if(lstrcmp(pci->ppParm[i3],temporary)==0) break;
		}

		if(i3==pci->ParmNum){
			//p[^łȂƂ
			lstrcpy(pCalcBuffer+i4,temporary);
			i4+=lstrlen(temporary);
		}
		else{
			//p[^̂Ƃ
			lstrcpy(pCalcBuffer+i4,pParms[i3]);
			i4+=lstrlen(pParms[i3]);
		}

		//ZqRs[
		for(;;i2++,i4++){
			if(pci->StrValue[i2]==1){
				pCalcBuffer[i4++]=pci->StrValue[i2++];
				pCalcBuffer[i4]=pci->StrValue[i2];
				continue;
			}
			if(IsVariableTopChar(pci->StrValue[i2])) break;
			pCalcBuffer[i4]=pci->StrValue[i2];
			if(pci->StrValue[i2]=='\0') break;
		}

		if(pci->StrValue[i2]=='\0') break;
	}

	for(i2=0;i2<num;i2++) HeapDefaultFree(pParms[i2]);

	return 1;
}
DWORD GetConstValue(char *name,double *pDbl,char *buffer,LONG_PTR *plpIndex){
	CONSTINFO *pci;
	pci=GetConstHash(name);
	if(pci){
		//萔Ƃ

		if(pci->StrValue){
			//萔

			//oCg
			*pDbl=pci->DblValue;

			//f[^
			memcpy(buffer,pci->StrValue,(int)pci->DblValue);

			if(plpIndex) *plpIndex=pci->lpIndex;

			return DEF_STRING;
		}
		else{
			if(pci->type==DEF_INT64){
				memcpy(pDbl,&pci->i64Value,sizeof(_int64));
				return DEF_INT64;
			}

			if(plpIndex) *plpIndex=pci->lpIndex;

			*pDbl=pci->DblValue;
			return pci->type;
		}
	}

	if(plpIndex) *plpIndex=-1;

	return -1;
}
int IsStrCalculation(char *Command){
	int i,i2,i3,i4,PareNum;
	char temporary[VN_SIZE],temp2[8192];

	for(i=0,i2=0;;i++){
		if(Command[i]=='('){
			for(i++,PareNum=1;;i++){
				if(Command[i]=='(') PareNum++;
				else if(Command[i]==')'){
					PareNum--;
					if(PareNum==0) break;
				}
			}
			continue;
		}
		if(Command[i]=='['){
			for(i++,PareNum=1;;i++){
				if(Command[i]=='[') PareNum++;
				else if(Command[i]==']'){
					PareNum--;
					if(PareNum==0) break;
				}
			}
			continue;
		}
		if(Command[i]=='\"'){
			i++;
			while(Command[i]!='\"') i++;
			continue;
		}
		if(Command[i]=='\0'){
			if(IsVariableTopChar(Command[i2])||
				Command[i2]=='.'&&IsVariableTopChar(Command[i2+1])){

				if((Command[i2]=='e'||Command[i2]=='E')&&
					(Command[i2+1]=='x'||Command[i2+1]=='X')&&
					Command[i2+2]=='\"'){
					//g
					return 1;
				}

				for(i3=0;;i3++){
					if(Command[i2+i3]=='('){
						temporary[i3]=0;
						break;
					}
					temporary[i3]=Command[i2+i3];
					if(Command[i2+i3]=='\0') break;
				}
				if(Command[i2+i3]=='('){

					//DLL֐̏ꍇ
					DllProc *pDllProc;
					pDllProc=GetDeclareHash(temporary);
					if(pDllProc){
						if( pDllProc->ReturnType().IsStringClass() ){
							return 1;
						}
						return 0;
					}

					//[U[`֐
					UserProc *pUserProc;
					pUserProc=GetSubHash(temporary);
					if(pUserProc){
						if( pUserProc->ReturnType().IsStringClass() ){
							return 1;
						}
						return 0;
					}

					//gݍ݊֐
					i4=GetFunctionFromName(temporary);
					if(i4){
						//gݍ݊֐͕ԂȂ
						return 0;
					}

					//萔
					CONSTINFO *pci;
					pci=GetConstHash(temporary);
					if(pci){

						if(pci->ParmNum){
							//}N֐̏ꍇ
							GetStringInPare_RemovePare(temporary,Command+i2+i3+1);
							GetConstCalcBuffer(pci->name,temporary,temp2);
							return IsStrCalculation(temp2);
						}

						if(pci->type==DEF_STRING) return 1;
						else return 0;
					}
				}

				//萔
				i3 = CDBConst::obj.GetBasicType(Command+i2);
				if(i3==DEF_STRING) return 1;	//
				if(i3) return 0;			//l

				//ϐ
				Type varType;
				if( !GetVarType(Command+i2,varType,1) ){
					//G[
					return -1;
				}
				if( varType.IsStringClass() ){
					return 1;
				}
			}
			else if(Command[i2]=='\"') return 1;
			break;
		}
		if(IsNumCalcMark(Command,i)||IsStrCalcMark(Command[i])){
			if(IsStrCalcMark(Command[i])){

				//&HA&O\L̏ꍇl
				if(i==0) continue;
				if(IsNumCalcMark(Command,i-1)) continue;

				if(Command[i+1]=='(') break;
				i2=i+1;
				continue;
			}
			break;
		}
	}
	return 0;
}

BYTE GetCalcId(const char *Command,int *pi){
	*pi=0;

	if(Command[0]==1) *pi=1;

	//_Zq
	if(Command[0]==1&&Command[1]==ESC_XOR) return CALC_XOR;
	else if(Command[0]==1&&Command[1]==ESC_OR) return CALC_OR;
	else if(Command[0]==1&&Command[1]==ESC_AND) return CALC_AND;
	else if(Command[0]==1&&Command[1]==ESC_NOT) return CALC_NOT;

	//rbgZqiD揇ʂ͎ZpZq̌㕔j
	else if(Command[0]=='<'&&Command[1]=='<'){
		*pi=1;
		return CALC_SHL;
	}
	else if(Command[0]=='>'&&Command[1]=='>'){
		*pi=1;
		return CALC_SHR;
	}

	//rZq
	else if(Command[0]=='<'&&Command[1]=='='||
		Command[0]=='='&&Command[1]=='<'){
		*pi=1;
		return CALC_PE;
	}
	else if(Command[0]=='>'&&Command[1]=='='||
		Command[0]=='='&&Command[1]=='>'){
		*pi=1;
		return CALC_QE;
	}
	else if(Command[0]=='<'&&Command[1]=='>'||
		Command[0]=='>'&&Command[1]=='<'){
		*pi=1;
		return CALC_NOTEQUAL;
	}
	else if(Command[0]=='=') return CALC_EQUAL;
	else if(Command[0]=='<') return CALC_P;
	else if(Command[0]=='>') return CALC_Q;

	//ZpZq
	else if(Command[0]=='+') return CALC_ADDITION;
	else if(Command[0]=='-') return CALC_SUBTRACTION;
	else if(Command[0]=='&') return CALC_STRPLUS;
	else if(Command[0]==1&&Command[1]==ESC_MOD) return CALC_MOD;
	else if(Command[0]=='*') return CALC_PRODUCT;
	else if(Command[0]=='/') return CALC_QUOTIENT;
	else if(Command[0]=='\\') return CALC_INTQUOTIENT;
	else if(Command[0]=='^') return CALC_POWER;
	else if(Command[0]==1&&Command[1]==ESC_AS) return CALC_AS;
	else if(Command[0]==1&&Command[1]==ESC_BYVAL) return CALC_BYVAL;

	return 0;
}
BOOL GetNumOpeElements(const char *Command,int *pnum,
					   char *values[255],long calc[255],long stack[255]){
	extern int cp;
	extern HANDLE hHeap;
	int i,i2,i3,i4,PareNum,sp;
	char temporary[1024];

	for(i=0,i2=0,sp=0,*pnum=0,PareNum=0;;i++,i2++){
		if(Command[i]=='\"'){
			temporary[i2]=Command[i];
			for(i++,i2++;;i++,i2++){
				temporary[i2]=Command[i];
				if(Command[i]=='\"') break;
			}
			continue;
		}
		else if(Command[i]=='['){
			i3=GetStringInBracket(temporary+i2,Command+i);
			i+=i3-1;
			i2+=i3-1;
			continue;
		}
		else if(Command[i]=='('){
			if(i==0){
				PareNum++;
				i2=-1;
				continue;
			}
			else if(IsNumCalcMark_Back(Command,i-1)||Command[i-1]=='('){
				PareNum++;
				i2=-1;
				continue;
			}
			else{
				//zϐ̏ꍇl
				i3=GetStringInPare(temporary+i2,Command+i);
				i+=i3-1;
				i2+=i3-1;
				continue;
			}
		}
		else if(Command[i]==')'){
			PareNum--;
			i2--;
			continue;
		}
		else if(IsNumCalcMark(Command,i)||(Command[i]=='&'&&i2!=0)){
			if((Command[i]=='+'||Command[i]=='-')&&(Command[i-1]=='e'||Command[i-1]=='E')){
				if(IsExponent(Command,i)){
					temporary[i2]=Command[i];
					continue;
				}
			}
			temporary[i2]=0;

			if((stack[sp-1]%100)==CALC_AS&&Command[i]=='*'){
				for(i3=0;i3<i2;i3++){
					if(temporary[i2]!='*') break;
				}
				if(i3==i2){
					//"*"|C^w蕶ƂĔF
					temporary[i2]=Command[i];
					continue;
				}
			}

			calc[*pnum]=0;
			if(i2){
				values[*pnum]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+255);
				lstrcpy(values[*pnum],temporary);
				(*pnum)++;
			}
			else{
				if(!(
						Command[i]=='+'||
						Command[i]=='-'||
						(Command[i]==1&&Command[i+1]==ESC_NOT)||
						(Command[i]==1&&Command[i+1]==ESC_BYVAL)
					)){
						SetError(1,NULL,cp);
						return 0;
				}
				if(Command[i]=='+'){
					i2=-1;
					continue;
				}
			}

			if(Command[i]=='-'&&i2==0){
				i3=CALC_MINUSMARK;
			}
			else{
				i3=GetCalcId(Command+i,&i4);
				i+=i4;
				if(!i3){
					SetError(1,NULL,cp);
					return 0;
				}
			}

			i3+=PareNum*100;
			if(sp){
				if(stack[sp-1]>i3-3&&
					(!(
					(stack[sp-1]%100==CALC_MINUSMARK || stack[sp-1]%100==CALC_NOT || stack[sp-1]%100==CALC_POWER)&&
					(i3%100==CALC_MINUSMARK || i3%100==CALC_NOT)
					))
					){
					for(;sp>0;){
						sp--;
						calc[*pnum]=stack[sp];
						values[*pnum]=0;
						(*pnum)++;
						if(!(stack[sp-1]>i3-3)) break;
					}
				}
			}
			stack[sp]=i3;
			sp++;

			i2=-1;
			continue;
		}
		temporary[i2]=Command[i];
		if(Command[i]=='\0'){
			calc[*pnum]=0;

			values[*pnum]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+255);
			lstrcpy(values[*pnum],temporary);
			(*pnum)++;

			for(;sp>0;(*pnum)++){
				sp--;
				calc[*pnum]=stack[sp];
				values[*pnum]=0;
			}
			break;
		}
	}

	calc[*pnum]=0;

	return 1;
}
