#pragma once

#include <vector>
#include <string>

#include <windows.h>
#include <stdlib.h>

using namespace std;

class Text{
protected:
	char *buffer;
	int length;

public:

	Text(){
		buffer = (char *)calloc( 1, 1 );
		length = 0;
	}
	~Text(){
		free( buffer );
	}

	bool ReadFile( const string &filePath );
};

class BasicSource : public Text
{
	static const string generateDirectiveName;

	void Realloc( int newLength ){
		buffer = (char *)realloc( buffer, newLength + 255 );

		length = newLength;

		extern char *basbuf;
		basbuf = buffer + 2;
	}

	void IncludeFiles();

	void ChangeReturnLineChar();

	void RemoveComments();

	bool ReadFile_InIncludeDirective( const string &filePath );
	void DirectiveIncludeOrRequire();

	void RemoveReturnLineUnderbar();

public:
	BasicSource(){}
	~BasicSource(){}

	char *GetBuffer(){
		return buffer+2;
	}
	int GetLength(){
		return length-2;
	}

	void SetBuffer( const char *buffer );

	bool ReadFile( const string &filePath );

	bool Generate( const string &genName, const char *buffer );

	void Addition( const char *buffer );

	void operator = ( const BasicSource &source ){
		Realloc( source.length );
		lstrcpy( buffer, source.buffer );
	}
};
