#include "common.h"

bool Variable::IsEqualSymbol( const Symbol &symbol, bool isSupportStaticMember ) const
{
	if( GetName() == symbol.GetName()
		&& NamespaceScopes::IsSameArea( this->namespaceScopes, symbol.GetNamespaceScopes() ) )
	{
		return true;
	}

	if( isSupportStaticMember && symbol.GetNamespaceScopes().size() >= 1 )
	{
		// ÓIol
		NamespaceScopes namespaceScopes( symbol.GetNamespaceScopes() );
		string name = namespaceScopes[namespaceScopes.size()-1] + "." + symbol.GetName();
		namespaceScopes.pop_back();

		return IsEqualSymbol( Symbol( namespaceScopes, name ), false );
	}
	return false;
}
