#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"



BOOL IsSafeReg(int reg){
	if(reg==REG_EBX||reg==REG_ESI||reg==REG_EDI) return 1;
	return 0;
}



/////////////////////////////////////////////////
// ModR/MoCgASIBoCgAfBXv[Xg
/////////////////////////////////////////////////

//XP[
#define SCALE_NON	(char)0x00
#define SCALE_2		(char)0x40
#define SCALE_4		(char)0x80
#define SCALE_8		(char)0xC0

//CfbNXȂ
#define INDEX_NON	0x04

void set_mod_rm_sib_disp(char mod,int reg,int scale,int index_reg,int base_reg,int disp){
	if(mod==MOD_DISP32){
		//ModR/MoCg
		OpBuffer[obp++]=(char)(      REGISTER_OPERAND(reg)<<3 | REGISTER_OPERAND(0x04));

		base_reg=0x05;
		index_reg=INDEX_NON;
	}
	else{
		//ModR/MoCg
		OpBuffer[obp++]=(char)(mod | REGISTER_OPERAND(reg)<<3 | REGISTER_OPERAND(base_reg));
	}


	//WX^[h̏ꍇ́AŏI
	if(mod==MOD_REG) return;


	if(REGISTER_OPERAND(base_reg)==0x04||mod==MOD_DISP32){
		//////////////////////
		// SIBoCgg
		//////////////////////

		OpBuffer[obp++]=(char)(scale| REGISTER_OPERAND(index_reg)<<3 | REGISTER_OPERAND(base_reg));
	}

	//fBXv[XgKvƂȂꍇ́AŏI
	if(mod==MOD_BASE) return;


	//////////////////////////
	// fBXv[Xg
	//////////////////////////

	if(mod==MOD_BASE_DISP8) OpBuffer[obp++]=(char)disp;
	else{
		*((long *)(OpBuffer+obp))=disp;
		obp+=sizeof(long);
	}
}



void __op_format(char op_prefix,char opcode,int reg){
	//߃vtBbNX
	if(op_prefix) OpBuffer[obp++]=op_prefix;

	//IyR[hAWX^
	OpBuffer[obp++]=(char)(opcode|REGISTER_OPERAND(reg));
}
void __op_format(char op_prefix,char opcode1,char opcode2,int reg,int base_reg,int offset,char mod){
	//߃vtBbNX
	if(op_prefix) OpBuffer[obp++]=op_prefix;

	//IyR[h
	OpBuffer[obp++]=opcode1;
	if(opcode2) OpBuffer[obp++]=opcode2;

	//ModR/M, SIB, disp
	set_mod_rm_sib_disp(mod,reg,SCALE_NON,INDEX_NON,base_reg,offset);
}



///////////////////
// mov֘A
///////////////////

void op_mov_RV(int reg,int offset){
	//mov reg,value

	//IyR[hAWX^
	OpBuffer[obp++]=(char)(0xB8|REGISTER_OPERAND(reg));

	//DISP32
	*((long *)(OpBuffer+obp))=offset;
	obp+=sizeof(long);
}
void op_mov_RV(int op_size,int reg,int offset){
	if(op_size==PTR_SIZE) op_mov_RV(reg,offset);
	else SetError(300,NULL,cp);
}
void op_mov_RR(int reg1,int reg2){
	//mov reg1,reg2

	if(reg1==reg2) return;

	//1000 1011 11xx xbbb
	OpBuffer[obp++]=(char)0x8B;
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg1)<<3 | REGISTER_OPERAND(reg2));
}
void op_mov_RM(int op_size,int reg,int base_reg,int offset,char mod){
	//mov reg32,dword ptr[base_reg+offset]
	//mov reg16,word ptr[base_reg+offset]
	//mov reg8,byte ptr[base_reg+offset]

	//16rbgZ̖߃vtBbNX
	char op_prefix=0;
	if(op_size==sizeof(short)) op_prefix=(char)0x66;

	//IyR[h
	char opcode;
	if(op_size==sizeof(char)) opcode=(char)0x8A;
	else opcode=(char)0x8B;

	__op_format(op_prefix,opcode,0,reg,base_reg,offset,mod);
}
void op_mov_RM_ex(int op_size,int reg,int base_reg1,int base_reg2,int offset,BOOL bUseOffset){
	//mov reg32,dword ptr[base_reg1+base_reg2+offset]
	//mov reg16,word ptr[base_reg1+base_reg2+offset]
	//mov reg8,byte ptr[base_reg1+base_reg2+offset]

	if(base_reg1==REG_ESP){
		//SIBoCgindexesp͎włȂ
		base_reg1=base_reg2;
		base_reg2=REG_ESP;
	}

	//16rbgZ̃vtBbNX
	if(op_size==sizeof(short)) OpBuffer[obp++]=(char)0x66;

	//IyR[h
	if(op_size==sizeof(char)) OpBuffer[obp++]=(char)0x8A;
	else OpBuffer[obp++]=(char)0x8B;

	if(bUseOffset){
		///////////////////////////
		// ItZbglg
		///////////////////////////

		//WX^
		OpBuffer[obp++]=(char)(0x84| REGISTER_OPERAND(reg)<<3);

		//x[XWX^
		OpBuffer[obp++]=(char)(REGISTER_OPERAND(base_reg1)<<3 | REGISTER_OPERAND(base_reg2));

		//ItZbgl
		*((long *)(OpBuffer+obp))=offset;
		obp+=sizeof(long);
	}
	else{
		///////////////////////////
		// ItZbglgȂ
		///////////////////////////

		//WX^
		OpBuffer[obp++]=(char)(0x04| REGISTER_OPERAND(reg)<<3);

		//x[XWX^
		OpBuffer[obp++]=(char)(REGISTER_OPERAND(base_reg1)<<3 | REGISTER_OPERAND(base_reg2));
	}
}
void op_mov_MR(int op_size,int reg,int base_reg,int offset,char mod){
	//mov dword ptr[base_reg+offset],reg32
	//mov word ptr[base_reg+offset],reg16
	//mov byte ptr[base_reg+offset],reg8

	//16rbgZ̖߃vtBbNX
	char op_prefix=0;
	if(op_size==sizeof(short)) op_prefix=(char)0x66;

	//IyR[h
	char opcode;
	if(op_size==sizeof(char)) opcode=(char)0x88;
	else opcode=(char)0x89;

	__op_format(op_prefix,opcode,0,reg,base_reg,offset,mod);
}
void op_mov_MR_ex(int op_size,int reg,int base_reg1,int base_reg2,int offset,BOOL bUseOffset){
	//mov dword ptr[base_reg1+base_reg2+offset],reg32
	//mov word ptr[base_reg1+base_reg2+offset],reg16
	//mov byte ptr[base_reg1+base_reg2+offset],reg8

	if(base_reg1==REG_ESP){
		//SIBoCgindexrsp͎włȂ
		base_reg1=base_reg2;
		base_reg2=REG_ESP;
	}

	//16rbgZ̃vtBbNX
	if(op_size==sizeof(short)) OpBuffer[obp++]=(char)0x66;

	//IyR[h
	if(op_size==sizeof(char)) OpBuffer[obp++]=(char)0x88;
	else OpBuffer[obp++]=(char)0x89;

	if(bUseOffset==USE_OFFSET){
		//////////////////////////
		//ItZbglg
		//////////////////////////

		//WX^
		OpBuffer[obp++]=(char)(0x84| REGISTER_OPERAND(reg)<<3);

		//x[XWX^
		OpBuffer[obp++]=(char)(REGISTER_OPERAND(base_reg1)<<3 | REGISTER_OPERAND(base_reg2));

		//ItZbgl
		*((long *)(OpBuffer+obp))=offset;
		obp+=sizeof(long);
	}
	else{
		//////////////////////////
		//ItZbglgȂ
		//////////////////////////

		//WX^
		OpBuffer[obp++]=(char)(0x04| REGISTER_OPERAND(reg)<<3);

		//x[XWX^
		OpBuffer[obp++]=(char)(REGISTER_OPERAND(base_reg1)<<3 | REGISTER_OPERAND(base_reg2));
	}
}




////////////////////////////////
// movsx֘A
////////////////////////////////

void op_movsx_R32R16(int reg32,int reg16){
	//movsx reg32,reg16

	//16rbgZ̖߃vtBbNX
	char op_prefix=0;

	//IyR[h
	char opcode=(char)0x0F;
	char opcode2=(char)0xBF;

	__op_format(op_prefix,opcode,opcode2,reg32,reg16,0,MOD_REG);
}
void op_movsx_R32R8(int reg32,int reg8){
	//movsx reg32,reg8

	//16rbgZ̖߃vtBbNX
	char op_prefix=0;

	//IyR[h
	char opcode=(char)0x0F;
	char opcode2=(char)0xBE;

	__op_format(op_prefix,opcode,opcode2,reg32,reg8,0,MOD_REG);
}
void op_movsx_R16R8(int reg16,int reg8){
	//movsx reg16,reg8

	//16rbgZ̖߃vtBbNX
	char op_prefix=(char)0x66;

	//IyR[h
	char opcode=(char)0x0F;
	char opcode2=(char)0xBE;

	__op_format(op_prefix,opcode,opcode2,reg16,reg8,0,MOD_REG);
}



//////////////////////////////////
// CNgEfNg
//////////////////////////////////

void op_inc(int reg){
	//inc reg

	//16rbgZ̖߃vtBbNX
	char op_prefix=0;

	//IyR[h
	char opcode=(char)0xFF;

	__op_format(op_prefix,opcode,0,0,reg,0,MOD_REG);
}
void op_dec(int reg){
	op_inc(reg);
	OpBuffer[obp-1]=OpBuffer[obp-1]|0x08;
}



/////////////////////
// add֘A
/////////////////////

void op_add_RV8(int reg,char cValue){
	//add reg,value8

	OpBuffer[obp++]=(char)0x83;
	OpBuffer[obp++]=(char)(0xC0|REGISTER_OPERAND(reg));
	OpBuffer[obp++]=cValue;
}
void op_add_RM(int op_size,int reg,int base_reg,int offset,char mod){
	//add reg32,dword ptr[base_reg+offset]
	//add reg16,word ptr[base_reg+offset]
	//add reg8,byte ptr[base_reg+offset]

	//16rbgZ̖߃vtBbNX
	char op_prefix=0;
	if(op_size==sizeof(short)) op_prefix=(char)0x66;

	//IyR[h
	char opcode;
	if(op_size==sizeof(char)) opcode=(char)0x02;
	else opcode=(char)0x03;

	__op_format(op_prefix,opcode,0,reg,base_reg,offset,mod);
}
void op_adc_RV8(int reg,char cValue){
	//adc reg,value8

	OpBuffer[obp++]=(char)0x83;
	OpBuffer[obp++]=(char)(0xD0|REGISTER_OPERAND(reg));
	OpBuffer[obp++]=cValue;
}


/////////////////////
// sub֘A
/////////////////////

void op_sub_RV8(int reg,char cValue){
	//sub reg,value8

	OpBuffer[obp++]=(char)0x83;
	OpBuffer[obp++]=(char)(0xE8|REGISTER_OPERAND(reg));
	OpBuffer[obp++]=cValue;
}
void op_sbb_RV8(int reg,char cValue){
	//sbb reg,value8

	OpBuffer[obp++]=(char)0x83;
	OpBuffer[obp++]=(char)(0xD8|REGISTER_OPERAND(reg));
	OpBuffer[obp++]=cValue;
}
void op_sbb_RR( int reg1, int reg2 ){
	//sbb reg1,reg2

	//IyR[h
	OpBuffer[obp++]=(char)0x1B;

	//WX^
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg1)<<3 | REGISTER_OPERAND(reg2));
}



////////////////////////
// imul֘A
////////////////////////

void op_imul_RR(int reg1,int reg2){
	//imul reg1,reg2

	//IyR[h
	OpBuffer[obp++]=(char)0x0F;
	OpBuffer[obp++]=(char)0xAF;

	//WX^
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg1)<<3 | REGISTER_OPERAND(reg2));
}

void op_imul_RV(int reg,int i32data){
	//imul reg,i32data

	if(-128<=i32data&&i32data<=127){
		//IyR[h
		OpBuffer[obp++]=(char)0x6B;

		//WX^
		OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg)<<3 | REGISTER_OPERAND(reg));

		//l
		OpBuffer[obp++]=(char)i32data;
	}
	else{
		//IyR[h
		OpBuffer[obp++]=(char)0x69;

		//WX^
		OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg)<<3 | REGISTER_OPERAND(reg));

		//l
		*((long *)(OpBuffer+obp))=i32data;
		obp+=sizeof(long);
	}
}



//////////////////////
// and֘A
//////////////////////

void op_and_RV(int reg,int value){
	//and reg,value

	if(reg==REG_RAX){
		//eax̂ݓ

		// [8bit rex] 0010 0101 [32bit offset]
		OpBuffer[obp++]=(char)0x25;
		*((long *)(OpBuffer+obp))=value;
		obp+=sizeof(long);
	}
	else{
		//16rbgZ̖߃vtBbNX
		char op_prefix=0;

		//IyR[h
		char opcode=(char)0x81;

		__op_format(op_prefix,opcode,0,0,reg,value,MOD_REG);
	}
}

void op_or_RR( int op_size, int reg1, int reg2 ){
	//16rbgZ̃vtBbNX
	if(op_size==sizeof(short)) OpBuffer[obp++]=(char)0x66;

	//IyR[h
	if(op_size==sizeof(char)) OpBuffer[obp++]=(char)0x0A;
	else OpBuffer[obp++]=(char)0x0B;

	//WX^
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg1)<<3 | REGISTER_OPERAND(reg2));
}



void op_neg( int reg ){
	//neg reg

	//IyR[h
	OpBuffer[obp++]=(char)0xF7;

	//WX^
	OpBuffer[obp++]=(char)(0xD8| REGISTER_OPERAND(reg));
}



///////////////////////
// 64rbg֘A
///////////////////////

void op_cdq(){
	//cdq
	OpBuffer[obp++]=(char)0x99;
}



/////////////////////
// XgO֌W
/////////////////////

void op_rep_movs(int op_size){
	if(op_size==sizeof(BYTE)){
		//rep movs byte ptr[edi],byte ptr[esi]
		OpBuffer[obp++]=(char)0xF3;
		OpBuffer[obp++]=(char)0xA4;
	}
	else if(op_size==sizeof(short)){
		//rep movs word ptr[edi],word ptr[esi]
		OpBuffer[obp++]=(char)0xF3;
		OpBuffer[obp++]=(char)0x66;
		OpBuffer[obp++]=(char)0xA5;
	}
	else if(op_size==sizeof(long)){
		//rep movs dword ptr[edi],dword ptr[esi]
		OpBuffer[obp++]=(char)0xF3;
		OpBuffer[obp++]=(char)0xA5;
	}
}




//////////////////////////
// X^bN֘A
//////////////////////////

void op_push(int reg){
	//push reg

	if( reg == REG_NON ){
		op_sub_esp( PTR_SIZE );
		return;
	}

	//IyR[hAWX^
	__op_format(0,(char)0x50,reg);
}
void op_push_V(long data){
	//X^bNɃelvbV
	if(-128<=data&&data<=127){
		//push 8rbgl
		OpBuffer[obp++]=(char)0x6A;
		OpBuffer[obp++]=(char)data;
	}
	else{
		//push 32rbgl
		OpBuffer[obp++]=(char)0x68;
		*((long *)(OpBuffer+obp))=data;
		obp+=sizeof(long);
	}
}
void op_pop(int reg){
	//pop reg

	if( reg == REG_NON ){
		op_add_esp( PTR_SIZE );
		return;
	}

	//IyR[hAWX^
	__op_format(0,(char)0x58,reg);
}
void op_add_esp(int num){
	//X^bN|C^̉Zipopj

	//add esp,num
	if(0xFFFFFF80&num){
		OpBuffer[obp++]=(char)0x81;
		OpBuffer[obp++]=(char)0xC4;
		*((long *)(OpBuffer+obp))=num;
		obp+=sizeof(long);
	}
	else{
		//u128 > num > -127v̏ꍇ
		OpBuffer[obp++]=(char)0x83;
		OpBuffer[obp++]=(char)0xC4;
		OpBuffer[obp++]=(char)num;
	}
}
void op_sub_esp(int num){
	//X^bN|C^̌Zipushj

	//sub esp,num
	if(0xFFFFFF80&num){
		OpBuffer[obp++]=(char)0x81;
		OpBuffer[obp++]=(char)0xEC;
		*((long *)(OpBuffer+obp))=num;
		obp+=sizeof(long);
	}
	else{
		//u128 > num > -127v̏ꍇ
		OpBuffer[obp++]=(char)0x83;
		OpBuffer[obp++]=(char)0xEC;
		OpBuffer[obp++]=(char)num;
	}
}



/////////////////////
// cmp֘A
/////////////////////
void op_cmp_RR( int reg1, int reg2 ){
	//IyR[h
	OpBuffer[obp++]=(char)0x3B;

	//WX^
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg1)<<3 | REGISTER_OPERAND(reg2));
}
void op_cmp_value(int op_size,int reg,char byte_data){
	//cmp reg,byte_data

	if(op_size==sizeof(char)&&reg==REG_EAX){
		//alWX^̏ꍇ͓
		OpBuffer[obp++]=(char)0x3C;

		//8rbgl
		OpBuffer[obp++]=byte_data;

		return;
	}

	//16rbgZ̃vtBbNX
	if(op_size==sizeof(short)) OpBuffer[obp++]=(char)0x66;

	//IyR[h
	if(op_size==sizeof(char)) OpBuffer[obp++]=(char)0x80;
	else OpBuffer[obp++]=(char)0x83;

	//WX^
	OpBuffer[obp++]=(char)(0xF8| REGISTER_OPERAND(reg));

	//8rbgl
	OpBuffer[obp++]=byte_data;
}
void op_setne( int reg ){
	//IyR[h
	OpBuffer[obp++]=(char)0x0F;
	OpBuffer[obp++]=(char)0x95;

	//WX^
	OpBuffer[obp++]=(char)( 0xC0 | REGISTER_OPERAND(reg) );
}



////////////////////
// test֘A
////////////////////

void op_test(int reg1,int reg2){
	//test reg1,reg2

	//1000 0101 11rr rbbb
	OpBuffer[obp++]=(char)0x85;
	OpBuffer[obp++]=(char)(0xC0| REGISTER_OPERAND(reg1)<<3 | REGISTER_OPERAND(reg2));
}



//////////////////////////////
// _֘A
//////////////////////////////

void op_fld_ptr_esp(int type){
	//X^bN|C^obt@̃f[^𕂓_WX^փ[h

	if(type==DEF_DOUBLE){
		//fld qword ptr[esp]
		OpBuffer[obp++]=(char)0xDD;
		OpBuffer[obp++]=(char)0x04;
		OpBuffer[obp++]=(char)0x24;
	}
	else if(type==DEF_SINGLE){
		//fld dword ptr[esp]
		OpBuffer[obp++]=(char)0xD9;
		OpBuffer[obp++]=(char)0x04;
		OpBuffer[obp++]=(char)0x24;
	}
	else if(type==DEF_INT64){
		//fild qword ptr[esp]
		OpBuffer[obp++]=(char)0xDF;
		OpBuffer[obp++]=(char)0x2C;
		OpBuffer[obp++]=(char)0x24;
	}
	else if(type==DEF_LONG){
		//fild dword ptr[esp]
		OpBuffer[obp++]=(char)0xDB;
		OpBuffer[obp++]=(char)0x04;
		OpBuffer[obp++]=(char)0x24;
	}
}
void op_fld_basereg(int type,int base_reg){
	//fld ptr[reg]

	//IyR[h
	if(type==DEF_DOUBLE)		OpBuffer[obp++]=(char)0xDD;
	else if(type==DEF_SINGLE)	OpBuffer[obp++]=(char)0xD9;
	else SetError(300,NULL,cp);

	if(base_reg==REG_ESP){
		OpBuffer[obp++]=(char)0x04;
		OpBuffer[obp++]=(char)0x24;
	}
	else if(base_reg==REG_EBP){
		OpBuffer[obp++]=(char)0x45;
		OpBuffer[obp++]=(char)0x00;
	}
	else{
		OpBuffer[obp++]=(char)REGISTER_OPERAND(base_reg);
	}
}
void op_fld_base_offset(int type,int base_reg,int offset){
	//fld ptr[reg+offset]

	//IyR[h
	if(type==DEF_DOUBLE)		OpBuffer[obp++]=(char)0xDD;
	else if(type==DEF_SINGLE)	OpBuffer[obp++]=(char)0xD9;
	else SetError(300,NULL,cp);

	//IyR[hAWX^
	if(base_reg==REG_ESP){
		OpBuffer[obp++]=(char)0x84;
		OpBuffer[obp++]=(char)0x24;
	}
	else{
		OpBuffer[obp++]=(char)(0x80|REGISTER_OPERAND(base_reg));
	}

	//ItZbgl
	*((long *)(OpBuffer+obp))=offset;
	obp+=sizeof(long);
}
void op_fld_base_offset_ex(int type,int base_reg1,int base_reg2,int offset,BOOL bUseOffset){
	//fld ptr[base_reg1+base_reg2+offset]

	if(base_reg1==REG_ESP){
		//SIBoCgindexesp͎włȂ
		base_reg1=base_reg2;
		base_reg2=REG_ESP;
	}

	//IyR[h
	if(type==DEF_DOUBLE)		OpBuffer[obp++]=(char)0xDD;
	else if(type==DEF_SINGLE)	OpBuffer[obp++]=(char)0xD9;
	else SetError(300,NULL,cp);

	int reg=0;
	if(bUseOffset){
		///////////////////////////
		// ItZbglg
		///////////////////////////

		//WX^
		OpBuffer[obp++]=(char)(0x84| REGISTER_OPERAND(reg)<<3);

		//x[XWX^
		OpBuffer[obp++]=(char)(REGISTER_OPERAND(base_reg1)<<3 | REGISTER_OPERAND(base_reg2));

		//ItZbgl
		*((long *)(OpBuffer+obp))=offset;
		obp+=sizeof(long);
	}
	else{
		///////////////////////////
		// ItZbglgȂ
		///////////////////////////

		//WX^
		OpBuffer[obp++]=(char)(0x04| REGISTER_OPERAND(reg)<<3);

		//x[XWX^
		OpBuffer[obp++]=(char)(REGISTER_OPERAND(base_reg1)<<3 | REGISTER_OPERAND(base_reg2));
	}
}
void op_fstp_basereg(int type,int base_reg){
	//fstp ptr[reg]

	//IyR[h
	if(type==DEF_DOUBLE)		OpBuffer[obp++]=(char)0xDD;
	else if(type==DEF_SINGLE)	OpBuffer[obp++]=(char)0xD9;
	else SetError(300,NULL,cp);

	if(base_reg==REG_ESP){
		OpBuffer[obp++]=(char)0x1C;
		OpBuffer[obp++]=(char)0x24;
	}
	else if(base_reg==REG_EBP){
		OpBuffer[obp++]=(char)0x5D;
		OpBuffer[obp++]=(char)0x00;
	}
	else{
		OpBuffer[obp++]=(char)(0x18|REGISTER_OPERAND(base_reg));
	}
}
void op_fstp_base_offset(int type,int base_reg,int offset){
	//fstp ptr[reg+offset]

	//IyR[h
	if(type==DEF_DOUBLE)		OpBuffer[obp++]=(char)0xDD;
	else if(type==DEF_SINGLE)	OpBuffer[obp++]=(char)0xD9;
	else SetError(300,NULL,cp);

	//IyR[hAWX^
	if(base_reg==REG_ESP){
		OpBuffer[obp++]=(char)0x9C;
		OpBuffer[obp++]=(char)0x24;
	}
	else{
		OpBuffer[obp++]=(char)(0x98|REGISTER_OPERAND(base_reg));
	}

	//ItZbgl
	*((long *)(OpBuffer+obp))=offset;
	obp+=sizeof(long);
}
void op_fstp_base_offset_ex(int type,int base_reg1,int base_reg2,int offset,BOOL bUseOffset){
	//fstp ptr[base_reg1+base_reg2+offset]

	if(base_reg1==REG_ESP){
		//SIBoCgindexesp͎włȂ
		base_reg1=base_reg2;
		base_reg2=REG_ESP;
	}

	//IyR[h
	if(type==DEF_DOUBLE)		OpBuffer[obp++]=(char)0xDD;
	else if(type==DEF_SINGLE)	OpBuffer[obp++]=(char)0xD9;
	else SetError(300,NULL,cp);

	int reg=0;
	if(bUseOffset){
		///////////////////////////
		// ItZbglg
		///////////////////////////

		//WX^
		OpBuffer[obp++]=(char)(0x9C| REGISTER_OPERAND(reg)<<3);

		//x[XWX^
		OpBuffer[obp++]=(char)(REGISTER_OPERAND(base_reg1)<<3 | REGISTER_OPERAND(base_reg2));

		//ItZbgl
		*((long *)(OpBuffer+obp))=offset;
		obp+=sizeof(long);
	}
	else{
		///////////////////////////
		// ItZbglgȂ
		///////////////////////////

		//WX^
		OpBuffer[obp++]=(char)(0x1C| REGISTER_OPERAND(reg)<<3);

		//x[XWX^
		OpBuffer[obp++]=(char)(REGISTER_OPERAND(base_reg1)<<3 | REGISTER_OPERAND(base_reg2));
	}
}
void op_fistp_ptr_esp( int typeSize ){
	if( typeSize == sizeof(_int64) ){
		//64bit

		//fistp qword ptr[esp]
		fpu_cast();
		OpBuffer[obp++]=(char)0xDF;
		OpBuffer[obp++]=(char)0x3C;
		OpBuffer[obp++]=(char)0x24;
		fpu_cast_end();
	}
	else if( typeSize == sizeof(long) ){
		//32bit

		//fistp dword ptr[esp]
		fpu_cast();
		OpBuffer[obp++]=(char)0xDB;
		OpBuffer[obp++]=(char)0x1C;
		OpBuffer[obp++]=(char)0x24;
		fpu_cast_end();
	}
	else{
		SetError();
	}
}
void op_fstp_push( Type &type ){
	//sub esp,size
	op_sub_esp( type.GetBasicSize() );

	op_fstp_basereg( type.GetBasicType(), REG_ESP );
}



//////////////////////////////
// WX^֘A
//////////////////////////////

void op_zero_reg(int reg){
	//WX^0Zbg

	switch(reg){
		case REG_EAX:
			//xor eax,eax
			OpBuffer[obp++]=(char)0x33;
			OpBuffer[obp++]=(char)0xC0;
			break;
		case REG_EBX:
			//xor ebx,ebx
			OpBuffer[obp++]=(char)0x33;
			OpBuffer[obp++]=(char)0xDB;
			break;
		case REG_ECX:
			//xor ecx,ecx
			OpBuffer[obp++]=(char)0x33;
			OpBuffer[obp++]=(char)0xC9;
			break;
		case REG_EDX:
			//xor edx,edx
			OpBuffer[obp++]=(char)0x33;
			OpBuffer[obp++]=(char)0xD2;
			break;
		case REG_EBP:
			//xor ebp,ebp
			OpBuffer[obp++]=(char)0x33;
			OpBuffer[obp++]=(char)0xED;
			break;
	}
}

void fpu_cast(){
	///////////////////////
	// FPU̐؂̂Đݒ
	///////////////////////

	//sub esp,16
	op_sub_esp(16);

	//mov dword ptr[esp+4],eax
	OpBuffer[obp++]=(char)0x89;
	OpBuffer[obp++]=(char)0x44;
	OpBuffer[obp++]=(char)0x24;
	OpBuffer[obp++]=(char)0x04;

	//fnstcw word ptr[esp]
	OpBuffer[obp++]=(char)0xD9;
	OpBuffer[obp++]=(char)0x3C;
	OpBuffer[obp++]=(char)0x24;

	//mov ax,word ptr[esp]
	OpBuffer[obp++]=(char)0x66;
	OpBuffer[obp++]=(char)0x8B;
	OpBuffer[obp++]=(char)0x04;
	OpBuffer[obp++]=(char)0x24;

	//or ah,0Ch
	OpBuffer[obp++]=(char)0x80;
	OpBuffer[obp++]=(char)0xCC;
	OpBuffer[obp++]=(char)0x0C;

	//mov word ptr[esp+2],ax
	OpBuffer[obp++]=(char)0x66;
	OpBuffer[obp++]=(char)0x89;
	OpBuffer[obp++]=(char)0x44;
	OpBuffer[obp++]=(char)0x24;
	OpBuffer[obp++]=(char)0x02;

	//fldcw word ptr[esp+2]
	OpBuffer[obp++]=(char)0xD9;
	OpBuffer[obp++]=(char)0x6C;
	OpBuffer[obp++]=(char)0x24;
	OpBuffer[obp++]=(char)0x02;

	//mov eax,dword ptr[esp+4]
	OpBuffer[obp++]=(char)0x8B;
	OpBuffer[obp++]=(char)0x44;
	OpBuffer[obp++]=(char)0x24;
	OpBuffer[obp++]=(char)0x04;

	//add esp,16
	op_add_esp(16);
}
void fpu_cast_end(){
	//sub esp,16
	op_sub_esp(16);

	//fldcw word ptr[esp]
	OpBuffer[obp++]=(char)0xD9;
	OpBuffer[obp++]=(char)0x2C;
	OpBuffer[obp++]=(char)0x24;

	//add esp,16
	op_add_esp(16);
}


/////////////////////////////
// ֐Ăяo
/////////////////////////////

void op_call(UserProc *pUserProc){
	OpBuffer[obp++]=(char)0xE8;
	pobj_SubAddrSchedule->add(pUserProc,1);
	pUserProc->Using();
	obp+=sizeof(long);
}
void op_ret(){
	OpBuffer[obp++]=(char)0xC3;
}
