#pragma once

#include <iomanip>
#include <ios>//streamsize
#include <streambuf>//basic_streambuf
#include <string>//char_traits, basic_string
#include <tchar.h>//char_traits, basic_string
#include <sstream>

#include <tchar.h>
#include <stdarg.h>

#define STDX_DSTREAM_BUFFERING

using namespace std;

extern char BasicSystemDir[MAX_PATH];


// VC++  STLport  using std::char_traits; ݂Ȃ̂Kv
template <typename Ch_T, typename Tr_T = std::char_traits<Ch_T> >
class basic_dbg_streambuf: public std::basic_stringbuf<Ch_T, Tr_T>
{
public:
  basic_dbg_streambuf()
    {
#ifndef STDX_DSTREAM_BUFFERING
      setbuf(0,0);
#endif
    }

  virtual ~basic_dbg_streambuf()
    {
      sync();
    }

protected:
  int sync(void)
    {
      dbg_out(str().c_str());
      pbump(static_cast<int>(pbase() - pptr()));
      return 0;
    }

  void dbg_out(const Ch_T*);
};

template <>
inline void basic_dbg_streambuf<char>::dbg_out(const char *str)
{
	ofstream ofs( ( (string)BasicSystemDir + "logger.log" ).c_str(), ios_base::app );
	ofs << str ;
	ofs.close();
}

template <typename Ch_T, typename Tr_T = std::char_traits<Ch_T> >
class basic_dbg_ostream: public std::basic_ostream<Ch_T, Tr_T>
{
public:
basic_dbg_ostream() : std::basic_ostream<Ch_T, Tr_T>(new \
    basic_dbg_streambuf<Ch_T, Tr_T>())
    {
		ofstream ofs( ( (string)BasicSystemDir + "logger.log" ).c_str(), ios_base::trunc );
		ofs.close();
    }

  virtual ~basic_dbg_ostream()
    {
      // flush(); // sv炵Dhttp://www.tietew.jp/cppll/archive/607
      delete rdbuf();
    }
};

// OȂꍇ͂̉̍sRgAEg
#define USE_TRACE

#ifdef USE_TRACE
static basic_dbg_ostream<_TCHAR> logger;
#define trace(s) logger << s << endl
#else
#define trace(s)
#endif
