#pragma once

#include <string>
#include <vector>

#include "Type.h"

using namespace std;

class CClass;

class CMember : public MemberPrototype
{
	string name;
	Type type;
	bool isConst;

	string initializeExpression;
	string constructParameter;
public:
	int SubScripts[MAX_ARRAYDIM];

	int source_code_address;

	const string &GetName() const
	{
		return name;
	}
	void SetName( const string &name )
	{
		this->name = name;
	}

	Type GetType() const
	{
		return type;
	}

	bool IsConst()
	{
		return isConst;
	}

	const string &GetInitializeExpression() const
	{
		return initializeExpression;
	}
	const string &GetConstructParameter() const
	{
		return constructParameter;
	}

	CMember( Prototype::Accessibility accessibility, const string &name, const Type &type, bool isConst )
		: MemberPrototype( accessibility )
		, name( name )
		, type( type )
		, isConst( isConst )
	{
	}
	CMember( CClass *pobj_c, Prototype::Accessibility accessibility, bool idConst, bool isRef, char *buffer, int nowLine=-1 );
	CMember( CMember &member );
	~CMember();
	static void InitStaticMember(void);
};
typedef std::vector<CMember *> Members;
