#include "../BasicCompiler_Common/common.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif


CDefine::CDefine(){
	extern HANDLE hHeap;
	ppNames=(char **)HeapAlloc(hHeap,0,1);
	num=0;

	extern BOOL bDebugCompile;
	if(bDebugCompile) add("_DEBUG");

#ifdef _AMD64_
	add("_WIN64");
#endif

	char temporary[255];
	sprintf(temporary,"_AB_VER%d",MAJOR_VER);
	add(temporary);
}
CDefine::~CDefine(){
	int i;
	for(i=0;i<num;i++){
		HeapDefaultFree(ppNames[i]);
	}
	HeapDefaultFree(ppNames);
}
BOOL CDefine::add(char *name){
	extern HANDLE hHeap;

	//d`FbN
	if(check(name)) return 0;

	//ǉ
	ppNames=(char **)HeapReAlloc(hHeap,0,ppNames,(num+1)*sizeof(char *));
	ppNames[num]=(char *)HeapAlloc(hHeap,0,lstrlen(name)+1);
	lstrcpy(ppNames[num],name);

	num++;

	return 1;
}
BOOL CDefine::undef(char *name){
	extern HANDLE hHeap;
	int i;

	for(i=0;i<num;i++){
		if(lstrcmp(ppNames[i],name)==0) break;
	}
	if(i==num) return 0;

	HeapDefaultFree(ppNames[i]);

	num--;
	for(;i<num;i++){
		ppNames[i]=ppNames[i+1];
	}

	return 1;
}
BOOL CDefine::check(char *name){
	extern HANDLE hHeap;
	int i;

	//d`FbN
	for(i=0;i<num;i++){
		if(lstrcmp(ppNames[i],name)==0) return 1;
	}
	return 0;
}

//#define
CDefine *pobj_define;

int Search_endif(char *buffer,int i){
	for(;;i++){
		if(buffer[i]=='\0') break;

		if(buffer[i-1]=='\n'){
			if(_memicmp(buffer+i,"#ifdef",6)==0||_memicmp(buffer+i,"#ifndef",7)==0){
				i=Search_endif(buffer,i+6);
				if(buffer[i]=='\0') break;
				continue;
			}
			else if(_memicmp(buffer+i,"#endif",6)==0){
				break;
			}
		}
	}
	return i;
}

void preprocessor_ifdef(char *buffer,BOOL bndef){
	int i,i2,i3;
	char temporary[VN_SIZE];

	if(bndef) i=lstrlen("#ifndef");
	else i=lstrlen("#ifdef");
	while(buffer[i]==' '||buffer[i]=='\t') i++;

	for(i2=0;;i++,i2++){
		if(buffer[i]=='\n'||buffer[i]=='\0'){
			temporary[i2]=0;
			break;
		}
		temporary[i2]=buffer[i];
	}

	int sw=0;
	if(pobj_define->check(temporary)) sw=1;

	if(bndef){
		//#ifndef̂Ƃi΂ɂj
		if(sw) sw=0;
		else sw=1;
	}

	//#ifdef̍s
	SlideString(buffer+i,-i);
	i=0;

	BOOL bElse=0;
	if(sw){
		//TRUÊƂ

		//#elseA#endifT
		for(;;i++){
			if(buffer[i]=='\0') break;

			if(i==0||buffer[i-1]=='\n'){
				if(_memicmp(buffer+i,"#ifdef",6)==0||_memicmp(buffer+i,"#ifndef",7)==0){
					i=Search_endif(buffer,i+6);
					if(buffer[i]=='\0') break;
					continue;
				}
				else if(_memicmp(buffer+i,"#else",5)==0){
					i2=5;
					bElse=1;
					break;
				}
				else if(_memicmp(buffer+i,"#endif",6)==0){
					i2=6;
					bElse=0;
					break;
				}
			}
		}

		//s
		SlideString(buffer+i+i2,-i2);

		if(bElse){
			//#elseꍇ͂̋Ԃ

			for(i2=i,i3=0;;i2++){
				if(buffer[i2]=='\0') break;

				if(buffer[i2]=='\n') i3++;

				if(i2==0||buffer[i2-1]=='\n'){
					if(_memicmp(buffer+i2,"#ifdef",6)==0||_memicmp(buffer+i2,"#ifndef",7)==0){
						i2=Search_endif(buffer,i2+6);
						if(buffer[i2]=='\0') break;
						continue;
					}
					if(_memicmp(buffer+i2,"#endif",6)==0){
						i2+=6;
						break;
					}
				}
			}

			//\[XR[hԂAsR[h}
			SlideString(buffer+i2,i-i2+i3);
			memset(buffer+i,'\n',i3);
		}
	}
	else{
		//FALSÊƂ

		//#elseA#endifT
		for(i2=i,i3=0;;i2++){
			if(buffer[i2]=='\0') break;

			if(buffer[i2]=='\n') i3++;

			if(i2==0||buffer[i2-1]=='\n'){
				if(_memicmp(buffer+i2,"#ifdef",6)==0||_memicmp(buffer+i2,"#ifndef",7)==0){
					i2=Search_endif(buffer,i2+6);
					if(buffer[i2]=='\0') break;
					continue;
				}
				else if(_memicmp(buffer+i2,"#else",5)==0){
					i2+=5;
					bElse=1;
					break;
				}
				else if(_memicmp(buffer+i2,"#endif",6)==0){
					i2+=6;
					bElse=0;
					break;
				}
			}
		}

		//\[XR[hԂAsR[h}
		SlideString(buffer+i2,i-i2+i3);
		memset(buffer+i,'\n',i3);

		if(bElse){
			//#endifT
			for(;;i++){
				if(buffer[i]=='\0') break;

				if(i==0||buffer[i-1]=='\n'){
					if(_memicmp(buffer+i,"#ifdef",6)==0||_memicmp(buffer+i,"#ifndef",7)==0){
						i=Search_endif(buffer,i+6);
						if(buffer[i]=='\0') break;
						continue;
					}
					else if(_memicmp(buffer+i,"#endif",6)==0){
						i2=6;
						bElse=0;
						break;
					}
				}
			}

			//s
			SlideString(buffer+i+i2,-i2);
		}
	}
}


void DirectiveIfdef(char *buffer){
	int i,i2,i3,sw;
	char temporary[VN_SIZE];

	for(i=0;;i++){
		if(buffer[i]=='\0') break;

		if(i==0||buffer[i-1]=='\n'){
			sw=0;
			if(_memicmp(buffer+i,"#define",7)==0){
				i2=i+7;
				while(buffer[i2]==' '||buffer[i2]=='\t') i2++;

				for(i3=0;;i2++,i3++){
					if(buffer[i2]=='\n'||buffer[i2]=='\0'){
						temporary[i3]=0;
						break;
					}
					temporary[i3]=buffer[i2];
				}

				pobj_define->add(temporary);

				i2-=i;

				//fBNeBu
				SlideString(buffer+i+i2,-i2);
			}
			if(_memicmp(buffer+i,"#undef",6)==0){
				i2=i+7;
				while(buffer[i2]==' '||buffer[i2]=='\t') i2++;

				for(i3=0;;i2++,i3++){
					if(buffer[i2]=='\n'||buffer[i2]=='\0'){
						temporary[i3]=0;
						break;
					}
					temporary[i3]=buffer[i2];
				}

				pobj_define->undef(temporary);

				i2-=i;

				//fBNeBu
				SlideString(buffer+i+i2,-i2);
			}
			else if(_memicmp(buffer+i,"#ifdef",6)==0){
				preprocessor_ifdef(buffer+i,0);
				continue;
			}
			else if(_memicmp(buffer+i,"#ifndef",7)==0){
				preprocessor_ifdef(buffer+i,1);
				continue;
			}
			else continue;
		}
	}
}

char *IncludeFiles(char *base){
	extern char szIncludeDir[MAX_PATH];
	extern char BasicCurDir[MAX_PATH];
	extern INCLUDEFILEINFO IncludeFileInfo;
	int i,i2,i3,sw1,FileSize,LineNum,FileLayer[255],layer,LastFileByte[255];
	char *buffer,temporary[MAX_PATH],temp2[MAX_PATH+255],*LayerDir[255];
	DWORD AccBytes;
	HANDLE hFile;

	IncludeFileInfo.ppFileNames=(char **)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,sizeof(char *));
	extern char SourceFileName[MAX_PATH];
	IncludeFileInfo.ppFileNames[0]=(char *)HeapAlloc(hHeap,0,lstrlen(SourceFileName)+1);
	lstrcpy(IncludeFileInfo.ppFileNames[0],SourceFileName);
	IncludeFileInfo.FilesNum=1;

	buffer=base+2;
	layer=0;
	FileLayer[layer]=0;
	LastFileByte[layer]=lstrlen(buffer);
	LineNum=0;

	//QƃfBNg
	LayerDir[0]=(char *)HeapAlloc(hHeap,0,lstrlen(BasicCurDir)+1);
	lstrcpy(LayerDir[0],BasicCurDir);

	for(i=0;;i++){
		if(buffer[i]=='\0'){
			IncludeFileInfo.LineOfFile[LineNum]=-1;
			break;
		}
		if(buffer[i]=='\n'){
			IncludeFileInfo.LineOfFile[LineNum]=FileLayer[layer];
			LineNum++;
		}
		if(i>LastFileByte[layer]){
			HeapDefaultFree(LayerDir[layer]);
			layer--;
		}
		if(buffer[i-1]=='\n'&&buffer[i]=='#'){
			if(memcmp(buffer+i+1,"include",7)==0){
				i2=i+8;
				while(buffer[i2]==' '||buffer[i2]=='\t') i2++;

				if(buffer[i2]=='\"') sw1=0;
				else if(buffer[i2]=='<') sw1=1;
				i2++;

				for(i3=0;;i2++,i3++){
					if((buffer[i2]=='\"'&&sw1==0)||(buffer[i2]=='>'&&sw1==1)||buffer[i2]=='\n'||buffer[i2]=='\0'){
						temporary[i3]=0;
						break;
					}
					temporary[i3]=buffer[i2];
				}
				while(buffer[i2]!='\n'&&buffer[i2]!='\0') i2++;

				if(sw1){
					sprintf(temp2,"%s%s",szIncludeDir,temporary);
					lstrcpy(temporary,temp2);
				}
				else GetFullPath(temporary,LayerDir[layer]);
			}
			else if(memcmp(buffer+i+1,"prompt",6)==0){
				i2=i+7;
				sprintf(temporary,"%sbasic\\prompt.sbp",szIncludeDir);
			}
			else if(memcmp(buffer+i+1,"N88BASIC",8)==0){
				i2=i+9;
				sprintf(temporary,"%sbasic\\prompt.sbp",szIncludeDir);
			}
			else if(memcmp(buffer+i+1,"console",7)==0){
				//TuVXe ^CvCUIɕύX
				extern unsigned short TypeOfSubSystem;
				TypeOfSubSystem=IMAGE_SUBSYSTEM_WINDOWS_CUI;

				i2=i+8;
				sprintf(temporary,"%sbasic\\dos_console.sbp",szIncludeDir);
			}
			else continue;

			if(i){
				//fBNeBu邽߁AsĂ܂̂hibasic.sbpj
				SlideString(buffer+i2,1);
				buffer[i2]='\n';
				for(i3=0;i3<=layer;i3++) LastFileByte[i3]++;
			}

			IncludeFileInfo.ppFileNames=(char **)HeapReAlloc(hHeap,0,IncludeFileInfo.ppFileNames,(IncludeFileInfo.FilesNum+1)*sizeof(char *));
			IncludeFileInfo.ppFileNames[IncludeFileInfo.FilesNum]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
			lstrcpy(IncludeFileInfo.ppFileNames[IncludeFileInfo.FilesNum],temporary);

			layer++;
			FileLayer[layer]=IncludeFileInfo.FilesNum;
			IncludeFileInfo.FilesNum++;

			//CN[ht@Cǂݍ
			hFile=CreateFile(temporary,GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
			if(hFile==INVALID_HANDLE_VALUE){
				sprintf(temp2,"CN[ht@C \"%s\" I[vł܂",temporary);
				extern char *basbuf;
				basbuf=base+2;
				SetError(-1,temp2,i);
				break;
			}
			FileSize=GetFileSize(hFile,NULL);

			//ǂݍ
			char *temp3;
			temp3=(char *)HeapAlloc(hHeap,0,FileSize+1);
			ReadFile(hFile,temp3,FileSize,&AccBytes,NULL);
			temp3[AccBytes]=0;

			//CRLFLFɕϊ
			ChangeReturnCode(temp3);

			//Rg폜
			DeleteComment(temp3);

			//#ifdeffBNeBu
			DirectiveIfdef(temp3);

			FileSize=lstrlen(temp3);

			i3=lstrlen(buffer)+FileSize;
			base=(char *)realloc(base,i3*2);
			buffer=base+2;
			SlideString(buffer+i2,FileSize+(i-i2));
			memcpy(buffer+i,temp3,FileSize);

			//N[Y
			CloseHandle(hFile);
			HeapDefaultFree(temp3);

			//VQƃfBNgZbg
			char temp4[MAX_PATH];
			_splitpath(temporary,temp2,temp4,0,0);
			lstrcat(temp2,temp4);
			LayerDir[layer]=(char *)HeapAlloc(hHeap,0,lstrlen(temp2)+1);
			lstrcpy(LayerDir[layer],temp2);

			//t@C͈͂XCh
			LastFileByte[layer]=i+FileSize-1;
			for(i3=0;i3<layer;i3++) LastFileByte[i3]+=FileSize+(i-i2);

			i--;
		}
	}

	HeapDefaultFree(LayerDir[0]);

	return base;
}
