#include "common.h"

char *basbuf;

extern CDefine *pobj_define;


CSource CSource::obj;

CToken::CToken(int pos, int length, TOKENTYPE type, int extended){
	this->pos = pos;
	this->length = length;
	this->type = type;
	this->extended = extended;
}
CToken::~CToken(){
}



CSource::CSource(){
}
CSource::~CSource(){
	Free();
}

void CSource::Free(){
	if(SourceCode){
		char *base = SourceCode-2;
		free(base);
		SourceCode = 0;
	}

	if(ppTokens){
		for(int i=0; i<TokenNum; i++){
			delete ppTokens[i];
		}
		free(ppTokens);
		ppTokens = 0;
	}
}

void CSource::Init(){

	//ÂJ
	Free();

	ppTokens = (CToken **)malloc(1);
	TokenNum = 0;
}


bool CSource::OpenFile(char *FileName){
	char *buffer;
	DWORD dwFileSize,dwAccBytes;
	HANDLE hFile;

	//t@CI[v
	hFile=CreateFile(FileName,GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hFile==INVALID_HANDLE_VALUE) return false;

	//obt@̈m
	dwFileSize=GetFileSize(hFile,0);
	buffer=(char *)malloc(dwFileSize+1);

	//ǂݍ
	ReadFile(hFile,buffer,dwFileSize,&dwAccBytes,0);
	buffer[dwAccBytes]=0;

	SetSourceCode(buffer);

	free(buffer);

	return true;
}

void CSource::SetSourceCode(char *source){

	//
	Init();

	//#define
	pobj_define=new CDefine;

	//obt@̈m
	char *base,*buffer;
	base=(char *)malloc(lstrlen(source)*2+255);
	base[0]='\n';
	base[1]='\n';
	buffer=base+2;
	lstrcpy(buffer,"#include <basic.sbp>\n");
	buffer+=lstrlen(buffer);

	//ǂݍ
	lstrcpy(buffer,source);

	//CRLFLFɕϊ
	ChangeReturnCode(buffer);

	//Rg폜
	DeleteComment(buffer);

	//#ifdeffBNeBu
	DirectiveIfdef(buffer);

	//ŏIsɂ͕܂܂Ȃ悤ɂ
	lstrcat(buffer,"\n");

	//CN[ht@Cǂݍ
	base=IncludeFiles(base);
	buffer = base + 2;

	//#definej
	delete pobj_define;
	pobj_define=0;

	SourceCode = buffer;
}

void CSource::AddSourceCode(char *source){
	char *temp;
	temp=(char *)malloc(lstrlen(source)+8192);
	lstrcpy(temp,source);

	//GXP[vV[PXݒ
	SetEscapeSequenceFormat(temp);

	//R}hΉ
	ChangeCommandToCode(temp);

	//V\[XR[hobt@̗e
	extern char *basbuf;
	int NewSize;
	NewSize=lstrlen(SourceCode)+lstrlen(temp);
	NewSize*=2;
	NewSize+=255;

	//Ōɓ\t
	char *base;
	base = SourceCode - 2;
	base = (char *)realloc(base, NewSize);
	SourceCode = base + 2;
	int oldlength = lstrlen(SourceCode);
	lstrcat(SourceCode, temp);

	free(temp);

	//
	CSource::obj.LexicalAnalysis(0);
}


//g[Nǉ
void CSource::AddToken(int pos, int length, TOKENTYPE type, int extended){
	CToken *ptoken = new CToken(pos, length, type, extended);

	ppTokens = (CToken **)realloc(ppTokens, (TokenNum + 1) * sizeof(CToken *));
	ppTokens[TokenNum] = ptoken;
	TokenNum++;
}

//́ig[N𐶐j
void CSource::LexicalAnalysis(int StartPos){
	int i = StartPos;
	int i2;

	try{

		while(true){
			if(SourceCode[i] == '\0') break;

			//
			int length;

			//g[N̎
			TOKENTYPE type;

			//t
			int extended = 0;

			if(IsNumCalcMark(SourceCode, i)){
				//Zq
				type = TOKEN_OPERATOR;

				extended = GetCalcId(SourceCode + i, &i2);

				length = i2 + 1;
			}
			else if(SourceCode[i] == 1){
				//ꎚ
				type = TOKEN_ESCAPESEQUENCE;

				length = 2;
			}
			else if(IsNumberTopChar(SourceCode + i)){
				//l
				type = TOKEN_NUMBER;

				if(SourceCode[i] == '&') length = 2;
				else length = 0;
				for(length=0; IsNumberChar(SourceCode[i+length]); length++){
				}
			}
			else if(SourceCode[i] == '\"'){
				//
				type = TOKEN_STRING;

				for(length=1;;length++){
					if(SourceCode[i + length]=='\0') break;
					if(SourceCode[i + length] == '\"'){
						length++;
						break;
					}
				}
			}
			else if(memicmp(SourceCode+i,"Ex",2) && SourceCode[i+3]=='\"'){
				//g
				type = TOKEN_EXSTRING;

				for(length=3;;length++){
					if(SourceCode[i + length]=='\0') break;
					if(SourceCode[i + length] == '\"'){
						length++;
						break;
					}
				}
			}
			else if(IsVariableTopChar(SourceCode[i])){
				//ʎq
				type = TOKEN_IDENTIFIER;

				for(length=0; IsVariableChar(SourceCode[i+length]); length++){
				}
			}
			else if(SourceCode[i] == 0x10 || SourceCode[i] == 0x11){
				//R}h
				type = TOKEN_COMMAND;
				length = 2;
			}
			else{
				throw "͂Ɏs\n";
			}

			if(length == 0){
				throw "͂Ɏs\n";
			}

			//g[Nǉ
			AddToken(i, length, type, extended);

			//̎̈ʒu
			i += length;

			//󔒂
			while(IsBlank(SourceCode[i])) i++;
		}

	}
	catch(const char *msg){
		OutputDebugString(msg);
	}
}
