#include "../common.h"
#ifdef _AMD64_
#include "../../BasicCompiler64/opcode.h"
#else
#include "../../BasicCompiler32/opcode.h"
#endif
#include <Member.h>

CMember::CMember( CClass *pobj_c, Prototype::Accessibility accessibility, bool isConst, bool isRef, char *buffer, int nowLine )
	: MemberPrototype( accessibility )
{
	extern int cp;

	//\
	char VarName[VN_SIZE];
	char init_buf[VN_SIZE];
	char constract_parameter[VN_SIZE];
	GetDimentionFormat(buffer,VarName,SubScripts,type,init_buf,constract_parameter);

	//d`FbN
	if(pobj_c->DupliCheckAll(VarName)){
		SetError(15,VarName,cp);
	}

	//o
	name = VarName;

	//萔ǂ
	this->isConst = isConst;

	//f[^
	InitBuf=(char *)HeapAlloc(hHeap,0,lstrlen(init_buf)+1);
	lstrcpy(InitBuf,init_buf);

	//RXgN^p̃p[^
	ConstractParameter=(char *)HeapAlloc(hHeap,0,lstrlen(constract_parameter)+1);
	lstrcpy(ConstractParameter,constract_parameter);

	//\[XR[ḧʒu
	source_code_address=nowLine;
}
CMember::CMember(CMember &member)
	: MemberPrototype( member.GetAccessibility() )
	, name( member.GetName() )
	, type( member.GetType() )
	, isConst( member.IsConst() )
{
	//SubScripts
	memcpy(SubScripts,member.SubScripts,MAX_ARRAYDIM*sizeof(int));

	//\[XR[ḧʒu
	source_code_address=member.source_code_address;
}
CMember::~CMember(){
	if(InitBuf) HeapDefaultFree(InitBuf);
	if(ConstractParameter) HeapDefaultFree(ConstractParameter);
}

void CMember::InitStaticMember(void){
	//ÓIoO[öɍ쐬

	//Ce[^Zbg
	extern CDBClass *pobj_DBClass;
	pobj_DBClass->Iterator_Reset();

	int back_cp=cp;

	while(pobj_DBClass->Iterator_HasNext()){
		CClass &objClass = *pobj_DBClass->Iterator_GetNext();

		// OԂZbg
		Smoothie::Lexical::liveingNamespaceScopes = objClass.GetNamespaceScopes();

		int i=0;
		foreach( CMember *member, objClass.staticMembers ){
			char temporary[VN_SIZE];
			sprintf(temporary,"%s.%s",objClass.GetName().c_str(),member->GetName().c_str());
			dim(
				temporary,
				member->SubScripts,
				member->GetType(),
				member->InitBuf,
				member->ConstractParameter,
				0);

			//lCeBuR[hobt@̍Ċm
			ReallocNativeCodeBuffer();

			i++;
		}
	}

	Smoothie::Lexical::liveingNamespaceScopes.clear();

	cp=back_cp;
}
