#pragma once

#include <string>
#include <vector>

#include <windows.h>

using namespace std;

class UserProc;
class CClass;
void SetError();

class CMethod
{
public:
	UserProc *pUserProc;
	DWORD dwAccess;

	CMethod( UserProc *pUserProc, DWORD dwAccess )
		: pUserProc( pUserProc )
		, dwAccess( dwAccess )
	{
	}

	virtual bool IsAbstract() const = 0;
	virtual void Override() = 0;
	virtual bool IsVirtual() const = 0;
	virtual bool IsConst() const = 0;
	virtual bool IsStatic() const = 0;
	virtual const CClass *GetInheritsClassPtr() const = 0;
	virtual void SetInheritsClassPtr( const CClass *pInheritsClass ) = 0;
};

class DynamicMethod : public CMethod
{
	bool isAbstract;
	bool isVirtual;
	bool isConst;
	const CClass *pInheritsClass;

public:
	DynamicMethod( UserProc *pUserProc, DWORD dwAccess, bool isAbstract, bool isVirtual, bool isConst, const CClass *pInheritsClass = NULL )
		: CMethod( pUserProc, dwAccess )
		, isAbstract( isAbstract )
		, isVirtual( isVirtual )
		, isConst( isConst )
		, pInheritsClass( pInheritsClass )
	{
	}
	DynamicMethod( const CMethod &method )
		: CMethod( method.pUserProc, method.dwAccess )
		, isAbstract( method.IsAbstract() )
		, isVirtual( method.IsVirtual() )
		, isConst( method.IsConst() )
		, pInheritsClass( method.GetInheritsClassPtr() )
	{
	}

	virtual bool IsAbstract() const
	{
		return isAbstract;
	}
	virtual void Override()
	{
		isAbstract = false;
	}
	virtual bool IsVirtual() const
	{
		return isVirtual;
	}
	virtual bool IsConst() const
	{
		return isConst;
	}
	virtual bool IsStatic() const
	{
		return false;
	}
	virtual const CClass *GetInheritsClassPtr() const
	{
		return pInheritsClass;
	}
	virtual void SetInheritsClassPtr( const CClass *pInheritsClass )
	{
		this->pInheritsClass = pInheritsClass;
	}
};
class StaticMethod : public CMethod
{
public:
	StaticMethod( UserProc *pUserProc, DWORD dwAccess )
		: CMethod( pUserProc, dwAccess )
	{
	}

	virtual bool IsAbstract() const{SetError();return false;}
	virtual void Override(){SetError();}
	virtual bool IsVirtual() const{
		return false;
	}
	virtual bool IsConst() const{SetError();return false;}
	virtual bool IsStatic() const
	{
		return true;
	}
	virtual const CClass *GetInheritsClassPtr() const{SetError();return NULL;}
	virtual void SetInheritsClassPtr( const CClass *pInheritsClass ){SetError();}
};

class Methods : public vector<CMethod *>
{
public:
	Methods();
	~Methods();

	//oA\bh̒ǉ
	void Add( UserProc *pUserProc,DWORD dwAccess, bool isConst, bool isAbstract, bool isVirtual );
	void AddStatic(UserProc *pUserProc,DWORD dwAccess);

	const CMethod *GetMethodPtr( UserProc *pUserProc ) const;
	bool IsExist( const char *name ) const;
	virtual void Enum( const char *methodName, vector<UserProc *> &subs ) const;
	virtual void Enum( const BYTE idOperatorCalc, vector<UserProc *> &subs ) const;
};
