#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void FreeTempObject(int reg,const CClass *pobj_c){
	if(!IsSafeReg(reg)) SetError(300,NULL,cp);

	const CMethod *method = pobj_c->GetDestructorMethod();
	if( method ){
		//push reg
		op_push(reg);

		//call DestructorProcAddr
		op_call( method->pUserProc );
	}

	//push reg
	op_push(reg);

	//call free
	extern UserProc *pSub_free;
	op_call(pSub_free);
}

int CallOperatorProc(int idCalc, const Type &baseType, int *type_stack,LONG_PTR *index_stack,BOOL *bUseHeap,int &sp){
	//I[o[[hꂽIy[^֐Ăяo
	CClass *pobj_c;
	pobj_c=(CClass *)index_stack[sp-2];

	std::vector<UserProc *> subs;
	pobj_c->GetMethods().Enum( idCalc, subs );
	if( subs.size() == 0 ){
		return 0;
	}


	//̐
	BOOL bTwoTerm=1;
	if(idCalc==CALC_AS) bTwoTerm=0;


	/////////////////////////////////////////////
	// I[o[[hp̃p[^ݒ
	/////////////////////////////////////////////

	Parameters params;

	if(bTwoTerm){
		params.push_back( new Parameter( "", Type( type_stack[sp-1], index_stack[sp-1] ) ) );
	}

	//I[o[[h
	char temporary[255];
	if(idCalc==CALC_EQUAL) lstrcpy(temporary,"==");
	else GetCalcName(idCalc,temporary);
	UserProc *pUserProc = OverloadSolution( temporary, subs, params, baseType );

	if(!pUserProc){
		if(bTwoTerm){
			delete params[0];
		}
		return -1;
	}
	else{
		//I[o[[hĂȂAp[^vȂƂ
		if(params.size()!=pUserProc->Params().size()){
			if(bTwoTerm){
				delete params[0];
			}
			return -1;
		}
	}

	for(int i=0;i<(int)params.size();i++){
		CheckDifferentType(
			pUserProc->Params()[i]->GetBasicType(),
			pUserProc->Params()[i]->GetIndex(),
			params[i]->GetBasicType(),
			params[i]->GetIndex(),
			"",
			i);
	}

	if(bTwoTerm){
		delete params[0];
	}

	int right_side_size = GetTypeSize(type_stack[sp-1],index_stack[sp-1]);

	if(bTwoTerm){
		if( pUserProc->RealParams()[1]->IsStruct() &&pUserProc->RealParams()[1]->IsRef() == false ){
			//ꎞIuWFNg̓\bhŔj
			bUseHeap[sp-1]=0;
		}
	}


	if( pUserProc->ReturnType().IsStruct() ){
		//////////////////////////////////////////////////////
		// ߂lɍ\̃CX^Xꍇ
		// ByRef _System_ReturnValue p[^p̈擾
		//////////////////////////////////////////////////////

		int object_size = pUserProc->ReturnType().GetClass().GetSize();

		//push object_size
		op_push_V(object_size);

		//call calloc
		extern UserProc *pSub_calloc;
		op_call(pSub_calloc);

		//mov ebx,eax
		op_mov_RR(REG_EBX,REG_EAX);
	}


	//2̍o
	if(bTwoTerm){
		if(right_side_size==sizeof(_int64)){
			//pop eax
			op_pop(REG_EAX);

			//pop edx
			op_pop(REG_EDX);
		}
		else{
			//pop eax
			op_pop(REG_EAX);
		}
	}

	//pop ecx
	op_pop(REG_ECX);


	//q[vpɑޔ
	if(bUseHeap[sp-1]){
		//mov esi,eax
		op_mov_RR(REG_ESI,REG_EAX);
	}
	if(bUseHeap[sp-2]){
		//mov edi,ecx
		op_mov_RR(REG_EDI,REG_ECX);
	}



	if(bTwoTerm){
		if(right_side_size==sizeof(_int64)){
			//push edx
			op_push(REG_EDX);

			//push eax
			op_push(REG_EAX);
		}
		else{
			//push eax
			op_push(REG_EAX);
		}

		if( pUserProc->RealParams()[1]->IsRef() ){
			//ꎞQƂ쐬

			//mov eax,esp
			op_mov_RR( REG_EAX, REG_ESP );

			//push eax
			op_push( REG_EAX );
		}
	}

	if( pUserProc->ReturnType().IsStruct() ){
		//push ebx
		op_push(REG_EBX);
	}

	//push ecx
	op_push(REG_ECX);

	//call operator_proc
	op_call(pUserProc);

	if(bTwoTerm){
		if( pUserProc->RealParams()[1]->IsRef() ){
			//ꎞQƂj
			op_pop( REG_NON );
		}
	}

	if( !pUserProc->ReturnType().IsNull() ){
		//X^bNփvbV
		PushReturnValue(pUserProc->ReturnType().GetBasicType());
	}

	if(bUseHeap[sp-1]){
		FreeTempObject(REG_ESI,(CClass *)index_stack[sp-1]);
	}
	if(bUseHeap[sp-2]){
		FreeTempObject(REG_EDI,(CClass *)index_stack[sp-2]);
	}

	sp--;
	type_stack[sp-1]=pUserProc->ReturnType().GetBasicType();
	index_stack[sp-1]=pUserProc->ReturnType().GetIndex();

	if( pUserProc->ReturnType().IsStruct() ){
		//\̂߂Ƃ̓q[v̈ɃCX^Xi[Ă
		//freeKv
		bUseHeap[sp-1]=1;
	}
	else bUseHeap[sp-1]=0;

	return 1;
}

void CallCastOperatorProc(Type &calcType,BOOL bCalcUseHeap,const Type &toType){
	int type_stack[10];
	LONG_PTR index_stack[10];
	BOOL array_bUseHeap[10];
	int sp=2;

	if(bCalcUseHeap){
		//̃CX^X݂|x
		SetError(-105,NULL,cp);
	}

	//
	type_stack[0]=calcType.GetBasicType();
	index_stack[0]=calcType.GetIndex();
	array_bUseHeap[0]=0;
	type_stack[1]=toType.GetBasicType();
	index_stack[1]=toType.GetIndex();
	array_bUseHeap[1]=0;

	int iRet = CallOperatorProc(CALC_AS,toType,type_stack,index_stack,array_bUseHeap,sp);

	if(iRet==1){
		//Ƃ
		calcType.SetType( type_stack[0], index_stack[0] );
		return;
	}
	else if(iRet==-1){
		//G[sꂽƂ
		return;
	}

	//G[𔭍s
	SetError(-1,"LXgZqI[o[[hĂ܂B",cp);
}
void CallIndexerGetterProc(const CClass *pobj_Class,char *ObjectName,char *Parameter,Type &resultType){
	std::vector<UserProc *> subs;
	pobj_Class->GetMethods().Enum( CALC_ARRAY_GET, subs );
	if( subs.size() == 0 ){
		return;
	}

	Opcode_CallProc(Parameter,subs[0],0,ObjectName,DEF_OBJECT);
	resultType = subs[0]->ReturnType();
}
