#pragma once

#include <string>
#include <vector>

#include <Namespace.h>

using namespace std;

class CMethod;
class UserProc;

class Prototype
{
	// O
	NamespaceScopes namespaceScopes;

	//O
	string name;

	mutable bool isUsing;

public:

	Prototype( const NamespaceScopes &namespaceScopes, const string &name )
		: namespaceScopes( namespaceScopes )
		, name( name )
		, isUsing( false )
	{
	}
	~Prototype()
	{
	}

	// O
	const NamespaceScopes &GetNamespaceScopes() const
	{
		return namespaceScopes;
	}

	const string &GetName() const
	{
		return name;
	}

	//gƓǂmF
	bool IsEquals( const Prototype *prototype ) const
	{
		if( this == prototype ){
			return true;
		}
		return false;
	}

	// V{r
	bool IsEqualSymbol( const NamespaceScopes &namespaceScopes, const string &name ) const;
	bool IsEqualSymbol( const Prototype &prototype ) const;
	bool IsEqualSymbol( const string &name ) const;

	// p
	bool IsUsing() const
	{
		return isUsing;
	}
	void Using() const
	{
		isUsing = true;
	}

};
