#pragma once

#include <string>
#include <vector>

#include <Namespace.h>

using namespace std;

class Prototype
{
	// O
	NamespaceScopes namespaceScopes;

	//O
	string name;

	mutable bool isUsing;

public:

	Prototype( const NamespaceScopes &namespaceScopes, const string &name )
		: namespaceScopes( namespaceScopes )
		, name( name )
		, isUsing( false )
	{
	}
	~Prototype()
	{
	}

	// O
	const NamespaceScopes &GetNamespaceScopes() const
	{
		return namespaceScopes;
	}

	const string &GetName() const
	{
		return name;
	}

	//gƓǂmF
	bool IsEquals( const Prototype *prototype ) const
	{
		if( this == prototype ){
			return true;
		}
		return false;
	}

	// p
	bool IsUsing() const
	{
		return isUsing;
	}
	void Using() const
	{
		isUsing = true;
	}

};
