#include "common.h"

const int Type::basicTypeList[] = {
	DEF_BYTE,
	DEF_SBYTE,
	DEF_WORD,
	DEF_INTEGER,
	DEF_DWORD,
	DEF_LONG,
	DEF_QWORD,
	DEF_INT64,

	DEF_SINGLE,
	DEF_DOUBLE,

	DEF_BOOLEAN,

	DEF_PTR_VOID,

	DEF_ANY,

	DEF_NON
};

const string Type::basicTypeNameList[] = {
	"Byte",
	"SByte",
	"Word",
	"Integer",
	"DWord",
	"Long",
	"QWord",
	"Int64",

	"Single",
	"Double",

	"Boolean",

	"VoidPtr",

	"Any",

	""
};

bool Type::StringToBasicType( const string &typeName, int &basicType ){
	for( int i=0; ; i++ ){
		if( basicTypeList[i] == DEF_NON ){
			break;
		}
		if( basicTypeNameList[i] == typeName ){
			basicType = basicTypeList[i];
			return true;
		}
	}
	return false;
}
bool Type::StringToType( const string &typeName, Type &type ){
	type.index = -1;

	if( typeName[0] == '*' ){
		if( typeName.size() >= 3
			&& typeName[1] == 1 && ( typeName[2] == ESC_FUNCTION || typeName[2] == ESC_SUB ) ){
				//֐|C^i*Functionj
				type.basicType = DEF_PTR_PROC;
				type.index = AddProcPtrInfo( typeName, cp );
				return true;
		}

		const string &nextTypeName = typeName.substr( 1 );

		if( !StringToType( nextTypeName, type ) ){
			return false;
		}

		type.PtrLevelUp();

		return true;
	}

	if( StringToBasicType( typeName, type.basicType ) ){
		// {^Ƃ
		return true;
	}


	// Object^Ƃ
	if( typeName == "Object" ){
		type.SetType( DEF_OBJECT, pobj_DBClass->GetObjectClassPtr() );
		return true;
	}

	// String^Ƃ
	if( typeName == "String" ){
		type.SetType( DEF_OBJECT, pobj_DBClass->GetStringClassPtr() );
		return true;
	}


	////////////////////
	// TypeDefꂽ^
	////////////////////
	int i=Smoothie::Meta::typeDefs.GetIndex( typeName );
	if(i!=-1){
		type = Smoothie::Meta::typeDefs[i].GetBaseType();
		return true;
	}

	//NX
	const CClass *pobj_c = pobj_DBClass->Find( typeName );
	if(pobj_c){
		type.pClass = pobj_c;

		if( pobj_c->IsStructure() ){
			type.basicType = DEF_STRUCT;
		}
		else{
			type.basicType = DEF_OBJECT;
		}
		return true;
	}

	return false;
}

int Type::GetBasicSize( int basicType )
{

	// {^
	switch( basicType ){
		case DEF_SBYTE:
		case DEF_BYTE:
		case DEF_BOOLEAN:
			return sizeof(BYTE);

		case DEF_INTEGER:
		case DEF_WORD:
			return sizeof(WORD);

		case DEF_LONG:
		case DEF_DWORD:
			return sizeof(DWORD);

		case DEF_INT64:
		case DEF_QWORD:
			return sizeof(_int64);

		case DEF_DOUBLE:
			return sizeof(double);
		case DEF_SINGLE:
			return sizeof(float);
	}

	// |C^
	if(IsPtrType(basicType)){
		return PTR_SIZE;
	}

	// IuWFNg
	if(basicType==DEF_OBJECT){
		return PTR_SIZE;
	}

	SetError();
	return 0;
}


bool Type::Equals( const Type &type ) const
{
	if( basicType == type.basicType ){
		if( NATURAL_TYPE( basicType ) == DEF_OBJECT
			|| NATURAL_TYPE( basicType ) == DEF_STRUCT ){

				if( index == type.index ){
					return true;
				}

		}
		else{
			return true;
		}
	}
	return false;
}

int Type::GetBasicSize() const
{
	return GetBasicSize( basicType );
}
int Type::GetSize() const
{

	// {^
	switch( basicType ){
		case DEF_LONG:
			if(index==LITERAL_NULL||index==LITERAL_M128_0||index==LITERAL_0_255){
				return sizeof(BYTE);
			}
			else if(index==LITERAL_M32768_0||index==LITERAL_0_65535){
				return sizeof(WORD);
			}
			return sizeof(DWORD);

		case DEF_SBYTE:
		case DEF_BYTE:
		case DEF_BOOLEAN:
			return sizeof(BYTE);

		case DEF_INTEGER:
		case DEF_WORD:
			return sizeof(WORD);

		case DEF_DWORD:
			return sizeof(DWORD);

		case DEF_INT64:
		case DEF_QWORD:
			return sizeof(_int64);

		case DEF_DOUBLE:
			return sizeof(double);
		case DEF_SINGLE:
			return sizeof(float);
	}

	// |C^
	if(IsPtrType(basicType)){
		return PTR_SIZE;
	}

	// \
	if( basicType == DEF_STRUCT ){
		if( !pClass ){
			SetError();
			return 0;
		}

		return pClass->GetSize();
	}

	// IuWFNg
	if(basicType==DEF_OBJECT){
		return PTR_SIZE;
	}

	SetError();
	return 0;
}

bool Type::IsNull() const{
  if( basicType == DEF_NON ){
	  return true;
  }
  return false;
}

bool Type::IsByte() const{
  if( basicType == DEF_BYTE ){
	  return true;
  }
  return false;
}
bool Type::IsSByte() const{
  if( basicType == DEF_SBYTE ){
	  return true;
  }
  return false;
}
bool Type::IsWord() const{
  if( basicType == DEF_WORD ){
	  return true;
  }
  return false;
}
bool Type::IsInteger() const{
  if( basicType == DEF_INTEGER ){
	  return true;
  }
  return false;
}
bool Type::IsDWord() const{
  if( basicType == DEF_DWORD ){
	  return true;
  }
  return false;
}
bool Type::IsLong() const{
  if( basicType == DEF_LONG ){
	  return true;
  }
  return false;
}
bool Type::IsQWord() const{
  if( basicType == DEF_QWORD ){
	  return true;
  }
  return false;
}
bool Type::IsInt64() const{
  if( basicType == DEF_INT64 ){
	  return true;
  }
  return false;
}
bool Type::IsSingle() const{
  if( basicType == DEF_SINGLE ){
	  return true;
  }
  return false;
}
bool Type::IsDouble() const{
  if( basicType == DEF_DOUBLE ){
	  return true;
  }
  return false;
}
bool Type::IsBoolean() const{
  if( basicType == DEF_BOOLEAN ){
	  return true;
  }
  return false;
}

bool Type::IsPointer() const
{
	if(PTR_LEVEL( basicType )|| basicType == DEF_PTR_VOID || basicType == DEF_PTR_PROC
		|| ( basicType & FLAG_PTR ) ){
			return true;
	}

	return false;
}
bool Type::IsSigned() const
{
	switch( basicType ){
		case DEF_SBYTE:
		case DEF_INTEGER:
		case DEF_LONG:
		case DEF_INT64:
		case DEF_SINGLE:
		case DEF_DOUBLE:
			return true;
		default:
			break;
	}
	return false;
}
bool Type::IsNaturalWhole() const
{
	switch( basicType ){
		case DEF_SBYTE:
		case DEF_BYTE:
		case DEF_INTEGER:
		case DEF_WORD:
		case DEF_LONG:
		case DEF_DWORD:
		case DEF_INT64:
		case DEF_QWORD:
			return true;
		default:
			break;
	}
	return false;
}
bool Type::IsWhole() const
{
	return (
		IsNaturalWhole()
		|| IsPtrType( basicType )
		|| basicType == DEF_BOOLEAN
		);
}
bool Type::IsReal() const
{
	switch( basicType ){
		case DEF_SINGLE:
		case DEF_DOUBLE:
			return true;
		default:
			break;
	}
	return false;
}
bool Type::Is64() const
{
	switch( basicType ){
		case DEF_QWORD:
		case DEF_INT64:
			return true;
		default:
			break;
	}
	return false;
}
bool Type::IsProcPtr() const
{
	if( basicType == DEF_PTR_PROC ){
		return true;
	}
	return false;
}
bool Type::IsStruct() const
{
	if( basicType == DEF_STRUCT ){
		return true;
	}
	return false;
}
bool Type::IsStructPtr() const
{
	if( basicType == DEF_PTR_STRUCT ){
		return true;
	}
	return false;
}
bool Type::IsObject() const
{
	if( basicType == DEF_OBJECT ){
		return true;
	}
	return false;
}
bool Type::IsObjectPtr() const
{
	if( basicType == DEF_PTR_OBJECT ){
		return true;
	}
	return false;
}
bool Type::IsObjectClass() const
{
	if( basicType == DEF_OBJECT ){
		if( lstrcmp( pClass->name,"Object")==0){
			return true;
		}
	}
	return false;
}
bool Type::IsStringClass() const
{
	if( basicType == DEF_OBJECT ){
		if( lstrcmp( pClass->name,"String")==0){
			return true;
		}
	}
	return false;
}
bool Type::IsVoidPtr() const
{
	if( basicType == DEF_PTR_VOID ){
		return true;
	}
	return false;
}

bool Type::IsAny() const
{
	if( basicType == DEF_ANY ){
		return true;
	}
	return false;
}

bool Type::HasMember() const
{
	if( NATURAL_TYPE( basicType ) == DEF_OBJECT
		|| NATURAL_TYPE( basicType ) == DEF_STRUCT ){
			return true;
	}
	return false;
}

const string Type::ToString() const
{
	if( PTR_LEVEL( basicType ) ){
		//|C^x1ȏ̏ꍇ
		Type type( *this );
		type.PtrLevelDown();

		return (string)"*" + type.ToString();
	}
	else if( IsObject() || IsStruct() ){
		//IuWFNg܂͍\

		if( !( index == 0 || index == -1 ) ){
			return pClass->name;
		}
	}
	else if( IsProcPtr() ){
		if( index == 0 || index == -1 ){
			return "VoidPtr";
		}
		else{
			if( Smoothie::Meta::procPointers[index]->ReturnType().IsNull() ){
				return "*Sub";
			}
			return "*Function";
		}
	}
	else{
		// {^

		for( int i=0; ; i++ ){
			if( basicTypeList[i] == DEF_NON ){
				break;
			}
			if( basicTypeList[i] == basicType ){
				return basicTypeNameList[i];
			}
		}
	}

	extern int cp;
	SetError(1,NULL,cp);

	return (string)"(null)";
}

Type Type::String(){
	return Type( DEF_OBJECT, *pobj_DBClass->GetStringClassPtr() );
}

const string BlittableType::GetCreateStaticMethodFullName() const
{
	return pClass->GetNamespaceScopes().ToString() + "." + pClass->GetName() + "._Create";
}
