#pragma once

#include <vector>
#include "Type.h"
#include "Procedure.h"

class CClass;

#define ACCESS_NON			0
#define ACCESS_PRIVATE		1
#define ACCESS_PUBLIC		2
#define ACCESS_PROTECTED	3

class CMember : public Type
{
	bool isConst;
public:
	char *name;
	int SubScripts[MAX_ARRAYDIM];

	DWORD dwAccess;

	char *InitBuf;
	char *ConstractParameter;

	int source_code_address;


	CMember( CClass *pobj_c, DWORD access, bool idConst, bool isRef, char *buffer, int nowLine=-1 );
	CMember( CMember &member );
	CMember();
	~CMember();

	bool IsConst();


	static void InitStaticMember(void);
};
class CMethod
{
public:
	UserProc *pUserProc;

	DWORD dwAccess;
	BOOL bAbstract;
	BOOL bVirtual;
	bool isConst;
	bool isStatic;

	const CClass *pobj_InheritsClass;

	CMethod(CMethod *pobj);
	CMethod( UserProc *pUserProc, DWORD dwAccess, BOOL bAbstract, BOOL bVirtual, bool isConst, bool isStatic );
	~CMethod();
};

class CDBClass;
class CDebugSection;
class CClass{
	friend CMember;
	friend CDBClass;
	friend CDebugSection;

	// O
	NamespaceScopes namespaceScopes;
	NamespaceScopesCollection importedNamespaces;

	// Blittable^
	Type blittableType;

	//ÓIo
	std::vector<CMember *> staticMembers;

	//\bh
	std::vector<CMethod *> methods;
	int ConstructorMemberSubIndex;
	int DestructorMemberSubIndex;

	//ÓI\bh
	std::vector<CMethod *> staticMethods;

	enum ClassType{
		Class,
		Interface,
		Enum,
		Delegate,
		Structure,
	};

	ClassType classType;

	mutable bool isUsing;

public:
	//NX
	char *name;

	//pNXւ̃|C^
	const CClass *pobj_InheritsClass;

	//o
	CMember **ppobj_Member;
	int iMemberNum;

	//z֐̐
	int vtbl_num;

	//ACgl
	int iAlign;


public:
	CClass( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const char *name );
	~CClass();

	const NamespaceScopes &GetNamespaceScopes() const
	{
		return namespaceScopes;
	}
	const NamespaceScopesCollection &GetImportedNamespaces() const
	{
		return importedNamespaces;
	}

	const string GetName() const
	{
		return name;
	}

	bool IsBlittableType() const
	{
		return !blittableType.IsNull();
	}
	const Type &GetBlittableType() const
	{
		return blittableType;
	}
	void SetBlittableType( const Type &type ){
		blittableType = type;
	}

	bool IsEqualSymbol( const NamespaceScopes &namespaceScopes, const string &name ) const;
	bool IsEqualSymbol( const CClass &objClass ) const;
	bool IsEqualSymbol( const string &name ) const;

	bool IsUsing() const;
	void Using() const;

	bool IsClass() const;
	bool IsInterface() const;
	bool IsEnum() const;
	bool IsDelegate() const;
	bool IsStructure() const;

	//p
	bool Inherits( const CClass &inheritsClass, int nowLine );
	bool InheritsInterface( const CClass &inheritsClass, int nowLine );

	//oA\bh̒ǉ
	void AddMember( DWORD dwAccess, bool idConst, bool isRef, char *buffer );
	void AddStaticMember( DWORD dwAccess, bool isConst, bool isRef, char *buffer, int nowLine );
	void AddMethod( UserProc *pUserProc,DWORD dwAccess, bool isConst, BOOL bAbstract, BOOL bVirtual );
	void AddStaticMethod(UserProc *pUserProc,DWORD dwAccess);

	//d`FbN
	BOOL DupliCheckAll(const char *name);
	BOOL DupliCheckMember(const char *name);

	//\bh擾
	CMethod *GetMethodInfo( UserProc *pUserProc ) const;
	CMethod *GetStaticMethodInfo( UserProc *pUserProc ) const;

	//\bh݂̑mF
	bool IsExistMethod( const char *name ) const;
	bool IsExistStaticMethod( const char *name ) const;

	//\bh
	void EnumStaticMethod( const char *methodName, vector<UserProc *> &subs ) const;
	void EnumMethod( const char *methodName, vector<UserProc *> &subs ) const;
	void EnumMethod( const BYTE idOperatorCalc, vector<UserProc *> &subs ) const;
	const std::vector<CMethod *> &GetMethods() const
	{
		return methods;
	}
	const std::vector<CMethod *> &GetStaticMethods() const
	{
		return staticMethods;
	}

	//ftHg RXgN^ \bh擾
	CMethod *GetConstructorMethod() const;

	//fXgN^ \bh擾
	CMethod *GetDestructorMethod() const;

	// ȏTCY擾
	int GetSize() const;

	// õItZbg擾
	int GetMemberOffset( const char *memberName, int *pMemberNum = NULL ) const;

private:
	// ACgl擾
	int GetAlignment() const;


	//vtbl
private:
	mutable long vtbl_offset;
public:
	int GetFuncNumInVtbl( const UserProc *pUserProc ) const;
	LONG_PTR GetVtblGlobalOffset(void) const;
	void ActionVtblSchedule(LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection);
	bool IsAbstract() const;


	//RXgN^RpCĂ邩ǂ̃`FbNtO
private:
	mutable bool isCompilingConstructor;
public:
	void NotifyStartConstructorCompile() const;
	void NotifyFinishConstructorCompile() const;
	bool IsCompilingConstructor() const;

	//fXgN^RpCĂ邩ǂ̃`FbNtO
private:
	mutable bool isCompilingDestructor;
public:
	void NotifyStartDestructorCompile() const;
	void NotifyFinishDestructorCompile() const;
	bool IsCompilingDestructor() const;


	//gƓNXǂmF
	bool IsEquals( const CClass *pClass ) const;

	//g̔hNXǂmF
	bool IsSubClass( const CClass *pClass ) const;

	//gƓ܂͔hNXǂmF
	bool IsEqualsOrSubClass( const CClass *pClass ) const;

	// gƓ܂͔hNXANXǂmF
	bool IsEqualsOrSubClassOrSuperClass( const CClass &objClass ) const;


	//`Xgp
	CClass *pobj_NextClass;


	//o̎Qƕ@
	enum RefType{
		Non = 0,		// no reference member
		Dot,			// obj.member
		Pointer,		// obj->member
	};
};

#define MAX_CLASS_HASH 65535
class CDBClass{
	int hash(const char *name) const;
	void DestroyClass(CClass *pobj_c);
public:
	CClass *pobj_ClassHash[MAX_CLASS_HASH];

	CDBClass();
	~CDBClass();

	const CClass *Find( const string &fullName ) const;
	const CClass *Find( const NamespaceScopes &namespaceScopes, const string &name ) const;

	CClass *AddClass( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const char *name,int nowLine);

	void ActionVtblSchedule(LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection);

private:
	void AddMethod(CClass *pobj_c, DWORD dwAccess, BOOL bStatic, bool isConst, BOOL bAbstract,
		BOOL bVirtual, BOOL bOverride, char *buffer, int nowLine);
	BOOL MemberVar_LoopRefCheck(const CClass &objClass);
public:
	void InitNames(void);
	void GetClass_recur(const char *lpszInheritsClass);
	void GetAllClassInfo(void);
	void Compile_System_InitializeUserTypes();


	/////////////////////////////
	// NX
	/////////////////////////////
	CClass *pStringClass;
	CClass *pObjectClass;
	CClass *GetStringClassPtr() const;
	CClass *GetObjectClassPtr() const;


	/////////////////////////////
	// ݃RpC̏
	/////////////////////////////
private:
	const CClass *pCompilingClass;
	CMethod *pCompilingMethod;
public:
	//RpCJn̒ʒm󂯎郁\bh
	void StartCompile( UserProc *pUserProc );

	//݃RpC̃\bh擾
	const CClass *GetNowCompilingClass() const;
	CMethod *GetNowCompilingMethodInfo();


	/////////////////////
	// Ce[^
	/////////////////////
private:
	CClass **ppobj_IteClass;
	int iIteMaxNum;
	int iIteNextNum;
public:
	void Iterator_Init(void);
	void Iterator_Reset(void);
	BOOL Iterator_HasNext(void);
	CClass *Iterator_GetNext(void);
	int Iterator_GetMaxCount(void);
};


extern CDBClass *pobj_DBClass;
extern const CClass *pobj_CompilingClass;
